/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;
import org.systemsbiology.biotapestry.biofabric.FabricCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareNodesSetupDialog
extends BTStashResultsDialog {
    private static final long serialVersionUID = 1L;
    private Set<NetNode> result_ = null;
    private EditableTable<NodeListTableModel.TableRow> est_;
    private Set<NetNode> allNodeIDs_;
    private Map<String, Set<NetNode>> normNameToID_;

    public CompareNodesSetupDialog(JFrame parent, Set<NetNode> allNodeIDs, Map<String, Set<NetNode>> normNameToID) {
        super(parent, ResourceManager.getManager().getString("compareNodesSetup.title"), new Dimension(600, 500), 2);
        this.allNodeIDs_ = allNodeIDs;
        this.normNameToID_ = normNameToID;
        FixedJButton buttonR = new FixedJButton(this.rMan_.getString("compareNodesSetup.loadFromFile"));
        buttonR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    CompareNodesSetupDialog.this.loadFromFile();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.est_ = new EditableTable<NodeListTableModel.TableRow>(new NodeListTableModel(), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = false;
        etp.buttons = 29;
        etp.singleSelectOnly = true;
        JPanel tablePan = this.est_.buildEditableTable(etp);
        this.addTable(tablePan, 5);
        this.finishConstructionWithExtraLeftButton(buttonR);
    }

    public Set<NetNode> getResults() {
        return this.result_;
    }

    @Override
    protected boolean stashForOK() {
        List<NetNode> av = ((NodeListTableModel)this.est_.getModel()).applyValues();
        if (av == null) {
            this.result_ = null;
            return false;
        }
        this.result_ = new HashSet<NetNode>(av);
        return true;
    }

    void loadFromFile() {
        CommandSet cmd = CommandSet.getCmds("mainWindow");
        File fileEda = cmd.getFileLoader().getTheFile(".txt", null, "AttribDirectory", "filterName.txt", this);
        if (fileEda == null) {
            return;
        }
        List<String> nodes = UiUtil.simpleFileRead(fileEda);
        if (nodes == null) {
            return;
        }
        List<NodeListTableModel.TableRow> initRows = this.initTableRows(nodes);
        this.est_.updateTable(true, initRows);
        FabricCommands.setPreference("AttribDirectory", fileEda.getAbsoluteFile().getParent());
    }

    private List<NodeListTableModel.TableRow> initTableRows(List<String> inTags) {
        ArrayList<NodeListTableModel.TableRow> retval = new ArrayList<NodeListTableModel.TableRow>();
        EditableTable.TableModel<NodeListTableModel.TableRow> ecdtm = this.est_.getModel();
        for (String tag : inTags) {
            NodeListTableModel.TableRow tr = ecdtm.constructARow();
            tr.nodeName = tag;
            retval.add(tr);
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeListTableModel
    extends EditableTable.TableModel<TableRow> {
        private static final long serialVersionUID = 1L;
        private static final int NODE_NAME_ = 0;
        private static final int NUM_COL_ = 1;
        private static final int NID_ = 0;
        private static final int NUM_HIDDEN_ = 1;

        NodeListTableModel() {
            super(1);
            this.colNames_ = new String[]{"compareNodesSetup.nodeName"};
            this.colClasses_ = new Class[]{String.class};
            this.addHiddenColumns(1);
        }

        @Override
        protected TableRow constructARow(int i) {
            return new TableRow(i);
        }

        @Override
        public TableRow constructARow() {
            return new TableRow();
        }

        List<NetNode> applyValues() {
            List vals = this.getValuesFromTable();
            ResourceManager rMan = ResourceManager.getManager();
            ArrayList<String> seenStrings = new ArrayList<String>();
            ArrayList<NetNode> seenTags = new ArrayList<NetNode>();
            int size = vals.size();
            if (size == 0) {
                return seenTags;
            }
            for (int i = 0; i < size; ++i) {
                TableRow row = (TableRow)vals.get(i);
                String tag = row.nodeName;
                if (tag == null || tag.trim().equals("")) {
                    JOptionPane.showMessageDialog(CompareNodesSetupDialog.this.parent_, rMan.getString("compareNodesSetup.badName"), rMan.getString("compareNodesSetup.badNameTitle"), 0);
                    return null;
                }
                if (DataUtil.containsKey(seenStrings, tag = tag.trim())) {
                    JOptionPane.showMessageDialog(CompareNodesSetupDialog.this.parent_, rMan.getString("compareNodesSetup.dupName"), rMan.getString("compareNodesSetup.dupNameTitle"), 0);
                    return null;
                }
                String normTag = DataUtil.normKey(tag);
                Set haveIDs = (Set)CompareNodesSetupDialog.this.normNameToID_.get(normTag);
                boolean gotIt = haveIDs != null;
                NetNode matchNode = null;
                if (gotIt) {
                    for (NetNode haveID : haveIDs) {
                        if (!CompareNodesSetupDialog.this.allNodeIDs_.contains(haveID)) continue;
                        if (matchNode != null) {
                            JOptionPane.showMessageDialog(CompareNodesSetupDialog.this.parent_, rMan.getString("compareNodesSetup.ambiguousNode"), rMan.getString("compareNodesSetup.ambiguousTitle"), 0);
                            return null;
                        }
                        matchNode = haveID;
                    }
                }
                if (matchNode == null) {
                    JOptionPane.showMessageDialog(CompareNodesSetupDialog.this.parent_, rMan.getString("compareNodesSetup.notANode"), rMan.getString("compareNodesSetup.notANodeTitle"), 0);
                    return null;
                }
                seenTags.add(matchNode);
                seenStrings.add(tag);
            }
            return seenTags;
        }

        public class TableRow
        implements EditableTable.ATableRow {
            public String nodeName;
            public String nid;

            public TableRow() {
            }

            TableRow(int i) {
                this.nodeName = (String)((List)NodeListTableModel.this.columns_.get(0)).get(i);
                this.nid = (String)((List)NodeListTableModel.this.hiddenColumns_.get(0)).get(i);
            }

            public void toCols() {
                ((List)NodeListTableModel.this.columns_.get(0)).add(this.nodeName);
                ((List)NodeListTableModel.this.hiddenColumns_.get(0)).add(this.nid);
            }
        }
    }
}

