/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.io.FileLoadFlows;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.io.AttributeLoader;
import org.systemsbiology.biofabric.layouts.NodeClusterLayout;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.TrueObjChoiceContent;
import org.systemsbiology.biofabric.util.UiUtil;

public class ClusterLayoutSetupDialog
extends BTStashResultsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox sourceCombo_;
    private JComboBox orderCombo_;
    private JComboBox interCombo_;
    private JComboBox cLayoutCombo_;
    private JCheckBox saveAssignBox_;
    private NetNode currSel_;
    private JLabel nameLabel_;
    private JTextField userName_;
    private BioFabricNetwork bfn_;
    private NodeClusterLayout.ClusterParams results_ = null;
    private boolean haveClusts_;

    public ClusterLayoutSetupDialog(JFrame parent, BioFabricNetwork bfn, NetNode selNode) {
        super(parent, ResourceManager.getManager().getString("nodeClusterLayout.title"), new Dimension(600, 350), 2);
        this.bfn_ = bfn;
        this.currSel_ = selNode;
        this.haveClusts_ = bfn.nodeClustersAssigned();
        this.sourceCombo_ = new JComboBox<TrueObjChoiceContent<NodeClusterLayout.ClusterParams.Source>>(NodeClusterLayout.ClusterParams.getSourceChoices(this.haveClusts_));
        this.orderCombo_ = new JComboBox<TrueObjChoiceContent<NodeClusterLayout.ClusterParams.Order>>(NodeClusterLayout.ClusterParams.getOrderChoices());
        this.interCombo_ = new JComboBox<TrueObjChoiceContent<NodeClusterLayout.ClusterParams.InterLink>>(NodeClusterLayout.ClusterParams.getILinkChoices());
        this.cLayoutCombo_ = new JComboBox<TrueObjChoiceContent<NodeClusterLayout.ClusterParams.ClustLayout>>(NodeClusterLayout.ClusterParams.getClustLayoutChoices());
        this.saveAssignBox_ = new JCheckBox(this.rMan_.getString("nodeClusterLayout.saveAssign"));
        NodeClusterLayout.ClusterParams params = new NodeClusterLayout.ClusterParams(this.haveClusts_);
        this.setToVals(params);
        JLabel label = new JLabel(this.rMan_.getString("nodeClusterLayout.source"));
        this.addLabeledWidget(label, this.sourceCombo_, false, false);
        this.addWidgetFullRow(this.saveAssignBox_, false);
        label = new JLabel(this.rMan_.getString("nodeClusterLayout.order"));
        this.addLabeledWidget(label, this.orderCombo_, false, false);
        label = new JLabel(this.rMan_.getString("nodeClusterLayout.interLink"));
        this.addLabeledWidget(label, this.interCombo_, false, false);
        label = new JLabel(this.rMan_.getString("nodeClusterLayout.clusterLayout"));
        this.addLabeledWidget(label, this.cLayoutCombo_, false, false);
        FixedJButton buttonR = new FixedJButton(this.rMan_.getString("dialogs.resetDefaults"));
        buttonR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    NodeClusterLayout.ClusterParams params = new NodeClusterLayout.ClusterParams(ClusterLayoutSetupDialog.this.haveClusts_);
                    ClusterLayoutSetupDialog.this.setToVals(params);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.userName_ = new JTextField(this.currSel_ == null ? "" : this.currSel_.getName().trim());
        this.nameLabel_ = new JLabel(this.rMan_.getString("bFirst.selectName"));
        this.addLabeledWidget(this.nameLabel_, this.userName_, false, false);
        this.finishConstructionWithExtraLeftButton(buttonR);
    }

    public NodeClusterLayout.ClusterParams getParams() {
        return this.results_;
    }

    protected boolean stashForOK() {
        String selName;
        this.results_ = new NodeClusterLayout.ClusterParams(this.haveClusts_);
        TrueObjChoiceContent scc = (TrueObjChoiceContent)this.sourceCombo_.getSelectedItem();
        this.results_.source = (NodeClusterLayout.ClusterParams.Source)((Object)scc.val);
        TrueObjChoiceContent occ = (TrueObjChoiceContent)this.orderCombo_.getSelectedItem();
        this.results_.order = (NodeClusterLayout.ClusterParams.Order)((Object)occ.val);
        TrueObjChoiceContent icc = (TrueObjChoiceContent)this.interCombo_.getSelectedItem();
        this.results_.iLink = (NodeClusterLayout.ClusterParams.InterLink)((Object)icc.val);
        TrueObjChoiceContent ccc = (TrueObjChoiceContent)this.cLayoutCombo_.getSelectedItem();
        this.results_.cLay = (NodeClusterLayout.ClusterParams.ClustLayout)((Object)ccc.val);
        this.results_.saveAssign = this.saveAssignBox_.isSelected();
        if (this.results_.source.equals((Object)NodeClusterLayout.ClusterParams.Source.STORED)) {
            this.results_.assign(this.bfn_.nodeClusterAssigment());
        }
        if ((selName = this.userName_.getText()) != null && !selName.trim().equals("")) {
            String cand = selName.trim();
            Map<String, Set<NetNode>> nn2ids = this.bfn_.getNormNameToIDs();
            Map<String, NetNode> nn2id = PluginSupportFactory.getBuildExtractor().reduceNameSetToOne(nn2ids);
            NetNode nidCand = nn2id.get(DataUtil.normKey(cand));
            if (this.bfn_.getNodeDefinition(nidCand) == null) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(this.parent_, rMan.getString("nodeClusterLayout.nodeDoesNotExist"), rMan.getString("nodeClusterLayout.nodeDoesNotExistTitle"), 0);
                return false;
            }
            this.results_.startNode = nidCand;
        } else {
            this.results_.startNode = null;
        }
        return true;
    }

    private void setToVals(NodeClusterLayout.ClusterParams params) {
        int numSrc = this.sourceCombo_.getItemCount();
        for (int i = 0; i < numSrc; ++i) {
            TrueObjChoiceContent cc = (TrueObjChoiceContent)this.sourceCombo_.getItemAt(i);
            if (cc.val != params.source) continue;
            this.sourceCombo_.setSelectedIndex(i);
            break;
        }
        int numOrd = this.orderCombo_.getItemCount();
        for (int i = 0; i < numOrd; ++i) {
            TrueObjChoiceContent cc = (TrueObjChoiceContent)this.orderCombo_.getItemAt(i);
            if (cc.val != params.order) continue;
            this.orderCombo_.setSelectedIndex(i);
            break;
        }
        int numInt = this.interCombo_.getItemCount();
        for (int i = 0; i < numInt; ++i) {
            TrueObjChoiceContent cc = (TrueObjChoiceContent)this.interCombo_.getItemAt(i);
            if (cc.val != params.iLink) continue;
            this.orderCombo_.setSelectedIndex(i);
            break;
        }
        int numClay = this.cLayoutCombo_.getItemCount();
        for (int i = 0; i < numClay; ++i) {
            TrueObjChoiceContent cc = (TrueObjChoiceContent)this.cLayoutCombo_.getItemAt(i);
            if (cc.val != params.cLay) continue;
            this.orderCombo_.setSelectedIndex(i);
            break;
        }
        this.saveAssignBox_.setSelected(params.saveAssign);
    }

    public static boolean askForFileInfo(NodeClusterLayout.ClusterParams params, CommandSet cset, FileLoadFlows flf, BioFabricNetwork bfn) {
        File file = flf.getTheFile(".noa", ".na", "AttribDirectory", "filterName.noa", null);
        if (file == null) {
            return false;
        }
        Map<AttributeKey, String> nodeAttributes = flf.loadTheFile(file, null, true);
        if (nodeAttributes == null) {
            return false;
        }
        HashSet<AttributeLoader.StringKey> asUpper = new HashSet<AttributeLoader.StringKey>();
        Iterator<NetNode> rttvit = bfn.getNodeSetIDs().iterator();
        while (rttvit.hasNext()) {
            asUpper.add(new AttributeLoader.StringKey(rttvit.next().getName()));
        }
        if (!asUpper.equals(new HashSet<AttributeKey>(nodeAttributes.keySet()))) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(cset.getBFW().getWindow(), rMan.getString("attribRead.badRowMessage"), rMan.getString("attribRead.badRowSemanticsTitle"), 2);
            return false;
        }
        UiUtil.fixMePrintout("Gotta make sure that no node name maps to two nodes (with different internal IDS)");
        Map<String, Set<NetNode>> nn2ids = bfn.getNormNameToIDs();
        Map<String, NetNode> nn2id = PluginSupportFactory.getBuildExtractor().reduceNameSetToOne(nn2ids);
        params.install(nodeAttributes, nn2id);
        return true;
    }
}

