/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.layout.DefaultLayout;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;

public class BreadthFirstLayoutDialog
extends BTStashResultsDialog {
    private static final long serialVersionUID = 1L;
    private JRadioButton useDefault_;
    private JRadioButton userSpec_;
    private JTextField userName_;
    private NodeLayout.Params params_ = null;
    private JLabel nameLabel_;
    private BioFabricNetwork bfn_;

    public BreadthFirstLayoutDialog(JFrame parent, NetNode currSel, BioFabricNetwork bfn) {
        super(parent, ResourceManager.getManager().getString("breadthFirstLayout.title"), new Dimension(600, 350), 2);
        this.bfn_ = bfn;
        String highest = this.rMan_.getString("bFirst.useHighest");
        this.useDefault_ = new JRadioButton(highest, currSel == null);
        this.useDefault_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    BreadthFirstLayoutDialog.this.userName_.setEnabled(BreadthFirstLayoutDialog.this.userSpec_.isSelected());
                    BreadthFirstLayoutDialog.this.nameLabel_.setEnabled(BreadthFirstLayoutDialog.this.userSpec_.isSelected());
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.addWidgetFullRow(this.useDefault_, false);
        String spec = this.rMan_.getString("bFirst.userSelect");
        this.userSpec_ = new JRadioButton(spec, currSel != null);
        this.userSpec_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    BreadthFirstLayoutDialog.this.userName_.setEnabled(BreadthFirstLayoutDialog.this.userSpec_.isSelected());
                    BreadthFirstLayoutDialog.this.nameLabel_.setEnabled(BreadthFirstLayoutDialog.this.userSpec_.isSelected());
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.addWidgetFullRow(this.userSpec_, false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.useDefault_);
        group.add(this.userSpec_);
        this.userName_ = new JTextField(currSel == null ? "" : currSel.getName().trim());
        this.nameLabel_ = new JLabel(this.rMan_.getString("bFirst.selectName"));
        this.userName_.setEnabled(this.userSpec_.isSelected());
        this.nameLabel_.setEnabled(this.userSpec_.isSelected());
        this.addLabeledWidget(this.nameLabel_, this.userName_, false, false);
        this.finishConstruction();
    }

    public NodeLayout.Params getParams() {
        return this.params_;
    }

    protected boolean stashForOK() {
        boolean useSelected = this.userSpec_.isSelected();
        if (useSelected) {
            String search = DataUtil.normKey(this.userName_.getText().trim());
            Set<NetNode> result = this.bfn_.nodeMatches(true, search);
            if (result.size() != 1) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(this.parent_, rMan.getString("bFirst.badNode"), rMan.getString("bFirst.badNodeTitle"), 0);
                return false;
            }
            ArrayList<NetNode> starts = new ArrayList<NetNode>();
            starts.add(result.iterator().next());
            this.params_ = new DefaultLayout.DefaultParams(starts);
        } else {
            this.params_ = new DefaultLayout.DefaultParams(null);
        }
        return true;
    }
}

