/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.ui.BrowserLauncher;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.util.ResourceManager;

public class PopupMenuControl {
    private NodePopup popupGuts_;
    private LinkPopup popupGutsLink_;
    private NetNode currNode_;
    private FabricLink currLink_;
    private JPanel parent_;

    public PopupMenuControl(JPanel parent) {
        this.parent_ = parent;
        this.popupGuts_ = new NodePopup();
        this.popupGutsLink_ = new LinkPopup();
    }

    public boolean isVisible() {
        return this.popupGuts_.isVisible() || this.popupGutsLink_.isVisible();
    }

    public void showNodePopup(NetNode nodeName, Point pt) {
        this.currNode_ = nodeName;
        this.popupGuts_.showPopup(pt);
    }

    public void showLinkPopup(FabricLink link, Point pt) {
        this.currLink_ = link;
        this.popupGutsLink_.showPopup(pt);
    }

    public class LaunchBrowserForLink
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LaunchBrowserForLink(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", mnem);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
                if (!fdo.getOfferLinkBrowser()) {
                    return;
                }
                String browserURL = fdo.getBrowserLinkURL();
                if (browserURL.indexOf("%_BIOFABRIC_LINK_SRC_%") == -1 || browserURL.indexOf("%_BIOFABRIC_LINK_TRG_%") == -1 || browserURL.indexOf("%_BIOFABRIC_LINK_REL_%") == -1) {
                    return;
                }
                NetNode src = PopupMenuControl.this.currLink_.getSrcNode();
                NetNode trg = PopupMenuControl.this.currLink_.getTrgNode();
                String rel = ((PopupMenuControl)PopupMenuControl.this).currLink_.getAugRelation().relation;
                browserURL = browserURL.replaceFirst("%_BIOFABRIC_LINK_SRC_%", src.getName());
                browserURL = browserURL.replaceFirst("%_BIOFABRIC_LINK_TRG_%", trg.getName());
                browserURL = browserURL.replaceFirst("%_BIOFABRIC_LINK_REL_%", rel);
                new BrowserLauncher().openBBURL(browserURL);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class LaunchBrowserForNode
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LaunchBrowserForNode(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", mnem);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
                if (!fdo.getOfferNodeBrowser()) {
                    return;
                }
                String browserURL = fdo.getBrowserURL();
                if (browserURL.indexOf("%_BIOFABRIC_NODE_NAME_%") == -1) {
                    return;
                }
                browserURL = browserURL.replaceFirst("%_BIOFABRIC_NODE_NAME_%", PopupMenuControl.this.currNode_.getName());
                new BrowserLauncher().openBBURL(browserURL);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private class LinkPopup {
        private JPopupMenu popMenu_;
        private LaunchBrowserForLink lbl_;

        LinkPopup() {
            ResourceManager rMan = ResourceManager.getManager();
            this.popMenu_ = new JPopupMenu();
            this.popMenu_.addPopupMenuListener(new PopupHandler());
            this.lbl_ = new LaunchBrowserForLink(rMan.getString("nodePopup.launchLinkBrowser"), rMan.getChar("nodePopup.launchLinkBrowserMnem"));
            this.popMenu_.add(this.lbl_);
        }

        JPopupMenu getPopup() {
            return this.popMenu_;
        }

        boolean isVisible() {
            return this.popMenu_.isVisible();
        }

        void showPopup(Point pt) {
            this.prepareMenu();
            this.popMenu_.show(PopupMenuControl.this.parent_, pt.x, pt.y);
            this.popMenu_.requestFocusInWindow();
        }

        void prepareMenu() {
            FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
            boolean canShow = fdo.getOfferLinkBrowser();
            String browserURL = fdo.getBrowserLinkURL();
            this.lbl_.setEnabled(canShow && !browserURL.equals(""));
        }
    }

    private class NodePopup {
        private JPopupMenu popMenu_;
        private LaunchBrowserForNode lbn_;

        NodePopup() {
            ResourceManager rMan = ResourceManager.getManager();
            this.popMenu_ = new JPopupMenu();
            this.popMenu_.addPopupMenuListener(new PopupHandler());
            this.lbn_ = new LaunchBrowserForNode(rMan.getString("nodePopup.launchBrowser"), rMan.getChar("nodePopup.launchBrowserMnem"));
            this.popMenu_.add(this.lbn_);
        }

        JPopupMenu getPopup() {
            return this.popMenu_;
        }

        boolean isVisible() {
            return this.popMenu_.isVisible();
        }

        void showPopup(Point pt) {
            this.prepareMenu();
            this.popMenu_.show(PopupMenuControl.this.parent_, pt.x, pt.y);
            this.popMenu_.requestFocusInWindow();
        }

        void prepareMenu() {
            FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
            String browserURL = fdo.getBrowserURL();
            boolean canShow = fdo.getOfferNodeBrowser();
            this.lbn_.setEnabled(canShow && !browserURL.equals(""));
        }
    }
}

