/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageExporter {
    public static final int INCHES = 0;
    public static final int CM = 1;
    private static final int METER_ = 2;

    public void export(Object outObj, BufferedImage bi, String format, ResolutionSettings res) throws IOException {
        if (format.equalsIgnoreCase("TIFF")) {
            this.writeTIFFImage(bi, outObj, res);
        } else if (format.equalsIgnoreCase("PNG")) {
            this.writePNGImage(bi, outObj, res);
        } else if (format.equalsIgnoreCase("JPEG")) {
            this.writeJPGImage(bi, outObj, res);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void setTIFFResolutionMetadata(IIOMetadata meta, ResolutionSettings res) {
        IIOMetadataNode topnode = (IIOMetadataNode)meta.getAsTree(meta.getNativeMetadataFormatName());
        NodeList nl = topnode.getElementsByTagName("TIFFField");
        String[] svals = new String[]{"ImageWidth", "ImageLength", "ResolutionUnit"};
        String[] rvals = new String[]{"XResolution", "YResolution"};
        List<String> smatches = Arrays.asList(svals);
        List<String> rmatches = Arrays.asList(rvals);
        int num = nl.getLength();
        for (int i = 0; i < num; ++i) {
            IIOMetadataNode node = (IIOMetadataNode)nl.item(i);
            String nameVal = node.getAttribute("name");
            if (smatches.contains(nameVal)) {
                NodeList snl = node.getElementsByTagName("TIFFShort");
                IIOMetadataNode shortNode = (IIOMetadataNode)snl.item(0);
                if (!nameVal.equals("ResolutionUnit")) continue;
                String resUnits = res.units == 0 ? "2" : "3";
                shortNode.setAttribute("value", resUnits);
                continue;
            }
            if (!rmatches.contains(nameVal)) continue;
            NodeList rnl = node.getElementsByTagName("TIFFRational");
            IIOMetadataNode ratNode = (IIOMetadataNode)rnl.item(0);
            ratNode.setAttribute("value", res.dotsPerUnit.numerator + "/" + res.dotsPerUnit.denominator);
        }
        try {
            meta.setFromTree(meta.getNativeMetadataFormatName(), topnode);
        }
        catch (IIOInvalidTreeException itex) {
            throw new IllegalStateException();
        }
    }

    private void setPNGResolutionMetadata(IIOMetadata meta, ResolutionSettings res) {
        if (res == null) {
            return;
        }
        IIOMetadataNode topnode = (IIOMetadataNode)meta.getAsTree(meta.getNativeMetadataFormatName());
        ResolutionSettings resMet = ImageExporter.mapResolutionToMeters(res);
        long resVal = Math.round((double)resMet.dotsPerUnit.numerator / (double)resMet.dotsPerUnit.denominator);
        String resValStr = Long.toString(resVal);
        IIOMetadataNode pNode = new IIOMetadataNode("pHYs");
        pNode.setAttribute("pixelsPerUnitXAxis", resValStr);
        pNode.setAttribute("pixelsPerUnitYAxis", resValStr);
        pNode.setAttribute("unitSpecifier", "meter");
        topnode.appendChild(pNode);
        try {
            meta.setFromTree(meta.getNativeMetadataFormatName(), topnode);
        }
        catch (IIOInvalidTreeException itex) {
            throw new IllegalStateException();
        }
    }

    private void setJPGResolutionMetadata(IIOMetadata meta, ResolutionSettings res) {
        if (res == null) {
            return;
        }
        IIOMetadataNode topnode = (IIOMetadataNode)meta.getAsTree(meta.getNativeMetadataFormatName());
        NodeList nl = topnode.getElementsByTagName("app0JFIF");
        if (nl.getLength() < 1) {
            throw new IllegalStateException();
        }
        String resUnits = res.units == 0 ? "1" : "2";
        long lResVal = Math.round((double)res.dotsPerUnit.numerator / (double)res.dotsPerUnit.denominator);
        String resValStr = Long.toString(lResVal);
        IIOMetadataNode node = (IIOMetadataNode)nl.item(0);
        node.setAttribute("resUnits", resUnits);
        node.setAttribute("Xdensity", resValStr);
        node.setAttribute("Ydensity", resValStr);
        try {
            meta.setFromTree(meta.getNativeMetadataFormatName(), topnode);
        }
        catch (IIOInvalidTreeException itex) {
            throw new IllegalStateException();
        }
    }

    private void writeTIFFImage(BufferedImage bi, Object outObj, ResolutionSettings res) throws IOException {
        if (res == null) {
            throw new IllegalArgumentException();
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("tiff");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(outObj);
        writer.setOutput(ios);
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("LZW");
        ImageTypeSpecifier its = new ImageTypeSpecifier(bi);
        IIOMetadata meta = writer.getDefaultImageMetadata(its, param);
        this.setTIFFResolutionMetadata(meta, res);
        IIOImage img = new IIOImage(bi, null, meta);
        writer.write(writer.getDefaultStreamMetadata(param), img, param);
        ios.close();
        writer.dispose();
    }

    private void writePNGImage(BufferedImage bi, Object outObj, ResolutionSettings res) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(outObj);
        writer.setOutput(ios);
        ImageWriteParam param = writer.getDefaultWriteParam();
        ImageTypeSpecifier its = new ImageTypeSpecifier(bi);
        IIOMetadata meta = writer.getDefaultImageMetadata(its, param);
        Node node = meta.getAsTree(meta.getNativeMetadataFormatName());
        this.setPNGResolutionMetadata(meta, res);
        IIOImage img = new IIOImage(bi, null, meta);
        writer.write(writer.getDefaultStreamMetadata(param), img, param);
        ios.close();
        writer.dispose();
    }

    private void writeJPGImage(BufferedImage bi, Object outObj, ResolutionSettings res) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(outObj);
        writer.setOutput(ios);
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("JPEG");
        param.setCompressionQuality(1.0f);
        ImageTypeSpecifier its = new ImageTypeSpecifier(bi);
        IIOMetadata meta = writer.getDefaultImageMetadata(its, param);
        Node node = meta.getAsTree(meta.getNativeMetadataFormatName());
        this.setJPGResolutionMetadata(meta, res);
        IIOImage img = new IIOImage(bi, null, meta);
        writer.write(writer.getDefaultStreamMetadata(param), img, param);
        ios.close();
        writer.dispose();
    }

    public static List<String> getSupportedExports() {
        String[] names = ImageIO.getWriterFormatNames();
        HashSet<String> present = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equalsIgnoreCase("TIF")) {
                present.add("TIFF");
                continue;
            }
            if (names[i].equalsIgnoreCase("PNG")) {
                present.add("PNG");
                continue;
            }
            if (!names[i].equalsIgnoreCase("JPG")) continue;
            present.add("JPEG");
        }
        ArrayList<String> retval = new ArrayList<String>();
        if (present.contains("TIFF")) {
            retval.add("TIFF");
        }
        if (present.contains("PNG")) {
            retval.add("PNG");
        }
        if (present.contains("JPEG")) {
            retval.add("JPEG");
        }
        return retval;
    }

    public static List<String> getSupportedFileSuffixes() {
        List<String> exps = ImageExporter.getSupportedExports();
        ArrayList<String> retval = new ArrayList<String>();
        if (exps.contains("TIFF")) {
            retval.add("tif");
            retval.add("tiff");
        }
        if (exps.contains("PNG")) {
            retval.add("png");
        }
        if (exps.contains("JPEG")) {
            retval.add("jpg");
            retval.add("jpeg");
        }
        return retval;
    }

    public static List<String> getFileSuffixesForType(String type) {
        ArrayList<String> retval = new ArrayList<String>();
        if (type.equals("TIFF")) {
            retval.add("tif");
            retval.add("tiff");
        } else if (type.equals("PNG")) {
            retval.add("png");
        } else if (type.equals("JPEG")) {
            retval.add("jpg");
            retval.add("jpeg");
        }
        return retval;
    }

    public static String getPreferredSuffixForType(String type) {
        if (type.equals("TIFF")) {
            return "tif";
        }
        if (type.equals("PNG")) {
            return "png";
        }
        if (type.equals("JPEG")) {
            return "jpg";
        }
        throw new IllegalArgumentException();
    }

    public static List getSupportedResolutions(boolean forPub) {
        ArrayList<Object[]> retval = new ArrayList<Object[]>();
        if (forPub) {
            Object[] res = new Object[]{new RationalNumber(150.0, 150, 1), new RationalNumber(59.0, 59, 1)};
            retval.add(res);
            res = new Object[]{new RationalNumber(300.0, 300, 1), new RationalNumber(118.0, 118, 1)};
            retval.add(res);
            res = new Object[]{new RationalNumber(600.0, 600, 1), new RationalNumber(236.0, 236, 1)};
            retval.add(res);
        } else {
            Object[] res = new Object[]{new RationalNumber(72.0, 72, 1), new RationalNumber(28.0, 28, 1)};
            retval.add(res);
        }
        return retval;
    }

    public static ResolutionSettings mapResolutionToMeters(ResolutionSettings res) {
        int newNum;
        ResolutionSettings retval = new ResolutionSettings();
        retval.units = 2;
        RationalNumber oldDpu = res.dotsPerUnit;
        if (res.units == 1) {
            newNum = oldDpu.numerator * 100;
        } else {
            switch (oldDpu.numerator) {
                case 150: {
                    newNum = 5900;
                    break;
                }
                case 300: {
                    newNum = 11800;
                    break;
                }
                case 600: {
                    newNum = 23600;
                    break;
                }
                case 72: {
                    newNum = 2800;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        int newDen = oldDpu.denominator;
        double newRes = newNum;
        retval.dotsPerUnit = new RationalNumber(newRes, newNum, newDen);
        return retval;
    }

    public static boolean formatRequiresResolution(String type) {
        return type.equals("TIFF");
    }

    public static class ResolutionSettings {
        public RationalNumber dotsPerUnit;
        public int units;
    }

    public static class RationalNumber {
        public double value;
        public int numerator;
        public int denominator;

        public RationalNumber(double val, int num, int den) {
            this.value = val;
            this.numerator = num;
            this.denominator = den;
        }
    }
}

