/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui;

import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.api.io.CharacterEntityMapper;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.io.FabricFactory;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.xml.sax.Attributes;

public class FabricDisplayOptions
implements Cloneable {
    public static final String NODE_NAME_PLACEHOLDER = "%_BIOFABRIC_NODE_NAME_%";
    public static final String LINK_SRC_PLACEHOLDER = "%_BIOFABRIC_LINK_SRC_%";
    public static final String LINK_TRG_PLACEHOLDER = "%_BIOFABRIC_LINK_TRG_%";
    public static final String LINK_REL_PLACEHOLDER = "%_BIOFABRIC_LINK_REL_%";
    private static final double DEFAULT_SELECTION_OPAQUE_LEVEL_ = 0.9;
    private static final double DEFAULT_NODE_LIGHTER_LEVEL_ = 0.43;
    private static final double DEFAULT_LINK_DARKER_LEVEL_ = 0.43;
    private static final boolean DEFAULT_DISPLAY_SHADOWS_ = false;
    private static final boolean DEFAULT_SHADE_NODES_ = false;
    private static final int DEFAULT_MIN_DRAIN_ZONE_ = 1;
    private static final boolean DEFAULT_OFFER_NODE_BROWSER_ = false;
    private static final boolean DEFAULT_OFFER_LINK_BROWSER_ = false;
    private static final boolean DEFAULT_OFFER_MOUSEOVER_VIEW_ = false;
    private static final boolean DEFAULT_MINIMIZE_SHADOW_SUBMODEL_LINKS_ = true;
    private static final String DEFAULT_BROWSER_URL_ = "http://www.genecards.org/cgi-bin/carddisp.pl?gene=%_BIOFABRIC_NODE_NAME_%";
    private static final String DEFAULT_LINK_BROWSER_URL_ = "http://localhost:8080/setToYourPage.jsp?src=%_BIOFABRIC_LINK_SRC_%&rel=%_BIOFABRIC_LINK_REL_%&trg=%_BIOFABRIC_LINK_TRG_%";
    private static final String DEFAULT_MOUSEOVER_URL_ = "/Users/bill/Desktop/ForBrains/%_BIOFABRIC_NODE_NAME_%.jpg";
    private double selectionOpaqueLevel_;
    private double nodeLighterLevel_;
    private double linkDarkerLevel_;
    private boolean displayShadows_;
    private boolean shadeNodes_;
    private boolean minShadSubLinks_;
    private boolean offerNodeBrowser_;
    private boolean offerLinkBrowser_;
    private boolean offerMouseOverView_;
    private String browserURL_;
    private String browserLinkURL_;
    private String mouseOverURL_;
    private int minDrainZone_;

    public FabricDisplayOptions() {
        this.selectionOpaqueLevel_ = 0.9;
        this.nodeLighterLevel_ = 0.43;
        this.linkDarkerLevel_ = 0.43;
        this.displayShadows_ = false;
        this.shadeNodes_ = false;
        this.minDrainZone_ = 1;
        this.browserURL_ = DEFAULT_BROWSER_URL_;
        this.browserLinkURL_ = DEFAULT_LINK_BROWSER_URL_;
        this.minShadSubLinks_ = true;
        this.offerNodeBrowser_ = false;
        this.offerLinkBrowser_ = false;
        this.offerMouseOverView_ = false;
        this.mouseOverURL_ = DEFAULT_MOUSEOVER_URL_;
    }

    FabricDisplayOptions(String selectionOpaqueLevelStr, String nodeLighterLevelStr, String linkDarkerLevelStr, String displayShadowsStr, String shadeNodesStr, String minDrainZoneStr, String minShadSubLinksStr, String offerNodeBrowser, String offerLinkBrowser, String offerMouseOverView, String browserURL, String browserLinkURL, String mouseOverURL) throws IOException {
        if (selectionOpaqueLevelStr != null) {
            try {
                this.selectionOpaqueLevel_ = Double.parseDouble(selectionOpaqueLevelStr);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        } else {
            this.selectionOpaqueLevel_ = 0.9;
        }
        if (nodeLighterLevelStr != null) {
            try {
                this.nodeLighterLevel_ = Double.parseDouble(nodeLighterLevelStr);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        } else {
            this.nodeLighterLevel_ = 0.43;
        }
        if (linkDarkerLevelStr != null) {
            try {
                this.linkDarkerLevel_ = Double.parseDouble(linkDarkerLevelStr);
            }
            catch (NumberFormatException ex) {
                throw new IOException();
            }
        } else {
            this.linkDarkerLevel_ = 0.43;
        }
        this.displayShadows_ = displayShadowsStr != null ? Boolean.valueOf(displayShadowsStr) : false;
        this.shadeNodes_ = shadeNodesStr != null ? Boolean.valueOf(shadeNodesStr) : false;
        this.minDrainZone_ = minDrainZoneStr != null ? Integer.valueOf(minDrainZoneStr) : 1;
        this.minShadSubLinks_ = minShadSubLinksStr != null ? Boolean.valueOf(minShadSubLinksStr) : true;
        this.offerNodeBrowser_ = offerNodeBrowser != null ? Boolean.valueOf(offerNodeBrowser) : false;
        this.offerLinkBrowser_ = offerLinkBrowser != null ? Boolean.valueOf(offerLinkBrowser) : false;
        this.offerMouseOverView_ = offerMouseOverView != null ? Boolean.valueOf(offerMouseOverView) : false;
        this.browserURL_ = browserURL != null ? browserURL : DEFAULT_BROWSER_URL_;
        this.browserLinkURL_ = browserLinkURL != null ? browserLinkURL : DEFAULT_LINK_BROWSER_URL_;
        this.mouseOverURL_ = mouseOverURL != null ? mouseOverURL : DEFAULT_MOUSEOVER_URL_;
    }

    public String getBrowserURL() {
        return this.browserURL_;
    }

    public void setBrowserURL(String browserURL) {
        this.browserURL_ = browserURL;
    }

    public String getBrowserLinkURL() {
        return this.browserLinkURL_;
    }

    public void setBrowserLinkURL(String browserLinkURL) {
        this.browserLinkURL_ = browserLinkURL;
    }

    public String getMouseOverURL() {
        return this.mouseOverURL_;
    }

    public void setMouseOverURL(String mouseOverURL) {
        this.mouseOverURL_ = mouseOverURL;
    }

    public double getSelectionOpaqueLevel() {
        return this.selectionOpaqueLevel_;
    }

    public void setSelectionOpaqueLevel(double opqLevel) {
        if (opqLevel < 0.0 || opqLevel > 1.0) {
            throw new IllegalArgumentException();
        }
        this.selectionOpaqueLevel_ = opqLevel;
    }

    public double getNodeLighterLevel() {
        return this.nodeLighterLevel_;
    }

    public void setNodeLighterLevel(double nodeLight) {
        if (nodeLight < 0.0) {
            throw new IllegalArgumentException();
        }
        this.nodeLighterLevel_ = nodeLight;
    }

    public double getLinkDarkerLevel() {
        return this.linkDarkerLevel_;
    }

    public void setLinkDarkerLevel(double linkDark) {
        if (linkDark < 0.0) {
            throw new IllegalArgumentException();
        }
        this.linkDarkerLevel_ = linkDark;
    }

    public boolean getMinShadowSubmodelLinks() {
        return this.minShadSubLinks_;
    }

    public void setMinShadowSubmodelLinks(boolean doMin) {
        this.minShadSubLinks_ = doMin;
    }

    public boolean getDisplayShadows() {
        return this.displayShadows_;
    }

    public void setDisplayShadows(boolean display) {
        this.displayShadows_ = display;
    }

    public boolean getShadeNodes() {
        return this.shadeNodes_;
    }

    public void setShadeNodes(boolean shade) {
        this.shadeNodes_ = shade;
    }

    public int getMinDrainZone() {
        return this.minDrainZone_;
    }

    public void setMinDrainZone(int size) {
        this.minDrainZone_ = size;
    }

    public boolean getOfferNodeBrowser() {
        return this.offerNodeBrowser_;
    }

    public void setOfferNodeBrowser(boolean offerNodeBrowser) {
        this.offerNodeBrowser_ = offerNodeBrowser;
    }

    public boolean getOfferLinkBrowser() {
        return this.offerLinkBrowser_;
    }

    public void setOfferLinkBrowser(boolean offerLinkBrowser) {
        this.offerLinkBrowser_ = offerLinkBrowser;
    }

    public boolean getOfferMouseOverView() {
        return this.offerMouseOverView_;
    }

    public void setOfferMouseOverView(boolean offerMouseOverView) {
        this.offerMouseOverView_ = offerMouseOverView;
    }

    public FabricDisplayOptions clone() {
        try {
            FabricDisplayOptions retval = (FabricDisplayOptions)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<displayOptions ");
        if (this.selectionOpaqueLevel_ != 0.9) {
            out.print("selOpq=\"");
            out.print(this.selectionOpaqueLevel_);
            out.print("\" ");
        }
        if (this.nodeLighterLevel_ != 0.43) {
            out.print("nodeLight=\"");
            out.print(this.nodeLighterLevel_);
            out.print("\" ");
        }
        if (this.linkDarkerLevel_ != 0.43) {
            out.print("linkDark=\"");
            out.print(this.linkDarkerLevel_);
            out.print("\" ");
        }
        if (this.displayShadows_) {
            out.print("shadows=\"");
            out.print(this.displayShadows_);
            out.print("\" ");
        }
        if (this.shadeNodes_) {
            out.print("shading=\"");
            out.print(this.shadeNodes_);
            out.print("\" ");
        }
        if (this.minDrainZone_ != 1) {
            out.print("minDrainZone=\"");
            out.print(this.minDrainZone_);
            out.print("\" ");
        }
        if (!this.minShadSubLinks_) {
            out.print("minShadSubLinks=\"");
            out.print(this.minShadSubLinks_);
            out.print("\" ");
        }
        if (this.offerNodeBrowser_) {
            out.print("offerNodeBrowser=\"");
            out.print(this.offerNodeBrowser_);
            out.print("\" ");
        }
        if (this.offerLinkBrowser_) {
            out.print("offerLinkBrowser=\"");
            out.print(this.offerLinkBrowser_);
            out.print("\" ");
        }
        if (this.offerMouseOverView_) {
            out.print("offerMouseOverView=\"");
            out.print(this.offerMouseOverView_);
            out.print("\" ");
        }
        if (!this.browserURL_.equals(DEFAULT_BROWSER_URL_)) {
            out.print("browserURL=\"");
            out.print(CharacterEntityMapper.mapEntities(this.browserURL_, false));
            out.print("\" ");
        }
        if (!this.browserLinkURL_.equals(DEFAULT_LINK_BROWSER_URL_)) {
            out.print("browserLinkURL=\"");
            out.print(CharacterEntityMapper.mapEntities(this.browserLinkURL_, false));
            out.print("\" ");
        }
        if (!this.mouseOverURL_.equals(DEFAULT_MOUSEOVER_URL_)) {
            out.print("mouseOverURL=\"");
            out.print(CharacterEntityMapper.mapEntities(this.mouseOverURL_, false));
            out.print("\" ");
        }
        out.println("/>");
    }

    public static class FabricDisplayOptionsWorker
    extends AbstractFactoryClient {
        public FabricDisplayOptionsWorker(FabricFactory.FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("displayOptions");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            FabricDisplayOptions retval = null;
            if (elemName.equals("displayOptions")) {
                FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
                board.displayOpts = this.buildFromXML(elemName, attrs);
                FabricDisplayOptionsManager.getMgr().setDisplayOptionsForIO(board.displayOpts);
                retval = board.displayOpts;
            }
            return retval;
        }

        private FabricDisplayOptions buildFromXML(String elemName, Attributes attrs) throws IOException {
            String selectionOpaqueLevelStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "selOpq", false);
            String nodeLighterLevelStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "nodeLight", false);
            String linkDarkerLevelStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "linkDark", false);
            String displayShadowsStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "shadows", false);
            String shadeNodesStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "shading", false);
            String minDrainZoneStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "minDrainZone", false);
            String minShadSubLinks = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "minShadSubLinks", false);
            String offerNodeBrowserStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "offerNodeBrowser", false);
            String offerLinkBrowserStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "offerLinkBrowser", false);
            String offerMouseOverViewStr = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "offerMouseOverView", false);
            String browserURL = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "browserURL", false);
            String browserLinkURL = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "browserLinkURL", false);
            String mouseOverURL = AttributeExtractor.extractAttribute(elemName, attrs, "displayOptions", "mouseOverURL", false);
            browserURL = browserURL == null ? null : CharacterEntityMapper.unmapEntities(browserURL, false);
            browserLinkURL = browserLinkURL == null ? null : CharacterEntityMapper.unmapEntities(browserLinkURL, false);
            return new FabricDisplayOptions(selectionOpaqueLevelStr, nodeLighterLevelStr, linkDarkerLevelStr, displayShadowsStr, shadeNodesStr, minDrainZoneStr, minShadSubLinks, offerNodeBrowserStr, offerLinkBrowserStr, offerMouseOverViewStr, browserURL, browserLinkURL, mouseOverURL);
        }
    }
}

