/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.db.ColorGenerator;
import org.systemsbiology.biofabric.io.FabricFactory;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.NamedColor;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricColorGenerator {
    public static final int UNCHANGED = 0;
    public static final int BRIGHTER = 1;
    public static final int DARKER = 2;
    private ColorGenerator myColGen_ = new ColorGenerator();
    private HashMap<String, Color> brighter_ = new HashMap();
    private HashMap<String, Color> darker_ = new HashMap();

    public void newColorModel() {
        boolean useHSV = false;
        this.myColGen_.newColorModel();
        FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
        double light = fdo.getNodeLighterLevel() + 1.0;
        double dark = 1.0 / (fdo.getLinkDarkerLevel() + 1.0);
        float[] hsbvals = new float[3];
        int numCol = this.myColGen_.getNumColors();
        for (int i = 0; i < numCol; ++i) {
            String gckey = this.myColGen_.getGeneColor(i);
            NamedColor nc = this.myColGen_.getNamedColor(gckey);
            int baseR = nc.color.getRed();
            int baseG = nc.color.getGreen();
            int baseB = nc.color.getBlue();
            if (useHSV) {
                Color.RGBtoHSB(baseR, baseG, baseB, hsbvals);
                float lb = Math.min(1.0f, hsbvals[2] * (float)light);
                this.brighter_.put(gckey, Color.getHSBColor(hsbvals[0], hsbvals[1], lb));
                float db = Math.min(1.0f, hsbvals[2] * (float)dark);
                this.darker_.put(gckey, Color.getHSBColor(hsbvals[0], hsbvals[1], db));
                continue;
            }
            if (nc.name.indexOf("Gold") == -1 && nc.name.indexOf("Dark Wheat") == -1 && nc.name.indexOf("Pale Goldenrod") == -1) {
                int rb = Math.min(255, (int)Math.round((double)baseR * light));
                int gb = Math.min(255, (int)Math.round((double)baseG * light));
                int bb = Math.min(255, (int)Math.round((double)baseB * light));
                this.brighter_.put(gckey, new Color(rb, gb, bb));
            } else {
                this.brighter_.put(gckey, nc.color);
            }
            int rd = Math.min(255, (int)Math.round((double)baseR * dark));
            int gd = Math.min(255, (int)Math.round((double)baseG * dark));
            int bd = Math.min(255, (int)Math.round((double)baseB * dark));
            this.darker_.put(gckey, new Color(rd, gd, bd));
        }
    }

    public void dropColors() {
        this.myColGen_.dropColors();
        this.brighter_.clear();
        this.darker_.clear();
    }

    void addColorForIO(int target, NamedColor color) {
        switch (target) {
            case 1: {
                this.brighter_.put(color.name, color.color);
                break;
            }
            case 2: {
                this.darker_.put(color.name, color.color);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Color getModifiedColor(String colorKey, int which) {
        Color paintCol;
        switch (which) {
            case 0: {
                NamedColor nc = this.myColGen_.getNamedColor(colorKey);
                paintCol = nc == null || nc.color == null ? null : nc.color;
                break;
            }
            case 2: {
                paintCol = this.darker_.get(colorKey);
                break;
            }
            case 1: {
                paintCol = this.brighter_.get(colorKey);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (paintCol == null) {
            paintCol = Color.BLACK;
        }
        return paintCol;
    }

    public String getGeneColor(int i) {
        return this.myColGen_.getGeneColor(i);
    }

    public int getNumColors() {
        return this.myColGen_.getNumColors();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<colors>");
        ind.up();
        this.writeColorsForType(out, ind, "nodes", this.brighter_);
        this.writeColorsForType(out, ind, "links", this.darker_);
        ind.down().indent();
        out.println("</colors>");
    }

    private void writeColorsForType(PrintWriter out, Indenter ind, String type, Map<String, Color> colMap) {
        ind.indent();
        out.print("<colorSet usage=\"");
        out.print(type);
        out.println("\">");
        ind.up();
        for (String key : colMap.keySet()) {
            Color c = colMap.get(key);
            ind.indent();
            out.print("<color ");
            out.print("color=\"");
            out.print(key);
            out.print("\" r=\"");
            out.print(c.getRed());
            out.print("\" g=\"");
            out.print(c.getGreen());
            out.print("\" b=\"");
            out.print(c.getBlue());
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</colorSet>");
    }

    public static class ColorWorker
    extends AbstractFactoryClient {
        public ColorWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            this.myKeys_.add("color");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NamedColor retval = null;
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            retval = board.currCol = this.buildFromXML(elemName, attrs);
            return retval;
        }

        private NamedColor buildFromXML(String elemName, Attributes attrs) throws IOException {
            NamedColor retval;
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "color", "color", true);
            String rStr = AttributeExtractor.extractAttribute(elemName, attrs, "color", "r", true);
            String gStr = AttributeExtractor.extractAttribute(elemName, attrs, "color", "g", true);
            String bStr = AttributeExtractor.extractAttribute(elemName, attrs, "color", "b", true);
            try {
                int r = Integer.valueOf(rStr);
                int g = Integer.valueOf(gStr);
                int b = Integer.valueOf(bStr);
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    throw new IOException();
                }
                retval = new NamedColor(name, new Color(r, g, b), name);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return retval;
        }
    }

    public static class MyColorGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.fcg.addColorForIO(board.colTarg, board.currCol);
            return null;
        }
    }

    public static class ColorSetWorker
    extends AbstractFactoryClient {
        public ColorSetWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            FabricFactory.FactoryWhiteboard whiteboard = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            this.myKeys_.add("colorSet");
            this.installWorker(new ColorWorker(whiteboard), new MyColorGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            FabricColorGenerator retval = null;
            if (elemName.equals("colorSet")) {
                int targVal;
                String target = AttributeExtractor.extractAttribute(elemName, attrs, "colorSet", "usage", true);
                if (target.equals("nodes")) {
                    targVal = 1;
                } else if (target.equals("links")) {
                    targVal = 2;
                } else {
                    throw new IOException();
                }
                FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
                if (board.colTarg == 0) {
                    board.fcg = new FabricColorGenerator();
                }
                board.colTarg = targVal;
                retval = board.fcg;
            }
            return retval;
        }
    }
}

