/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.systemsbiology.biofabric.cmd.ZoomTarget;
import org.systemsbiology.biofabric.ui.ZoomPresentation;
import org.systemsbiology.biofabric.util.UiUtil;

public class BasicZoomTargetSupport
implements ZoomTarget {
    protected ZoomPresentation myGenomePre_;
    protected double zoom_ = 1.0;
    protected AffineTransform transform_ = new AffineTransform();
    protected JPanel paintTarget_;
    protected Rectangle worldRect_;
    protected Rectangle2D clipRect_;

    public BasicZoomTargetSupport(ZoomPresentation genomePre, JPanel paintTarget) {
        this.myGenomePre_ = genomePre;
        this.paintTarget_ = paintTarget;
        this.worldRect_ = new Rectangle(0, 0, 100, 100);
        this.clipRect_ = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void setWorldRect(Rectangle worldRect) {
        this.worldRect_ = (Rectangle)worldRect.clone();
    }

    public void setCurrClipRect(Rectangle2D clipRect) {
        this.clipRect_.setRect(clipRect);
    }

    public void incrementToNextSelection() {
        this.myGenomePre_.bumpNextSelection();
    }

    public void decrementToPreviousSelection() {
        this.myGenomePre_.bumpPreviousSelection();
    }

    public void repaint() {
        this.paintTarget_.repaint();
    }

    public AffineTransform getTransform() {
        return this.transform_;
    }

    public Dimension getPreferredSize() {
        int width = (int)((double)this.worldRect_.width * this.zoom_);
        int height = (int)((double)this.worldRect_.height * this.zoom_);
        return new Dimension(width, height);
    }

    public Rectangle getWorldRect() {
        return (Rectangle)this.worldRect_.clone();
    }

    public Point getCenterPoint() {
        Point2D center = UiUtil.getRectCenter(this.worldRect_);
        Point2D centerPoint = (Point2D)center.clone();
        this.transform_.transform(centerPoint, centerPoint);
        int x = (int)Math.round(centerPoint.getX());
        int y = (int)Math.round(centerPoint.getY());
        Point pt = new Point(x, y);
        return pt;
    }

    public Point2D getRawCenterPoint() {
        Point2D center = UiUtil.getRectCenter(this.worldRect_);
        return (Point2D)center.clone();
    }

    public Dimension getBasicSize() {
        Rectangle origRect = this.myGenomePre_.getRequiredSize();
        return new Dimension(origRect.width, origRect.height);
    }

    public Rectangle getCurrentBasicBounds() {
        return this.myGenomePre_.getRequiredSize();
    }

    public Rectangle getSelectedBounds() {
        return this.myGenomePre_.getSelectionSize();
    }

    public Rectangle getCurrentSelectedBounds() {
        return this.myGenomePre_.getCurrentSelectionSize();
    }

    public Point pointToViewport(Point worldPoint) {
        Point2D.Double newPoint = new Point2D.Double();
        Point pt = new Point();
        return BasicZoomTargetSupport.pointToViewport(worldPoint, this.transform_, newPoint, pt);
    }

    public static Point pointToViewport(Point worldPoint, AffineTransform trans, Point2D temp, Point res) {
        temp.setLocation(worldPoint.getX(), worldPoint.getY());
        trans.transform(temp, temp);
        int x = (int)Math.round(temp.getX());
        int y = (int)Math.round(temp.getY());
        res.setLocation(x, y);
        return res;
    }

    public Point2D viewToWorld(Point viewPoint) {
        Point2D.Double ptSrc = new Point2D.Double(viewPoint.getX(), viewPoint.getY());
        try {
            Point2D.Double ptDest = new Point2D.Double(0.0, 0.0);
            this.transform_.inverseTransform(ptSrc, ptDest);
            return ptDest;
        }
        catch (NoninvertibleTransformException ex) {
            System.err.println("cannot invert: " + this.transform_ + " " + this.zoom_);
            throw new IllegalStateException();
        }
    }

    public void setZoomFactor(double zoom, Dimension viewportDim) {
        this.zoom_ = zoom;
        this.transform_ = this.getTransformForWideZoomFactor(zoom, viewportDim);
        this.myGenomePre_.setPresentationZoomFactor(zoom);
    }

    private AffineTransform getTransformForWideZoomFactor(double zoom, Dimension viewportDim) {
        UiUtil.fixMePrintout("READ ME");
        AffineTransform transform = new AffineTransform();
        int rectWidth = (int)(this.worldRect_.getWidth() * zoom);
        int rectHeight = (int)(this.worldRect_.getHeight() * zoom);
        int useWidth = rectWidth < viewportDim.width ? viewportDim.width : rectWidth;
        int useHeight = rectHeight < viewportDim.height ? viewportDim.height : rectHeight;
        Point2D center = UiUtil.getRectCenter(this.worldRect_);
        transform = new AffineTransform();
        transform.translate((double)useWidth / 2.0, (double)useHeight / 2.0);
        transform.scale(zoom, zoom);
        transform.translate(-center.getX(), -center.getY());
        return transform;
    }

    public void adjustWideZoomForSize(Dimension viewportDim) {
        int rectWidth = (int)(this.worldRect_.getWidth() * this.zoom_);
        int rectHeight = (int)(this.worldRect_.getHeight() * this.zoom_);
        int useWidth = rectWidth < viewportDim.width ? viewportDim.width : rectWidth;
        int useHeight = rectHeight < viewportDim.height ? viewportDim.height : rectHeight;
        Point2D center = UiUtil.getRectCenter(this.worldRect_);
        this.transform_ = new AffineTransform();
        this.transform_.translate((double)useWidth / 2.0, (double)useHeight / 2.0);
        this.transform_.scale(this.zoom_, this.zoom_);
        this.transform_.translate(-center.getX(), -center.getY());
    }

    public double getZoomFactor() {
        return this.zoom_;
    }

    public void transformPoint(Point pt) {
        try {
            this.transform_.inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
    }

    public void transformClick(int x, int y, Point pt) {
        Point2D.Double clickPoint = new Point2D.Double(x, y);
        try {
            this.transform_.inverseTransform(clickPoint, clickPoint);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        pt.x = (int)Math.round(((Point2D)clickPoint).getX());
        pt.y = (int)Math.round(((Point2D)clickPoint).getY());
    }

    public double currentPixelDiameter() {
        Point2D.Double clickPoint0 = new Point2D.Double(0.0, 0.0);
        Point2D.Double clickPoint1 = new Point2D.Double(1.0, 0.0);
        try {
            this.transform_.inverseTransform(clickPoint0, clickPoint0);
            this.transform_.inverseTransform(clickPoint1, clickPoint1);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        return Math.abs(((Point2D)clickPoint1).getX() - ((Point2D)clickPoint0).getX());
    }

    public Rectangle2D getCurrentWorldClipRect() {
        Point2D.Double clipUL = new Point2D.Double(this.clipRect_.getMinX(), this.clipRect_.getMinY());
        Point2D.Double clipLR = new Point2D.Double(this.clipRect_.getMaxX(), this.clipRect_.getMaxY());
        try {
            this.transform_.inverseTransform(clipUL, clipUL);
            this.transform_.inverseTransform(clipLR, clipLR);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        return new Rectangle2D.Double(((Point2D)clipUL).getX(), ((Point2D)clipUL).getY(), ((Point2D)clipLR).getX() - ((Point2D)clipUL).getX(), ((Point2D)clipLR).getY() - ((Point2D)clipUL).getY());
    }

    public void transformClick(double x, double y, Point pt) {
        Point2D.Double clickPoint = new Point2D.Double(x, y);
        try {
            this.transform_.inverseTransform(clickPoint, clickPoint);
        }
        catch (NoninvertibleTransformException nitex) {
            throw new IllegalStateException();
        }
        pt.x = (int)Math.round(((Point2D)clickPoint).getX());
        pt.y = (int)Math.round(((Point2D)clickPoint).getY());
    }
}

