/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.io.PluginWhiteboard;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInCmd;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInData;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.plugin.PlugInNetworkModelAPI;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.util.UiUtil;
import org.xml.sax.Attributes;

public class NetStatsPlugIn
implements BioFabricToolPlugIn {
    private ArrayList<BioFabricToolPlugInCmd> myCmds_ = new ArrayList();
    private String myTag_;
    private StatData myData_;
    private String className_;
    private PluginResourceManager rMan_;

    public NetStatsPlugIn() {
        this.myCmds_.add(new NodeAndLinkCounterCmd());
        this.myData_ = new StatData(0, 0, 0);
        this.className_ = this.getClass().getName();
    }

    public void setUniquePlugInTag(String tag) {
        this.myTag_ = tag;
    }

    public String getUniquePlugInTag() {
        return this.myTag_;
    }

    public void installManager(PlugInManager pMan) {
        this.rMan_ = PluginSupportFactory.getResourceManager(this.className_, pMan);
        this.rMan_.setPluginBundle("org.systemsbiology.biofabric.plugin.core.NetStats");
    }

    public void installAPI(PlugInNetworkModelAPI bfn) {
    }

    public void newNetworkInstalled(Network bfn) {
        for (BioFabricToolPlugInCmd cmd : this.myCmds_) {
            NodeAndLinkCounterCmd nalc = (NodeAndLinkCounterCmd)cmd;
            nalc.setNewNetwork(bfn);
        }
    }

    public String getToolMenu() {
        return this.rMan_.getPluginString("command.pluginName");
    }

    public int getCommandCount() {
        return this.myCmds_.size();
    }

    public BioFabricToolPlugInCmd getCommand(int index) {
        return this.myCmds_.get(index);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.up();
        ind.indent();
        String name = this.getClass().getName();
        out.print("<");
        out.print(name);
        out.println(">");
        ind.up();
        ind.indent();
        out.print("<netStats nodes=\"");
        out.print(this.myData_.nodeCount);
        out.print("\" links=\"");
        out.print(this.myData_.linkCount);
        out.print("\" fullShadowLinks=\"");
        out.print(this.myData_.fullShadowLinkCount);
        out.println("\" />");
        ind.down();
        ind.indent();
        out.print("</");
        out.print(name);
        out.println(">");
        ind.down();
    }

    public AbstractFactoryClient getXMLWorker(PluginWhiteboard board) {
        return new PlugInWorker(board, this);
    }

    public void attachXMLData(BioFabricToolPlugInData data) {
        this.myData_ = (StatData)data;
    }

    public static class StatsGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            PluginWhiteboard board = (PluginWhiteboard)optionalArgs;
            board.getCurrentPlugIn().attachXMLData(board.getCurrentPlugInData());
            return null;
        }
    }

    public static class NetStatsWorker
    extends AbstractFactoryClient {
        public NetStatsWorker(PluginWhiteboard board) {
            super(board);
            this.myKeys_.add("netStats");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BioFabricToolPlugInData retval = null;
            PluginWhiteboard board = (PluginWhiteboard)this.sharedWhiteboard_;
            board.setCurrentPlugInData(this.buildFromXML(elemName, attrs));
            retval = board.getCurrentPlugInData();
            return retval;
        }

        private StatData buildFromXML(String elemName, Attributes attrs) throws IOException {
            StatData retval;
            String nodeStr = AttributeExtractor.extractAttribute(elemName, attrs, "netStats", "nodes", true);
            String linkStr = AttributeExtractor.extractAttribute(elemName, attrs, "netStats", "links", true);
            String shadStr = AttributeExtractor.extractAttribute(elemName, attrs, "netStats", "fullShadowLinks", true);
            try {
                int nodeCount = Integer.valueOf(nodeStr);
                int linkCount = Integer.valueOf(linkStr);
                int fullCount = Integer.valueOf(shadStr);
                retval = new StatData(nodeCount, linkCount, fullCount);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return retval;
        }
    }

    public static class StatData
    implements BioFabricToolPlugInData {
        int nodeCount;
        int linkCount;
        int fullShadowLinkCount;

        public StatData(int nodeCount, int linkCount, int fullShadowLinkCount) {
            this.nodeCount = nodeCount;
            this.linkCount = linkCount;
            this.fullShadowLinkCount = fullShadowLinkCount;
        }
    }

    public static class PlugInWorker
    extends AbstractFactoryClient {
        private NetStatsPlugIn plugin_;

        public PlugInWorker(PluginWhiteboard board, NetStatsPlugIn plugin) {
            super(board);
            this.plugin_ = plugin;
            String name = plugin.getClass().getName();
            this.myKeys_.add(name);
            this.installWorker(new NetStatsWorker(board), new StatsGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BioFabricToolPlugIn retval = null;
            PluginWhiteboard board = (PluginWhiteboard)this.sharedWhiteboard_;
            if (this.myKeys_.contains(elemName)) {
                board.setCurrentPlugIn(this.plugin_);
                retval = board.getCurrentPlugIn();
            }
            return retval;
        }
    }

    public class NodeAndLinkCounterCmd
    implements BioFabricToolPlugInCmd {
        private boolean enabled_;

        public void setNewNetwork(Network bfn) {
            if (bfn != null) {
                ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.nodeCount = bfn.getNodeCount();
                ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.linkCount = bfn.getLinkCount(false);
                ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.fullShadowLinkCount = bfn.getLinkCount(true);
                this.enabled_ = ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.nodeCount > 0;
            } else {
                ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.nodeCount = 0;
                ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.linkCount = 0;
                ((NetStatsPlugIn)NetStatsPlugIn.this).myData_.fullShadowLinkCount = 0;
                this.enabled_ = false;
            }
        }

        public String getCommandName() {
            return NetStatsPlugIn.this.rMan_.getPluginString("command.statsCommands");
        }

        public boolean performOperation(JFrame topFrame) {
            if (!this.enabled_) {
                return false;
            }
            String desc = MessageFormat.format(NetStatsPlugIn.this.rMan_.getPluginString("modelCounts.message"), new Integer(((NetStatsPlugIn)NetStatsPlugIn.this).myData_.nodeCount), new Integer(((NetStatsPlugIn)NetStatsPlugIn.this).myData_.linkCount), new Integer(((NetStatsPlugIn)NetStatsPlugIn.this).myData_.fullShadowLinkCount));
            desc = UiUtil.convertMessageToHtml(desc);
            JOptionPane.showMessageDialog(topFrame, desc, NetStatsPlugIn.this.rMan_.getPluginString("modelCounts.modelCountTitle"), 1);
            return true;
        }

        public boolean isEnabled() {
            return this.enabled_;
        }
    }
}

