/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin;

import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.io.BuildExtractor;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.api.util.PreferenceStorage;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.BFWorker;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerControlManager;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerOwner;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.io.BuildExtractorImpl;
import org.systemsbiology.biofabric.model.AnnotationSetImpl;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.model.FabricNode;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.worker.BackgroundWorker;
import org.systemsbiology.biofabric.worker.BackgroundWorkerClient;
import org.systemsbiology.biofabric.worker.WorkerClientBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginSupportFactory {
    public static NetNode buildNode(NID id, String name) {
        return new FabricNode(id, name);
    }

    public static NetLink buildLink(NetNode srcID, NetNode trgID, String relation, boolean isShadow, Boolean directed) {
        return new FabricLink(srcID, trgID, relation, isShadow, directed);
    }

    public static NetLink buildLink(NetNode srcID, NetNode trgID, String relation, boolean isShadow) {
        return new FabricLink(srcID, trgID, relation, isShadow);
    }

    public static AnnotationSet buildAnnotationSet() {
        return new AnnotationSetImpl();
    }

    public static Annot buildAnnotation(String tag, int startPos, int endPos, int layer, String colorName) {
        return new AnnotationSetImpl.AnnotImpl(tag, startPos, endPos, layer, colorName);
    }

    public static PreferenceStorage getPreferenceStorage() {
        return new PreferenceStorage();
    }

    public static BuildExtractor getBuildExtractor() {
        return new BuildExtractorImpl();
    }

    public static BFWorker getBFWorker(BackgroundWorkerOwner owner, JFrame topWindow, BackgroundWorkerControlManager suw, String waitTitle, String waitMsg, boolean allowCancels, PluginResourceManager rMan) {
        BackgroundWorker bw = new BackgroundWorker();
        BackgroundWorkerClient bwc = new BackgroundWorkerClient(owner, bw, topWindow, suw, waitTitle, waitMsg, allowCancels, rMan);
        return new WorkerClientBundle(bw, bwc);
    }

    public static PluginResourceManager getResourceManager(String pluginName, PlugInManager pMan) {
        return new ResourceManager.ForPlugins(pluginName, pMan);
    }

    public static BuildData getBuildDataForPlugin(UniqueLabeller idGen, Set<NetLink> allLinks, Set<NetNode> loneNodeIDs, Map<NetNode, String> clustAssign, FabricColorGenerator colGen) {
        return new BuildDataImpl(idGen, allLinks, loneNodeIDs, clustAssign, colGen, BuildDataImpl.BuildMode.BUILD_FROM_PLUGIN);
    }
}

