/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.api.parser.ParserClient;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.io.FabricFactory;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.parser.SUParser;
import org.systemsbiology.biofabric.plugin.AbstractPlugInDirective;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.PlugInDirectiveFactory;
import org.systemsbiology.biofabric.plugin.PlugInNetworkModelAPI;
import org.systemsbiology.biofabric.plugin.ToolPlugInDirective;
import org.systemsbiology.biotapestry.biofabric.FabricCommands;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInManager {
    private ArrayList<BioFabricToolPlugIn> toolPlugIns_ = new ArrayList();
    private int maxCount_;
    private TreeSet<AbstractPlugInDirective> directives_ = new TreeSet();
    private HashMap<String, ResourceBundle> rBunds_;

    public PlugInManager() {
        this.maxCount_ = Integer.MIN_VALUE;
        this.rBunds_ = new HashMap();
    }

    public ResourceBundle getResourceBundle(String name) {
        ResourceBundle rBund = this.rBunds_.get(name);
        if (rBund == null) {
            rBund = ResourceBundle.getBundle(name);
        }
        return rBund;
    }

    public void setDirectory(File directory) {
        FabricCommands.setPreference("PlugInDirectory", directory.getAbsolutePath());
    }

    public String getDirectory() {
        return FabricCommands.getPreference("PlugInDirectory");
    }

    public void installAPI(PlugInNetworkModelAPI api) {
        for (BioFabricToolPlugIn pi : this.toolPlugIns_) {
            pi.installAPI(api);
        }
    }

    public void newNetworkInstalled(BioFabricNetwork bfn) {
        for (BioFabricToolPlugIn pi : this.toolPlugIns_) {
            pi.newNetworkInstalled(bfn);
        }
    }

    public void addDirective(AbstractPlugInDirective dir) {
        this.directives_.add(dir);
        int order = dir.getOrder();
        if (this.maxCount_ < order) {
            this.maxCount_ = order;
        }
    }

    public List<String> getOrderedToolPlugInKeys() {
        ArrayList<String> retval = new ArrayList<String>();
        for (BioFabricToolPlugIn pi : this.toolPlugIns_) {
            retval.add(pi.getUniquePlugInTag());
        }
        return retval;
    }

    public BioFabricToolPlugIn getToolPlugIn(String key) {
        for (BioFabricToolPlugIn pi : this.toolPlugIns_) {
            if (!pi.getUniquePlugInTag().equals(key)) continue;
            return pi;
        }
        throw new IllegalArgumentException();
    }

    public boolean loadPlugIns(Map<String, Object> args) {
        File plugDirectory;
        String plugDirPref;
        if (!this.readPlugInListing()) {
            return false;
        }
        String plugDirStr = (String)args.get("plugInDir");
        if (plugDirStr != null) {
            File plugDirectory2 = new File(plugDirStr);
            if (!(plugDirectory2.exists() && plugDirectory2.isDirectory() && plugDirectory2.canRead())) {
                return false;
            }
            if (!this.readJarFiles(plugDirectory2, this.maxCount_ + 1)) {
                return false;
            }
        }
        if ((plugDirPref = FabricCommands.getPreference("PlugInDirectory")) != null && (plugDirectory = new File(plugDirPref)).exists() && plugDirectory.isDirectory() && plugDirectory.canRead()) {
            this.readJarFiles(plugDirectory, this.maxCount_ + 1);
        }
        for (AbstractPlugInDirective pid : this.directives_) {
            BioFabricToolPlugIn pi = pid.buildPlugIn(this);
            if (pi == null) continue;
            this.toolPlugIns_.add(pi);
        }
        return true;
    }

    public void writeXML(PrintWriter out, Indenter ind, BTProgressMonitor monitor, boolean forCache) throws AsynchExitRequestException {
        ind.indent();
        out.println("<plugInDataSets>");
        List<String> keyList = this.getOrderedToolPlugInKeys();
        for (String key : keyList) {
            BioFabricToolPlugIn plugin = this.getToolPlugIn(key);
            plugin.writeXML(out, ind);
        }
        ind.indent();
        out.println("</plugInDataSets>");
    }

    private boolean readJarFiles(File plugInDir, int currMax) {
        try {
            int propLen = ".properties".length();
            ExtensionFilter filter = new ExtensionFilter(".jar");
            if (plugInDir.isDirectory()) {
                File[] files = plugInDir.listFiles(filter);
                for (int i = 0; i < files.length; ++i) {
                    JarFile jar = new JarFile(files[i]);
                    List<String> sl = this.getServiceList(jar, "org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn");
                    int numSvc = sl.size();
                    for (int j = 0; j < numSvc; ++j) {
                        String plugin = sl.get(j);
                        ToolPlugInDirective pid = new ToolPlugInDirective(plugin, Integer.toString(currMax++), files[i]);
                        this.addDirective(pid);
                    }
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String suffix;
                        JarEntry jarEntry = entries.nextElement();
                        String jarName = jarEntry.getName();
                        int jnlen = jarName.length();
                        if (jnlen <= propLen || !(suffix = jarEntry.getName().substring(jnlen - propLen, jnlen)).equals(".properties")) continue;
                        String prefix = jarEntry.getName().substring(0, jnlen - propLen).replaceAll("/", ".");
                        BufferedReader in = new BufferedReader(new InputStreamReader(jar.getInputStream(jarEntry)));
                        this.rBunds_.put(prefix, new PropertyResourceBundle(in));
                    }
                }
            }
        }
        catch (IOException ioex) {
            return false;
        }
        return true;
    }

    private List<String> getServiceList(JarFile jar, String svcInterface) throws IOException {
        svcInterface = "META-INF/services/" + svcInterface;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.equals(svcInterface)) continue;
            return this.readClassList(jar, entry);
        }
        return new ArrayList<String>();
    }

    private List<String> readClassList(JarFile jar, JarEntry entry) throws IOException {
        String newLine;
        ArrayList<String> retval = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
        while ((newLine = in.readLine()) != null) {
            if ((newLine = newLine.trim()).equals("") || newLine.startsWith("#")) continue;
            retval.add(newLine);
        }
        in.close();
        return retval;
    }

    private boolean readPlugInListing() {
        URL url = this.getClass().getResource("/org/systemsbiology/biofabric/plugin/plugInListing.xml");
        if (url == null) {
            System.err.println("No plugIn directives file found");
            return false;
        }
        ArrayList<ParserClient> alist = new ArrayList<ParserClient>();
        alist.add(new PlugInDirectiveFactory(this));
        SUParser sup = new SUParser(alist);
        try {
            sup.parse(url);
        }
        catch (IOException ioe) {
            System.err.println("Could not read plugIn directives file");
            return false;
        }
        return true;
    }

    class ExtensionFilter
    implements FileFilter {
        private String suffix_;

        ExtensionFilter(String suffix) {
            this.suffix_ = suffix;
        }

        private boolean hasSuffix(String fileName, String suffix) {
            int sufl;
            int fnl = fileName.length();
            return fnl > (sufl = suffix.length()) && fileName.toLowerCase().lastIndexOf(suffix.toLowerCase()) == fnl - sufl;
        }

        public boolean accept(File f) {
            String fileName = f.getName();
            return this.hasSuffix(fileName, this.suffix_);
        }
    }

    public static class PlugInWorker
    extends AbstractFactoryClient {
        public PlugInWorker(FabricFactory.FactoryWhiteboard board, PlugInManager pmg) {
            super(board);
            this.myKeys_.add("plugInDataSets");
            List<String> keyList = pmg.getOrderedToolPlugInKeys();
            for (String key : keyList) {
                BioFabricToolPlugIn plugin = pmg.getToolPlugIn(key);
                AbstractFactoryClient afc = plugin.getXMLWorker(board);
                this.installWorker(afc, null);
            }
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Object retval = null;
            if (this.myKeys_.contains(elemName)) {
                // empty if block
            }
            return retval;
        }
    }

    public static class MyDirectiveGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            PlugInDirectiveFactory.FactoryWhiteboard board = (PlugInDirectiveFactory.FactoryWhiteboard)optionalArgs;
            board.mgr.addDirective(board.dir);
            return null;
        }
    }

    public static class DirectiveWorker
    extends AbstractFactoryClient {
        public DirectiveWorker(PlugInDirectiveFactory.FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("BioFabricPlugIns");
            this.installWorker(new ToolPlugInDirective.DirectiveWorker(whiteboard), new MyDirectiveGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }
}

