/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biofabric.api.parser.ParserClient;
import org.systemsbiology.biofabric.plugin.AbstractPlugInDirective;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInDirectiveFactory
implements ParserClient {
    private HashSet<String> allKeys_ = new HashSet();
    private ParserClient currClient_;
    private HashMap<String, ParserClient> clients_;
    private FactoryWhiteboard whiteBoard_;

    public PlugInDirectiveFactory(PlugInManager mgr) {
        this.whiteBoard_ = new FactoryWhiteboard(mgr);
        PlugInManager.DirectiveWorker ndw = new PlugInManager.DirectiveWorker(this.whiteBoard_);
        ArrayList<PlugInManager.DirectiveWorker> alist = new ArrayList<PlugInManager.DirectiveWorker>();
        alist.add(ndw);
        this.allKeys_.addAll(ndw.keywordsOfInterest());
        Iterator cit = alist.iterator();
        this.clients_ = new HashMap();
        while (cit.hasNext()) {
            ParserClient pc = (ParserClient)cit.next();
            Set<String> keys = pc.keywordsOfInterest();
            for (String key : keys) {
                ParserClient prev = this.clients_.put(key, pc);
                if (prev == null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.currClient_ = null;
    }

    @Override
    public void setContainer(Object container) {
        if (this.currClient_ != null) {
            this.currClient_.setContainer(container);
        }
    }

    @Override
    public boolean finishElement(String elemName) throws IOException {
        if (this.currClient_ == null) {
            return false;
        }
        if (this.currClient_.finishElement(elemName)) {
            this.currClient_ = null;
        }
        return this.allKeys_.contains(elemName);
    }

    @Override
    public void processCharacters(char[] chars, int start, int length) {
        if (this.currClient_ != null) {
            this.currClient_.processCharacters(chars, start, length);
        }
    }

    @Override
    public Set<String> keywordsOfInterest() {
        return this.allKeys_;
    }

    @Override
    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.currClient_ != null) {
            return this.currClient_.processElement(elemName, attrs);
        }
        ParserClient pc = this.clients_.get(elemName);
        if (pc != null) {
            this.currClient_ = pc;
            return this.currClient_.processElement(elemName, attrs);
        }
        return null;
    }

    public static class FactoryWhiteboard {
        public PlugInManager mgr;
        public AbstractPlugInDirective dir;

        public FactoryWhiteboard(PlugInManager mgr) {
            this.mgr = mgr;
        }
    }
}

