/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlugInDirective
implements Comparable<AbstractPlugInDirective> {
    protected String className_;
    protected int order_;
    protected File jar_;

    public AbstractPlugInDirective(String className, String order, File jarFile) {
        this.stockCore(className, order);
        this.jar_ = jarFile;
    }

    protected AbstractPlugInDirective() {
        this.jar_ = null;
    }

    public int getOrder() {
        return this.order_;
    }

    public String getClassName() {
        return this.className_;
    }

    public File getJar() {
        return this.jar_;
    }

    public BioFabricToolPlugIn buildPlugIn(PlugInManager pMan) {
        if (this.jar_ == null) {
            return this.manufacture(pMan);
        }
        return this.load(pMan);
    }

    @Override
    public int compareTo(AbstractPlugInDirective other) {
        if (this.order_ != other.order_) {
            return this.order_ > other.order_ ? 1 : -1;
        }
        return this.className_.compareTo(other.className_);
    }

    protected void stockCoreFromXML(String elemName, Attributes attrs) throws IOException {
        String className = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "class", true);
        String orderStr = AttributeExtractor.extractAttribute(elemName, attrs, elemName, "order", true);
        try {
            this.stockCore(className, orderStr);
        }
        catch (IllegalArgumentException iex) {
            throw new IOException();
        }
    }

    private void stockCore(String className, String order) throws IllegalArgumentException {
        this.className_ = className;
        try {
            this.order_ = Integer.parseInt(order);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException();
        }
    }

    private BioFabricToolPlugIn load(PlugInManager pMan) {
        try {
            URL purl = this.jar_.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{purl}, BioFabricToolPlugIn.class.getClassLoader());
            Class<?> pluggedIn = Class.forName(this.className_, true, loader);
            BioFabricToolPlugIn instance = (BioFabricToolPlugIn)pluggedIn.newInstance();
            instance.setUniquePlugInTag(this.className_);
            instance.installManager(pMan);
            return instance;
        }
        catch (MalformedURLException muex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + muex);
        }
        catch (ClassNotFoundException cnfex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + cnfex);
        }
        catch (InstantiationException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        catch (IllegalAccessException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        return null;
    }

    private BioFabricToolPlugIn manufacture(PlugInManager pMan) {
        try {
            Class<?> plugClass = Class.forName(this.className_);
            BioFabricToolPlugIn instance = (BioFabricToolPlugIn)plugClass.newInstance();
            instance.setUniquePlugInTag(this.className_);
            instance.installManager(pMan);
            return instance;
        }
        catch (ClassNotFoundException cnfex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + cnfex);
        }
        catch (InstantiationException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        catch (IllegalAccessException iex) {
            System.err.println("PlugIn " + this.className_ + " not loaded: " + iex);
        }
        return null;
    }
}

