/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.model;

import java.util.Map;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.util.DataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricLink
implements NetLink,
Cloneable,
AttributeKey {
    private NetNode srcID_;
    private NetNode trgID_;
    private String relation_;
    private Boolean directed_;
    private boolean isShadow_;

    public FabricLink(NetNode srcID, NetNode trgID, String relation, boolean isShadow, Boolean directed) {
        if (srcID == null || trgID == null || relation == null) {
            throw new IllegalArgumentException();
        }
        this.srcID_ = srcID;
        this.trgID_ = trgID;
        this.relation_ = relation;
        this.isShadow_ = isShadow;
        this.directed_ = directed;
    }

    public FabricLink(NetNode srcID, NetNode trgID, String relation, boolean isShadow) {
        this(srcID, trgID, relation, isShadow, null);
    }

    @Override
    public FabricLink flipped() {
        if (this.isFeedback()) {
            throw new IllegalStateException();
        }
        return new FabricLink(this.trgID_, this.srcID_, this.relation_, this.isShadow_, this.directed_);
    }

    public boolean directionFrozen() {
        return this.directed_ != null;
    }

    @Override
    public void installDirection(Boolean isDirected) {
        if (this.directed_ != null) {
            throw new IllegalStateException();
        }
        this.directed_ = isDirected;
    }

    public FabricLink clone() {
        try {
            return (FabricLink)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isShadow() {
        return this.isShadow_;
    }

    public void dropShadowStatus() {
        this.isShadow_ = false;
    }

    @Override
    public NetNode getTrgNode() {
        return this.trgID_;
    }

    @Override
    public NetNode getSrcNode() {
        return this.srcID_;
    }

    @Override
    public String getRelation() {
        return this.relation_;
    }

    @Override
    public AugRelation getAugRelation() {
        return new AugRelation(this.relation_, this.isShadow_);
    }

    @Override
    public boolean isDirected() {
        if (this.directed_ == null) {
            throw new IllegalStateException();
        }
        return this.directed_;
    }

    @Override
    public boolean isFeedback() {
        return this.srcID_.equals(this.trgID_);
    }

    public int hashCode() {
        return this.srcID_.hashCode() + this.trgID_.hashCode() + DataUtil.normKey(this.relation_).hashCode() + (this.isShadow_ ? 17 : 31) + (this.directed_ == null ? 0 : this.directed_.hashCode());
    }

    public String toString() {
        return "srcID = " + this.srcID_ + " trgID = " + this.trgID_ + "rel = " + this.relation_ + " directed_ = " + this.directed_ + " isShadow_ = " + this.isShadow_;
    }

    public String toDisplayString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.srcID_.getName());
        buf.append(this.isDirected() ? (char)'-' : '\u2190');
        if (this.isShadow_) {
            buf.append("shdw");
        }
        buf.append("(");
        buf.append(this.relation_);
        buf.append(")");
        buf.append('\u2192');
        buf.append(this.trgID_.getName());
        return buf.toString();
    }

    public String toEOAString(Map<NetNode, BioFabricNetwork.NodeInfo> nodeInfo) {
        StringBuffer buf = new StringBuffer();
        buf.append(nodeInfo.get(this.srcID_).getNodeName());
        if (this.isShadow_) {
            buf.append(" shdw");
        } else {
            buf.append(" ");
        }
        buf.append("(");
        buf.append(this.relation_);
        buf.append(") ");
        buf.append(nodeInfo.get(this.trgID_).getNodeName());
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof FabricLink)) {
            return false;
        }
        FabricLink otherLink = (FabricLink)other;
        if (!this.srcID_.equals(otherLink.srcID_)) {
            return false;
        }
        if (!this.trgID_.equals(otherLink.trgID_)) {
            return false;
        }
        if (this.isShadow_ != otherLink.isShadow_) {
            return false;
        }
        if (!DataUtil.normKey(this.relation_).equals(DataUtil.normKey(otherLink.relation_))) {
            return false;
        }
        if (this.directed_ == null) {
            return otherLink.directed_ == null;
        }
        return this.directed_.equals(otherLink.directed_);
    }

    @Override
    public boolean synonymous(NetLink other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.isDirected() || other.isDirected()) {
            return false;
        }
        if (!DataUtil.normKey(this.relation_).equals(DataUtil.normKey(other.getRelation()))) {
            return false;
        }
        if (this.isShadow_ != other.isShadow()) {
            return false;
        }
        if (!this.srcID_.equals(other.getTrgNode())) {
            return false;
        }
        return this.trgID_.equals(other.getSrcNode());
    }

    public boolean shadowPair(FabricLink other) {
        if (this.equals(other)) {
            return false;
        }
        if (!this.srcID_.equals(other.srcID_)) {
            return false;
        }
        if (!this.trgID_.equals(other.trgID_)) {
            return false;
        }
        if (!DataUtil.normKey(this.relation_).equals(DataUtil.normKey(other.relation_))) {
            return false;
        }
        if (this.directed_ == null ? other.directed_ != null : !this.directed_.equals(other.directed_)) {
            return false;
        }
        return this.isShadow_ != other.isShadow_;
    }
}

