/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.analysis.Link;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.io.CharacterEntityMapper;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.layout.AnnotColorSource;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.layout.EdgeLayout;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.io.FabricFactory;
import org.systemsbiology.biofabric.model.AnnotationSetImpl;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.model.FabricNode;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInData;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.UiUtil;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioFabricNetwork
implements Network {
    private HashMap<Integer, NetNode> rowToTargID_;
    private int rowCount_;
    private TreeMap<Integer, LinkInfo> fullLinkDefs_;
    private TreeMap<Integer, Integer> nonShadowedLinkMap_;
    private HashMap<NetNode, NodeInfo> nodeDefs_;
    private List<String> linkGrouping_;
    private boolean showLinkGroupAnnotations_;
    private ColumnAssign normalCols_;
    private ColumnAssign shadowCols_;
    private FabricColorGenerator colGen_;
    private Network.LayoutMode layoutMode_;
    private UniqueLabeller nodeIDGenerator_;
    private AnnotationSet nodeAnnot_;
    private Map<Boolean, AnnotationSet> linkAnnots_;
    private PlugInManager pMan_;

    public BioFabricNetwork(BuildData rbd, PlugInManager pMan, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        this.nodeIDGenerator_ = new UniqueLabeller();
        BuildDataImpl bd = (BuildDataImpl)rbd;
        this.pMan_ = pMan;
        this.layoutMode_ = Network.LayoutMode.UNINITIALIZED_MODE;
        BuildDataImpl.BuildMode mode = bd.getMode();
        this.nodeAnnot_ = new AnnotationSetImpl();
        HashMap<Boolean, AnnotationSetImpl> linkAnnots_ = new HashMap<Boolean, AnnotationSetImpl>();
        linkAnnots_.put(Boolean.TRUE, new AnnotationSetImpl());
        linkAnnots_.put(Boolean.FALSE, new AnnotationSetImpl());
        switch (mode) {
            case DEFAULT_LAYOUT: 
            case REORDER_LAYOUT: 
            case CLUSTERED_LAYOUT: 
            case GROUP_PER_NODE_CHANGE: 
            case GROUP_PER_NETWORK_CHANGE: 
            case NODE_ATTRIB_LAYOUT: 
            case LINK_ATTRIB_LAYOUT: 
            case NODE_CLUSTER_LAYOUT: 
            case CONTROL_TOP_LAYOUT: 
            case HIER_DAG_LAYOUT: 
            case SET_LAYOUT: 
            case WORLD_BANK_LAYOUT: {
                this.standardBuildDataInit(bd);
                this.transferRelayoutBuildData(bd);
                this.relayoutNetwork(bd, monitor);
                if (!bd.getTurnOnShadows()) break;
                FabricDisplayOptions dops = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
                dops.setDisplayShadows(true);
                break;
            }
            case BUILD_FROM_PLUGIN: {
                this.standardBuildDataInit(bd);
                this.transferRelayoutBuildData(bd);
                this.processLinks(bd, monitor);
                if (!bd.getTurnOnShadows()) break;
                FabricDisplayOptions dops = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
                dops.setDisplayShadows(true);
                break;
            }
            case BUILD_FOR_SUBMODEL: {
                this.colGen_ = bd.fullNet.colGen_;
                this.linkGrouping_ = new ArrayList<String>(bd.fullNet.linkGrouping_);
                this.showLinkGroupAnnotations_ = bd.fullNet.showLinkGroupAnnotations_;
                this.layoutMode_ = bd.fullNet.layoutMode_;
                this.fillSubModel(bd.fullNet, bd.subNodes, bd.subLinks);
                break;
            }
            case BUILD_FROM_XML: 
            case SHADOW_LINK_CHANGE: {
                this.standardBuildDataTransfer(bd.getExistingNetwork());
                break;
            }
            case BUILD_FROM_SIF: {
                this.standardBuildDataInit(bd);
                this.linkGrouping_ = new ArrayList<String>();
                this.showLinkGroupAnnotations_ = false;
                this.layoutMode_ = Network.LayoutMode.UNINITIALIZED_MODE;
                this.colGen_ = bd.getColorGen();
                this.processLinks(bd, monitor);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void standardBuildDataInit(BuildData bd) {
        this.normalCols_ = new ColumnAssign();
        this.shadowCols_ = new ColumnAssign();
        this.rowToTargID_ = new HashMap();
        this.fullLinkDefs_ = new TreeMap();
        this.nonShadowedLinkMap_ = new TreeMap();
        this.nodeDefs_ = new HashMap();
    }

    private void transferRelayoutBuildData(BuildDataImpl bd) {
        this.linkGrouping_ = new ArrayList<String>(bd.getGroupOrder());
        this.showLinkGroupAnnotations_ = bd.getShowLinkGroupAnnotations();
        this.colGen_ = bd.getColorGen();
        this.layoutMode_ = bd.getGroupOrderMode();
    }

    private void standardBuildDataTransfer(BioFabricNetwork built) {
        this.normalCols_ = built.normalCols_;
        this.shadowCols_ = built.shadowCols_;
        this.rowToTargID_ = built.rowToTargID_;
        this.fullLinkDefs_ = built.fullLinkDefs_;
        this.nonShadowedLinkMap_ = built.nonShadowedLinkMap_;
        this.nodeDefs_ = built.nodeDefs_;
        this.colGen_ = built.colGen_;
        this.rowCount_ = built.rowCount_;
        this.linkGrouping_ = built.linkGrouping_;
        this.showLinkGroupAnnotations_ = built.showLinkGroupAnnotations_;
        this.layoutMode_ = built.layoutMode_;
        this.nodeAnnot_ = built.nodeAnnot_;
        this.linkAnnots_ = built.linkAnnots_;
    }

    public UniqueLabeller getGenerator() {
        return this.nodeIDGenerator_;
    }

    public FabricColorGenerator getColorGenerator() {
        return this.colGen_;
    }

    public List<String> getLinkGrouping() {
        return this.linkGrouping_;
    }

    public void setNodeAnnotations(AnnotationSet aSet) {
        this.nodeAnnot_ = aSet;
    }

    public void setLinkAnnotations(AnnotationSet aSet, boolean forShadow) {
        if (this.linkAnnots_ == null) {
            this.linkAnnots_ = new HashMap<Boolean, AnnotationSet>();
        }
        this.linkAnnots_.put(forShadow, aSet);
    }

    public AnnotationSet getNodeAnnotations() {
        return this.nodeAnnot_;
    }

    public AnnotationSet getLinkAnnotations(boolean forShadow) {
        return this.linkAnnots_ == null ? null : this.linkAnnots_.get(forShadow);
    }

    public Map<String, Set<NetNode>> getNormNameToIDs() {
        HashMap<String, Set<NetNode>> retval = new HashMap<String, Set<NetNode>>();
        for (NetNode key : this.nodeDefs_.keySet()) {
            NodeInfo forKey = this.nodeDefs_.get(key);
            String nameNorm = DataUtil.normKey(forKey.getNodeName());
            Set<NetNode> forName = retval.get(nameNorm);
            if (forName == null) {
                forName = new HashSet<NetNode>();
                retval.put(nameNorm, forName);
            }
            forName.add(key);
        }
        return retval;
    }

    public void installLinkGroups(List<String> linkTagList) {
        this.linkGrouping_ = new ArrayList<String>(linkTagList);
    }

    public void setShowLinkGroupAnnotations(boolean show) {
        this.showLinkGroupAnnotations_ = show;
    }

    public boolean getShowLinkGroupAnnotations() {
        return this.showLinkGroupAnnotations_;
    }

    public List<String> getLinkGroups() {
        return this.linkGrouping_;
    }

    public boolean checkNewNodeOrder(Map<AttributeKey, String> nodeAttributes) {
        HashSet<String> normedNames = new HashSet<String>();
        for (NetNode key : this.rowToTargID_.values()) {
            NodeInfo ni = this.nodeDefs_.get(key);
            normedNames.add(DataUtil.normKey(ni.getNodeName()));
        }
        HashSet<String> normedKeys = new HashSet<String>();
        for (AttributeKey key : nodeAttributes.keySet()) {
            normedKeys.add(DataUtil.normKey(key.toString()));
        }
        if (!normedNames.equals(normedKeys)) {
            return false;
        }
        TreeSet<Integer> asInts = new TreeSet<Integer>();
        for (String asStr : nodeAttributes.values()) {
            try {
                asInts.add(Integer.valueOf(asStr));
            }
            catch (NumberFormatException nfex) {
                return false;
            }
        }
        return asInts.equals(new TreeSet<Integer>(this.rowToTargID_.keySet()));
    }

    public SortedMap<Integer, NetLink> checkNewLinkOrder(Map<AttributeKey, String> linkRows) {
        TreeSet dmks;
        HashMap<AugRelation, Boolean> relDir = new HashMap<AugRelation, Boolean>();
        Set<NetLink> allLinks = this.getAllLinks(true);
        for (NetLink link : allLinks) {
            AugRelation rel = link.getAugRelation();
            boolean bl = link.isDirected();
            Boolean myVal = new Boolean(bl);
            Boolean currVal = (Boolean)relDir.get(rel);
            if (currVal != null) {
                if (currVal.equals(myVal)) continue;
                throw new IllegalStateException();
            }
            relDir.put(rel, myVal);
        }
        TreeMap<Integer, NetLink> dirMap = new TreeMap<Integer, NetLink>();
        for (FabricLink fabricLink : linkRows.keySet()) {
            String colNumStr = linkRows.get(fabricLink);
            FabricLink dirCopy = fabricLink.clone();
            Boolean isDirected = (Boolean)relDir.get(dirCopy.getAugRelation());
            dirCopy.installDirection(isDirected);
            try {
                dirMap.put(Integer.valueOf(colNumStr), dirCopy);
            }
            catch (NumberFormatException nfex) {
                return null;
            }
        }
        TreeSet<NetLink> treeSet = new TreeSet<NetLink>(allLinks);
        TreeSet dmvs = new TreeSet(dirMap.values());
        if (!treeSet.equals(dmvs)) {
            return null;
        }
        TreeSet<Integer> ldks = new TreeSet<Integer>(this.fullLinkDefs_.keySet());
        if (!ldks.equals(dmks = new TreeSet(dirMap.keySet()))) {
            return null;
        }
        return dirMap;
    }

    public Set<NetLink> getAllLinks(boolean withShadows) {
        HashSet<NetLink> allLinks = new HashSet<NetLink>();
        for (Integer col : this.fullLinkDefs_.keySet()) {
            LinkInfo li = this.getLinkDefinition(col, true);
            FabricLink link = li.getLink();
            if (!withShadows && link.isShadow()) continue;
            allLinks.add(link);
        }
        return allLinks;
    }

    public Iterator<Integer> getOrderedLinkInfo(boolean withShadows) {
        return withShadows ? this.fullLinkDefs_.keySet().iterator() : this.nonShadowedLinkMap_.keySet().iterator();
    }

    private void processLinks(BuildData bd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        BuildDataImpl rbd = (BuildDataImpl)bd;
        NodeLayout layout = rbd.getNodeLayout();
        boolean nlok = layout.criteriaMet(rbd, monitor);
        if (!nlok) {
            throw new IllegalStateException();
        }
        List<NetNode> targetIDs = layout.doNodeLayout(rbd, null, monitor);
        this.fillNodesFromOrder(targetIDs, rbd.getColorGen(), rbd.clustAssign, monitor);
        EdgeLayout edgeLayout = rbd.getEdgeLayout();
        edgeLayout.preProcessEdges(rbd, monitor);
        edgeLayout.layoutEdges(rbd, monitor);
        this.specifiedLinkToColumn(rbd.getColorGen(), rbd.getLinkOrder(), false, monitor);
        this.nodeAnnot_ = rbd.getNodeAnnotations();
        this.linkAnnots_ = rbd.getLinkAnnotations();
        this.linkGrouping_ = rbd.getGroupOrder();
        this.layoutMode_ = rbd.getGroupOrderMode();
        this.trimTargetRows(monitor);
        this.loneNodesToLastColumn(rbd.getSingletonNodes(), monitor);
    }

    private void relayoutNetwork(BuildData bd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        BuildDataImpl rbd = (BuildDataImpl)bd;
        BuildDataImpl.BuildMode mode = rbd.getMode();
        this.installLinkGroups(rbd.getGroupOrder());
        this.setShowLinkGroupAnnotations(rbd.getShowLinkGroupAnnotations());
        this.setLayoutMode(rbd.getGroupOrderMode());
        boolean specifiedNodeOrder = mode == BuildDataImpl.BuildMode.NODE_ATTRIB_LAYOUT || mode == BuildDataImpl.BuildMode.DEFAULT_LAYOUT || mode == BuildDataImpl.BuildMode.CONTROL_TOP_LAYOUT || mode == BuildDataImpl.BuildMode.HIER_DAG_LAYOUT || mode == BuildDataImpl.BuildMode.SET_LAYOUT || mode == BuildDataImpl.BuildMode.WORLD_BANK_LAYOUT || mode == BuildDataImpl.BuildMode.NODE_CLUSTER_LAYOUT || mode == BuildDataImpl.BuildMode.CLUSTERED_LAYOUT || mode == BuildDataImpl.BuildMode.REORDER_LAYOUT;
        List<NetNode> targetIDs = specifiedNodeOrder ? this.specifiedIDOrder(rbd.getAllNodes(), rbd.getNodeOrder()) : rbd.getExistingIDOrder();
        this.fillNodesFromOrder(targetIDs, rbd.getColorGen(), rbd.clustAssign, monitor);
        SortedMap<Integer, NetLink> lor = rbd.getLinkOrder();
        Map<NetNode, Integer> nor = rbd.getNodeOrder();
        if (lor == null || lor.isEmpty() || mode == BuildDataImpl.BuildMode.GROUP_PER_NODE_CHANGE || mode == BuildDataImpl.BuildMode.GROUP_PER_NETWORK_CHANGE) {
            if (nor == null || nor.isEmpty()) {
                HashMap<NetNode, Integer> norNew = new HashMap<NetNode, Integer>();
                int numT = targetIDs.size();
                for (int i = 0; i < numT; ++i) {
                    NetNode targID = targetIDs.get(i);
                    norNew.put(targID, i);
                }
                rbd.setNodeOrder(norNew);
            }
            lor = new DefaultEdgeLayout().layoutAllEdges(rbd, monitor);
        }
        this.specifiedLinkToColumn(rbd.getColorGen(), lor, mode == BuildDataImpl.BuildMode.LINK_ATTRIB_LAYOUT || mode == BuildDataImpl.BuildMode.NODE_CLUSTER_LAYOUT || mode == BuildDataImpl.BuildMode.GROUP_PER_NODE_CHANGE || mode == BuildDataImpl.BuildMode.GROUP_PER_NETWORK_CHANGE, monitor);
        this.trimTargetRows(monitor);
        this.loneNodesToLastColumn(rbd.getSingletonNodes(), monitor);
        this.nodeAnnot_ = rbd.getNodeAnnotations();
        this.linkAnnots_ = rbd.getLinkAnnotations();
    }

    private List<NetNode> specifiedIDOrder(Set<NetNode> allNodeIDs, Map<NetNode, Integer> newOrder) {
        TreeMap<Integer, NetNode> forRetval = new TreeMap<Integer, NetNode>();
        for (NetNode key : allNodeIDs) {
            Integer val = newOrder.get(key);
            forRetval.put(val, key);
        }
        return new ArrayList<NetNode>(forRetval.values());
    }

    public List<NetNode> existingIDOrder() {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        for (Integer row : new TreeSet<Integer>(this.rowToTargID_.keySet())) {
            NetNode nodeID = this.rowToTargID_.get(row);
            retval.add(nodeID);
        }
        return retval;
    }

    public SortedMap<Integer, FabricLink> getExistingLinkOrder() {
        TreeMap<Integer, FabricLink> retval = new TreeMap<Integer, FabricLink>();
        for (Integer col : this.fullLinkDefs_.keySet()) {
            LinkInfo li = this.fullLinkDefs_.get(col);
            FabricLink link = li.getLink();
            retval.put(col, link);
        }
        return retval;
    }

    private void specifiedLinkToColumn(FabricColorGenerator colGen, SortedMap<Integer, NetLink> linkOrder, boolean userSpec, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.normalCols_.columnCount = 0;
        this.shadowCols_.columnCount = 0;
        int numColors = colGen.getNumColors();
        Iterator<Integer> frkit = linkOrder.keySet().iterator();
        LoopReporter lr = new LoopReporter(linkOrder.size(), 20, monitor, 0.0, 1.0, "progress.linkToColumn");
        while (frkit.hasNext()) {
            Integer nextCol = frkit.next();
            lr.report();
            NetLink nextLink = (NetLink)linkOrder.get(nextCol);
            Integer[] colCounts = this.addLinkDef(nextLink, numColors, this.normalCols_.columnCount, this.shadowCols_.columnCount, colGen);
            this.shadowCols_.columnCount = colCounts[0];
            if (colCounts[1] == null) continue;
            this.normalCols_.columnCount = colCounts[1];
        }
        lr.finish();
        this.setDrainZonesWithMultipleLabels(true, monitor, 0.0, 0.5);
        this.setDrainZonesWithMultipleLabels(false, monitor, 0.5, 1.0);
    }

    private void setDrainZonesWithMultipleLabels(boolean forShadow, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        List<LinkInfo> links = this.getLinkDefList(forShadow);
        if (links.isEmpty()) {
            return;
        }
        int size = links.size() + this.nodeDefs_.size();
        String progressTag = forShadow ? "progress.findingDrainZonesWithShadow" : "progress.findingDrainZones";
        LoopReporter lr = new LoopReporter(size, 20, monitor, startFrac, endFrac, progressTag);
        TreeMap nodeToZones = new TreeMap();
        if (links.size() == 0) {
            return;
        }
        LinkInfo current = links.get(0);
        int startIdx = 0;
        for (int index = 0; index <= links.size(); ++index) {
            NetNode name;
            MinMax mm;
            lr.report();
            if (index == links.size()) {
                int endIdx = links.size() - 1;
                mm = new MinMax(startIdx, endIdx);
                name = this.findZoneNode(mm, links);
                if (nodeToZones.get(name) == null) {
                    nodeToZones.put(name, new ArrayList());
                }
                ((List)nodeToZones.get(name)).add(new DrainZone(mm, forShadow));
                continue;
            }
            if (this.isContiguous(links.get(index), current)) continue;
            int last = index - 1;
            mm = new MinMax(startIdx, last);
            name = this.findZoneNode(mm, links);
            if (nodeToZones.get(name) == null) {
                nodeToZones.put(name, new ArrayList());
            }
            ((List)nodeToZones.get(name)).add(new DrainZone(mm, forShadow));
            startIdx = index;
            current = links.get(index);
        }
        for (Map.Entry entry : nodeToZones.entrySet()) {
            NodeInfo ni = this.getNodeDefinition((NetNode)entry.getKey());
            lr.report();
            ni.setDrainZones((List)entry.getValue(), forShadow);
        }
        lr.finish();
    }

    private boolean isContiguous(LinkInfo A, LinkInfo B) {
        NetNode mainA = A.isShadow() ? this.getNodeIDForRow(A.bottomRow()) : this.getNodeIDForRow(A.topRow());
        NetNode mainB = B.isShadow() ? this.getNodeIDForRow(B.bottomRow()) : this.getNodeIDForRow(B.topRow());
        return mainA.equals(mainB);
    }

    private NetNode findZoneNode(MinMax mm, List<LinkInfo> links) {
        LinkInfo li = links.get(mm.min);
        if (li.isShadow()) {
            return this.getNodeIDForRow(li.bottomRow());
        }
        return this.getNodeIDForRow(li.topRow());
    }

    public void writeXML(PrintWriter out, Indenter ind, BTProgressMonitor monitor, boolean forCache) throws AsynchExitRequestException {
        ind.indent();
        int numNodes = this.rowToTargID_.size();
        int numLinks = this.fullLinkDefs_.size();
        int numLm = this.nonShadowedLinkMap_.size();
        int numNA = this.nodeAnnot_ == null ? 0 : this.nodeAnnot_.size();
        int numLAs = this.linkAnnots_ == null ? 0 : this.linkAnnots_.get(Boolean.TRUE).size();
        int numLAns = this.linkAnnots_ == null ? 0 : this.linkAnnots_.get(Boolean.FALSE).size();
        out.println("<BioFabric>");
        ind.up();
        String label = forCache ? "progress.cachingCurrentNetwork" : "progress.writingFile";
        LoopReporter lr = new LoopReporter(numNodes + numLinks + numLm + numNA + numLAs + numLAns, 20, monitor, 0.0, 1.0, label);
        this.colGen_.writeXML(out, ind);
        FabricDisplayOptionsManager.getMgr().writeXML(out, ind);
        Iterator<Integer> r2tit = new TreeSet<Integer>(this.rowToTargID_.keySet()).iterator();
        ind.indent();
        out.println("<nodes>");
        ind.up();
        while (r2tit.hasNext()) {
            Integer row = r2tit.next();
            lr.report();
            NetNode nodeID = this.rowToTargID_.get(row);
            NodeInfo ni = this.getNodeDefinition(nodeID);
            ni.writeXML(out, ind, row);
        }
        ind.down().indent();
        out.println("</nodes>");
        if (!this.linkGrouping_.isEmpty()) {
            Iterator<String> lgit = this.linkGrouping_.iterator();
            ind.indent();
            out.print("<linkGroups mode=\"");
            out.print(this.layoutMode_.getText());
            out.print("\" annots=\"");
            out.print(this.showLinkGroupAnnotations_);
            out.println("\">");
            ind.up();
            while (lgit.hasNext()) {
                String grpTag = lgit.next();
                ind.indent();
                out.print("<linkGroup tag=\"");
                out.print(grpTag);
                out.println("\" />");
            }
            ind.down().indent();
            out.println("</linkGroups>");
        }
        HashMap<Integer, Integer> inverse = new HashMap<Integer, Integer>();
        for (Integer key : this.nonShadowedLinkMap_.keySet()) {
            lr.report();
            inverse.put(this.nonShadowedLinkMap_.get(key), key);
        }
        Iterator<Integer> ldit = this.fullLinkDefs_.keySet().iterator();
        ind.indent();
        out.println("<links>");
        ind.up();
        while (ldit.hasNext()) {
            Iterator<Annot> col = ldit.next();
            LinkInfo li = this.getLinkDefinition((Integer)((Object)col), true);
            FabricLink link = li.getLink();
            lr.report();
            ind.indent();
            out.print("<link srcID=\"");
            out.print(link.getSrcNode().getNID().getNID().getInternal());
            out.print("\" trgID=\"");
            out.print(link.getTrgNode().getNID().getNID().getInternal());
            out.print("\" rel=\"");
            AugRelation augr = link.getAugRelation();
            out.print(CharacterEntityMapper.mapEntities(augr.relation, false));
            out.print("\" directed=\"");
            out.print(link.isDirected());
            out.print("\" shadow=\"");
            out.print(augr.isShadow);
            if (!augr.isShadow) {
                Integer nsCol = (Integer)inverse.get(col);
                out.print("\" column=\"");
                out.print(nsCol);
            }
            out.print("\" shadowCol=\"");
            out.print(col);
            out.print("\" srcRow=\"");
            out.print(li.getStartRow());
            out.print("\" trgRow=\"");
            out.print(li.getEndRow());
            out.print("\" color=\"");
            out.print(li.getColorKey());
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</links>");
        ind.indent();
        out.println("<nodeAnnotations>");
        ind.up();
        if (this.nodeAnnot_ != null) {
            for (Annot an : this.nodeAnnot_) {
                lr.report();
                ((AnnotationSetImpl.AnnotImpl)an).writeXML(out, ind);
            }
        }
        ind.down().indent();
        out.println("</nodeAnnotations>");
        ind.indent();
        out.println("<linkAnnotations>");
        ind.up();
        if (this.linkAnnots_ != null) {
            for (Annot an : this.linkAnnots_.get(Boolean.FALSE)) {
                lr.report();
                ((AnnotationSetImpl.AnnotImpl)an).writeXML(out, ind);
            }
        }
        ind.down().indent();
        out.println("</linkAnnotations>");
        ind.indent();
        out.println("<shadowLinkAnnotations>");
        ind.up();
        if (this.linkAnnots_ != null) {
            for (Annot an : this.linkAnnots_.get(Boolean.TRUE)) {
                lr.report();
                ((AnnotationSetImpl.AnnotImpl)an).writeXML(out, ind);
            }
        }
        ind.down().indent();
        out.println("</shadowLinkAnnotations>");
        ind.indent();
        out.println("<plugInDataSets>");
        List<String> keyList = this.pMan_.getOrderedToolPlugInKeys();
        for (String key : keyList) {
            BioFabricToolPlugIn plugin = this.pMan_.getToolPlugIn(key);
            plugin.writeXML(out, ind);
        }
        ind.indent();
        out.println("</plugInDataSets>");
        lr.finish();
        ind.down().indent();
        out.println("</BioFabric>");
    }

    public void writeNOA(PrintWriter out) {
        out.println("Node Row");
        for (Integer row : new TreeSet<Integer>(this.rowToTargID_.keySet())) {
            NetNode nodeID = this.rowToTargID_.get(row);
            NodeInfo ni = this.getNodeDefinition(nodeID);
            out.print(ni.getNodeName());
            out.print(" = ");
            out.println(row);
        }
    }

    public void writeEDA(PrintWriter out) {
        out.println("Link Column");
        for (Integer col : this.fullLinkDefs_.keySet()) {
            LinkInfo li = this.getLinkDefinition(col, true);
            FabricLink link = li.getLink();
            out.print(link.toEOAString(this.nodeDefs_));
            out.print(" = ");
            out.println(col);
        }
    }

    public NodeInfo getNodeDefinition(NetNode targID) {
        NodeInfo node = this.nodeDefs_.get(targID);
        return node;
    }

    public Map<NetNode, NodeInfo> getAllNodeDefinitions() {
        return this.nodeDefs_;
    }

    public LinkInfo getLinkDefinition(Integer colObj, boolean forShadow) {
        if (forShadow) {
            return this.fullLinkDefs_.get(colObj);
        }
        Integer mapped = this.nonShadowedLinkMap_.get(colObj);
        if (mapped != null) {
            return this.fullLinkDefs_.get(mapped);
        }
        return null;
    }

    public NetNode getTargetIDForColumn(Integer colVal, boolean forShadow) {
        ColumnAssign useCA = forShadow ? this.shadowCols_ : this.normalCols_;
        NetNode target = useCA.columnToTarget.get(colVal);
        return target;
    }

    public NetNode getDrainForColumn(Integer colVal, boolean forShadow) {
        NodeInfo nis;
        List<DrainZone> sdzs;
        NodeInfo nit;
        List<DrainZone> tdzs;
        int col = colVal;
        ColumnAssign useCA = forShadow ? this.shadowCols_ : this.normalCols_;
        NetNode targetID = useCA.columnToTarget.get(colVal);
        NetNode sourceID = useCA.columnToSource.get(colVal);
        if (targetID != null && (tdzs = (nit = this.nodeDefs_.get(targetID)).getDrainZones(forShadow)) != null) {
            for (DrainZone tdz : tdzs) {
                if (col < tdz.getMinMax().min || col > tdz.getMinMax().max) continue;
                return targetID;
            }
        }
        if (sourceID != null && (sdzs = (nis = this.nodeDefs_.get(sourceID)).getDrainZones(forShadow)) != null) {
            for (DrainZone sdz : sdzs) {
                if (col < sdz.getMinMax().min || col > sdz.getMinMax().max) continue;
                return sourceID;
            }
        }
        return null;
    }

    public NetNode getSourceIDForColumn(Integer colVal, boolean forShadow) {
        ColumnAssign useCA = forShadow ? this.shadowCols_ : this.normalCols_;
        NetNode source = useCA.columnToSource.get(colVal);
        return source;
    }

    public NetNode getNodeIDForRow(Integer rowObj) {
        NetNode node = this.rowToTargID_.get(rowObj);
        return node;
    }

    @Override
    public int getLinkCount(boolean forShadow) {
        return forShadow ? this.fullLinkDefs_.size() : this.nonShadowedLinkMap_.size();
    }

    public int getColumnCount(boolean forShadow) {
        ColumnAssign useCA = forShadow ? this.shadowCols_ : this.normalCols_;
        return useCA.columnCount;
    }

    @Override
    public int getNodeCount() {
        return this.rowCount_;
    }

    public int getRowCount() {
        return this.rowCount_;
    }

    public void stashPluginData(String keyword, BioFabricToolPlugInData data) {
    }

    public BioFabricToolPlugInData providePluginData(String keyword) {
        return null;
    }

    public List<NodeInfo> getNodeDefList() {
        return new ArrayList<NodeInfo>(this.nodeDefs_.values());
    }

    public Set<NetNode> getNodeSetIDs() {
        HashSet<NetNode> retval = new HashSet<NetNode>();
        for (NodeInfo ni : this.nodeDefs_.values()) {
            retval.add(new FabricNode(ni.getNodeID(), ni.getNodeName()));
        }
        return retval;
    }

    public List<LinkInfo> getLinkDefList(boolean forShadow) {
        if (forShadow) {
            return new ArrayList<LinkInfo>(this.fullLinkDefs_.values());
        }
        ArrayList<LinkInfo> retval = new ArrayList<LinkInfo>();
        for (Integer linkID : this.nonShadowedLinkMap_.keySet()) {
            Integer mappedID = this.nonShadowedLinkMap_.get(linkID);
            retval.add(this.fullLinkDefs_.get(mappedID));
        }
        return retval;
    }

    public void setLayoutMode(Network.LayoutMode mode) {
        this.layoutMode_ = mode;
    }

    public Network.LayoutMode getLayoutMode() {
        return this.layoutMode_;
    }

    public Set<NetNode> nodeMatches(boolean fullMatch, String searchString) {
        HashSet<NetNode> retval = new HashSet<NetNode>();
        for (NetNode nodeID : this.nodeDefs_.keySet()) {
            String nodeName = this.nodeDefs_.get(nodeID).getNodeName();
            if (!this.matches(searchString, nodeName, fullMatch)) continue;
            retval.add(nodeID);
        }
        return retval;
    }

    public void getFirstNeighbors(NetNode nodeID, Set<NetNode> nodeSet, List<NodeInfo> nodes, List<LinkInfo> links) {
        for (LinkInfo linf : this.fullLinkDefs_.values()) {
            if (linf.getSource().equals(nodeID)) {
                nodeSet.add(linf.getTarget());
                links.add(linf);
                continue;
            }
            if (!linf.getTarget().equals(nodeID)) continue;
            nodeSet.add(linf.getSource());
            links.add(linf);
        }
        for (NetNode nextID : nodeSet) {
            nodes.add(this.nodeDefs_.get(nextID));
        }
    }

    public Set<NetNode> getFirstNeighbors(NetNode nodeID) {
        HashSet<NetNode> nodeSet = new HashSet<NetNode>();
        for (LinkInfo linf : this.fullLinkDefs_.values()) {
            if (linf.getSource().equals(nodeID)) {
                nodeSet.add(linf.getTarget());
                continue;
            }
            if (!linf.getTarget().equals(nodeID)) continue;
            nodeSet.add(linf.getSource());
        }
        return nodeSet;
    }

    public void addFirstNeighbors(Set<NetNode> nodeSet, Set<Integer> columnSet, Set<FabricLink> linkSet, boolean forShadow) {
        HashSet<NetNode> newNodes = new HashSet<NetNode>();
        for (LinkInfo linf : this.fullLinkDefs_.values()) {
            if (!forShadow && linf.isShadow()) continue;
            if (nodeSet.contains(linf.getSource())) {
                newNodes.add(linf.getTarget());
                columnSet.add(linf.getUseColumn(forShadow));
                linkSet.add(linf.getLink());
            }
            if (!nodeSet.contains(linf.getTarget())) continue;
            newNodes.add(linf.getSource());
            columnSet.add(linf.getUseColumn(forShadow));
            linkSet.add(linf.getLink());
        }
        nodeSet.addAll(newNodes);
    }

    private boolean matches(String searchString, String nodeName, boolean isFull) {
        String canonicalNodeName = DataUtil.normKey(nodeName);
        if (isFull) {
            return canonicalNodeName.equals(searchString);
        }
        return canonicalNodeName.indexOf(searchString) != -1;
    }

    private Map<NetNode, Integer> linkCountPerTarg(Set<NetNode> targets, List<LinkInfo> linkList) {
        HashMap<NetNode, Integer> retval = new HashMap<NetNode, Integer>();
        for (LinkInfo linf : linkList) {
            Integer count;
            NetNode src = linf.getSource();
            NetNode trg = linf.getTarget();
            if (targets.contains(src)) {
                count = retval.get(src);
                if (count == null) {
                    retval.put(src, 1);
                } else {
                    retval.put(src, count + 1);
                }
            }
            if (src.equals(trg) || !targets.contains(trg)) continue;
            count = retval.get(trg);
            if (count == null) {
                retval.put(trg, 1);
                continue;
            }
            retval.put(trg, count + 1);
        }
        return retval;
    }

    private List<LinkInfo> pruneToMinSubModel(BioFabricNetwork bfn, List<NodeInfo> targetList, List<LinkInfo> linkList) {
        HashSet<NetNode> targSet = new HashSet<NetNode>();
        for (NodeInfo ninf : targetList) {
            targSet.add(new FabricNode(ninf.getNodeID(), ninf.getNodeName()));
        }
        Map<NetNode, Integer> subCounts = this.linkCountPerTarg(targSet, linkList);
        Map<NetNode, Integer> fullCounts = this.linkCountPerTarg(bfn.getNodeSetIDs(), bfn.getLinkDefList(true));
        HashSet<Integer> skipThem = new HashSet<Integer>();
        HashSet<Integer> ditchThem = new HashSet<Integer>();
        block1: for (LinkInfo linf : linkList) {
            NetNode topNode = bfn.getNodeIDForRow(linf.topRow());
            NetNode botNode = bfn.getNodeIDForRow(linf.bottomRow());
            boolean topStays = subCounts.get(topNode).equals(fullCounts.get(topNode));
            boolean botStays = subCounts.get(botNode).equals(fullCounts.get(botNode));
            if (topStays && botStays || !topStays && !botStays) continue;
            FabricLink link1 = linf.getLink();
            int col1 = linf.getUseColumn(true);
            skipThem.add(col1);
            for (LinkInfo linf2 : linkList) {
                int col2 = linf2.getUseColumn(true);
                if (skipThem.contains(col2) || !linf2.getLink().shadowPair(link1)) continue;
                int maxLink = Math.max(col1, col2);
                int minLink = Math.min(col1, col2);
                ditchThem.add(topStays ? maxLink : minLink);
                continue block1;
            }
        }
        ArrayList<LinkInfo> retval = new ArrayList<LinkInfo>();
        for (LinkInfo linf : linkList) {
            int col = linf.getUseColumn(true);
            if (ditchThem.contains(col)) continue;
            retval.add(linf);
        }
        return retval;
    }

    /*
     * WARNING - void declaration
     */
    private void fillSubModel(BioFabricNetwork bfn, List<NodeInfo> targetList, List<LinkInfo> linkList) {
        boolean doPrune = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getMinShadowSubmodelLinks();
        if (doPrune) {
            linkList = this.pruneToMinSubModel(bfn, targetList, linkList);
        }
        HashMap<NetNode, Integer> lastColForNode = new HashMap<NetNode, Integer>();
        HashMap<NetNode, Integer> lastShadColForNode = new HashMap<NetNode, Integer>();
        for (LinkInfo linf : linkList) {
            Integer lastColShad;
            if (!linf.isShadow()) {
                Integer lastCol = (Integer)lastColForNode.get(linf.getTarget());
                if (lastCol == null || lastCol < linf.getUseColumn(false)) {
                    lastColForNode.put(linf.getTarget(), linf.getUseColumn(false));
                }
                if ((lastCol = (Integer)lastColForNode.get(linf.getSource())) == null || lastCol < linf.getUseColumn(false)) {
                    lastColForNode.put(linf.getSource(), linf.getUseColumn(false));
                }
            }
            if ((lastColShad = (Integer)lastShadColForNode.get(linf.getTarget())) == null || lastColShad < linf.getUseColumn(true)) {
                lastShadColForNode.put(linf.getTarget(), linf.getUseColumn(true));
            }
            if ((lastColShad = (Integer)lastShadColForNode.get(linf.getSource())) != null && lastColShad >= linf.getUseColumn(true)) continue;
            lastShadColForNode.put(linf.getSource(), linf.getUseColumn(true));
        }
        TreeSet<Integer> needRows = new TreeSet<Integer>();
        TreeSet<Integer> needColumns = new TreeSet<Integer>();
        TreeSet<Integer> needColumnsShad = new TreeSet<Integer>();
        for (NodeInfo targetInf : targetList) {
            needRows.add(targetInf.nodeRow);
            needColumns.add(targetInf.getColRange((boolean)false).min);
            needColumnsShad.add(targetInf.getColRange((boolean)true).min);
        }
        for (LinkInfo linf : linkList) {
            needRows.add(linf.getStartRow());
            needRows.add(linf.getEndRow());
            if (!linf.isShadow()) {
                needColumns.add(linf.getUseColumn(false));
            }
            needColumnsShad.add(linf.getUseColumn(true));
        }
        TreeMap<Integer, Integer> rowMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> columnMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> shadColumnMap = new TreeMap<Integer, Integer>();
        int rowCount = 0;
        for (Integer n : needRows) {
            rowMap.put(n, rowCount++);
        }
        int colCount = 0;
        for (Integer n : needColumns) {
            columnMap.put(n, colCount++);
        }
        boolean bl = false;
        for (Integer fullCol : needColumnsShad) {
            void var16_20;
            shadColumnMap.put(fullCol, (int)(++var16_20));
        }
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
        ArrayList<LinkInfo> modLinkList = new ArrayList<LinkInfo>();
        int maxShadLinkCol = Integer.MIN_VALUE;
        int maxLinkCol = Integer.MIN_VALUE;
        for (LinkInfo linf : linkList) {
            int miniColShadVal;
            Integer startRowObj = (Integer)rowMap.get(linf.getStartRow());
            Integer endRowObj = (Integer)rowMap.get(linf.getEndRow());
            Integer miniColObj = linf.isShadow() ? Integer.valueOf(Integer.MIN_VALUE) : (Integer)columnMap.get(linf.getUseColumn(false));
            Integer miniColShadObj = (Integer)shadColumnMap.get(linf.getUseColumn(true));
            int miniColVal = miniColObj;
            if (miniColVal > maxLinkCol) {
                maxLinkCol = miniColVal;
            }
            if ((miniColShadVal = miniColShadObj.intValue()) > maxShadLinkCol) {
                maxShadLinkCol = miniColShadVal;
            }
            LinkInfo miniLinf = new LinkInfo(linf.getLink(), startRowObj, endRowObj, miniColObj, miniColShadObj, linf.getColorKey());
            modLinkList.add(miniLinf);
        }
        maxLinkCol = maxLinkCol == Integer.MIN_VALUE ? 1 : ++maxLinkCol;
        maxShadLinkCol = maxShadLinkCol == Integer.MIN_VALUE ? 1 : ++maxShadLinkCol;
        int minTrgCol = Integer.MAX_VALUE;
        int minShadTrgCol = Integer.MAX_VALUE;
        for (NodeInfo infoFull : targetList) {
            int maxShadCol;
            int maxCol;
            Integer lastCol;
            Integer miniRowObj = (Integer)rowMap.get(infoFull.nodeRow);
            NodeInfo infoMini = new NodeInfo(infoFull.getNodeID(), infoFull.getNodeName(), miniRowObj, infoFull.colorKey);
            Integer minCol = (Integer)columnMap.get(infoFull.getColRange((boolean)false).min);
            infoMini.updateMinMaxCol(minCol, false);
            int miniColVal = minCol;
            if (miniColVal < minTrgCol) {
                minTrgCol = miniColVal;
            }
            Integer minShadCol = (Integer)shadColumnMap.get(infoFull.getColRange((boolean)true).min);
            infoMini.updateMinMaxCol(minShadCol, true);
            int miniShadColVal = minShadCol;
            if (miniShadColVal < minShadTrgCol) {
                minShadTrgCol = miniShadColVal;
            }
            if ((lastCol = (Integer)lastColForNode.get(infoFull.getNodeID())) == null) {
                maxCol = maxLinkCol;
            } else {
                Integer maxColObj = (Integer)columnMap.get(lastCol);
                maxCol = maxColObj;
            }
            infoMini.updateMinMaxCol(maxCol, false);
            Integer lastShadCol = (Integer)lastShadColForNode.get(infoFull.getNodeID());
            if (lastShadCol == null) {
                maxShadCol = maxShadLinkCol;
            } else {
                Integer maxShadColObj = (Integer)shadColumnMap.get(lastShadCol);
                maxShadCol = maxShadColObj;
            }
            infoMini.updateMinMaxCol(maxShadCol, true);
            arrayList.add(infoMini);
        }
        if (minTrgCol == Integer.MAX_VALUE) {
            minTrgCol = 0;
        }
        this.rowToTargID_ = new HashMap();
        this.nodeDefs_ = new HashMap();
        this.rowCount_ = arrayList.size();
        for (int i = 0; i < this.rowCount_; ++i) {
            NodeInfo infoMini = (NodeInfo)arrayList.get(i);
            FabricNode nwn = new FabricNode(infoMini.getNodeID(), infoMini.getNodeName());
            this.rowToTargID_.put(infoMini.nodeRow, nwn);
            this.nodeDefs_.put(nwn, infoMini);
        }
        this.normalCols_ = new ColumnAssign();
        this.shadowCols_ = new ColumnAssign();
        this.fullLinkDefs_ = new TreeMap();
        this.nonShadowedLinkMap_ = new TreeMap();
        int numMll = modLinkList.size();
        for (int i = 0; i < numMll; ++i) {
            LinkInfo infoMini = (LinkInfo)modLinkList.get(i);
            Integer useShadCol = infoMini.getUseColumn(true);
            this.fullLinkDefs_.put(useShadCol, infoMini);
            this.shadowCols_.columnToSource.put(useShadCol, infoMini.getSource());
            this.shadowCols_.columnToTarget.put(useShadCol, infoMini.getTarget());
            if (infoMini.isShadow()) continue;
            Integer useCol = infoMini.getUseColumn(false);
            this.nonShadowedLinkMap_.put(useCol, useShadCol);
            this.normalCols_.columnToSource.put(useCol, infoMini.getSource());
            this.normalCols_.columnToTarget.put(useCol, infoMini.getTarget());
        }
        this.normalCols_.columnCount = maxLinkCol - minTrgCol;
        this.shadowCols_.columnCount = maxShadLinkCol - minShadTrgCol;
        UiUtil.fixMePrintout("Are multiple drain zones handled for submodels? NO");
        for (NetNode node : this.nodeDefs_.keySet()) {
            LinkInfo linf;
            NodeInfo srcNI = this.nodeDefs_.get(node);
            MinMax srcDrain = null;
            MinMax range = srcNI.getColRange(false);
            int startCol = range.max;
            int endCol = range.min;
            for (int i = startCol; i >= endCol && (linf = this.getLinkDefinition(i, false)) != null && (linf.getSource().equals(node) || linf.getTarget().equals(node)) && (linf.bottomRow() != srcNI.nodeRow || linf.topRow() == srcNI.nodeRow); --i) {
                if (linf.topRow() != srcNI.nodeRow) continue;
                if (srcDrain == null) {
                    srcDrain = new MinMax();
                    srcDrain.init();
                }
                srcDrain.update(i);
            }
            if (srcDrain != null) {
                srcNI.addDrainZone(new DrainZone(srcDrain, false));
            }
            MinMax shadowSrcDrain = null;
            MinMax shadowRange = srcNI.getColRange(true);
            int startColShad = shadowRange.min;
            int endColShad = shadowRange.max;
            for (int i = startColShad; i <= endColShad; ++i) {
                boolean isShadow;
                LinkInfo linf2 = this.getLinkDefinition(i, true);
                if (linf2 == null) continue;
                boolean bl2 = isShadow = linf2 != null && linf2.isShadow();
                if (shadowSrcDrain != null && (linf2 == null || !linf2.getSource().equals(node) && !linf2.getTarget().equals(node))) break;
                if ((linf2.topRow() != srcNI.nodeRow || isShadow) && (linf2.bottomRow() != srcNI.nodeRow || !isShadow)) continue;
                if (shadowSrcDrain == null) {
                    shadowSrcDrain = new MinMax();
                    shadowSrcDrain.init();
                }
                shadowSrcDrain.update(i);
            }
            if (shadowSrcDrain == null) continue;
            srcNI.addDrainZone(new DrainZone(shadowSrcDrain, true));
        }
        UiUtil.fixMePrintout("Nodes are stretching all the way to right border in LesMizCluster subset.");
        this.nodeAnnot_ = this.annotationsForSubNet(rowMap, bfn.nodeAnnot_);
        if (bfn.linkAnnots_ != null) {
            this.linkAnnots_ = new HashMap<Boolean, AnnotationSet>();
            if (bfn.linkAnnots_.get(Boolean.FALSE) != null) {
                this.linkAnnots_.put(Boolean.FALSE, this.annotationsForSubNet(columnMap, bfn.linkAnnots_.get(Boolean.FALSE)));
            }
            if (bfn.linkAnnots_.get(Boolean.TRUE) != null) {
                this.linkAnnots_.put(Boolean.TRUE, this.annotationsForSubNet(shadColumnMap, bfn.linkAnnots_.get(Boolean.TRUE)));
            }
        }
    }

    private AnnotationSet annotationsForSubNet(TreeMap<Integer, Integer> reduceMap, AnnotationSet origAnnots) {
        AnnotationSetImpl retval = new AnnotationSetImpl();
        if (origAnnots == null || origAnnots.size() == 0) {
            return retval;
        }
        TreeMap<Annot, MinMax> useAnnots = new TreeMap<Annot, MinMax>();
        block0: for (Integer origRow : reduceMap.keySet()) {
            int orVal = origRow;
            for (Annot origAnnot : origAnnots) {
                MinMax anRange = origAnnot.getRange();
                if (orVal < anRange.min || orVal > anRange.max) continue;
                MinMax useRange = (MinMax)useAnnots.get(origAnnot);
                Integer newRowOrCol = reduceMap.get(origRow);
                int nrVal = newRowOrCol;
                if (useRange == null) {
                    useRange = new MinMax(nrVal, nrVal);
                    useAnnots.put(origAnnot, useRange);
                    continue block0;
                }
                useRange.update(nrVal);
                continue block0;
            }
        }
        for (Annot oldAnnot : useAnnots.keySet()) {
            MinMax useRange = (MinMax)useAnnots.get(oldAnnot);
            AnnotColorSource.AnnotColor color = oldAnnot.getColor();
            String colorName = color == null ? null : color.getName();
            AnnotationSetImpl.AnnotImpl ai = new AnnotationSetImpl.AnnotImpl(oldAnnot.getName(), useRange.min, useRange.max, oldAnnot.getLayer(), colorName);
            retval.addAnnot(ai);
        }
        return retval;
    }

    private void fillNodesFromOrder(List<NetNode> targetIDs, FabricColorGenerator colGen, Map<NetNode, String> clustAssign, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int numColors = colGen.getNumColors();
        LoopReporter lr = new LoopReporter(targetIDs.size(), 20, monitor, 0.0, 1.0, "progress.nodeInfo");
        int currRow = 0;
        for (NetNode targetID : targetIDs) {
            lr.report();
            Integer rowObj = currRow;
            this.rowToTargID_.put(rowObj, targetID);
            String colorKey = colGen.getGeneColor(currRow % numColors);
            if (targetID == null) {
                UiUtil.fixMePrintout("SAW THIS FOR ROW OBJ 5245");
                UiUtil.fixMePrintout("targetID is Null " + rowObj);
            }
            NodeInfo nextNI = new NodeInfo(targetID.getNID().getNID(), targetID.getName(), currRow++, colorKey);
            if (clustAssign != null) {
                nextNI.setCluster(clustAssign.get(targetID));
            }
            this.nodeDefs_.put(targetID, nextNI);
        }
        this.rowCount_ = targetIDs.size();
    }

    void addNodeInfoForIO(NodeInfo nif) {
        FabricNode nwn = new FabricNode(nif.getNodeID(), nif.getNodeName());
        this.nodeDefs_.put(nwn, nif);
        this.rowCount_ = this.nodeDefs_.size();
        this.rowToTargID_.put(nif.nodeRow, nwn);
    }

    private void trimTargetRows(BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(this.fullLinkDefs_.size(), 20, monitor, 0.0, 0.5, "progress.trimTargetRows1");
        for (Integer colNum : this.fullLinkDefs_.keySet()) {
            lr.report();
            LinkInfo li = this.fullLinkDefs_.get(colNum);
            this.shadowCols_.columnToSource.put(colNum, li.getSource());
            this.shadowCols_.columnToTarget.put(colNum, li.getTarget());
            NodeInfo srcNI = this.nodeDefs_.get(li.getSource());
            NodeInfo trgNI = this.nodeDefs_.get(li.getTarget());
            srcNI.updateMinMaxCol(colNum, true);
            trgNI.updateMinMaxCol(colNum, true);
        }
        lr.finish();
        LoopReporter lr2 = new LoopReporter(this.nonShadowedLinkMap_.size(), 20, monitor, 0.5, 1.0, "progress.trimTargetRows2");
        for (Integer colNum : this.nonShadowedLinkMap_.keySet()) {
            lr2.report();
            Integer mappedCol = this.nonShadowedLinkMap_.get(colNum);
            LinkInfo li = this.fullLinkDefs_.get(mappedCol);
            this.normalCols_.columnToSource.put(colNum, li.getSource());
            this.normalCols_.columnToTarget.put(colNum, li.getTarget());
            NodeInfo srcNI = this.nodeDefs_.get(li.getSource());
            NodeInfo trgNI = this.nodeDefs_.get(li.getTarget());
            srcNI.updateMinMaxCol(colNum, false);
            trgNI.updateMinMaxCol(colNum, false);
        }
        lr.finish();
    }

    private void loneNodesToLastColumn(Set<NetNode> loneNodeIDs, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(loneNodeIDs.size(), 20, monitor, 0.0, 1.0, "progress.loneNodes");
        for (NetNode loneID : loneNodeIDs) {
            lr.report();
            NodeInfo loneNI = this.nodeDefs_.get(loneID);
            loneNI.updateMinMaxCol(this.normalCols_.columnCount - 1, false);
            loneNI.updateMinMaxCol(this.shadowCols_.columnCount - 1, true);
        }
        lr.finish();
    }

    public Set<NetNode> getLoneNodes(BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<NetNode> retval = new HashSet<NetNode>(this.nodeDefs_.keySet());
        LoopReporter lr = new LoopReporter(this.fullLinkDefs_.size(), 20, monitor, 0.0, 1.0, "progress.findingLoneNodes");
        for (LinkInfo lif : this.fullLinkDefs_.values()) {
            lr.report();
            FabricLink link = lif.getLink();
            retval.remove(link.getSrcNode());
            retval.remove(link.getTrgNode());
        }
        lr.finish();
        return retval;
    }

    private Integer[] addLinkDef(NetLink nextLink, int numColors, int noShadowCol, int shadowCol, FabricColorGenerator colGen) {
        Integer[] retval = new Integer[2];
        String key = colGen.getGeneColor(shadowCol % numColors);
        int srcRow = this.nodeDefs_.get((Object)nextLink.getSrcNode()).nodeRow;
        int trgRow = this.nodeDefs_.get((Object)nextLink.getTrgNode()).nodeRow;
        LinkInfo linf = new LinkInfo((FabricLink)nextLink, srcRow, trgRow, noShadowCol, shadowCol, key);
        Integer shadowKey = shadowCol;
        this.fullLinkDefs_.put(shadowKey, linf);
        retval[0] = shadowCol + 1;
        if (!linf.isShadow()) {
            this.nonShadowedLinkMap_.put(noShadowCol, shadowKey);
            retval[1] = noShadowCol + 1;
        }
        return retval;
    }

    void addLinkInfoForIO(LinkInfo linf) {
        int useColVal = linf.getUseColumn(true);
        Integer useCol = useColVal;
        this.fullLinkDefs_.put(useCol, linf);
        if (useColVal > this.shadowCols_.columnCount) {
            this.shadowCols_.columnCount = useColVal;
        }
        this.shadowCols_.columnToSource.put(useCol, linf.getSource());
        this.shadowCols_.columnToTarget.put(useCol, linf.getTarget());
        if (!linf.isShadow()) {
            int useNColVal = linf.getUseColumn(false);
            Integer useNCol = useNColVal;
            this.nonShadowedLinkMap_.put(useNCol, useCol);
            if (useNColVal > this.normalCols_.columnCount) {
                this.normalCols_.columnCount = useNColVal;
            }
            this.normalCols_.columnToSource.put(useNCol, linf.getSource());
            this.normalCols_.columnToTarget.put(useNCol, linf.getTarget());
        }
    }

    void addLinkGroupForIO(String tag) {
        this.linkGrouping_.add(tag);
    }

    void setColorGenerator(FabricColorGenerator fcg) {
        this.colGen_ = fcg;
    }

    public boolean nodeClustersAssigned() {
        if (this.nodeDefs_.isEmpty()) {
            return false;
        }
        NodeInfo ni = this.nodeDefs_.values().iterator().next();
        return ni.getCluster() != null;
    }

    public Map<NetNode, String> nodeClusterAssigment() {
        HashMap<NetNode, String> retval = new HashMap<NetNode, String>();
        if (this.nodeDefs_.isEmpty()) {
            return retval;
        }
        for (NodeInfo ni : this.nodeDefs_.values()) {
            String cluster = ni.getCluster();
            if (cluster == null) {
                throw new IllegalStateException();
            }
            retval.put(new FabricNode(ni.getNodeID(), ni.getNodeName()), cluster);
        }
        return retval;
    }

    public void setNodeClusterAssigment(Map<NID, String> assign) {
        if (this.nodeDefs_.isEmpty()) {
            throw new IllegalStateException();
        }
        for (NodeInfo ni : this.nodeDefs_.values()) {
            String cluster = assign.get(ni.getNodeID());
            if (cluster == null) {
                throw new IllegalArgumentException();
            }
            ni.setCluster(cluster);
        }
    }

    BioFabricNetwork() {
        this.normalCols_ = new ColumnAssign();
        this.shadowCols_ = new ColumnAssign();
        this.rowToTargID_ = new HashMap();
        this.fullLinkDefs_ = new TreeMap();
        this.nonShadowedLinkMap_ = new TreeMap();
        this.nodeDefs_ = new HashMap();
        this.linkGrouping_ = new ArrayList<String>();
        this.showLinkGroupAnnotations_ = false;
        this.colGen_ = null;
    }

    public static class Extents {
        public HashMap<Boolean, HashMap<Integer, MinMax>> allLinkExtents = new HashMap();
        public HashMap<Boolean, HashMap<Integer, MinMax>> allNodeExtents = new HashMap();
        public HashMap<Boolean, MinMax> allLinkFullRange = new HashMap();
        public HashMap<Boolean, MinMax> allNodeFullRange = new HashMap();
        public HashMap<Boolean, Integer> singletonNodeStart = new HashMap();

        public Extents() {
            boolean[] builds;
            for (boolean build : builds = new boolean[]{true, false}) {
                MinMax linkFullRange = new MinMax();
                HashMap linkExtents = new HashMap();
                this.allLinkExtents.put(build, linkExtents);
                this.allLinkFullRange.put(build, linkFullRange);
                MinMax nodeFullRange = new MinMax();
                HashMap nodeExtents = new HashMap();
                this.allNodeExtents.put(build, nodeExtents);
                this.allNodeFullRange.put(build, nodeFullRange);
            }
        }

        public Extents(BioFabricNetwork bfn, BTProgressMonitor monitor) throws AsynchExitRequestException {
            this();
            Boolean boolKey;
            boolean[] builds = new boolean[]{true, false};
            HashMap<NID, Integer> singletons = new HashMap<NID, Integer>();
            for (boolean build : builds) {
                boolKey = build;
                MinMax nodeFullRange = this.allNodeFullRange.get(boolKey).init();
                HashMap<Integer, MinMax> nodeExtents = this.allNodeExtents.get(boolKey);
                List<NodeInfo> targets = bfn.getNodeDefList();
                int numNodes = targets.size();
                String tag = build ? "WithShadows" : "NoShadows";
                LoopReporter lr = new LoopReporter(targets.size(), 20, monitor, 0.0, 1.0, "progress.buildNodeExtents" + tag);
                for (int i = 0; i < numNodes; ++i) {
                    NodeInfo node = targets.get(i);
                    int num = node.nodeRow;
                    Integer numObj = num;
                    lr.report();
                    MinMax cols = node.getColRange(build);
                    nodeExtents.put(numObj, cols);
                    nodeFullRange.update(num);
                    if (!build) continue;
                    singletons.put(node.getNodeID(), numObj);
                }
                lr.finish();
            }
            for (boolean build : builds) {
                MinMax linkFullRange = this.allLinkFullRange.get(build).init();
                HashMap<Integer, MinMax> linkExtents = this.allLinkExtents.get(build);
                List<LinkInfo> links = bfn.getLinkDefList(build);
                int numLinks = links.size();
                String tag = build ? "WithShadows" : "NoShadows";
                LoopReporter lr0 = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, "progress.buildLinkExtents" + tag);
                for (int i = 0; i < numLinks; ++i) {
                    LinkInfo link = links.get(i);
                    lr0.report();
                    int num = link.getUseColumn(build);
                    int sRow = link.topRow();
                    int eRow = link.bottomRow();
                    linkExtents.put(num, new MinMax(sRow, eRow));
                    linkFullRange.update(num);
                    if (!build) continue;
                    singletons.remove(link.getSource().getNID().getNID());
                    singletons.remove(link.getTarget().getNID().getNID());
                }
                lr0.finish();
            }
            for (boolean build : builds) {
                boolKey = build;
                String tag = build ? "WithShadows" : "NoShadows";
                LoopReporter lr2 = new LoopReporter(singletons.size(), 20, monitor, 0.0, 1.0, "progress.buildSingletonExtents" + tag);
                for (NID singNode : singletons.keySet()) {
                    Integer existing = this.singletonNodeStart.get(boolKey);
                    lr2.report();
                    Integer singMin = null;
                    Integer singNum = (Integer)singletons.get(singNode);
                    if (existing == null) {
                        singMin = singNum;
                    } else if (existing > singNum) {
                        singMin = singNum;
                    }
                    if (singMin == null) continue;
                    this.singletonNodeStart.put(boolKey, singMin);
                }
                lr2.finish();
            }
        }
    }

    public static class NodeInfoWorker
    extends AbstractFactoryClient {
        public NodeInfoWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            this.myKeys_.add("node");
            this.installWorker(new DrainZoneWorker(board, false), new DrainZoneGlue());
            this.installWorker(new DrainZoneWorker(board, true), new DrainZoneGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NodeInfo retval = null;
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            if (this.myKeys_.contains(elemName)) {
                retval = board.nodeInfo = this.buildFromXML(elemName, attrs, board);
            }
            return retval;
        }

        private NodeInfo buildFromXML(String elemName, Attributes attrs, FabricFactory.FactoryWhiteboard board) throws IOException {
            NodeInfo retval;
            NID.WithName nwn;
            NID nid;
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "node", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            String nidStr = AttributeExtractor.extractAttribute(elemName, attrs, "node", "nid", false);
            if (nidStr != null) {
                boolean ok = board.ulb.addExistingLabel(nidStr);
                if (!ok) {
                    throw new IOException();
                }
                nid = new NID(nidStr);
                nwn = new NID.WithName(nid, name);
            } else {
                nid = board.ulb.getNextOID();
                nwn = new NID.WithName(nid, name);
                board.legacyMap.put(name, nwn);
            }
            board.wnMap.put(nid, nwn);
            String row = AttributeExtractor.extractAttribute(elemName, attrs, "node", "row", true);
            String minCol = AttributeExtractor.extractAttribute(elemName, attrs, "node", "minCol", true);
            String maxCol = AttributeExtractor.extractAttribute(elemName, attrs, "node", "maxCol", true);
            String minColSha = AttributeExtractor.extractAttribute(elemName, attrs, "node", "minColSha", true);
            String maxColSha = AttributeExtractor.extractAttribute(elemName, attrs, "node", "maxColSha", true);
            String minDrain = AttributeExtractor.extractAttribute(elemName, attrs, "node", "drainMin", false);
            String maxDrain = AttributeExtractor.extractAttribute(elemName, attrs, "node", "drainMax", false);
            String minDrainSha = AttributeExtractor.extractAttribute(elemName, attrs, "node", "drainMinSha", false);
            String maxDrainSha = AttributeExtractor.extractAttribute(elemName, attrs, "node", "drainMaxSha", false);
            String color = AttributeExtractor.extractAttribute(elemName, attrs, "node", "color", true);
            String cluster = AttributeExtractor.extractAttribute(elemName, attrs, "node", "cluster", false);
            cluster = CharacterEntityMapper.unmapEntities(cluster, false);
            try {
                DrainZone dz;
                int nodeRow = Integer.valueOf(row);
                retval = new NodeInfo(nid, name, nodeRow, color);
                if (cluster != null) {
                    UiUtil.fixMePrintout("Make cluster assign a list");
                    retval.setCluster(cluster);
                }
                int min = Integer.valueOf(minCol);
                int max = Integer.valueOf(maxCol);
                retval.updateMinMaxCol(min, false);
                retval.updateMinMaxCol(max, false);
                int minSha = Integer.valueOf(minColSha);
                int maxSha = Integer.valueOf(maxColSha);
                retval.updateMinMaxCol(minSha, true);
                retval.updateMinMaxCol(maxSha, true);
                if (minDrain != null) {
                    int minDrVal = Integer.valueOf(minDrain);
                    int maxDrVal = Integer.valueOf(maxDrain);
                    dz = new DrainZone(new MinMax(minDrVal, maxDrVal), false);
                    retval.addDrainZone(dz);
                }
                if (minDrainSha != null) {
                    int minDrValSha = Integer.valueOf(minDrainSha);
                    int maxDrValSha = Integer.valueOf(maxDrainSha);
                    dz = new DrainZone(new MinMax(minDrValSha, maxDrValSha), true);
                    retval.addDrainZone(dz);
                }
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return retval;
        }
    }

    public static class LinkGroupTagWorker
    extends AbstractFactoryClient {
        public LinkGroupTagWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            this.myKeys_.add("linkGroup");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            String retval = null;
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            retval = board.groupTag = this.buildFromXML(elemName, attrs);
            return retval;
        }

        private String buildFromXML(String elemName, Attributes attrs) throws IOException {
            String tag = AttributeExtractor.extractAttribute(elemName, attrs, "linkGroup", "tag", true);
            return tag;
        }
    }

    public static class LinkInfoWorker
    extends AbstractFactoryClient {
        public LinkInfoWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            this.myKeys_.add("link");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            LinkInfo retval = null;
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            retval = board.linkInfo = this.buildFromXML(elemName, attrs, board);
            return retval;
        }

        private LinkInfo buildFromXML(String elemName, Attributes attrs, FabricFactory.FactoryWhiteboard board) throws IOException {
            LinkInfo retval;
            NID.WithName trgNID;
            NID.WithName srcNID;
            String src = AttributeExtractor.extractAttribute(elemName, attrs, "link", "src", false);
            src = CharacterEntityMapper.unmapEntities(src, false);
            String trg = AttributeExtractor.extractAttribute(elemName, attrs, "link", "trg", false);
            trg = CharacterEntityMapper.unmapEntities(trg, false);
            String srcID = AttributeExtractor.extractAttribute(elemName, attrs, "link", "srcID", false);
            String trgID = AttributeExtractor.extractAttribute(elemName, attrs, "link", "trgID", false);
            if (src != null) {
                srcNID = board.legacyMap.get(src);
            } else if (srcID != null) {
                srcNID = board.wnMap.get(new NID(srcID));
            } else {
                throw new IOException();
            }
            if (trg != null) {
                trgNID = board.legacyMap.get(trg);
            } else if (trgID != null) {
                trgNID = board.wnMap.get(new NID(trgID));
            } else {
                throw new IOException();
            }
            String rel = AttributeExtractor.extractAttribute(elemName, attrs, "link", "rel", true);
            rel = CharacterEntityMapper.unmapEntities(rel, false);
            String directed = AttributeExtractor.extractAttribute(elemName, attrs, "link", "directed", true);
            Boolean dirObj = Boolean.valueOf(directed);
            String shadow = AttributeExtractor.extractAttribute(elemName, attrs, "link", "shadow", true);
            Boolean shadObj = Boolean.valueOf(shadow);
            FabricLink flink = new FabricLink(new FabricNode(srcNID), new FabricNode(trgNID), rel, shadObj, dirObj);
            String col = AttributeExtractor.extractAttribute(elemName, attrs, "link", "column", false);
            String shadowCol = AttributeExtractor.extractAttribute(elemName, attrs, "link", "shadowCol", true);
            String srcRow = AttributeExtractor.extractAttribute(elemName, attrs, "link", "srcRow", true);
            String trgRow = AttributeExtractor.extractAttribute(elemName, attrs, "link", "trgRow", true);
            String color = AttributeExtractor.extractAttribute(elemName, attrs, "link", "color", true);
            if (!shadObj.booleanValue() && col == null) {
                throw new IOException();
            }
            try {
                int useColumn = col == null ? Integer.MIN_VALUE : Integer.valueOf(col);
                int shadowColumn = Integer.valueOf(shadowCol);
                int srcRowVal = Integer.valueOf(srcRow);
                int trgRowVal = Integer.valueOf(trgRow);
                retval = new LinkInfo(flink, srcRowVal, trgRowVal, useColumn, shadowColumn, color);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return retval;
        }
    }

    public static class LinkGroupWorker
    extends AbstractFactoryClient {
        public LinkGroupWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            FabricFactory.FactoryWhiteboard whiteboard = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            this.myKeys_.add("linkGroups");
            this.installWorker(new LinkGroupTagWorker(whiteboard), new MyGroupGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Network.LayoutMode retval = null;
            if (elemName.equals("linkGroups")) {
                String target = AttributeExtractor.extractAttribute(elemName, attrs, "linkGroups", "mode", false);
                String annots = AttributeExtractor.extractAttribute(elemName, attrs, "linkGroups", "view", false);
                if (target == null) {
                    target = Network.LayoutMode.PER_NODE_MODE.getText();
                }
                boolean showAnnots = annots != null ? Boolean.valueOf(annots) : false;
                FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
                retval = Network.LayoutMode.fromString(target);
                board.bfn.setLayoutMode(retval);
                board.bfn.setShowLinkGroupAnnotations(showAnnots);
            }
            return retval;
        }
    }

    public static class DrainZoneWorker
    extends AbstractFactoryClient {
        private boolean isShadow;

        public DrainZoneWorker(FabricFactory.FactoryWhiteboard board, boolean isShadow) {
            super(board);
            this.isShadow = isShadow;
            if (this.isShadow) {
                this.myKeys_.add("drainZoneShadow");
            } else {
                this.myKeys_.add("drainZone");
            }
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            DrainZone retval = null;
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
            retval = board.drainZone = this.buildFromXML(elemName, attrs);
            return retval;
        }

        private DrainZone buildFromXML(String elemName, Attributes attrs) throws IOException {
            String maxCol;
            String minCol;
            if (this.isShadow) {
                minCol = AttributeExtractor.extractAttribute(elemName, attrs, "drainZoneShadow", "minCol", true);
                maxCol = AttributeExtractor.extractAttribute(elemName, attrs, "drainZoneShadow", "maxCol", true);
            } else {
                minCol = AttributeExtractor.extractAttribute(elemName, attrs, "drainZone", "minCol", true);
                maxCol = AttributeExtractor.extractAttribute(elemName, attrs, "drainZone", "maxCol", true);
            }
            int min = Integer.valueOf(minCol);
            int max = Integer.valueOf(maxCol);
            MinMax dzmm = new MinMax(min, max);
            return new DrainZone(dzmm, this.isShadow);
        }
    }

    public static class DrainZoneGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.nodeInfo.addDrainZone(board.drainZone);
            return null;
        }
    }

    public static class MyGroupGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.bfn.addLinkGroupForIO(board.groupTag);
            return null;
        }
    }

    public static class MyLinkGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.bfn.addLinkInfoForIO(board.linkInfo);
            return null;
        }
    }

    public static class MyNodeGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.bfn.addNodeInfoForIO(board.nodeInfo);
            return null;
        }
    }

    public static class MyAnnotsGlue
    implements GlueStick {
        private boolean forNodes_;
        private boolean forShadow_;

        public MyAnnotsGlue(boolean forNodes, boolean forShadow) {
            this.forNodes_ = forNodes;
            this.forShadow_ = forShadow;
        }

        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            if (this.forNodes_) {
                board.bfn.setNodeAnnotations(board.currAnnots);
            } else {
                board.bfn.setLinkAnnotations(board.currAnnots, this.forShadow_);
            }
            return null;
        }
    }

    public static class MyColorSetGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.bfn.setColorGenerator(board.fcg);
            return null;
        }
    }

    public static class NetworkDataWorker
    extends AbstractFactoryClient {
        public NetworkDataWorker(FabricFactory.FactoryWhiteboard whiteboard, PlugInManager pMan) {
            super(whiteboard);
            this.myKeys_.add("BioFabric");
            this.installWorker(new FabricColorGenerator.ColorSetWorker(whiteboard), new MyColorSetGlue());
            this.installWorker(new FabricDisplayOptions.FabricDisplayOptionsWorker(whiteboard), null);
            this.installWorker(new NodeInfoWorker(whiteboard), new MyNodeGlue());
            this.installWorker(new LinkInfoWorker(whiteboard), new MyLinkGlue());
            this.installWorker(new LinkGroupWorker(whiteboard), null);
            this.installWorker(new AnnotationSetImpl.AnnotsWorker(whiteboard, "nodeAnnotations"), new MyAnnotsGlue(true, false));
            this.installWorker(new AnnotationSetImpl.AnnotsWorker(whiteboard, "linkAnnotations"), new MyAnnotsGlue(false, false));
            this.installWorker(new AnnotationSetImpl.AnnotsWorker(whiteboard, "shadowLinkAnnotations"), new MyAnnotsGlue(false, true));
            this.installWorker(new PlugInManager.PlugInWorker(whiteboard, pMan), null);
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BioFabricNetwork retval = null;
            if (elemName.equals("BioFabric")) {
                FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.bfn = new BioFabricNetwork();
            }
            return retval;
        }
    }

    public static class ColumnAssign {
        public HashMap<Integer, NetNode> columnToSource = new HashMap();
        public HashMap<Integer, NetNode> columnToTarget = new HashMap();
        public int columnCount = 0;

        ColumnAssign() {
        }
    }

    static class DoubleRanked {
        double rank;
        String id;
        Link byLink;

        DoubleRanked(double rank, String id, Link byLink) {
            this.rank = rank;
            this.id = id;
            this.byLink = byLink;
        }
    }

    public static class DrainZone {
        private MinMax dzmm;
        private boolean isShadow;

        public DrainZone(MinMax dzmm, boolean isShadow) {
            this.dzmm = dzmm.clone();
            this.isShadow = isShadow;
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            if (this.isShadow) {
                ind.indent();
                out.print("<drainZoneShadow minCol=\"");
                out.print(this.dzmm.min);
                out.print("\" maxCol=\"");
                out.print(this.dzmm.max);
                out.println("\" />");
            } else {
                ind.indent();
                out.print("<drainZone minCol=\"");
                out.print(this.dzmm.min);
                out.print("\" maxCol=\"");
                out.print(this.dzmm.max);
                out.println("\" />");
            }
        }

        public boolean isShadow() {
            return this.isShadow;
        }

        public MinMax getMinMax() {
            return this.dzmm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeInfo {
        private NID nodeID_;
        private String nodeName_;
        public int nodeRow;
        public String colorKey;
        private String cluster_;
        private MinMax colRangeSha_;
        private MinMax colRangePln_;
        private List<DrainZone> shadowDrainZones_;
        private List<DrainZone> plainDrainZones_;

        NodeInfo(NID nodeID, String nodeName, int nodeRow, String colorKey) {
            this.nodeID_ = nodeID;
            this.nodeName_ = nodeName;
            this.nodeRow = nodeRow;
            this.colorKey = colorKey;
            this.colRangeSha_ = new MinMax();
            this.colRangeSha_.init();
            this.colRangePln_ = new MinMax();
            this.colRangePln_.init();
            this.shadowDrainZones_ = new ArrayList<DrainZone>();
            this.cluster_ = null;
            this.plainDrainZones_ = new ArrayList<DrainZone>();
        }

        public String getNodeName() {
            return this.nodeName_;
        }

        public NID getNodeID() {
            return this.nodeID_;
        }

        public NetNode getNodeIDWithName() {
            return new FabricNode(this.nodeID_, this.nodeName_);
        }

        public List<DrainZone> getDrainZones(boolean forShadow) {
            return forShadow ? new ArrayList<DrainZone>(this.shadowDrainZones_) : new ArrayList<DrainZone>(this.plainDrainZones_);
        }

        public void addDrainZone(DrainZone dz) {
            if (dz.isShadow()) {
                this.shadowDrainZones_.add(dz);
            } else {
                this.plainDrainZones_.add(dz);
            }
        }

        public void setDrainZones(List<DrainZone> zones, boolean forShadow) {
            if (forShadow) {
                this.shadowDrainZones_ = new ArrayList<DrainZone>(zones);
            } else {
                this.plainDrainZones_ = new ArrayList<DrainZone>(zones);
            }
        }

        public MinMax getColRange(boolean forShadow) {
            return forShadow ? this.colRangeSha_ : this.colRangePln_;
        }

        void updateMinMaxCol(int i, boolean forShadow) {
            MinMax useMM = forShadow ? this.colRangeSha_ : this.colRangePln_;
            useMM.update(i);
        }

        public void setCluster(String cluster) {
            this.cluster_ = cluster;
        }

        public String getCluster() {
            return this.cluster_;
        }

        public void writeXML(PrintWriter out, Indenter ind, int row) {
            ind.indent();
            out.print("<node name=\"");
            out.print(CharacterEntityMapper.mapEntities(this.nodeName_, false));
            out.print("\" nid=\"");
            out.print(this.nodeID_.getInternal());
            out.print("\" row=\"");
            out.print(row);
            MinMax nsCols = this.getColRange(false);
            out.print("\" minCol=\"");
            out.print(nsCols.min);
            out.print("\" maxCol=\"");
            out.print(nsCols.max);
            MinMax sCols = this.getColRange(true);
            out.print("\" minColSha=\"");
            out.print(sCols.min);
            out.print("\" maxColSha=\"");
            out.print(sCols.max);
            out.print("\" color=\"");
            out.print(this.colorKey);
            String clust = this.getCluster();
            if (clust != null) {
                out.print("\" cluster=\"");
                out.print(CharacterEntityMapper.mapEntities(clust, false));
            }
            out.println("\">");
            ind.up();
            ind.indent();
            if (this.plainDrainZones_.size() > 0) {
                out.println("<drainZones>");
                ind.up();
                for (DrainZone dz : this.plainDrainZones_) {
                    dz.writeXML(out, ind);
                }
                ind.down();
                ind.indent();
                out.println("</drainZones>");
            } else {
                out.println("<drainZones/>");
            }
            ind.indent();
            if (this.shadowDrainZones_.size() > 0) {
                out.println("<drainZonesShadow>");
                ind.up();
                for (DrainZone dzSha : this.shadowDrainZones_) {
                    dzSha.writeXML(out, ind);
                }
                ind.down();
                ind.indent();
                out.println("</drainZonesShadow>");
            } else {
                out.println("<drainZonesShadow/>");
            }
            ind.down();
            ind.indent();
            out.println("</node>");
        }
    }

    public static class LinkInfo {
        private FabricLink myLink_;
        private int startRow_;
        private int endRow_;
        private int noShadowColumn_;
        private int shadowColumn_;
        private String colorKey_;

        public LinkInfo(FabricLink flink, int startRow, int endRow, int noShadowColumn, int shadowColumn, String colorKey) {
            this.myLink_ = flink.clone();
            this.startRow_ = startRow;
            this.endRow_ = endRow;
            this.noShadowColumn_ = noShadowColumn;
            this.shadowColumn_ = shadowColumn;
            this.colorKey_ = colorKey;
        }

        public int getStartRow() {
            return this.startRow_;
        }

        public int getEndRow() {
            return this.endRow_;
        }

        public int getUseColumn(boolean shadowEnabled) {
            if (!shadowEnabled && this.myLink_.isShadow()) {
                throw new IllegalStateException();
            }
            return shadowEnabled ? this.shadowColumn_ : this.noShadowColumn_;
        }

        public String getColorKey() {
            return this.colorKey_;
        }

        public FabricLink getLink() {
            return this.myLink_;
        }

        public NetNode getSource() {
            return this.myLink_.getSrcNode();
        }

        public NetNode getTarget() {
            return this.myLink_.getTrgNode();
        }

        public AugRelation getAugRelation() {
            return this.myLink_.getAugRelation();
        }

        public boolean isShadow() {
            return this.myLink_.isShadow();
        }

        public boolean isDirected() {
            return this.myLink_.isDirected();
        }

        public int bottomRow() {
            return Math.max(this.startRow_, this.endRow_);
        }

        public int topRow() {
            return Math.min(this.startRow_, this.endRow_);
        }

        public boolean inLinkRowRange(int row) {
            return row >= this.topRow() && row <= this.bottomRow();
        }
    }
}

