/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.api.io.CharacterEntityMapper;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.layout.AnnotColorSource;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.AnnotsForPos;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.io.FabricFactory;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSetImpl
implements AnnotationSet,
Cloneable,
Iterable<Annot> {
    private TreeSet<Annot> annots_ = new TreeSet();

    public AnnotationSetImpl clone() {
        try {
            AnnotationSetImpl retval = (AnnotationSetImpl)super.clone();
            retval.annots_ = new TreeSet();
            for (Annot annot : this.annots_) {
                retval.annots_.add(((AnnotImpl)annot).clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Iterator<Annot> iterator() {
        return this.annots_.iterator();
    }

    @Override
    public int size() {
        return this.annots_.size();
    }

    @Override
    public void addAnnot(Annot an) {
        this.annots_.add(an);
    }

    @Override
    public void fillAnnots(AnnotsForPos fillIt, Integer whereObj) {
        for (Annot an : this.annots_) {
            if (!an.getRange().contained(whereObj)) continue;
            fillIt.addAnnot(an);
        }
    }

    public static class AnnotWorker
    extends AbstractFactoryClient {
        public AnnotWorker(FabricFactory.FactoryWhiteboard board) {
            super(board);
            this.myKeys_.add("annot");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Annot retval = null;
            if (elemName.equals("annot")) {
                FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.annot = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private Annot buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "annot", "tag", true);
            String minStr = AttributeExtractor.extractAttribute(elemName, attrs, "annot", "start", true);
            String maxStr = AttributeExtractor.extractAttribute(elemName, attrs, "annot", "end", true);
            String layerStr = AttributeExtractor.extractAttribute(elemName, attrs, "annot", "layer", true);
            String colorStr = AttributeExtractor.extractAttribute(elemName, attrs, "annot", "color", false);
            name = CharacterEntityMapper.unmapEntities(name, false);
            try {
                int min = Integer.valueOf(minStr);
                int max = Integer.valueOf(maxStr);
                int layer = Integer.valueOf(layerStr);
                AnnotImpl retval = new AnnotImpl(name, min, max, layer, colorStr);
                return retval;
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
        }
    }

    public static class MyAnnotGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)optionalArgs;
            board.currAnnots.addAnnot(board.annot);
            return null;
        }
    }

    public static class AnnotsWorker
    extends AbstractFactoryClient {
        private String tag_;

        public AnnotsWorker(FabricFactory.FactoryWhiteboard whiteboard, String tag) {
            super(whiteboard);
            this.tag_ = tag;
            this.myKeys_.add(this.tag_);
            this.installWorker(new AnnotWorker(whiteboard), new MyAnnotGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            AnnotationSet retval = null;
            if (elemName.equals(this.tag_)) {
                FabricFactory.FactoryWhiteboard board = (FabricFactory.FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.currAnnots = new AnnotationSetImpl();
            }
            return retval;
        }
    }

    public static class AnnotImpl
    implements Annot,
    Cloneable {
        private String tag_;
        private MinMax range_;
        private int layer_;
        private AnnotColorSource.AnnotColor color_;

        public AnnotImpl(String tag, int startPos, int endPos, int layer, String colorName) {
            if (startPos > endPos || layer < 0) {
                throw new IllegalArgumentException();
            }
            this.tag_ = tag;
            this.range_ = new MinMax(startPos, endPos);
            this.layer_ = layer;
            this.color_ = colorName == null ? null : AnnotColorSource.AnnotColor.getColor(colorName);
        }

        public AnnotImpl clone() {
            try {
                AnnotImpl retval = (AnnotImpl)super.clone();
                retval.range_ = this.range_.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public String getName() {
            return this.tag_;
        }

        public MinMax getRange() {
            return this.range_;
        }

        public int getLayer() {
            return this.layer_;
        }

        public AnnotColorSource.AnnotColor getColor() {
            return this.color_;
        }

        public int hashCode() {
            return this.tag_.hashCode() + this.range_.hashCode() + this.layer_;
        }

        public String toString() {
            String retval = "Annot name = " + this.tag_ + " range = " + this.range_ + " layer = " + this.layer_;
            return this.color_ == null ? retval : retval + "color = " + (Object)((Object)this.color_);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Annot)) {
                return false;
            }
            Annot otherAnnot = (Annot)other;
            if (!this.tag_.equalsIgnoreCase(otherAnnot.getName())) {
                return false;
            }
            if (!this.range_.equals(otherAnnot.getRange())) {
                return false;
            }
            if (this.color_ == null) {
                if (otherAnnot.getColor() != null) {
                    return false;
                }
            } else {
                if (otherAnnot.getColor() == null) {
                    return false;
                }
                if (!this.color_.equals((Object)otherAnnot.getColor())) {
                    return false;
                }
            }
            return this.layer_ == otherAnnot.getLayer();
        }

        public int compareTo(Annot otherAnnot) {
            if (this.equals(otherAnnot)) {
                return 0;
            }
            int startDiff = this.range_.min - otherAnnot.getRange().min;
            if (startDiff != 0) {
                return startDiff;
            }
            int endDiff = this.range_.max - otherAnnot.getRange().min;
            if (endDiff != 0) {
                return endDiff;
            }
            int layerDiff = this.layer_ - otherAnnot.getLayer();
            if (layerDiff != 0) {
                return layerDiff;
            }
            if (this.color_ == null) {
                if (otherAnnot.getColor() != null) {
                    return -1;
                }
            } else {
                if (otherAnnot.getColor() == null) {
                    return 1;
                }
                int compval = this.color_.compareTo(otherAnnot.getColor());
                if (compval != 0) {
                    return compval;
                }
            }
            return this.tag_.compareToIgnoreCase(otherAnnot.getName());
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("<annot tag=\"");
            out.print(CharacterEntityMapper.mapEntities(this.tag_, false));
            out.print("\" start=\"");
            out.print(this.range_.min);
            out.print("\" end=\"");
            out.print(this.range_.max);
            out.print("\" layer=\"");
            out.print(this.layer_);
            if (this.color_ != null) {
                out.print("\" color=\"");
                out.print(this.color_.getName());
            }
            out.println("\" />");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotsForPosImpl
    implements AnnotsForPos {
        private TreeMap<Integer, SortedSet<Annot>> perLayers_ = new TreeMap(Collections.reverseOrder());

        public AnnotsForPosImpl() {
            this.perLayers_.put(0, new TreeSet());
        }

        @Override
        public void addAnnot(Annot toAdd) {
            int layer = toAdd.getLayer();
            SortedSet<Annot> forLayer = this.perLayers_.get(layer);
            if (forLayer == null) {
                forLayer = new TreeSet<Annot>();
                this.perLayers_.put(layer, forLayer);
            }
            forLayer.add(toAdd);
        }

        @Override
        public void clear() {
            for (Integer layer : this.perLayers_.keySet()) {
                this.perLayers_.get(layer).clear();
            }
        }

        @Override
        public void displayStrings(List<String> fill) {
            for (Integer layer : this.perLayers_.keySet()) {
                SortedSet<Annot> forLay = this.perLayers_.get(layer);
                for (Annot ant : forLay) {
                    fill.add(ant.getName());
                }
            }
        }
    }
}

