/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.layouts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldBankLayout
extends NodeLayout {
    @Override
    public boolean criteriaMet(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        LoopReporter lr = new LoopReporter(rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.hDagLayoutCriteriaCheck");
        for (NetLink aLink : rbd.getLinks()) {
            lr.report();
        }
        lr.finish();
        return true;
    }

    @Override
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<NetNode> targets = this.calcNodeOrder(rbd.getLinks(), rbd.getSingletonNodes(), monitor);
        this.installNodeOrder(targets, rbd, monitor);
        return targets;
    }

    private void bumpDaCount(Map<NetNode, Integer> countMap, NetNode dNode) {
        Integer inc = countMap.get(dNode);
        if (inc == null) {
            countMap.put(dNode, 1);
        } else {
            countMap.put(dNode, inc + 1);
        }
    }

    private void addANeighbor(Map<NetNode, SortedSet<NetNode>> neighMap, NetNode daNode, NetNode daNeigh) {
        SortedSet<NetNode> forNode = neighMap.get(daNode);
        if (forNode == null) {
            forNode = new TreeSet<NetNode>();
            neighMap.put(daNode, forNode);
        }
        forNode.add(daNeigh);
    }

    private SortedMap<Integer, SortedSet<NetNode>> invertCountMap(Map<NetNode, Integer> countMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(countMap.size(), 20, monitor, 0.0, 1.0, "progress.sortingByDegree");
        TreeMap<Integer, SortedSet<NetNode>> retval = new TreeMap<Integer, SortedSet<NetNode>>(Collections.reverseOrder());
        for (NetNode daKey : countMap.keySet()) {
            lr.report();
            Integer daCount = countMap.get(daKey);
            SortedSet<NetNode> forCount = retval.get(daCount);
            if (forCount == null) {
                forCount = new TreeSet<NetNode>();
                retval.put(daCount, forCount);
            }
            forCount.add(daKey);
        }
        lr.finish();
        return retval;
    }

    private List<NetNode> flattenDaCount(SortedMap<Integer, SortedSet<NetNode>> invCountMap) {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        Iterator<SortedSet<NetNode>> icmit = invCountMap.values().iterator();
        while (icmit.hasNext()) {
            retval.addAll((Collection<NetNode>)icmit.next());
        }
        return retval;
    }

    private List<NetNode> calcNodeOrder(Set<NetLink> allLinks, Set<NetNode> loneNodes, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NetNode, Integer> node2Degree = new HashMap<NetNode, Integer>();
        HashMap<NetNode, SortedSet<NetNode>> node2Neighbor = new HashMap<NetNode, SortedSet<NetNode>>();
        HashSet<NetNode> allNodes = new HashSet<NetNode>();
        LoopReporter lr = new LoopReporter(allLinks.size(), 20, monitor, 0.0, 1.0, "progress.wblCalcNodeOrder");
        for (NetLink nextLink : allLinks) {
            lr.report();
            NetNode source = nextLink.getSrcNode();
            NetNode target = nextLink.getTrgNode();
            allNodes.add(source);
            allNodes.add(target);
            this.bumpDaCount(node2Degree, source);
            this.bumpDaCount(node2Degree, target);
            this.addANeighbor(node2Neighbor, source, target);
            this.addANeighbor(node2Neighbor, target, source);
        }
        lr.finish();
        SortedMap<Integer, SortedSet<NetNode>> degree2Nodes = this.invertCountMap(node2Degree, monitor);
        LoopReporter lr2 = new LoopReporter(node2Neighbor.size(), 20, monitor, 0.0, 1.0, "progress.wblPopNeighbors");
        HashMap oneNeighbor = new HashMap();
        for (NetNode node : node2Neighbor.keySet()) {
            lr2.report();
            SortedSet<NetNode> nextDoor = node2Neighbor.get(node);
            if (nextDoor.size() != 1) continue;
            NetNode popular = nextDoor.first();
            Set popFriends = (Set)oneNeighbor.get(popular);
            if (popFriends == null) {
                popFriends = new HashSet();
                oneNeighbor.put(popular, popFriends);
            }
            popFriends.add(node);
        }
        lr2.finish();
        LoopReporter lr3 = new LoopReporter(degree2Nodes.size(), 0, monitor, 0.0, 1.0, "progress.addingSatellites");
        ArrayList<NetNode> targets = new ArrayList<NetNode>();
        HashSet<NetNode> tSet = new HashSet<NetNode>();
        Set populars = oneNeighbor.keySet();
        for (Integer deg : degree2Nodes.keySet()) {
            lr3.report();
            if (deg == 1) {
                UiUtil.fixMePrintout("DO SOMETHING: Don't want 1-deg node added twice!");
            }
            SortedSet forDeg = (SortedSet)degree2Nodes.get(deg);
            Iterator iterator = forDeg.iterator();
            while (iterator.hasNext()) {
                NetNode degNode = (NetNode)iterator.next();
                if (!populars.contains(degNode)) continue;
                targets.add(degNode);
                tSet.add(degNode);
                HashMap<NetNode, Integer> forDaPop = new HashMap<NetNode, Integer>();
                Set unpopFriends = (Set)oneNeighbor.get(degNode);
                for (NetNode unPop : unpopFriends) {
                    Integer upd = node2Degree.get(unPop);
                    forDaPop.put(unPop, upd);
                }
                SortedMap<Integer, SortedSet<NetNode>> invFor = this.invertCountMap(forDaPop, null);
                List<NetNode> fdc = this.flattenDaCount(invFor);
                targets.addAll(fdc);
                tSet.addAll(fdc);
            }
        }
        lr3.finish();
        HashSet stillToPlace = new HashSet(allNodes);
        stillToPlace.removeAll(targets);
        LoopReporter lr4 = new LoopReporter(degree2Nodes.size(), 0, monitor, 0.0, 1.0, "progress.addingGlobalNodes");
        for (SortedSet sortedSet : degree2Nodes.values()) {
            lr4.report();
            for (NetNode chkNode : sortedSet) {
                if (!stillToPlace.contains(chkNode)) continue;
                targets.add(chkNode);
            }
        }
        lr4.finish();
        HashSet<NetNode> remains = new HashSet<NetNode>(loneNodes);
        remains.removeAll(targets);
        targets.addAll(new TreeSet<NetNode>(remains));
        return targets;
    }
}

