/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.analysis.GraphSearcher;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.layout.DefaultLayout;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetLayout
extends NodeLayout {
    private Map<NetNode, Set<NetNode>> elemsPerSet_;
    private Map<NetNode, Set<NetNode>> setsPerElem_;
    private LinkMeans direction_;

    public SetLayout(LinkMeans direction) {
        this.direction_ = direction;
    }

    @Override
    public boolean criteriaMet(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        LoopReporter lr = new LoopReporter(rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.setLayoutCriteriaCheck");
        HashSet<String> rels = new HashSet<String>();
        for (NetLink aLink : rbd.getLinks()) {
            lr.report();
            if (!aLink.isDirected()) {
                throw new LayoutCriterionFailureException();
            }
            rels.add(aLink.getRelation());
            if (rels.size() <= 1) continue;
            throw new LayoutCriterionFailureException();
        }
        lr.finish();
        this.elemsPerSet_ = new HashMap<NetNode, Set<NetNode>>();
        this.setsPerElem_ = new HashMap<NetNode, Set<NetNode>>();
        this.extractSets(rbd.getLinks(), rbd.getSingletonNodes(), monitor);
        return true;
    }

    @Override
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        TreeMap byDegree = new TreeMap(Collections.reverseOrder());
        for (NetNode set : this.elemsPerSet_.keySet()) {
            Set<NetNode> elems = this.elemsPerSet_.get(set);
            Integer card = elems.size();
            TreeSet<NetNode> setsWithCard = (TreeSet<NetNode>)byDegree.get(card);
            if (setsWithCard == null) {
                setsWithCard = new TreeSet<NetNode>();
                byDegree.put(card, setsWithCard);
            }
            setsWithCard.add(set);
        }
        ArrayList<NetNode> setList = new ArrayList<NetNode>();
        SortedSet emptySets = (SortedSet)byDegree.get(0);
        if (emptySets != null) {
            setList.addAll(emptySets);
        }
        for (Integer size : byDegree.keySet()) {
            if (size == 0) continue;
            SortedSet forDeg = (SortedSet)byDegree.get(size);
            setList.addAll(forDeg);
        }
        ArrayList<NetNode> nodeOrder = new ArrayList<NetNode>(setList);
        HashMap<NetNode, Set<NetNode>> setsHoldingElement = new HashMap<NetNode, Set<NetNode>>();
        HashMap<Set<NetNode>, String> tagMap = new HashMap<Set<NetNode>, String>();
        StringBuffer buf = new StringBuffer();
        SortedSet<GraphSearcher.SourcedNodeGray> snds = GraphSearcher.nodeGraySetWithSourceFromMap(setList, this.setsPerElem_);
        for (GraphSearcher.SourcedNodeGray node : snds) {
            nodeOrder.add(node.getNodeID());
            Set<NetNode> setNodes = node.getSrcs();
            setsHoldingElement.put(node.getNodeID(), setNodes);
            String tag = tagMap.get(setNodes);
            if (tag != null) continue;
            tag = this.buildTag(setNodes, setList, buf);
            tagMap.put(setNodes, tag);
        }
        new DefaultLayout().installNodeOrder(nodeOrder, rbd, monitor);
        new DefaultEdgeLayout().layoutEdges(rbd, monitor);
        AnnotationSet nAnnots = this.generateNodeAnnotations(rbd, setsHoldingElement, tagMap);
        rbd.setNodeAnnotations(nAnnots);
        Map<Boolean, AnnotationSet> lAnnots = this.generateLinkAnnotations(rbd, setsHoldingElement, tagMap);
        rbd.setLinkAnnotations(lAnnots);
        return nodeOrder;
    }

    private String buildTag(Set<NetNode> setNodes, ArrayList<NetNode> setList, StringBuffer buf) {
        buf.setLength(0);
        boolean first = true;
        for (NetNode node : setList) {
            if (!setNodes.contains(node)) continue;
            if (first) {
                first = false;
            } else {
                buf.append("&");
            }
            buf.append(node.getName());
        }
        return buf.toString();
    }

    private AnnotationSet generateNodeAnnotations(BuildData rbd, Map<NetNode, Set<NetNode>> setsHoldingElement, Map<Set<NetNode>, String> tagMap) {
        AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
        TreeMap<Integer, NetNode> invert = new TreeMap<Integer, NetNode>();
        Map<NetNode, Integer> nod = rbd.getNodeOrder();
        for (NetNode node : nod.keySet()) {
            invert.put(nod.get(node), node);
        }
        Set<NetNode> currIntersect = null;
        Integer startRow = null;
        Integer lastKey = (Integer)invert.lastKey();
        for (Integer row : invert.keySet()) {
            Annot annot;
            NetNode node = (NetNode)invert.get(row);
            Set<NetNode> sets = setsHoldingElement.get(node);
            if (currIntersect == null) {
                currIntersect = sets;
                startRow = row;
                if (!row.equals(lastKey)) continue;
                annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startRow, row, 0, null);
                retval.addAnnot(annot);
                break;
            }
            if (currIntersect.equals(sets)) {
                if (!row.equals(lastKey)) continue;
                annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startRow, row, 0, null);
                retval.addAnnot(annot);
                break;
            }
            annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startRow, row - 1, 0, null);
            retval.addAnnot(annot);
            startRow = row;
            currIntersect = sets;
            if (!row.equals(lastKey)) continue;
            annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startRow, row, 0, null);
            retval.addAnnot(annot);
            break;
        }
        return retval;
    }

    private Map<Boolean, AnnotationSet> generateLinkAnnotations(BuildData rbd, Map<NetNode, Set<NetNode>> setsHoldingElement, Map<Set<NetNode>, String> tagMap) {
        HashMap<Boolean, AnnotationSet> retval = new HashMap<Boolean, AnnotationSet>();
        SortedMap<Integer, NetLink> lod = rbd.getLinkOrder();
        ArrayList<NetLink> shadowsOnly = new ArrayList<NetLink>();
        ArrayList<NetLink> noShadows = new ArrayList<NetLink>();
        int firstShadow = -1;
        for (Integer col : lod.keySet()) {
            NetLink fl = (NetLink)lod.get(col);
            if (fl.isShadow()) {
                if (firstShadow < 0) {
                    firstShadow = col;
                }
                shadowsOnly.add(fl);
                continue;
            }
            noShadows.add(fl);
        }
        AnnotationSet forSets = this.generateLinkAnnotationsForSets(noShadows);
        AnnotationSet noShad = PluginSupportFactory.buildAnnotationSet();
        AnnotationSet withShad = PluginSupportFactory.buildAnnotationSet();
        for (Annot an : forSets) {
            noShad.addAnnot(an);
            withShad.addAnnot(an);
        }
        retval.put(Boolean.FALSE, noShad);
        retval.put(Boolean.TRUE, this.appendLinkAnnotationsForIntersections(withShad, shadowsOnly, setsHoldingElement, tagMap, firstShadow));
        return retval;
    }

    private AnnotationSet generateLinkAnnotationsForSets(List<NetLink> linkList) {
        AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
        NetNode currSetNode = null;
        int startCol = 0;
        int lastCol = linkList.size() - 1;
        for (int i = 0; i < linkList.size(); ++i) {
            Annot annot;
            NetNode nextSet;
            NetLink fl = linkList.get(i);
            if (fl.isShadow()) {
                throw new IllegalArgumentException();
            }
            NetNode netNode = nextSet = this.direction_ == LinkMeans.CONTAINS ? fl.getSrcNode() : fl.getTrgNode();
            if (currSetNode == null) {
                currSetNode = nextSet;
                startCol = i;
                if (i != lastCol) continue;
                annot = PluginSupportFactory.buildAnnotation(currSetNode.getName(), startCol, i, 0, null);
                retval.addAnnot(annot);
                break;
            }
            if (currSetNode.equals(nextSet)) {
                if (i != lastCol) continue;
                annot = PluginSupportFactory.buildAnnotation(currSetNode.getName(), startCol, i, 0, null);
                retval.addAnnot(annot);
                break;
            }
            annot = PluginSupportFactory.buildAnnotation(currSetNode.getName(), startCol, i - 1, 0, null);
            retval.addAnnot(annot);
            startCol = i;
            currSetNode = nextSet;
            if (i != lastCol) continue;
            annot = PluginSupportFactory.buildAnnotation(currSetNode.getName(), startCol, i, 0, null);
            retval.addAnnot(annot);
            break;
        }
        return retval;
    }

    private AnnotationSet appendLinkAnnotationsForIntersections(AnnotationSet retval, List<NetLink> linkList, Map<NetNode, Set<NetNode>> setsHoldingElement, Map<Set<NetNode>, String> tagMap, int offset) {
        Set<NetNode> currIntersect = null;
        int startCol = offset;
        int lastCol = offset + linkList.size() - 1;
        for (int i = 0; i < linkList.size(); ++i) {
            Annot annot;
            NetLink fl = linkList.get(i);
            if (!fl.isShadow()) {
                throw new IllegalArgumentException();
            }
            NetNode elem = this.direction_ == LinkMeans.CONTAINS ? fl.getTrgNode() : fl.getSrcNode();
            Set<NetNode> sets = setsHoldingElement.get(elem);
            if (currIntersect == null) {
                currIntersect = sets;
                startCol = i + offset;
                if (i + offset != lastCol) continue;
                annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startCol, i + offset, 0, null);
                retval.addAnnot(annot);
                break;
            }
            if (currIntersect.equals(sets)) {
                if (i + offset != lastCol) continue;
                annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startCol, i + offset, 0, null);
                retval.addAnnot(annot);
                break;
            }
            annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startCol, i + offset - 1, 0, null);
            retval.addAnnot(annot);
            startCol = i + offset;
            currIntersect = sets;
            if (i + offset != lastCol) continue;
            annot = PluginSupportFactory.buildAnnotation(tagMap.get(currIntersect), startCol, i + offset, 0, null);
            retval.addAnnot(annot);
            break;
        }
        return retval;
    }

    private void extractSets(Set<NetLink> links, Set<NetNode> singletons, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        HashSet<NetNode> setNodes = new HashSet<NetNode>();
        HashSet<NetNode> elementNodes = new HashSet<NetNode>();
        if (singletons != null) {
            setNodes.addAll(singletons);
            for (NetNode netNode : singletons) {
                this.elemsPerSet_.put(netNode, new HashSet());
            }
        }
        LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, "progress.setLayoutSetExtraction");
        for (NetLink link : links) {
            lr.report();
            NetNode set = this.direction_ == LinkMeans.CONTAINS ? link.getSrcNode() : link.getTrgNode();
            NetNode elem = this.direction_ == LinkMeans.CONTAINS ? link.getTrgNode() : link.getSrcNode();
            setNodes.add(set);
            elementNodes.add(elem);
            Set<NetNode> forSet = this.elemsPerSet_.get(set);
            if (forSet == null) {
                forSet = new HashSet<NetNode>();
                this.elemsPerSet_.put(set, forSet);
            }
            forSet.add(elem);
            Set<NetNode> forElem = this.setsPerElem_.get(elem);
            if (forElem == null) {
                forElem = new HashSet<NetNode>();
                this.setsPerElem_.put(elem, forElem);
            }
            forElem.add(set);
        }
        lr.finish();
        HashSet hashSet = new HashSet(setNodes);
        hashSet.retainAll(elementNodes);
        if (!hashSet.isEmpty()) {
            throw new LayoutCriterionFailureException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkMeans {
        BELONGS_TO,
        CONTAINS;

    }
}

