/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biofabric.analysis.Link;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.util.ChoiceContent;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.DoubMinMax;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSimilarityLayout
extends NodeLayout {
    @Override
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (params instanceof ResortParams) {
            return this.doReorderLayout(rbd, (ResortParams)params, monitor);
        }
        if (params instanceof ClusterParams) {
            return this.doClusteredLayout(rbd, (ClusterParams)params, monitor);
        }
        throw new IllegalArgumentException();
    }

    private List<NetNode> doReorderLayout(BuildData rbd, ResortParams rp, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NetNode, Integer> targToRow = new HashMap<NetNode, Integer>();
        SortedMap<Integer, SortedSet<Integer>> connVecs = this.getConnectionVectors(rbd, targToRow, monitor);
        List<Integer> ordered = new ArrayList<Integer>();
        int numRows = ((BuildDataImpl)rbd).getRowCountForNetwork();
        for (int i = 0; i < numRows; ++i) {
            ordered.add(i);
        }
        double currStart = 0.0;
        double inc = 1.0 / (double)rp.passCount;
        double currEnd = currStart + inc;
        TreeMap<Integer, Double> rankings = new TreeMap<Integer, Double>();
        ClusterPrep cprep = this.setupForResort(connVecs, ordered, rankings);
        Double lastRank = rankings.get(rankings.lastKey());
        for (int i = 0; i < rp.passCount; ++i) {
            monitor.updateRankings(rankings);
            List<Integer> nextOrdered = this.resort(cprep, monitor, currStart, currEnd);
            currStart = currEnd;
            currEnd = currStart + inc;
            cprep = this.setupForResort(connVecs, nextOrdered, rankings);
            Integer lastKey = rankings.lastKey();
            Double nowRank = rankings.get(lastKey);
            if (rp.terminateAtIncrease && lastRank < nowRank) {
                rankings.remove(lastKey);
                break;
            }
            ordered = nextOrdered;
            lastRank = nowRank;
        }
        monitor.updateRankings(rankings);
        List<NetNode> retval = this.convertOrderToMap(rbd, ordered);
        return retval;
    }

    private List<NetNode> doClusteredLayout(BuildData rbd, ClusterParams params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<Integer> ordered = this.doClusteredLayoutOrder(rbd, params, monitor);
        List<NetNode> retval = this.convertOrderToMap(rbd, ordered);
        return retval;
    }

    private List<Integer> doClusteredLayoutOrder(BuildData rbd, ClusterParams cp, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NetNode, Integer> targToRow = new HashMap<NetNode, Integer>();
        SortedMap<Integer, SortedSet<Integer>> connVecs = this.getConnectionVectors(rbd, targToRow, monitor);
        TreeMap<Double, SortedSet<Link>> dists = new TreeMap<Double, SortedSet<Link>>(Collections.reverseOrder());
        HashMap<Integer, Integer> degMag = new HashMap<Integer, Integer>();
        Integer highestDegree = cp.distanceMethod == 1 ? this.getCosines(connVecs, dists, degMag, rbd, targToRow, monitor) : this.getJaccard(connVecs, dists, degMag, rbd, targToRow, monitor);
        ArrayList<Link> linkTrace = new ArrayList<Link>();
        ArrayList<Integer> jumpLog = new ArrayList<Integer>();
        LoopReporter lr = new LoopReporter(targToRow.size(), 20, monitor, 0.0, 1.0, "progress.preparingToChain");
        HashMap<Integer, NetNode> rowToTarg = new HashMap<Integer, NetNode>();
        for (NetNode targ : targToRow.keySet()) {
            lr.report();
            rowToTarg.put(targToRow.get(targ), targ);
        }
        lr.finish();
        List<Integer> ordered = this.orderByDistanceChained(rowToTarg, highestDegree, dists, degMag, linkTrace, cp.chainLength, cp.tolerance, jumpLog, monitor);
        return ordered;
    }

    private SortedMap<Integer, SortedSet<Integer>> getConnectionVectors(BuildData rbd, Map<NetNode, Integer> targToRow, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Iterator<NetNode> rtit = ((BuildDataImpl)rbd).getExistingIDOrder().iterator();
        int count = 0;
        while (rtit.hasNext()) {
            NetNode node = rtit.next();
            targToRow.put(node, count++);
        }
        LoopReporter lr = new LoopReporter(rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.getConnectionVectors");
        TreeMap<Integer, SortedSet<Integer>> retval = new TreeMap<Integer, SortedSet<Integer>>();
        for (NetLink fl : rbd.getLinks()) {
            lr.report();
            if (fl.isShadow()) continue;
            NetNode srcName = fl.getSrcNode();
            Integer srcRow = targToRow.get(srcName);
            NetNode trgName = fl.getTrgNode();
            Integer trgRow = targToRow.get(trgName);
            SortedSet<Integer> forRetval = retval.get(srcRow);
            if (forRetval == null) {
                forRetval = new TreeSet<Integer>();
                retval.put(srcRow, forRetval);
            }
            forRetval.add(trgRow);
            forRetval = retval.get(trgRow);
            if (forRetval == null) {
                forRetval = new TreeSet<Integer>();
                retval.put(trgRow, forRetval);
            }
            forRetval.add(srcRow);
        }
        lr.finish();
        return retval;
    }

    private Integer getCosines(SortedMap<Integer, SortedSet<Integer>> connVec, SortedMap<Double, SortedSet<Link>> retval, Map<Integer, Integer> connMag, BuildData rbd, Map<NetNode, Integer> targToRow, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int rowCount = rbd.getLinks().size();
        Integer[] icache = new Integer[rowCount];
        String[] scache = new String[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            icache[i] = i;
            scache[i] = icache[i].toString();
        }
        Integer highestDegree = null;
        int biggestMag = Integer.MIN_VALUE;
        HashSet intersect = new HashSet();
        LoopReporter lr = new LoopReporter(rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.getCosines");
        for (NetLink fl : rbd.getLinks()) {
            SortedSet trgVec;
            int trgSize;
            lr.report();
            if (fl.isShadow()) continue;
            NetNode srcName = fl.getSrcNode();
            Integer srcRow = targToRow.get(srcName);
            NetNode trgName = fl.getTrgNode();
            Integer trgRow = targToRow.get(trgName);
            SortedSet srcVec = (SortedSet)connVec.get(srcRow);
            int srcSize = srcVec.size();
            if (srcSize > biggestMag) {
                biggestMag = srcSize;
                highestDegree = srcRow;
            }
            if ((trgSize = (trgVec = (SortedSet)connVec.get(trgRow)).size()) > biggestMag) {
                biggestMag = trgSize;
                highestDegree = trgRow;
            }
            connMag.put(icache[srcRow], icache[srcSize]);
            connMag.put(icache[trgRow], icache[trgSize]);
            double sqrs = Math.sqrt(srcSize);
            double sqrt = Math.sqrt(trgSize);
            intersect.clear();
            intersect.addAll(srcVec);
            intersect.retainAll(trgVec);
            double val = (double)intersect.size() / (sqrs * sqrt);
            Double dot = new Double(val);
            TreeSet<Link> forDot = (TreeSet<Link>)retval.get(dot);
            if (forDot == null) {
                forDot = new TreeSet<Link>();
                retval.put(dot, forDot);
            }
            forDot.add(new Link(scache[srcRow], scache[trgRow]));
        }
        lr.finish();
        return highestDegree;
    }

    private Integer getJaccard(SortedMap<Integer, SortedSet<Integer>> connVec, SortedMap<Double, SortedSet<Link>> retval, Map<Integer, Integer> connMag, BuildData rbd, Map<NetNode, Integer> targToRow, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int rowCount = rbd.getAllNodes().size();
        Integer[] icache = new Integer[rowCount];
        String[] scache = new String[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            icache[i] = i;
            scache[i] = icache[i].toString();
        }
        Integer highestDegree = null;
        int biggestMag = Integer.MIN_VALUE;
        HashSet union = new HashSet();
        HashSet intersect = new HashSet();
        LoopReporter lr = new LoopReporter(rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.getJaccard");
        for (NetLink fl : rbd.getLinks()) {
            SortedSet trgVec;
            int trgSize;
            lr.report();
            if (fl.isShadow()) continue;
            NetNode srcName = fl.getSrcNode();
            Integer srcRow = targToRow.get(srcName);
            NetNode trgName = fl.getTrgNode();
            Integer trgRow = targToRow.get(trgName);
            SortedSet srcVec = (SortedSet)connVec.get(srcRow);
            int srcSize = srcVec.size();
            if (srcSize > biggestMag) {
                biggestMag = srcSize;
                highestDegree = srcRow;
            }
            if ((trgSize = (trgVec = (SortedSet)connVec.get(trgRow)).size()) > biggestMag) {
                biggestMag = trgSize;
                highestDegree = trgRow;
            }
            connMag.put(icache[srcRow], icache[srcSize]);
            connMag.put(icache[trgRow], icache[trgSize]);
            union.clear();
            DataUtil.union(srcVec, trgVec, union);
            intersect.clear();
            DataUtil.intersection(srcVec, trgVec, intersect);
            int uSize = union.size();
            int iSize = intersect.size();
            double jaccard = (double)iSize / (double)uSize;
            Double jaccardObj = new Double(jaccard);
            TreeSet<Link> forDot = (TreeSet<Link>)retval.get(jaccardObj);
            if (forDot == null) {
                forDot = new TreeSet<Link>();
                retval.put(jaccardObj, forDot);
            }
            forDot.add(new Link(scache[srcRow], scache[trgRow]));
        }
        lr.finish();
        return highestDegree;
    }

    private List<Integer> orderByDistanceChained(Map<Integer, NetNode> rowToTarg, Integer start, SortedMap<Double, SortedSet<Link>> cosines, Map<Integer, Integer> connMag, List<Link> linkTrace, int limit, double tol, List<Integer> jumpLog, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int rowCount = rowToTarg.size();
        ArrayList<Integer> retval = new ArrayList<Integer>();
        HashSet<Integer> seen = new HashSet<Integer>();
        retval.add(start);
        seen.add(start);
        ArrayList<Integer> currentChain = new ArrayList<Integer>();
        currentChain.add(start);
        int switchCount = 0;
        int stayCount = 0;
        LoopReporter lr = new LoopReporter(rowCount, 20, monitor, 0.0, 1.0, "progress.orderByDistanceChained");
        int lastSize = retval.size();
        while (retval.size() < rowCount) {
            int rtvSize = retval.size();
            lr.report(rtvSize - lastSize);
            lastSize = rtvSize;
            DoubleRanked bestHop = this.findBestUnseenHop(rowToTarg, cosines, connMag, seen, null, retval);
            DoubleRanked currentHop = this.findBestUnseenHop(rowToTarg, cosines, connMag, seen, currentChain, retval);
            if (bestHop == null) {
                if (currentHop != null) {
                    throw new IllegalStateException();
                }
                this.handleFallbacks(rowToTarg, connMag, linkTrace, seen, retval);
                continue;
            }
            if (currentHop == null || currentHop.rank <= bestHop.rank * tol) {
                seen.add(bestHop.id);
                linkTrace.add(bestHop.byLink);
                jumpLog.add(retval.size());
                retval.add(bestHop.id);
                currentChain.clear();
                this.maintainChain(currentChain, bestHop, limit);
                ++switchCount;
                continue;
            }
            seen.add(currentHop.id);
            linkTrace.add(currentHop.byLink);
            retval.add(currentHop.id);
            this.maintainChain(currentChain, currentHop, limit);
            ++stayCount;
        }
        lr.finish();
        return retval;
    }

    private void maintainChain(List<Integer> chain, DoubleRanked bestChainedHop, int limit) {
        Integer bySrc = Integer.valueOf(bestChainedHop.byLink.getSrc());
        Integer byTrg = Integer.valueOf(bestChainedHop.byLink.getTrg());
        Integer bridge = bySrc.equals(bestChainedHop.id) ? byTrg : bySrc;
        chain.remove(bridge);
        chain.add(0, bestChainedHop.id);
        chain.add(0, bridge);
        while (chain.size() > limit) {
            chain.remove(chain.size() - 1);
        }
    }

    private DoubleRanked findBestUnseenHop(Map<Integer, NetNode> nodeForRow, SortedMap<Double, SortedSet<Link>> cosines, Map<Integer, Integer> degMag, HashSet<Integer> seen, List<Integer> launchNodes, List<Integer> currentOrder) {
        if (launchNodes != null && launchNodes.isEmpty()) {
            return null;
        }
        Iterator<Double> dotIt = cosines.keySet().iterator();
        String maxDegNodeName = null;
        Integer maxDegNode = null;
        Integer maxDegDeg = null;
        Integer maxDegMinOther = null;
        Integer maxDegOtherNode = null;
        ArrayList<Link> candConnects = new ArrayList<Link>();
        while (dotIt.hasNext()) {
            Double dot = dotIt.next();
            SortedSet forDot = (SortedSet)cosines.get(dot);
            maxDegNode = null;
            maxDegDeg = null;
            for (Link nextLink : forDot) {
                boolean eqName;
                Integer src = Integer.valueOf(nextLink.getSrc());
                Integer trg = Integer.valueOf(nextLink.getTrg());
                Integer cand = null;
                Integer other = null;
                if (seen.contains(src) && !seen.contains(trg)) {
                    if (launchNodes == null || launchNodes.contains(src)) {
                        cand = trg;
                        other = src;
                    }
                } else if (seen.contains(trg) && !seen.contains(src) && (launchNodes == null || launchNodes.contains(trg))) {
                    cand = src;
                    other = trg;
                }
                if (cand == null) continue;
                Integer degVal = degMag.get(cand);
                UiUtil.fixMePrintout("current degmag counts src->trg and trg->src directed links as only degree 1");
                String n4r = nodeForRow.get(cand).getName();
                Integer r4o = currentOrder.indexOf(other);
                boolean gtCon = maxDegDeg == null || maxDegDeg < degVal;
                boolean eqCon = maxDegDeg != null && maxDegDeg.intValue() == degVal.intValue();
                boolean ltORow = maxDegMinOther == null || maxDegMinOther.compareTo(r4o) > 0;
                boolean eqORow = maxDegMinOther != null && maxDegMinOther.compareTo(r4o) == 0;
                boolean ltName = maxDegNodeName == null || maxDegNodeName.compareToIgnoreCase(n4r) > 0;
                boolean bl = eqName = maxDegNodeName != null && maxDegNodeName.compareToIgnoreCase(n4r) == 0;
                if (!gtCon && (!eqCon || !ltORow && (!eqORow || !ltName && !eqName))) continue;
                maxDegNode = cand;
                maxDegNodeName = n4r;
                maxDegDeg = degVal;
                maxDegMinOther = r4o;
                maxDegOtherNode = other;
                if (!eqName) {
                    candConnects.clear();
                }
                candConnects.add(nextLink);
            }
            if (maxDegNode == null) continue;
            Link viaLink = null;
            for (Link aConnect : candConnects) {
                String other = aConnect.getSrc().equals(maxDegNode.toString()) ? aConnect.getTrg() : aConnect.getSrc();
                if (!other.equals(maxDegOtherNode.toString())) continue;
                viaLink = aConnect;
                break;
            }
            if (viaLink == null) {
                throw new IllegalStateException();
            }
            return new DoubleRanked(dot, maxDegNode, viaLink);
        }
        return null;
    }

    private void handleFallbacks(Map<Integer, NetNode> rowToNode, Map<Integer, Integer> degMag, List<Link> linkTrace, HashSet<Integer> seen, List<Integer> retval) {
        Integer nextBest = this.getHighestDegreeRemaining(rowToNode, seen, degMag);
        if (nextBest != null) {
            retval.add(nextBest);
            seen.add(nextBest);
            linkTrace.add(new Link(nextBest.toString(), nextBest.toString()));
        } else {
            TreeSet<Integer> remainingTargs = new TreeSet<Integer>();
            for (Integer row : rowToNode.keySet()) {
                remainingTargs.add(row);
            }
            remainingTargs.removeAll(retval);
            for (Integer rTrg : remainingTargs) {
                retval.add(rTrg);
                linkTrace.add(new Link(rTrg.toString(), rTrg.toString()));
            }
        }
    }

    private Integer getHighestDegreeRemaining(Map<Integer, NetNode> rowToNode, Set<Integer> seen, Map<Integer, Integer> degMag) {
        Integer maxDegNode = null;
        String maxDegNodeName = null;
        Integer maxDegDeg = null;
        for (Integer cand : degMag.keySet()) {
            boolean eqName;
            if (seen.contains(cand)) continue;
            Integer degVal = degMag.get(cand);
            String n4r = rowToNode.get(cand).getName();
            boolean gtCon = maxDegDeg == null || maxDegDeg < degVal;
            boolean eqCon = maxDegDeg != null && maxDegDeg.intValue() == degVal.intValue();
            boolean ltName = maxDegNodeName == null || maxDegNodeName.compareToIgnoreCase(n4r) > 0;
            boolean bl = eqName = maxDegNodeName != null && maxDegNodeName.compareToIgnoreCase(n4r) == 0;
            if (!gtCon && (!eqCon || !ltName && !eqName)) continue;
            maxDegNode = cand;
            maxDegNodeName = n4r;
            maxDegDeg = degVal;
        }
        return maxDegNode;
    }

    private void orderToMaps(List<Integer> orderedStringRows, Map<Integer, Integer> forward, Map<Integer, Integer> backward) {
        int numOsr = orderedStringRows.size();
        for (int i = 0; i < numOsr; ++i) {
            Integer sval = orderedStringRows.get(i);
            try {
                Integer newPos = sval;
                Integer oldPos = i;
                forward.put(oldPos, newPos);
                backward.put(newPos, oldPos);
                continue;
            }
            catch (NumberFormatException nfex) {
                throw new IllegalStateException();
            }
        }
    }

    private void curveDebug(SortedMap<Integer, Double> curve) {
        Iterator<Integer> cit = curve.keySet().iterator();
        int count = 0;
        while (cit.hasNext()) {
            Integer key = cit.next();
            Double val = (Double)curve.get(key);
            System.out.print("(" + key + "," + val + ")");
            if (count++ != 5) continue;
            break;
        }
        System.out.println();
    }

    private void buildCurvesAndCaches(TreeMap<Integer, Integer> oldToNew, TreeMap<Integer, Integer> newToOld, SortedMap<Integer, SortedSet<Integer>> connVec, Integer[] icache, Double[] dcache, HashMap<Integer, SortedMap<Integer, Double>> curves, HashMap<Integer, Map<Double, Set<Integer>>> connectMap, int numRows) {
        for (int i = 0; i < numRows; ++i) {
            Set<Integer> perFine;
            Integer newRow;
            icache[i] = newRow = Integer.valueOf(i);
            dcache[i] = new Double(i);
            Integer oldRow = newToOld.get(newRow);
            SortedSet baseNodeVec = (SortedSet)connVec.get(oldRow);
            SortedMap<Integer, Double> curve = this.calcShapeCurve(baseNodeVec, oldToNew);
            curves.put(newRow, curve);
            double connLog = Math.log(baseNodeVec.size()) / Math.log(2.0);
            Double connLogKey = new Double(connLog);
            int logBin = connLog < 4.0 ? 0 : (int)Math.floor(connLog);
            Integer logBinKey = logBin;
            Map<Double, Set<Integer>> fineGrain = connectMap.get(logBinKey);
            if (fineGrain == null) {
                fineGrain = new HashMap<Double, Set<Integer>>();
                connectMap.put(logBinKey, fineGrain);
            }
            if ((perFine = fineGrain.get(connLogKey)) == null) {
                perFine = new HashSet<Integer>();
                fineGrain.put(connLogKey, perFine);
            }
            perFine.add(newRow);
        }
    }

    private void buildCheckSet(SortedMap<Integer, Double> baseCurve, TreeSet<Integer> connBuf, SortedSet<Integer> logKeys, HashMap<Integer, Map<Double, Set<Integer>>> connectMap) {
        double baseConnLog = Math.log(baseCurve.size()) / Math.log(2.0);
        double baseConnLogLo = 0.98 * baseConnLog;
        double baseConnLogHi = 1.02 * baseConnLog;
        logKeys.clear();
        int logBinLo = baseConnLog < 4.0 ? 0 : (int)Math.floor(baseConnLogLo);
        Integer logBinLoKey = logBinLo;
        logKeys.add(logBinLoKey);
        int logBinHi = baseConnLog < 4.0 ? 0 : (int)Math.floor(baseConnLogHi);
        Integer logBinHiKey = logBinHi;
        logKeys.add(logBinHiKey);
        logKeys = DataUtil.fillOutHourly(logKeys);
        connBuf.clear();
        for (Integer logBinKey : logKeys) {
            int logBinVal = logBinKey;
            Map<Double, Set<Integer>> fineGrain = connectMap.get(logBinKey);
            if (fineGrain == null) continue;
            for (Double fineKey : fineGrain.keySet()) {
                double fineKeyVal = fineKey;
                if (logBinVal != 0 && (!(baseConnLogLo <= fineKeyVal) || !(baseConnLogHi >= fineKeyVal))) continue;
                Set<Integer> fineGrains = fineGrain.get(fineKey);
                connBuf.addAll(fineGrains);
            }
        }
    }

    private ClusterPrep setupForResort(SortedMap<Integer, SortedSet<Integer>> connVec, List<Integer> orderedStringRows, SortedMap<Integer, Double> rankings) {
        Integer newRow;
        int currRow;
        ClusterPrep retval = new ClusterPrep(orderedStringRows.size());
        this.orderToMaps(orderedStringRows, retval.oldToNew, retval.newToOld);
        this.buildCurvesAndCaches(retval.oldToNew, retval.newToOld, connVec, retval.icache, retval.dcache, retval.curves, retval.connectMap, retval.numRows);
        TreeSet<Integer> unionBuf = new TreeSet<Integer>();
        TreeSet<Integer> keyBuf = new TreeSet<Integer>();
        double deltaSum = 0.0;
        Iterator<Integer> n2oit = new TreeSet<Integer>(retval.newToOld.keySet()).iterator();
        while (n2oit.hasNext() && (currRow = (newRow = n2oit.next()).intValue()) != retval.numRows - 1) {
            SortedMap<Integer, Double> baseCurve = retval.curves.get(newRow);
            SortedMap<Integer, Double> nextCurve = retval.curves.get(retval.icache[currRow + 1]);
            double delt = this.calcShapeDeltaUsingCurveMaps(baseCurve, nextCurve, unionBuf, keyBuf);
            deltaSum += delt;
        }
        Integer useKey = rankings.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(rankings.lastKey() + 1);
        rankings.put(useKey, new Double(deltaSum));
        return retval;
    }

    public List<Integer> resort(ClusterPrep prep, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        TreeSet<Integer> unionBuf = new TreeSet<Integer>();
        TreeSet<Integer> keyBuf = new TreeSet<Integer>();
        TreeSet<Integer> stillAvail = new TreeSet<Integer>(prep.newToOld.keySet());
        TreeMap<Integer, Integer> results = new TreeMap<Integer, Integer>();
        TreeSet<Integer> connBuf = new TreeSet<Integer>();
        TreeSet<Integer> logKeys = new TreeSet<Integer>();
        SortedMap<Integer, Double> baseCurve = null;
        int currRow = 0;
        int startCheck = 1;
        int fillSlot = 0;
        results.put(prep.icache[0], prep.icache[fillSlot++]);
        stillAvail.remove(prep.icache[0]);
        baseCurve = prep.curves.get(prep.icache[0]);
        while (!stillAvail.isEmpty()) {
            double currProg;
            Integer newRow = stillAvail.first();
            startCheck = newRow;
            this.buildCheckSet(baseCurve, connBuf, logKeys, prep.connectMap);
            connBuf.retainAll(stillAvail);
            connBuf.add(prep.icache[startCheck]);
            DoubMinMax dmm = new DoubMinMax();
            dmm.inverseInit();
            double minMatch = Double.POSITIVE_INFINITY;
            int minI = currRow;
            int numCheck = 0;
            for (Integer swapCheck : connBuf) {
                int swapCheckVal = swapCheck;
                ++numCheck;
                SortedMap<Integer, Double> shiftCandCurve = prep.curves.get(swapCheck);
                double delt = this.calcShapeDeltaUsingCurveMaps(baseCurve, shiftCandCurve, unionBuf, keyBuf);
                dmm.update(delt);
                if (!(delt < minMatch)) continue;
                minI = swapCheckVal;
                minMatch = delt;
            }
            if (minI > startCheck) {
                baseCurve = prep.curves.get(prep.icache[minI]);
                stillAvail.remove(prep.icache[minI]);
                results.put(prep.icache[minI], prep.icache[fillSlot++]);
            } else {
                baseCurve = prep.curves.get(prep.icache[startCheck]);
                stillAvail.remove(prep.icache[startCheck]);
                results.put(prep.icache[startCheck], prep.icache[fillSlot++]);
            }
            if (monitor == null || monitor.updateProgress((int)((currProg = startFrac + (endFrac - startFrac) * (1.0 - (double)stillAvail.size() / (double)prep.numRows)) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        ArrayList<Integer> retval = new ArrayList<Integer>();
        for (Integer newRow : prep.oldToNew.values()) {
            Integer mappedRow = (Integer)results.get(newRow);
            retval.add(mappedRow);
        }
        return retval;
    }

    private SortedMap<Integer, Double> calcShapeCurve(SortedSet<Integer> vec1, Map<Integer, Integer> newOrder) {
        TreeSet<Integer> reordered1 = new TreeSet<Integer>();
        for (Integer linkEnd : vec1) {
            Integer mappedEnd = newOrder.get(linkEnd);
            reordered1.add(mappedEnd);
        }
        ArrayList<Integer> vec1Order = new ArrayList<Integer>(reordered1);
        int numPts = vec1Order.size();
        TreeMap<Integer, Double> vec1Points = new TreeMap<Integer, Double>();
        for (int i = 0; i < numPts; ++i) {
            Integer linkEnd = (Integer)vec1Order.get(i);
            this.calcCurveMap(reordered1, vec1Order, linkEnd, vec1Points);
        }
        return vec1Points;
    }

    private double curveAverage(SortedMap<Integer, Double> curve) {
        double retval = 0.0;
        Double firstVal = null;
        double lastX = 0.0;
        for (Integer key : curve.keySet()) {
            Double val = (Double)curve.get(key);
            double thisKey = key.doubleValue();
            double thisVal = val;
            if (firstVal == null) {
                firstVal = val;
            } else {
                retval += (thisKey - lastX) * thisVal;
            }
            lastX = thisKey;
        }
        if (firstVal == null) {
            return 0.0;
        }
        if (lastX == 0.0) {
            return firstVal;
        }
        return retval /= lastX;
    }

    private double calcShapeDeltaUsingCurveMaps(SortedMap<Integer, Double> vec1Points, SortedMap<Integer, Double> vec2Points, SortedSet<Integer> unionBuf, SortedSet<Integer> keyBuf) {
        double deltaSqSum = 0.0;
        if (vec1Points.isEmpty() || vec2Points.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double ca1 = this.curveAverage(vec1Points);
        double ca2 = this.curveAverage(vec2Points);
        unionBuf.clear();
        DataUtil.union(vec1Points.keySet(), vec2Points.keySet(), unionBuf);
        for (Integer point : unionBuf) {
            double v1Val = this.interpCurve(vec1Points, point, keyBuf) - ca1;
            double v2Val = this.interpCurve(vec2Points, point, keyBuf) - ca2;
            double yDelt = v1Val - v2Val;
            deltaSqSum += yDelt * yDelt;
        }
        double retval = Math.sqrt(deltaSqSum);
        if (Double.isNaN(retval)) {
            System.err.println(vec1Points);
            System.err.println(vec2Points);
            System.err.println(unionBuf);
            throw new IllegalStateException();
        }
        return retval;
    }

    private void calcCurveMap(SortedSet<Integer> vec, List<Integer> vecOrder, Integer linkEnd, Map<Integer, Double> curvePoints) {
        int numVec = vecOrder.size();
        int vec1Pos = vecOrder.indexOf(linkEnd);
        if (vec1Pos == -1) {
            throw new IllegalArgumentException();
        }
        curvePoints.put(linkEnd, new Double(numVec - vec1Pos));
    }

    private double interpCurve(SortedMap<Integer, Double> curve, Integer xVal, SortedSet<Integer> xBuf) {
        Double exact = (Double)curve.get(xVal);
        if (exact != null) {
            return exact;
        }
        double[] weights = new double[2];
        xBuf.clear();
        xBuf.addAll(curve.keySet());
        MinMax bounds = DataUtil.boundingInts(xBuf, xVal);
        boolean areDiff = this.getWeights(bounds.min, bounds.max, xVal.doubleValue(), weights);
        if (areDiff) {
            Integer mappedEndLo = bounds.min;
            Integer mappedEndHi = bounds.max;
            double vec1YVal = weights[0] * (Double)curve.get(mappedEndLo) + weights[1] * (Double)curve.get(mappedEndHi);
            return vec1YVal;
        }
        if (bounds.min > xBuf.first()) {
            return (Double)curve.get(curve.firstKey());
        }
        return 0.0;
    }

    private boolean getWeights(double val1, double val2, double calcForVal, double[] toFill) {
        if (val1 == val2) {
            return false;
        }
        toFill[0] = (calcForVal - val2) / (val1 - val2);
        toFill[1] = 1.0 - toFill[0];
        return true;
    }

    public static class ResortParams
    implements NodeLayout.Params {
        public int passCount;
        public boolean terminateAtIncrease;

        public ResortParams(double tolerance, int passCount, boolean terminateAtIncrease) {
            this.passCount = passCount;
            this.terminateAtIncrease = terminateAtIncrease;
        }

        public ResortParams() {
            this.passCount = 10;
            this.terminateAtIncrease = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClusterParams
    implements NodeLayout.Params {
        public static final int JACCARD = 0;
        public static final int COSINES = 1;
        public double tolerance;
        public int chainLength;
        public int distanceMethod;

        public ClusterParams(double tolerance, int chainLength, int distanceMethod) {
            this.tolerance = tolerance;
            this.chainLength = chainLength;
            this.distanceMethod = distanceMethod;
        }

        public ClusterParams() {
            this.tolerance = 0.8;
            this.chainLength = 15;
            this.distanceMethod = 0;
        }

        public static Vector<ChoiceContent> getDistanceChoices() {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
            retval.add(new ChoiceContent(rMan.getString("clusterParams.jaccard"), 0));
            retval.add(new ChoiceContent(rMan.getString("clusterParams.cosines"), 1));
            return retval;
        }
    }

    public static class ClusterPrep {
        int numRows;
        TreeMap<Integer, Integer> oldToNew;
        TreeMap<Integer, Integer> newToOld;
        Integer[] icache;
        Double[] dcache;
        HashMap<Integer, SortedMap<Integer, Double>> curves;
        HashMap<Integer, Map<Double, Set<Integer>>> connectMap;

        ClusterPrep(int numRows) {
            this.numRows = numRows;
            this.oldToNew = new TreeMap();
            this.newToOld = new TreeMap();
            this.icache = new Integer[numRows];
            this.dcache = new Double[numRows];
            this.curves = new HashMap();
            this.connectMap = new HashMap();
        }
    }

    static class DoubleRanked {
        double rank;
        Integer id;
        Link byLink;

        DoubleRanked(double rank, Integer id, Link byLink) {
            this.rank = rank;
            this.id = id;
            this.byLink = byLink;
        }
    }
}

