/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.layouts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biofabric.analysis.GraphSearcher;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.layout.DefaultLayout;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.io.AttributeLoader;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.model.FabricNode;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.TrueObjChoiceContent;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeClusterLayout
extends NodeLayout {
    @Override
    public List<NetNode> doNodeLayout(BuildData bd, NodeLayout.Params crParams, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<String> bfc;
        BuildDataImpl rbd = (BuildDataImpl)bd;
        ClusterParams params = (ClusterParams)crParams;
        TreeMap<String, BuildDataImpl> perClust = new TreeMap<String, BuildDataImpl>();
        HashMap<Tuple, List<NetLink>> interClust = new HashMap<Tuple, List<NetLink>>();
        HashSet<NetNode> interNodesOnly = new HashSet<NetNode>();
        HashMap<NetNode, Integer> fullNodeDegree = null;
        if (params.cLay == ClusterParams.ClustLayout.BREADTH_CONN_FIRST) {
            fullNodeDegree = new HashMap<NetNode, Integer>();
        }
        BuildDataImpl.BuildMode intraLay = BuildDataImpl.BuildMode.DEFAULT_LAYOUT;
        for (NetLink netLink : rbd.getLinks()) {
            String trgClust;
            String srcClust;
            NetNode source = netLink.getSrcNode();
            NetNode target = netLink.getTrgNode();
            if (fullNodeDegree != null) {
                Integer count = (Integer)fullNodeDegree.get(source);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                fullNodeDegree.put(source, count);
                count = (Integer)fullNodeDegree.get(target);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                fullNodeDegree.put(target, count);
            }
            if ((srcClust = params.getClusterForNode(source)).equals(trgClust = params.getClusterForNode(target))) {
                BuildDataImpl rbdpc = perClust.get(srcClust);
                if (rbdpc == null) {
                    rbdpc = new BuildDataImpl(new UniqueLabeller(), new HashSet<NetLink>(), new HashSet<NetNode>(), new HashMap<NetNode, String>(), rbd.getColorGen(), intraLay);
                    rbdpc.initAllNodesBogus(new HashSet<NetNode>());
                    perClust.put(srcClust, rbdpc);
                }
                UiUtil.fixMePrintout("ADDING TO THE RETURNED SET");
                rbdpc.getLinks().add(netLink);
                this.addClusterNode(rbdpc, source);
                this.addClusterNode(rbdpc, target);
                continue;
            }
            Tuple intup = new Tuple(srcClust, trgClust);
            ArrayList<NetLink> icfl = (ArrayList<NetLink>)interClust.get(intup);
            if (icfl == null) {
                icfl = new ArrayList<NetLink>();
                interClust.put(intup, icfl);
            }
            icfl.add(netLink);
            interNodesOnly.add(source);
            interNodesOnly.add(target);
        }
        for (NetNode node : rbd.getAllNodes()) {
            String clust = params.getClusterForNode(node);
            BuildDataImpl rbdpc = (BuildDataImpl)perClust.get(clust);
            if (rbdpc == null) {
                rbdpc = new BuildDataImpl(new UniqueLabeller(), new HashSet<NetLink>(), new HashSet<NetNode>(), new HashMap<NetNode, String>(), rbd.getColorGen(), intraLay);
                rbdpc.initAllNodesBogus(new HashSet<NetNode>());
                perClust.put(clust, rbdpc);
            }
            this.addClusterNode(rbdpc, node);
        }
        String string = params.startNode != null ? params.getClusterForNode(params.startNode) : null;
        switch (params.order) {
            case BREADTH: {
                bfc = this.breadthFirstClustering(params, interClust.keySet(), string, monitor);
                break;
            }
            case LINK_SIZE: {
                bfc = this.clusterSizeOrder(perClust, false, string);
                break;
            }
            case NODE_SIZE: {
                bfc = this.clusterSizeOrder(perClust, true, string);
                break;
            }
            case NAME: {
                bfc = new ArrayList(perClust.keySet());
                if (string == null) break;
                bfc.remove(string);
                bfc.add(0, string);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Map<String, List<NetNode>> hubs = null;
        if (params.cLay == ClusterParams.ClustLayout.BREADTH_CONN_FIRST) {
            hubs = this.rankInterClustHubs(interClust, params, fullNodeDegree);
        }
        ArrayList<NetNode> allTargets = new ArrayList<NetNode>();
        for (String clustName : bfc) {
            BuildData pcrbd = perClust.get(clustName);
            if (pcrbd == null) continue;
            if (intraLay != BuildDataImpl.BuildMode.DEFAULT_LAYOUT) {
                throw new IllegalStateException();
            }
            DefaultLayout dl = new DefaultLayout();
            List<NetNode> starts = hubs == null ? null : hubs.get(clustName);
            List<NetNode> targets = dl.defaultNodeOrder(pcrbd.getLinks(), pcrbd.getSingletonNodes(), starts, monitor);
            allTargets.addAll(targets);
        }
        interNodesOnly.removeAll(allTargets);
        allTargets.addAll(interNodesOnly);
        this.installNodeOrder(allTargets, rbd, monitor);
        UiUtil.fixMePrintout("Inter cluster shadows are messed up and on the right");
        new DefaultEdgeLayout().layoutEdges(rbd, monitor);
        UiUtil.fixMePrintout("How does this interact with network-wide link groups??");
        if (params.iLink == ClusterParams.InterLink.BETWEEN) {
            int origNum = rbd.getLinkOrder().size();
            TreeMap<Integer, NetLink> newOrder = new TreeMap<Integer, NetLink>();
            HashMap<String, ArrayList<NetLink>> holdEm = new HashMap<String, ArrayList<NetLink>>();
            Iterator<NetLink> ksit = rbd.getLinkOrder().values().iterator();
            int colCount = 0;
            String currClust = null;
            boolean drainTime = false;
            boolean interClustLink = false;
            while (ksit.hasNext()) {
                String trgClust;
                NetLink daLink = ksit.next();
                String srcClust = params.getClusterForNode(daLink.getSrcNode());
                if (srcClust.equals(trgClust = params.getClusterForNode(daLink.getTrgNode()))) {
                    if (currClust != null && !currClust.equals(srcClust)) {
                        drainTime = true;
                    }
                    currClust = srcClust;
                    interClustLink = false;
                } else {
                    interClustLink = true;
                }
                if (drainTime) {
                    List toDrain = (List)holdEm.get(currClust);
                    if (toDrain != null) {
                        for (NetLink ihe : toDrain) {
                            newOrder.put(colCount++, ihe);
                        }
                    }
                    holdEm.remove(currClust);
                    drainTime = false;
                    newOrder.put(colCount++, daLink);
                    continue;
                }
                if (!interClustLink) {
                    currClust = srcClust;
                    newOrder.put(colCount++, daLink);
                    continue;
                }
                String otherClust = srcClust.equals(currClust) ? trgClust : srcClust;
                ArrayList<NetLink> toDefer = (ArrayList<NetLink>)holdEm.get(otherClust);
                if (toDefer == null) {
                    toDefer = new ArrayList<NetLink>();
                    holdEm.put(otherClust, toDefer);
                }
                toDefer.add(daLink);
            }
            UiUtil.fixMePrintout("Cluster drain order is not correct");
            for (String daClust : holdEm.keySet()) {
                List toDrain = (List)holdEm.get(daClust);
                if (toDrain == null) continue;
                for (NetLink ihe : toDrain) {
                    newOrder.put(colCount++, ihe);
                }
            }
            if (newOrder.size() != origNum) {
                throw new IllegalStateException();
            }
            rbd.setLinkOrder(newOrder);
        }
        if (params.saveAssign) {
            rbd.clustAssign = params.getClusterAssign();
        }
        AnnotationSet nAnnots = this.generateNodeAnnotations(rbd, params);
        rbd.setNodeAnnotations(nAnnots);
        Map<Boolean, AnnotationSet> lAnnots = this.generateLinkAnnotations(rbd, params);
        rbd.setLinkAnnotations(lAnnots);
        return allTargets;
    }

    private AnnotationSet generateNodeAnnotations(BuildData rbd, ClusterParams params) {
        AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
        TreeMap<Integer, NetNode> invert = new TreeMap<Integer, NetNode>();
        Map<NetNode, Integer> nod = rbd.getNodeOrder();
        for (NetNode node : nod.keySet()) {
            invert.put(nod.get(node), node);
        }
        String currClust = null;
        Integer startRow = null;
        Integer lastKey = (Integer)invert.lastKey();
        for (Integer row : invert.keySet()) {
            Annot annot;
            NetNode node = (NetNode)invert.get(row);
            String clust = params.getClusterForNode(node);
            if (currClust == null) {
                currClust = clust;
                startRow = row;
                if (!row.equals(lastKey)) continue;
                annot = PluginSupportFactory.buildAnnotation(currClust, startRow, row, 0, null);
                retval.addAnnot(annot);
                break;
            }
            if (currClust.equals(clust)) {
                if (!row.equals(lastKey)) continue;
                annot = PluginSupportFactory.buildAnnotation(currClust, startRow, row, 0, null);
                retval.addAnnot(annot);
                break;
            }
            annot = PluginSupportFactory.buildAnnotation(currClust, startRow, row - 1, 0, null);
            retval.addAnnot(annot);
            startRow = row;
            currClust = clust;
            if (!row.equals(lastKey)) continue;
            annot = PluginSupportFactory.buildAnnotation(currClust, startRow, row, 0, null);
            retval.addAnnot(annot);
            break;
        }
        return retval;
    }

    private Map<Boolean, AnnotationSet> generateLinkAnnotations(BuildData rbd, ClusterParams params) {
        HashMap<Boolean, AnnotationSet> retval = new HashMap<Boolean, AnnotationSet>();
        SortedMap<Integer, NetLink> lod = rbd.getLinkOrder();
        ArrayList<NetLink> noShadows = new ArrayList<NetLink>();
        ArrayList<NetLink> withShadows = new ArrayList<NetLink>();
        for (Integer col : lod.keySet()) {
            NetLink fl = (NetLink)lod.get(col);
            withShadows.add(fl);
            if (fl.isShadow()) continue;
            noShadows.add(fl);
        }
        retval.put(Boolean.FALSE, this.generateLinkAnnotationsForSet(rbd, noShadows, params));
        UiUtil.fixMePrintout("Messedup link annotations with shadows");
        retval.put(Boolean.TRUE, this.generateLinkAnnotationsForSet(rbd, withShadows, params));
        return retval;
    }

    private AnnotationSet generateLinkAnnotationsForSet(BuildData rbd, List<NetLink> linkList, ClusterParams params) {
        MinMax mm;
        String trgClust;
        String srcClust;
        NetNode trgNode;
        NetNode srcNode;
        boolean isShad;
        NetLink fl;
        int i;
        HashMap<String, MinMax> clustRanges = new HashMap<String, MinMax>();
        Map<NetNode, Integer> nod = rbd.getNodeOrder();
        if (params.iLink == ClusterParams.InterLink.INLINE) {
            for (i = 0; i < linkList.size(); ++i) {
                int trgRow;
                fl = linkList.get(i);
                isShad = fl.isShadow();
                srcNode = fl.getSrcNode();
                trgNode = fl.getTrgNode();
                srcClust = params.getClusterForNode(srcNode);
                trgClust = params.getClusterForNode(trgNode);
                int srcRow = nod.get(srcNode);
                String useClust = srcRow <= (trgRow = nod.get(trgNode).intValue()) ? (isShad ? trgClust : srcClust) : (isShad ? srcClust : trgClust);
                MinMax mmc = (MinMax)clustRanges.get(useClust);
                if (mmc == null) {
                    mmc = new MinMax(i);
                    clustRanges.put(useClust, mmc);
                }
                mmc.update(i);
            }
        } else {
            for (i = 0; i < linkList.size(); ++i) {
                fl = linkList.get(i);
                isShad = fl.isShadow();
                srcNode = fl.getSrcNode();
                trgNode = fl.getTrgNode();
                srcClust = params.getClusterForNode(srcNode);
                if (!srcClust.equals(trgClust = params.getClusterForNode(trgNode))) continue;
                String useClust = srcClust;
                MinMax mmc = (MinMax)clustRanges.get(useClust);
                if (mmc == null) {
                    mmc = new MinMax(i);
                    clustRanges.put(useClust, mmc);
                }
                mmc.update(i);
            }
        }
        AnnotationSet afns = PluginSupportFactory.buildAnnotationSet();
        TreeMap<Integer, String> ord = new TreeMap<Integer, String>();
        for (String aName : clustRanges.keySet()) {
            mm = (MinMax)clustRanges.get(aName);
            ord.put(mm.min, aName);
        }
        for (String aName : ord.values()) {
            mm = (MinMax)clustRanges.get(aName);
            Annot annot = PluginSupportFactory.buildAnnotation(aName, mm.min, mm.max, 0, null);
            afns.addAnnot(annot);
        }
        return afns;
    }

    private void addClusterNode(BuildDataImpl rbd, NetNode nid) {
        if (!rbd.getAllNodes().contains(nid)) {
            boolean ok = rbd.idGen.addExistingLabel(nid.getNID().getNID().getInternal());
            if (!ok) {
                throw new IllegalStateException();
            }
            rbd.addToAllNodesBogus(nid);
        }
    }

    private void addToCount(Map<String, Map<NetNode, Integer>> countMap, String clust, NetNode node) {
        Integer count;
        Map<NetNode, Integer> perClust = countMap.get(clust);
        if (perClust == null) {
            perClust = new HashMap<NetNode, Integer>();
            countMap.put(clust, perClust);
        }
        count = (count = perClust.get(node)) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        perClust.put(node, count);
    }

    private Map<String, List<NetNode>> rankInterClustHubs(Map<Tuple, List<NetLink>> interLinks, ClusterParams params, Map<NetNode, Integer> fullNodeDegree) {
        HashMap<String, Map<NetNode, Integer>> preRetval = new HashMap<String, Map<NetNode, Integer>>();
        for (Tuple tup : interLinks.keySet()) {
            List<NetLink> forTup = interLinks.get(tup);
            for (NetLink link : forTup) {
                this.addToCount(preRetval, params.getClusterForNode(link.getSrcNode()), link.getSrcNode());
                this.addToCount(preRetval, params.getClusterForNode(link.getTrgNode()), link.getTrgNode());
            }
        }
        HashMap<String, List<NetNode>> retval = new HashMap<String, List<NetNode>>();
        for (String clust : preRetval.keySet()) {
            Map degMap = (Map)preRetval.get(clust);
            TreeMap invert = new TreeMap(Collections.reverseOrder());
            for (NetNode node : degMap.keySet()) {
                Integer fnDeg;
                TreeSet<NetNode> perFullDeg;
                Integer interClustDeg = (Integer)degMap.get(node);
                TreeMap perInterDeg = (TreeMap)invert.get(interClustDeg);
                if (perInterDeg == null) {
                    perInterDeg = new TreeMap(Collections.reverseOrder());
                    invert.put(interClustDeg, perInterDeg);
                }
                if ((perFullDeg = (TreeSet<NetNode>)perInterDeg.get(fnDeg = fullNodeDegree.get(node))) == null) {
                    perFullDeg = new TreeSet<NetNode>();
                    perInterDeg.put(fnDeg, perFullDeg);
                }
                perFullDeg.add(node);
            }
            ArrayList flat = new ArrayList();
            for (SortedMap perInterDeg : invert.values()) {
                for (SortedSet perFull : perInterDeg.values()) {
                    flat.addAll(perFull);
                }
            }
            retval.put(clust, flat);
        }
        return retval;
    }

    private List<String> clusterSizeOrder(TreeMap<String, BuildDataImpl> perClust, boolean nodeFirst, String startClust) {
        TreeMap preRet = new TreeMap(Collections.reverseOrder());
        for (String clustName : perClust.keySet()) {
            Integer size2;
            TreeSet<String> forSize2;
            BuildData rbdpc = perClust.get(clustName);
            Integer size1 = nodeFirst ? rbdpc.getAllNodes().size() : rbdpc.getLinks().size();
            TreeMap forSize1 = (TreeMap)preRet.get(size1);
            if (forSize1 == null) {
                forSize1 = new TreeMap(Collections.reverseOrder());
                preRet.put(size1, forSize1);
            }
            if ((forSize2 = (TreeSet<String>)forSize1.get(size2 = Integer.valueOf(nodeFirst ? rbdpc.getLinks().size() : rbdpc.getAllNodes().size()))) == null) {
                forSize2 = new TreeSet<String>();
                forSize1.put(size2, forSize2);
            }
            forSize2.add(clustName);
        }
        ArrayList<String> flat = new ArrayList<String>();
        for (SortedMap perSize1 : preRet.values()) {
            for (SortedSet perSize2 : perSize1.values()) {
                flat.addAll(perSize2);
            }
        }
        if (startClust != null) {
            flat.remove(startClust);
            flat.add(0, startClust);
        }
        return flat;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> breadthFirstClustering(ClusterParams params, Set<Tuple> iclinks, String startClust, BTProgressMonitor monitor) throws AsynchExitRequestException {
        void var8_12;
        UniqueLabeller uLab = new UniqueLabeller();
        HashMap<String, FabricNode> fakeNodes = new HashMap<String, FabricNode>();
        for (String string : params.getClusters()) {
            NID pnid = uLab.getNextOID();
            fakeNodes.put(string, new FabricNode(pnid, string));
        }
        HashSet<NetLink> links = new HashSet<NetLink>();
        for (Tuple tup : iclinks) {
            FabricLink pseudo = new FabricLink((NetNode)fakeNodes.get(tup.getVal1()), (NetNode)fakeNodes.get(tup.getVal2()), "ic", false, false);
            links.add(pseudo);
            pseudo = new FabricLink((NetNode)fakeNodes.get(tup.getVal2()), (NetNode)fakeNodes.get(tup.getVal1()), "ic", false, false);
            links.add(pseudo);
        }
        Object var8_10 = null;
        if (startClust != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(fakeNodes.get(startClust));
        }
        GraphSearcher gs = new GraphSearcher(new HashSet<NetNode>(fakeNodes.values()), links);
        List<GraphSearcher.QueueEntry> qes = gs.breadthSearch((List<NetNode>)var8_12, true, monitor);
        ArrayList<String> retval = new ArrayList<String>();
        for (GraphSearcher.QueueEntry aqe : qes) {
            retval.add(aqe.name.getName());
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tuple
    implements Cloneable,
    Comparable<Tuple> {
        private String val1_;
        private String val2_;

        public Tuple(String val1, String val2) {
            if (val1 == null || val2 == null) {
                throw new IllegalArgumentException();
            }
            if (val1.compareTo(val2) < 0) {
                this.val1_ = val1;
                this.val2_ = val2;
            } else {
                this.val1_ = val2;
                this.val2_ = val1;
            }
        }

        public Tuple clone() {
            try {
                Tuple newTup = (Tuple)super.clone();
                return newTup;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            return this.val1_.hashCode() + this.val2_.hashCode();
        }

        public String getVal1() {
            return this.val1_;
        }

        public String getVal2() {
            return this.val2_;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Tuple)) {
                return false;
            }
            Tuple otherT = (Tuple)other;
            return this.val1_.equals(otherT.val1_) && this.val2_.equals(otherT.val2_);
        }

        public String toString() {
            return "Tuple: (" + this.val1_ + ", " + this.val2_ + ")";
        }

        @Override
        public int compareTo(Tuple otherTup) {
            int val1Diff = this.val1_.compareTo(otherTup.val1_);
            if (val1Diff != 0) {
                return val1Diff;
            }
            return this.val2_.compareTo(otherTup.val2_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClusterParams
    implements NodeLayout.Params {
        public Source source;
        public Order order;
        public InterLink iLink;
        public ClustLayout cLay;
        public NetNode startNode;
        public boolean saveAssign;
        private Map<NetNode, String> nodeClusters_;

        public ClusterParams(Source source, Order order, InterLink iLink, ClustLayout cLay, String startNode, Map<AttributeKey, String> nodeClusterAttributes, Map<String, NetNode> nodes, boolean saveAssign) {
            if (nodeClusterAttributes != null) {
                this.nodeClusters_ = new HashMap<NetNode, String>();
                for (AttributeKey key : nodeClusterAttributes.keySet()) {
                    NetNode nodeID = nodes.get(DataUtil.normKey(((AttributeLoader.StringKey)key).key));
                    this.nodeClusters_.put(nodeID, nodeClusterAttributes.get(key));
                }
            }
            this.source = source;
            this.order = order;
            this.saveAssign = saveAssign;
        }

        public ClusterParams(boolean stored) {
            this.source = stored ? Source.STORED : Source.FILE;
            this.order = Order.BREADTH;
            this.iLink = InterLink.BETWEEN;
            this.cLay = ClustLayout.BREADTH_CONN_FIRST;
            this.startNode = null;
            this.saveAssign = true;
        }

        public boolean needsFile() {
            return this.source.equals((Object)Source.FILE);
        }

        public void install(Map<AttributeKey, String> nodeClusterAttributes, Map<String, NetNode> nodes) {
            if (nodeClusterAttributes != null) {
                this.nodeClusters_ = new HashMap<NetNode, String>();
                for (AttributeKey key : nodeClusterAttributes.keySet()) {
                    NetNode nodeID = nodes.get(DataUtil.normKey(((AttributeLoader.StringKey)key).key));
                    this.nodeClusters_.put(nodeID, nodeClusterAttributes.get(key));
                }
            }
        }

        public void assign(Map<NetNode, String> nodeClusterAssign) {
            this.nodeClusters_ = nodeClusterAssign;
        }

        public String getClusterForNode(NetNode nodeID) {
            return this.nodeClusters_.get(nodeID);
        }

        public Map<NetNode, String> getClusterAssign() {
            return this.nodeClusters_;
        }

        public Collection<String> getClusters() {
            return this.nodeClusters_.values();
        }

        public static Vector<TrueObjChoiceContent<Source>> getSourceChoices(boolean stored) {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<TrueObjChoiceContent<Source>> retval = new Vector<TrueObjChoiceContent<Source>>();
            if (stored) {
                retval.add(new TrueObjChoiceContent<Source>(rMan.getString("nodeClusterParams.stored"), Source.STORED));
            }
            retval.add(new TrueObjChoiceContent<Source>(rMan.getString("nodeClusterParams.file"), Source.FILE));
            return retval;
        }

        public static Vector<TrueObjChoiceContent<InterLink>> getILinkChoices() {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<TrueObjChoiceContent<InterLink>> retval = new Vector<TrueObjChoiceContent<InterLink>>();
            retval.add(new TrueObjChoiceContent<InterLink>(rMan.getString("nodeClusterParams.between"), InterLink.BETWEEN));
            retval.add(new TrueObjChoiceContent<InterLink>(rMan.getString("nodeClusterParams.inline"), InterLink.INLINE));
            return retval;
        }

        public static Vector<TrueObjChoiceContent<ClustLayout>> getClustLayoutChoices() {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<TrueObjChoiceContent<ClustLayout>> retval = new Vector<TrueObjChoiceContent<ClustLayout>>();
            retval.add(new TrueObjChoiceContent<ClustLayout>(rMan.getString("nodeClusterParams.breadthConnFirst"), ClustLayout.BREADTH_CONN_FIRST));
            retval.add(new TrueObjChoiceContent<ClustLayout>(rMan.getString("nodeClusterParams.breadth"), ClustLayout.BREADTH));
            return retval;
        }

        public static Vector<TrueObjChoiceContent<Order>> getOrderChoices() {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<TrueObjChoiceContent<Order>> retval = new Vector<TrueObjChoiceContent<Order>>();
            retval.add(new TrueObjChoiceContent<Order>(rMan.getString("nodeClusterParams.breadthOrder"), Order.BREADTH));
            retval.add(new TrueObjChoiceContent<Order>(rMan.getString("nodeClusterParams.name"), Order.NAME));
            retval.add(new TrueObjChoiceContent<Order>(rMan.getString("nodeClusterParams.nodeSize"), Order.NODE_SIZE));
            retval.add(new TrueObjChoiceContent<Order>(rMan.getString("nodeClusterParams.linkSize"), Order.LINK_SIZE));
            return retval;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ClustLayout {
            BREADTH_CONN_FIRST,
            BREADTH;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InterLink {
            INLINE,
            BETWEEN;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Order {
            NAME,
            NODE_SIZE,
            LINK_SIZE,
            BREADTH;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Source {
            STORED,
            FILE;

        }
    }
}

