/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.analysis.CycleFinder;
import org.systemsbiology.biofabric.analysis.GraphSearcher;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierDAGLayout
extends NodeLayout {
    private Map<NetNode, Set<NetNode>> l2s_ = new HashMap<NetNode, Set<NetNode>>();
    private Map<NetNode, Integer> inDegs_ = new HashMap<NetNode, Integer>();
    private Map<NetNode, Integer> outDegs_ = new HashMap<NetNode, Integer>();
    private ArrayList<NetNode> placeList_ = new ArrayList();
    private HashMap<NetNode, Integer> nameToRow_ = new HashMap();
    private boolean pointUp_;

    public HierDAGLayout(boolean pointUp) {
        this.pointUp_ = pointUp;
    }

    @Override
    public boolean criteriaMet(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        LoopReporter lr = new LoopReporter(rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.hDagLayoutCriteriaCheck");
        for (NetLink aLink : rbd.getLinks()) {
            lr.report();
            if (aLink.isDirected()) continue;
            throw new LayoutCriterionFailureException();
        }
        lr.finish();
        CycleFinder cf = new CycleFinder(rbd.getAllNodes(), rbd.getLinks(), monitor);
        if (cf.hasACycle(monitor)) {
            throw new LayoutCriterionFailureException();
        }
        return true;
    }

    @Override
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<NetNode> targets = this.orderByNodeDegree(rbd, monitor);
        this.installNodeOrder(targets, rbd, monitor);
        return targets;
    }

    private List<NetNode> orderByNodeDegree(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<NetNode> nodesToGo = new HashSet<NetNode>(rbd.getAllNodes());
        this.linksToSources(rbd.getAllNodes(), rbd.getLinks(), monitor);
        List<NetNode> placeList = this.extractRoots(monitor);
        AnnotationSet nAnnots = PluginSupportFactory.buildAnnotationSet();
        Annot annot = PluginSupportFactory.buildAnnotation("Level 0", 0, placeList.size() - 1, 0, null);
        nAnnots.addAnnot(annot);
        this.addToPlaceList(placeList);
        nodesToGo.removeAll(placeList);
        LoopReporter lr = new LoopReporter(nodesToGo.size(), 20, monitor, 0.0, 1.0, "progress.findingCandidates");
        int count = 1;
        while (!nodesToGo.isEmpty()) {
            List<NetNode> nextBatch = this.findNextCandidates();
            lr.report(nextBatch.size());
            int start = this.placeList_.size();
            this.addToPlaceList(nextBatch);
            annot = PluginSupportFactory.buildAnnotation("Level " + count++, start, this.placeList_.size() - 1, 0, null);
            nAnnots.addAnnot(annot);
            for (NetNode nbNod : nextBatch) {
                if (!nodesToGo.contains(nbNod)) continue;
                nodesToGo.remove(nbNod);
            }
        }
        lr.finish();
        rbd.setNodeAnnotations(nAnnots);
        return this.placeList_;
    }

    private void linksToSources(Set<NetNode> nodeList, Set<NetLink> linkList, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(nodeList.size(), 20, monitor, 0.0, 1.0, "progress.hDagLayoutInit");
        for (NetNode node : nodeList) {
            lr.report();
            this.l2s_.put(node, new HashSet());
            this.inDegs_.put(node, 0);
            this.outDegs_.put(node, 0);
        }
        LoopReporter lr2 = new LoopReporter(linkList.size(), 20, monitor, 0.0, 1.0, "progress.hDagDegAndTargs");
        for (NetLink link : linkList) {
            lr2.report();
            NetNode src = this.pointUp_ ? link.getSrcNode() : link.getTrgNode();
            NetNode trg = this.pointUp_ ? link.getTrgNode() : link.getSrcNode();
            Set<NetNode> toTarg = this.l2s_.get(src);
            toTarg.add(trg);
            Integer deg = this.outDegs_.get(src);
            this.outDegs_.put(src, deg + 1);
            deg = this.inDegs_.get(trg);
            this.inDegs_.put(trg, deg + 1);
        }
    }

    private void addToPlaceList(List<NetNode> nextBatch) {
        int nextRow = this.placeList_.size();
        for (NetNode nextNode : nextBatch) {
            this.placeList_.add(nextNode);
            this.nameToRow_.put(nextNode, nextRow++);
        }
    }

    private List<NetNode> extractRoots(BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(this.l2s_.size(), 20, monitor, 0.0, 1.0, "progress.rootExtractPass1");
        HashMap<NetNode, Integer> roots = new HashMap<NetNode, Integer>();
        for (NetNode node : this.l2s_.keySet()) {
            lr.report();
            Set<NetNode> fn = this.l2s_.get(node);
            if (!fn.isEmpty()) continue;
            roots.put(node, 0);
        }
        lr.finish();
        LoopReporter lr2 = new LoopReporter(this.l2s_.size(), 20, monitor, 0.0, 1.0, "progress.rootExtractPass2");
        for (NetNode node : this.l2s_.keySet()) {
            lr2.report();
            Set<NetNode> fn = this.l2s_.get(node);
            for (NetNode trg : fn) {
                Integer rs = (Integer)roots.get(trg);
                if (rs == null) continue;
                roots.put(trg, rs + 1);
            }
        }
        lr2.finish();
        ArrayList<NetNode> buildList = new ArrayList<NetNode>();
        LoopReporter lr3 = new LoopReporter(roots.size(), 20, monitor, 0.0, 1.0, "progress.rootExtractPass3");
        int count = 1;
        TreeSet alpha = new TreeSet(Collections.reverseOrder());
        alpha.addAll(roots.keySet());
        while (buildList.size() < roots.size()) {
            for (NetNode node : alpha) {
                Integer val = (Integer)roots.get(node);
                if (val != count) continue;
                buildList.add(node);
                lr3.report();
            }
            ++count;
        }
        lr3.finish();
        Collections.reverse(buildList);
        return buildList;
    }

    private List<NetNode> findNextCandidates() {
        HashSet<NetNode> quickie = new HashSet<NetNode>(this.placeList_);
        ArrayList<GraphSearcher.SourcedNode> nextOutList = new ArrayList<GraphSearcher.SourcedNode>();
        for (NetNode node : this.l2s_.keySet()) {
            if (quickie.contains(node)) continue;
            Set<NetNode> fn = this.l2s_.get(node);
            boolean allThere = true;
            for (NetNode trg : fn) {
                if (quickie.contains(trg)) continue;
                allThere = false;
                break;
            }
            if (!allThere) continue;
            nextOutList.add(new GraphSearcher.SourcedNode(node, this.inDegs_, this.nameToRow_, this.l2s_));
        }
        TreeSet nextOut = new TreeSet(Collections.reverseOrder());
        nextOut.addAll(nextOutList);
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        for (GraphSearcher.SourcedNode sn : nextOut) {
            retval.add(sn.getNode());
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgeLayout
    extends DefaultEdgeLayout {
        @Override
        public void layoutEdges(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
            SortedMap<Integer, NetLink> retval = this.layoutEdges(rbd.getNodeOrder(), rbd.getLinks(), rbd.getGroupOrder(), rbd.getGroupOrderMode(), monitor);
            rbd.setLinkOrder(retval);
            this.installLinkAnnotations(rbd, monitor);
        }

        @Override
        protected void installLinkAnnotations(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
            SortedMap<Integer, NetLink> lo = rbd.getLinkOrder();
            LoopReporter lr = new LoopReporter(lo.size(), 20, monitor, 0.0, 1.0, "progress.linkAnnotationPrep");
            ArrayList<NetLink> linkList = new ArrayList<NetLink>();
            for (NetLink link : lo.values()) {
                linkList.add(link);
                lr.report();
            }
            lr.finish();
            Map<NetNode, Integer> no = rbd.getNodeOrder();
            LoopReporter lr2 = new LoopReporter(no.size(), 20, monitor, 0.0, 1.0, "progress.nodeOrderInvert");
            HashMap<Integer, NetNode> invNo = new HashMap<Integer, NetNode>();
            for (NetNode node : no.keySet()) {
                invNo.put(no.get(node), node);
                lr2.report();
            }
            lr2.finish();
            AnnotationSet withShdwAnnots = this.calcLevelLinkAnnots(rbd, linkList, monitor, invNo, rbd.getNodeAnnotations());
            HashMap<Boolean, AnnotationSet> linkAnnots = new HashMap<Boolean, AnnotationSet>();
            linkAnnots.put(true, withShdwAnnots);
            linkAnnots.put(false, PluginSupportFactory.buildAnnotationSet());
            rbd.setLinkAnnotations(linkAnnots);
        }

        protected AnnotationSet calcLevelLinkAnnots(BuildData rbd, List<NetLink> links, BTProgressMonitor monitor, Map<Integer, NetNode> nodeOrder, AnnotationSet nodeAnnot) throws AsynchExitRequestException {
            LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, "progress.linkAnnotationShad");
            HashMap colorMap = new HashMap();
            AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
            boolean first = true;
            int startPos = 0;
            int numLink = links.size();
            int annotCount = 0;
            block0: for (Annot currAnnot : nodeAnnot) {
                if (first) {
                    first = false;
                    continue;
                }
                MinMax mm = currAnnot.getRange();
                NetNode start = nodeOrder.get(mm.min);
                for (int i = 0; i < numLink; ++i) {
                    NetLink link = links.get(i);
                    NetNode src = link.getSrcNode();
                    if (!link.getAugRelation().isShadow || !src.equals(start)) continue;
                    retval.addAnnot(PluginSupportFactory.buildAnnotation("Level " + annotCount++, startPos, i - 1, 0, null));
                    startPos = i;
                    continue block0;
                }
            }
            retval.addAnnot(PluginSupportFactory.buildAnnotation("Level " + annotCount, startPos, numLink - 1, 0, null));
            return retval;
        }
    }
}

