/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.layouts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.systemsbiology.biofabric.analysis.CycleFinder;
import org.systemsbiology.biofabric.analysis.GraphSearcher;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.TrueObjChoiceContent;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTopLayout
extends NodeLayout {
    private CtrlMode ctrlMode_;
    private TargMode targMode_;
    private List<String> fixedOrder_;
    private Map<String, Set<NetNode>> normNameToIDs_;
    private Set<NetNode> ctrlNodes_;

    public ControlTopLayout(CtrlMode cMode, TargMode tMode, List<String> fixedOrder, Map<String, Set<NetNode>> normNameToIDs) {
        this.ctrlMode_ = cMode;
        this.targMode_ = tMode;
        this.fixedOrder_ = fixedOrder;
        this.normNameToIDs_ = normNameToIDs;
        this.ctrlNodes_ = null;
    }

    @Override
    public boolean criteriaMet(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        Set<NetLink> links = rbd.getLinks();
        LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, "progress.ControlTopLayoutCriteriaCheck1");
        for (NetLink link : links) {
            lr.report();
            if (link.isDirected()) continue;
            lr.finish();
            throw new LayoutCriterionFailureException();
        }
        lr.finish();
        this.ctrlNodes_ = this.controlNodes(rbd.getAllNodes(), rbd.getLinks(), monitor);
        if (this.ctrlNodes_ == null || this.ctrlNodes_.isEmpty()) {
            throw new LayoutCriterionFailureException();
        }
        if (this.fixedOrder_ != null && this.normNameToIDs_ == null) {
            throw new LayoutCriterionFailureException();
        }
        if (this.fixedOrder_ != null) {
            HashSet<NetNode> checkSet = new HashSet<NetNode>(this.ctrlNodes_);
            LoopReporter lr2 = new LoopReporter(this.fixedOrder_.size(), 20, monitor, 0.0, 1.0, "progress.ControlTopLayoutCriteriaCheck2");
            for (String name : this.fixedOrder_) {
                lr2.report();
                Set<NetNode> matches = this.normNameToIDs_.get(DataUtil.normKey(name));
                if (matches == null || matches.size() != 1) {
                    throw new LayoutCriterionFailureException();
                }
                NetNode match = matches.iterator().next();
                if (!checkSet.contains(match)) {
                    throw new LayoutCriterionFailureException();
                }
                checkSet.remove(match);
            }
            lr2.finish();
            if (!checkSet.isEmpty()) {
                throw new LayoutCriterionFailureException();
            }
        }
        return true;
    }

    @Override
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<NetNode> nodeOrder;
        List<NetNode> ctrlList;
        if (this.ctrlNodes_ == null) {
            this.ctrlNodes_ = this.controlNodes(rbd.getAllNodes(), rbd.getLinks(), monitor);
        }
        TreeSet<NetNode> cnSet = new TreeSet<NetNode>(this.ctrlNodes_);
        List<NetNode> dfo = null;
        switch (this.ctrlMode_) {
            case CTRL_PARTIAL_ORDER: {
                dfo = this.allNodeOrder(rbd.getAllNodes(), rbd.getLinks(), false, monitor);
                ctrlList = this.controlSortPartialOrder(rbd.getAllNodes(), rbd.getLinks(), cnSet, dfo, false, monitor);
                break;
            }
            case CTRL_INTRA_DEGREE_ONLY: {
                ctrlList = this.controlSortIntraDegreeOnly(rbd.getAllNodes(), rbd.getLinks(), cnSet, false, monitor);
                break;
            }
            case CTRL_DEGREE_ONLY: {
                dfo = this.allNodeOrder(rbd.getAllNodes(), rbd.getLinks(), false, monitor);
                ctrlList = this.listToSublist(cnSet, dfo, monitor);
                break;
            }
            case CTRL_MEDIAN_TARGET_DEGREE: {
                ctrlList = this.orderCtrlMedianTargetDegree(rbd.getAllNodes(), rbd.getLinks(), false, monitor);
                break;
            }
            case FIXED_LIST: {
                ctrlList = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (this.targMode_) {
            case GRAY_CODE: {
                nodeOrder = this.targetsBySourceGrayCode(ctrlList, cnSet, rbd.getAllNodes(), rbd.getLinks(), monitor);
                break;
            }
            case NODE_DEGREE_ODOMETER_SOURCE: {
                nodeOrder = this.targetsByNodeDegreeOdometerSourceMultigraph(ctrlList, cnSet, rbd.getAllNodes(), rbd.getLinks(), monitor);
                break;
            }
            case TARGET_DEGREE: {
                if (dfo == null) {
                    dfo = this.allNodeOrder(rbd.getAllNodes(), rbd.getLinks(), false, monitor);
                }
                HashSet<NetNode> targs = new HashSet<NetNode>(rbd.getAllNodes());
                targs.removeAll(cnSet);
                nodeOrder = new ArrayList<NetNode>(ctrlList);
                nodeOrder.addAll(this.listToSublist(targs, dfo, monitor));
                break;
            }
            case BREADTH_ORDER: {
                nodeOrder = this.orderTargetsBreadth(ctrlList, cnSet, rbd.getAllNodes(), rbd.getLinks(), false, monitor);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Set<NetNode> loneNodes = rbd.getSingletonNodes();
        if (loneNodes != null && !loneNodes.isEmpty()) {
            TreeSet<NetNode> orderedLones = new TreeSet<NetNode>(loneNodes);
            nodeOrder.addAll(orderedLones);
        }
        this.installNodeOrder(nodeOrder, rbd, monitor);
        return nodeOrder;
    }

    private Set<NetNode> controlNodes(Set<NetNode> nodes, Set<NetLink> links, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, "progress.findControlNodes");
        HashSet<NetNode> srcs = new HashSet<NetNode>();
        for (NetLink nextLink : links) {
            lr.report();
            srcs.add(nextLink.getSrcNode());
        }
        lr.finish();
        return srcs;
    }

    private List<NetNode> controlSortPartialOrder(Set<NetNode> nodes, Set<NetLink> links, SortedSet<NetNode> cnSet, List<NetNode> dfo, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<NetLink> ctrlLinks = new HashSet<NetLink>();
        for (NetLink nextLink : links) {
            if (!cnSet.contains(nextLink.getTrgNode())) continue;
            ctrlLinks.add(nextLink);
        }
        List<NetNode> ctrlNodes = this.listToSublist(cnSet, dfo, monitor);
        HashMap<NetNode, Integer> nodeToRow = new HashMap<NetNode, Integer>();
        int numNodes = ctrlNodes.size();
        for (int i = 0; i < numNodes; ++i) {
            NetNode ctrlNode = ctrlNodes.get(i);
            nodeToRow.put(ctrlNode, i);
        }
        HashSet<NetLink> downLinks = new HashSet<NetLink>();
        HashSet<NetLink> upLinks = new HashSet<NetLink>();
        HashSet<NetLink> autoFeedLinks = new HashSet<NetLink>();
        for (NetLink ctrlLink : ctrlLinks) {
            int trgRow;
            if (ctrlLink.isShadow()) continue;
            NetNode srcID = ctrlLink.getSrcNode();
            NetNode trgID = ctrlLink.getTrgNode();
            int srcRow = nodeToRow.get(srcID);
            if (srcRow < (trgRow = nodeToRow.get(trgID).intValue())) {
                downLinks.add(ctrlLink);
                continue;
            }
            if (srcRow > trgRow) {
                upLinks.add(ctrlLink);
                continue;
            }
            autoFeedLinks.add(ctrlLink);
        }
        DefaultEdgeLayout.DefaultFabricLinkLocater dfll = new DefaultEdgeLayout.DefaultFabricLinkLocater(nodeToRow, null, null, Network.LayoutMode.UNINITIALIZED_MODE);
        TreeSet<NetLink> upLinkOrder = new TreeSet<NetLink>(dfll);
        upLinkOrder.addAll(upLinks);
        HashSet<NetLink> dagLinks = new HashSet<NetLink>(downLinks);
        HashSet<NetLink> testLinks = new HashSet<NetLink>(dagLinks);
        HashSet<NetLink> heldOut = new HashSet<NetLink>(dagLinks);
        for (NetLink testLink : upLinkOrder) {
            testLinks.add(testLink);
            CycleFinder cf = new CycleFinder(nodes, testLinks, monitor);
            if (!cf.hasACycle(monitor)) {
                dagLinks.add(testLink);
                continue;
            }
            testLinks.remove(testLink);
            heldOut.add(testLink);
        }
        UiUtil.fixMePrintout("NO! Still arbitrary? (HashSet iteration??)");
        GraphSearcher gs = new GraphSearcher(new HashSet<NetNode>(ctrlNodes), dagLinks);
        Map<NetNode, Integer> ts = gs.topoSort(false);
        List<NetNode> retval = gs.topoSortToPartialOrdering(ts, links, relCollapse, monitor);
        TreeSet<NetNode> remaining = new TreeSet<NetNode>(ctrlNodes);
        remaining.removeAll(retval);
        retval.addAll(remaining);
        return retval;
    }

    private List<NetNode> allNodeOrder(Set<NetNode> nodes, Set<NetLink> links, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        GraphSearcher gs = new GraphSearcher(nodes, links);
        List<NetNode> retval = gs.nodeDegreeOrder(relCollapse, monitor);
        Collections.reverse(retval);
        return retval;
    }

    private List<NetNode> controlSortIntraDegreeOnly(Set<NetNode> nodes, Set<NetLink> links, SortedSet<NetNode> ctrlNodes, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<NetLink> ctrlLinks = new HashSet<NetLink>();
        for (NetLink nextLink : links) {
            if (!ctrlNodes.contains(nextLink.getTrgNode())) continue;
            ctrlLinks.add(nextLink);
        }
        GraphSearcher gs = new GraphSearcher(ctrlNodes, ctrlLinks);
        List<NetNode> retval = gs.nodeDegreeOrder(relCollapse, monitor);
        ctrlNodes.removeAll(retval);
        retval.addAll(ctrlNodes);
        Collections.reverse(retval);
        return retval;
    }

    private List<NetNode> orderTargetsBreadth(List<NetNode> ctrlList, Set<NetNode> cnSet, Set<NetNode> nodes, Set<NetLink> links, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        GraphSearcher gs = new GraphSearcher(nodes, links);
        List<GraphSearcher.QueueEntry> queue = gs.breadthSearch(ctrlList, relCollapse, monitor);
        ArrayList<NetNode> outList = new ArrayList<NetNode>(ctrlList);
        for (GraphSearcher.QueueEntry qe : queue) {
            if (cnSet.contains(qe.name)) continue;
            outList.add(qe.name);
        }
        return outList;
    }

    private List<NetNode> targetsBySourceGrayCode(List<NetNode> ctrlList, Set<NetNode> cnSet, Set<NetNode> nodes, Set<NetLink> links, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> outList = new ArrayList<NetNode>(ctrlList);
        GraphSearcher gs = new GraphSearcher(nodes, links);
        SortedSet<GraphSearcher.SourcedNodeGray> sngr = gs.nodeGraySetWithSource(ctrlList);
        for (GraphSearcher.SourcedNodeGray node : sngr) {
            if (cnSet.contains(node.getNodeID())) continue;
            outList.add(node.getNodeID());
        }
        return outList;
    }

    private List<NetNode> targetsByNodeDegreeOdometerSource(List<NetNode> ctrlList, Set<NetNode> cnSet, Set<NetNode> nodes, Set<NetLink> links, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> outList = new ArrayList<NetNode>(ctrlList);
        GraphSearcher gs = new GraphSearcher(nodes, links);
        SortedSet<GraphSearcher.SourcedNodeDegree> snds = gs.nodeDegreeSetWithSource(ctrlList);
        for (GraphSearcher.SourcedNodeDegree node : snds) {
            if (cnSet.contains(node.getNode())) continue;
            outList.add(node.getNode());
        }
        return outList;
    }

    private List<NetNode> targetsByNodeDegreeOdometerSourceMultigraph(List<NetNode> ctrlList, Set<NetNode> cnSet, Set<NetNode> nodes, Set<NetLink> links, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> outList = new ArrayList<NetNode>(ctrlList);
        GraphSearcher gs = new GraphSearcher(nodes, links);
        SortedSet<GraphSearcher.SourcedNodeAndRelDegree> snds = gs.nodeDegreeSetWithSourceMultigraph(ctrlList);
        for (GraphSearcher.SourcedNodeAndRelDegree nodeAndRel : snds) {
            if (cnSet.contains(nodeAndRel.getNode())) continue;
            outList.add(nodeAndRel.getNode());
        }
        return outList;
    }

    private List<NetNode> listToSublist(Set<NetNode> nodeSet, List<NetNode> dfo, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> outList = new ArrayList<NetNode>();
        for (NetNode node : dfo) {
            if (!nodeSet.contains(node)) continue;
            outList.add(node);
        }
        return outList;
    }

    private List<NetNode> orderCtrlMedianTargetDegree(Set<NetNode> nodes, Set<NetLink> links, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> outList = new ArrayList<NetNode>();
        SortedSet<GraphSearcher.NodeDegree> ctrlMed = this.medianTargetDegree(nodes, links, relCollapse, monitor);
        for (GraphSearcher.NodeDegree nodeDeg : ctrlMed) {
            outList.add(nodeDeg.getNodeID());
        }
        Collections.reverse(outList);
        return outList;
    }

    private SortedSet<GraphSearcher.NodeDegree> medianTargetDegree(Set<NetNode> nodes, Set<NetLink> links, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        GraphSearcher gs = new GraphSearcher(nodes, links);
        Map<NetNode, Integer> nDeg = gs.nodeDegree(true, relCollapse, monitor);
        HashMap<NetNode, ArrayList<Integer>> deg = new HashMap<NetNode, ArrayList<Integer>>();
        for (NetLink nextLink : links) {
            NetNode src = nextLink.getSrcNode();
            NetNode trg = nextLink.getTrgNode();
            Integer trgDeg = nDeg.get(trg);
            ArrayList<Integer> forSrc = (ArrayList<Integer>)deg.get(src);
            if (forSrc == null) {
                forSrc = new ArrayList<Integer>();
                deg.put(src, forSrc);
            }
            forSrc.add(trgDeg);
        }
        TreeSet<GraphSearcher.NodeDegree> retval = new TreeSet<GraphSearcher.NodeDegree>();
        for (NetNode src : deg.keySet()) {
            List forSrc = (List)deg.get(src);
            Collections.sort(forSrc);
            int size = forSrc.size();
            int medI = size / 2;
            Integer med = (Integer)forSrc.get(medI);
            retval.add(new GraphSearcher.NodeDegree(src, med));
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargMode {
        TARGET_DEGREE("ctrlTop.trgTargDegree"),
        NODE_DEGREE_ODOMETER_SOURCE("ctrlTop.degreeOdometer"),
        GRAY_CODE("ctrlTop.trgGrayCode"),
        BREADTH_ORDER("ctrlTop.trgBreadth");

        private String resource_;

        private TargMode(String resource) {
            this.resource_ = resource;
        }

        public static Vector<TrueObjChoiceContent<TargMode>> getTargChoices() {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<TrueObjChoiceContent<TargMode>> retval = new Vector<TrueObjChoiceContent<TargMode>>();
            for (TargMode tm : TargMode.values()) {
                retval.add(new TrueObjChoiceContent<TargMode>(rMan.getString(tm.resource_), tm));
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CtrlMode {
        CTRL_PARTIAL_ORDER("ctrlTop.ctrlPartialOrder"),
        CTRL_INTRA_DEGREE_ONLY("ctrlTop.ctrlIntraDegree"),
        CTRL_MEDIAN_TARGET_DEGREE("ctrlTop.ctrlMedianTarg"),
        CTRL_DEGREE_ONLY("ctrlTop.ctrlDegreeOnly"),
        FIXED_LIST("ctrlTop.ctrlInputList");

        private String resource_;

        private CtrlMode(String resource) {
            this.resource_ = resource;
        }

        public static Vector<TrueObjChoiceContent<CtrlMode>> getControlChoices() {
            ResourceManager rMan = ResourceManager.getManager();
            Vector<TrueObjChoiceContent<CtrlMode>> retval = new Vector<TrueObjChoiceContent<CtrlMode>>();
            for (CtrlMode cm : CtrlMode.values()) {
                retval.add(new TrueObjChoiceContent<CtrlMode>(rMan.getString(cm.resource_), cm));
            }
            return retval;
        }
    }
}

