/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.io.FabricImportLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIFImportLoader
extends FabricImportLoader {
    @Override
    protected String[] lineToToks(String line, FabricImportLoader.FileImportStats stats) throws IOException {
        if (line.trim().equals("")) {
            return null;
        }
        String[] tokens = line.split("\\t");
        if (tokens.length == 1 && line.indexOf("\\t") == -1) {
            tokens = line.split(" ");
        }
        if (tokens.length == 0) {
            return null;
        }
        if (tokens.length == 2 || tokens.length > 3) {
            stats.badLines.add(line);
            return null;
        }
        return tokens;
    }

    @Override
    protected void consumeTokens(String[] tokens, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, Integer magBins, Map<String, NetNode> nameToID, FabricImportLoader.FileImportStats stats) throws IOException {
        if (tokens.length == 3) {
            String source = tokens[0].trim();
            source = this.stripQuotes(source);
            String target = tokens[2].trim();
            target = this.stripQuotes(target);
            source = this.mapName(source, nameMap);
            target = this.mapName(target, nameMap);
            NetNode srcID = this.nameToNode(source, idGen, nameToID);
            NetNode trgID = this.nameToNode(target, idGen, nameToID);
            String rel = tokens[1].trim();
            rel = this.stripQuotes(rel);
            this.buildLinkAndShadow(srcID, trgID, rel, links);
        } else {
            String loner = tokens[0].trim();
            loner = this.stripQuotes(loner);
            loner = this.mapName(loner, nameMap);
            NetNode lonerID = this.nameToNode(loner, idGen, nameToID);
            loneNodeIDs.add(lonerID);
        }
    }
}

