/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.io.FabricImportLoader;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.ui.dialogs.LinkRelationDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWImportLoader
extends FabricImportLoader {
    private static final String DEFAULT_RELATION = "default";
    private static final int HEADER_LINES = 4;
    private int lineToTokIndex_ = 0;
    private int consTokIndex_ = 0;
    private Integer numNodes_;
    private Integer numEdges_;
    private Map<Integer, String> indexToName_ = new HashMap<Integer, String>();
    private Map<Integer, Boolean> indexUsed_ = new HashMap<Integer, Boolean>();

    @Override
    protected String[] lineToToks(String line, FabricImportLoader.FileImportStats stats) throws IOException {
        if (line.trim().equals("")) {
            return null;
        }
        String[] tokens = line.split("\\t");
        if (tokens.length == 1 && line.indexOf("\\t") == -1) {
            tokens = line.split(" ");
        }
        if (tokens.length == 0 || tokens.length == 2 || tokens.length == 3 || tokens.length > 4) {
            stats.badLines.add(line);
            return null;
        }
        if (this.lineToTokIndex_ == 4) {
            try {
                this.numNodes_ = Integer.parseInt(tokens[0].trim());
            }
            catch (NumberFormatException ex) {
                throw new IOException("We assume 4 header lines");
            }
        }
        if (this.numNodes_ != null && this.lineToTokIndex_ == 4 + this.numNodes_ + 1) {
            try {
                this.numEdges_ = Integer.parseInt(tokens[0].trim());
            }
            catch (NumberFormatException ex) {
                throw new IOException("We assume 4 header lines");
            }
        }
        ++this.lineToTokIndex_;
        return tokens;
    }

    @Override
    protected void consumeTokens(String[] tokens, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, Integer magBins, Map<String, NetNode> nameToID, FabricImportLoader.FileImportStats stats) throws IOException {
        if (tokens.length == 1) {
            if (this.consTokIndex_ > 4 && this.consTokIndex_ != 4 + this.numNodes_ + 1) {
                int index = this.consTokIndex_ - 4;
                String nodeName = tokens[0].trim();
                nodeName = this.stripBrackets(nodeName);
                this.indexToName_.put(index, nodeName);
                this.indexUsed_.put(index, false);
            }
        } else if (tokens.length == 4) {
            int targetIndex;
            int sourceIndex;
            String sourceIndexStr = tokens[0].trim();
            String targetIndexStr = tokens[1].trim();
            String edgeRelation = tokens[3].trim();
            try {
                sourceIndex = Integer.parseInt(sourceIndexStr);
                targetIndex = Integer.parseInt(targetIndexStr);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Could not parse integer");
            }
            this.indexUsed_.put(sourceIndex, true);
            this.indexUsed_.put(targetIndex, true);
            String sourceName = this.indexToName_.get(sourceIndex);
            String targetName = this.indexToName_.get(targetIndex);
            sourceName = this.stripBrackets(sourceName);
            targetName = this.stripBrackets(targetName);
            NetNode srcID = this.nameToNode(sourceName, idGen, nameToID);
            NetNode trgID = this.nameToNode(targetName, idGen, nameToID);
            edgeRelation = this.stripBrackets(edgeRelation);
            if (edgeRelation.equals("")) {
                edgeRelation = DEFAULT_RELATION;
            }
            this.buildLinkAndShadow(srcID, trgID, edgeRelation, links);
        } else {
            throw new IllegalArgumentException();
        }
        ++this.consTokIndex_;
        if (this.consTokIndex_ == 4 + this.numNodes_ + 1 + this.numEdges_ + 1) {
            this.addLoneNodes(idGen, loneNodeIDs, nameToID);
        }
    }

    private void addLoneNodes(UniqueLabeller idGen, Set<NetNode> loneNodeIDs, Map<String, NetNode> nameToID) {
        for (Map.Entry<Integer, Boolean> entry : this.indexUsed_.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            String loner = this.indexToName_.get(entry.getKey());
            NetNode lonerID = this.nameToNode(loner, idGen, nameToID);
            loneNodeIDs.add(lonerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGWFile(File file) {
        BufferedReader in = null;
        try {
            boolean i;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = in.readLine();
            if (line.equals("LEDA.GRAPH")) {
                boolean bl = true;
                return bl;
            }
            for (i = true; i < 4 != 0; i += 1) {
                in.readLine();
            }
            line = in.readLine();
            if (line == null) {
                i = false;
                return i;
            }
            String[] tok = line.split(" ");
            if (tok.length != 1) {
                boolean bl = false;
                return bl;
            }
            int numNodes = Integer.parseInt(tok[0]);
            if (numNodes > 0) {
                String aNode = in.readLine();
                int len = aNode.length();
                if (len < 4) {
                    boolean bl = false;
                    return bl;
                }
                if (!aNode.substring(0, 2).equals("|{")) return false;
                if (!aNode.substring(len - 2, len).equals("}|")) return false;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        catch (NumberFormatException nfe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GWRelationManager {
        public boolean process(List<NetLink> links, JFrame parent, BTProgressMonitor monitor) throws AsynchExitRequestException {
            LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 0.3, "progress.processingLinkRelations");
            ArrayList<NetLink> linksToChange = new ArrayList<NetLink>();
            ArrayList<NetLink> returnLinks = new ArrayList<NetLink>();
            for (NetLink link : links) {
                lr.report();
                if (link.getRelation().equals(GWImportLoader.DEFAULT_RELATION)) {
                    linksToChange.add(link);
                    continue;
                }
                returnLinks.add(link);
            }
            lr.finish();
            if (linksToChange.isEmpty()) {
                return true;
            }
            LinkRelationDialog dialog = new LinkRelationDialog(parent, GWImportLoader.DEFAULT_RELATION);
            dialog.setVisible(true);
            if (!dialog.haveResult()) {
                return false;
            }
            String newRel = dialog.getRelation();
            if (newRel.equals(GWImportLoader.DEFAULT_RELATION)) {
                return true;
            }
            lr = new LoopReporter(linksToChange.size(), 20, monitor, 0.3, 0.6, "progress.changingLinkRelations");
            for (NetLink link : linksToChange) {
                lr.report();
                FabricLink newLink = new FabricLink(link.getSrcNode(), link.getTrgNode(), newRel, link.isShadow());
                returnLinks.add(newLink);
            }
            lr.finish();
            if (links.size() != returnLinks.size()) {
                throw new IllegalStateException("Return links different size in GWRelationManager");
            }
            lr = new LoopReporter(returnLinks.size(), 20, monitor, 0.6, 1.0, "progress.addingNewLinks");
            links.clear();
            for (NetLink link : returnLinks) {
                lr.report();
                links.add(link);
            }
            lr.finish();
            return true;
        }
    }
}

