/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.io.BuildExtractor;
import org.systemsbiology.biofabric.api.io.FileLoadFlows;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.layout.EdgeLayout;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.parser.ParserClient;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BFWorker;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.BackgroundCore;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerControlManager;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerOwner;
import org.systemsbiology.biofabric.app.BioFabricWindow;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.cmd.HeadlessOracle;
import org.systemsbiology.biofabric.io.AnnotationLoader;
import org.systemsbiology.biofabric.io.AttributeLoader;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.io.FabricFactory;
import org.systemsbiology.biofabric.io.FabricImportLoader;
import org.systemsbiology.biofabric.io.GWImportLoader;
import org.systemsbiology.biofabric.io.SIFImportLoader;
import org.systemsbiology.biofabric.layouts.ControlTopLayout;
import org.systemsbiology.biofabric.layouts.NodeClusterLayout;
import org.systemsbiology.biofabric.layouts.NodeSimilarityLayout;
import org.systemsbiology.biofabric.layouts.SetLayout;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.parser.ProgressFilterInputStream;
import org.systemsbiology.biofabric.parser.SUParser;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInData;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.plugin.PlugInNetworkModelAPI;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.dialogs.RelationDirectionDialog;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.ui.render.BufferBuilder;
import org.systemsbiology.biofabric.util.FileExtensionFilters;
import org.systemsbiology.biofabric.util.GarbageRequester;
import org.systemsbiology.biofabric.util.InvalidInputException;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;
import org.systemsbiology.biotapestry.biofabric.FabricCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoadFlowsImpl
implements FileLoadFlows {
    public static final int LINK_COUNT_FOR_BACKGROUND_WRITE = 5000;
    public static final int FILE_LENGTH_FOR_BACKGROUND_FILE_READ = 500000;
    public static final int SIZE_TO_ASK_ABOUT_SHADOWS = 100000;
    public static final int XML_SIZE_FOR_BACKGROUND_READ = 1000000;
    public static final boolean FILE_MUST_EXIST_DONT_CARE = false;
    public static final boolean FILE_MUST_EXIST = true;
    public static final boolean FILE_CAN_CREATE_DONT_CARE = false;
    public static final boolean FILE_CAN_CREATE = true;
    public static final boolean FILE_DONT_CHECK_OVERWRITE = false;
    public static final boolean FILE_CHECK_OVERWRITE = true;
    public static final boolean FILE_MUST_BE_FILE = false;
    public static final boolean FILE_MUST_BE_DIRECTORY = true;
    public static final boolean FILE_CAN_WRITE_DONT_CARE = false;
    public static final boolean FILE_CAN_WRITE = true;
    public static final boolean FILE_CAN_READ_DONT_CARE = false;
    public static final boolean FILE_CAN_READ = true;
    private HeadlessOracle headlessOracle_;
    private JFrame topWindow_;
    private BioFabricWindow bfw_;
    private BioFabricPanel bfp_;
    private File currentFile_;
    private PlugInManager pMan_;
    private FabricColorGenerator colGen_;
    private CommandSet cSet_;
    private boolean isForMain_;

    public FileLoadFlowsImpl(BioFabricWindow bfw, PlugInManager pMan, FabricColorGenerator colGen, CommandSet cSet, HeadlessOracle headlessOracle, boolean isForMain) {
        this.bfw_ = bfw;
        this.pMan_ = pMan;
        this.topWindow_ = bfw.getWindow();
        this.headlessOracle_ = headlessOracle;
        this.colGen_ = colGen;
        this.cSet_ = cSet;
        this.isForMain_ = isForMain;
    }

    public void setFabricPanel(BioFabricPanel bfp) {
        this.bfp_ = bfp;
        if (this.isForMain_) {
            this.pMan_.installAPI(new PlugInInfo(this, this.bfp_.getNetwork(), this.bfw_));
        }
    }

    @Override
    public void buildNetworkForPlugIn(BuildData pluginData, File holdIt, PluginResourceManager rMan) {
        NetworkBuilder nb = new NetworkBuilder(true, holdIt, rMan);
        nb.setForPlugInBuild(pluginData);
        nb.doNetworkBuild();
    }

    public void doBasicRelayout(BuildDataImpl.BuildMode bMode) {
        new NetworkRelayout().doNetworkRelayout(this.bfp_.getNetwork(), bMode);
    }

    public void doDefaultRelayout(NodeLayout.Params params) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setParams(params);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.DEFAULT_LAYOUT);
    }

    public void doConnectivityRelayout(NodeSimilarityLayout.ClusterParams params) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setParams(params);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.CLUSTERED_LAYOUT);
    }

    public void doDisplayOptionChange() {
        File holdIt;
        try {
            holdIt = File.createTempFile("BioFabricHold", ".zip");
            holdIt.deleteOnExit();
        }
        catch (IOException ioex) {
            holdIt = null;
        }
        BioFabricNetwork bfn = this.bfp_.getNetwork();
        if (bfn != null) {
            NetworkBuilder nb = new NetworkBuilder(true, holdIt, null);
            nb.setForDisplayOptionChange(bfn, BuildDataImpl.BuildMode.SHADOW_LINK_CHANGE);
            nb.doNetworkBuild();
        }
    }

    public void doRecolor(boolean isForMain) {
        File holdIt;
        try {
            holdIt = File.createTempFile("BioFabricHold", ".zip");
            holdIt.deleteOnExit();
        }
        catch (IOException ioex) {
            holdIt = null;
        }
        NetworkRecolor nb = new NetworkRecolor();
        nb.doNetworkRecolor(isForMain, holdIt);
    }

    public void doShapeMatchRelayout(NodeSimilarityLayout.ResortParams params) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setParams(params);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.REORDER_LAYOUT);
    }

    public void doLinkGroupRelayout(BioFabricNetwork bfn, List<String> groupOrder, Network.LayoutMode mode, boolean showGroupLinkAnnotations, BuildDataImpl.BuildMode bmode) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setGroupOrderAndMode(groupOrder, mode, showGroupLinkAnnotations);
        nb.doNetworkRelayout(bfn, bmode);
    }

    public void doSetRelayout(SetLayout.LinkMeans linkMeaning) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setLinkMeaning(linkMeaning);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.SET_LAYOUT);
    }

    public void doHierDagRelayout(boolean pointUp) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setPointUp(pointUp);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.HIER_DAG_LAYOUT);
    }

    public void doControlTopRelayout(ControlTopLayout.CtrlMode cMode, ControlTopLayout.TargMode tMode, List<String> fixedList) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setControlTopModes(cMode, tMode, fixedList);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.CONTROL_TOP_LAYOUT);
    }

    public void doNetworkClusterRelayout(NodeClusterLayout.ClusterParams params) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setParams(params);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.NODE_CLUSTER_LAYOUT);
    }

    public void doNetworkLinkRelayout(SortedMap<Integer, NetLink> modifiedAndChecked) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setLinkOrder(modifiedAndChecked);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.LINK_ATTRIB_LAYOUT);
    }

    public void doNetworkRelayout(Map<AttributeKey, String> nodeAttributes) {
        NetworkRelayout nb = new NetworkRelayout();
        nb.setNodeOrderFromAttrib(nodeAttributes);
        nb.doNetworkRelayout(this.bfp_.getNetwork(), BuildDataImpl.BuildMode.NODE_ATTRIB_LAYOUT);
    }

    public void doBackgroundWrite(OutputStream stream) {
        BackgroundFileWriter bw = new BackgroundFileWriter();
        bw.doBackgroundWrite(stream);
    }

    @Override
    public void setCurrentXMLFile(File file) {
        this.currentFile_ = file;
        if (this.currentFile_ == null) {
            return;
        }
        FabricCommands.setPreference("LoadDirectory", file.getAbsoluteFile().getParent());
    }

    private boolean buildTheNetworkFomLinks(File file, UniqueLabeller idGen, Set<NetNode> loneNodeIDs, Set<NetLink> reducedLinks, File holdIt) {
        try {
            NetworkBuilder nb = new NetworkBuilder(true, holdIt, null);
            nb.setForSifBuild(idGen, reducedLinks, loneNodeIDs, BuildDataImpl.BuildMode.BUILD_FROM_SIF);
            if (this.headlessOracle_ == null) {
                nb.doNetworkBuild();
            } else {
                nb.doNetworkBuildForeground();
            }
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.getHandler().displayOutOfMemory(oom);
            return false;
        }
        this.currentFile_ = null;
        FabricCommands.setPreference("LoadDirectory", file.getAbsoluteFile().getParent());
        this.manageWindowTitle(file.getName());
        return true;
    }

    private void announceBadLines(FabricImportLoader.FileImportStats sss) {
        ResourceManager rMan = ResourceManager.getManager();
        if (!sss.badLines.isEmpty()) {
            String badLineFormat = rMan.getString("fabricRead.badLineFormat");
            String badLineMsg = MessageFormat.format(badLineFormat, sss.badLines.size());
            if (this.headlessOracle_ == null) {
                JOptionPane.showMessageDialog(this.topWindow_, badLineMsg, rMan.getString("fabricRead.badLineTitle"), 2);
            } else {
                this.headlessOracle_.displayErrorMessage(badLineMsg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleDirectionsDupsAndShadows(List<NetLink> links, Set<NetNode> loneNodeIDs, boolean binMag, SortedMap<AugRelation, Boolean> relaMap, Set<NetLink> reducedLinks, File holdIt, boolean doForceUndirected, boolean skipShadowQuestion) {
        ResourceManager rMan = ResourceManager.getManager();
        try {
            if (doForceUndirected) {
                relaMap = RelationDirectionDialog.forceAllUndirected(relaMap);
            } else if (this.headlessOracle_ == null) {
                RelationDirectionDialog rdd = new RelationDirectionDialog(this.topWindow_, relaMap);
                rdd.setVisible(true);
                if (!rdd.haveResult()) {
                    return false;
                }
                if (rdd.getFromFile()) {
                    File fileEda = this.getTheFile(".rda", ".txt", "AttribDirectory", "filterName.rda", null);
                    if (fileEda == null) {
                        return true;
                    }
                    Map<AttributeKey, String> relAttributes = this.loadTheFile(fileEda, null, true);
                    if (relAttributes == null) {
                        return true;
                    }
                    HashSet<AugRelation> needed = new HashSet<AugRelation>(relaMap.keySet());
                    boolean tooMany = false;
                    for (AttributeLoader.StringKey stringKey : relAttributes.keySet()) {
                        String key = stringKey.key;
                        String val = relAttributes.get(stringKey);
                        Boolean dirVal = Boolean.valueOf(val);
                        AugRelation forNorm = new AugRelation(key, false);
                        AugRelation forShad = new AugRelation(key, true);
                        boolean matched = false;
                        if (needed.contains(forNorm)) {
                            matched = true;
                            relaMap.put(forNorm, dirVal);
                            needed.remove(forNorm);
                        }
                        if (needed.contains(forShad)) {
                            matched = true;
                            relaMap.put(forShad, dirVal);
                            needed.remove(forShad);
                        }
                        if (matched) continue;
                        tooMany = true;
                        break;
                    }
                    if (!needed.isEmpty() || tooMany) {
                        JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("fabricRead.directionMapLoadFailure"), rMan.getString("fabricRead.directionMapLoadFailureTitle"), 0);
                        return false;
                    }
                } else {
                    relaMap = rdd.getRelationMap();
                }
            }
            HashSet<NetLink> culledLinks = new HashSet<NetLink>();
            if (this.headlessOracle_ == null) {
                boolean didFinish = this.backPreprocess(links, relaMap, reducedLinks, culledLinks, holdIt);
                if (!didFinish) {
                    return false;
                }
            } else {
                try {
                    this.preprocess(links, relaMap, reducedLinks, culledLinks, null);
                }
                catch (AsynchExitRequestException didFinish) {
                    // empty catch block
                }
            }
            if (!culledLinks.isEmpty()) {
                String dupLinkFormat = rMan.getString("fabricRead.dupLinkFormat");
                String dupLinkMsg = MessageFormat.format(dupLinkFormat, culledLinks.size() / 2);
                JOptionPane.showMessageDialog(this.topWindow_, dupLinkMsg, rMan.getString("fabricRead.dupLinkTitle"), 2);
            }
            if (!skipShadowQuestion && reducedLinks.size() > 100000) {
                String shadowMessage = rMan.getString("fabricRead.askAboutShadows");
                int doShadow = JOptionPane.showConfirmDialog(this.topWindow_, shadowMessage, rMan.getString("fabricRead.askAboutShadowsTitle"), 1);
                if (doShadow == 2) {
                    return false;
                }
                FabricDisplayOptions dops = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
                dops.setDisplayShadows(doShadow == 0);
            }
            if (!binMag) return true;
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.getHandler().displayOutOfMemory(oom);
            return false;
        }
        return true;
    }

    public boolean backPreprocess(List<NetLink> links, SortedMap<AugRelation, Boolean> relMap, Set<NetLink> reducedLinks, Set<NetLink> culledLinks, File holdIt) {
        PreprocessNetwork pn = new PreprocessNetwork();
        boolean didFinish = pn.doNetworkPreprocess(links, relMap, reducedLinks, culledLinks, holdIt);
        return didFinish;
    }

    @Override
    public FileLoadFlows.FileLoadResult loadFromASource(File file, Map<AttributeKey, String> nameMap, Integer magBins, UniqueLabeller idGen, FileLoadFlows.FileLoadType type, boolean skipShadowQuestion) {
        FabricImportLoader.FileImportStats sss;
        File holdIt;
        HashMap<String, String> nodeNames = null;
        if (nameMap != null) {
            nodeNames = new HashMap<String, String>();
            for (AttributeKey key : nameMap.keySet()) {
                nodeNames.put(((AttributeLoader.StringKey)key).key, nameMap.get(key));
            }
        }
        try {
            holdIt = File.createTempFile("BioFabricHold", ".zip");
            holdIt.deleteOnExit();
        }
        catch (IOException ioex) {
            holdIt = null;
        }
        ArrayList<NetLink> links = new ArrayList<NetLink>();
        HashSet<NetNode> loneNodes = new HashSet<NetNode>();
        TreeMap<AugRelation, Boolean> relMap = new TreeMap<AugRelation, Boolean>();
        HashSet<NetLink> reducedLinks = new HashSet<NetLink>();
        if (file.length() > 500000L && this.headlessOracle_ == null) {
            boolean finished;
            sss = new FabricImportLoader.FileImportStats();
            BackgroundFileReader br = new BackgroundFileReader();
            if (type == FileLoadFlows.FileLoadType.SIF) {
                finished = br.doBackgroundSIFRead(file, idGen, links, loneNodes, nodeNames, sss, magBins, relMap, holdIt);
            } else if (type == FileLoadFlows.FileLoadType.GW) {
                finished = br.doBackgroundGWRead(file, idGen, links, loneNodes, nodeNames, sss, true, magBins, relMap, holdIt);
            } else {
                throw new IllegalArgumentException("File type not identified");
            }
            if (!finished) {
                return new FileLoadResultImpl(true, holdIt);
            }
        } else {
            try {
                if (type == FileLoadFlows.FileLoadType.SIF) {
                    sss = new SIFImportLoader().importFabric(file, idGen, links, loneNodes, nodeNames, magBins, null);
                } else if (type == FileLoadFlows.FileLoadType.GW) {
                    sss = new GWImportLoader().importFabric(file, idGen, links, loneNodes, nodeNames, magBins, null);
                    boolean finished = new GWImportLoader.GWRelationManager().process(links, this.topWindow_, null);
                    if (!finished) {
                        return new FileLoadResultImpl(false, holdIt);
                    }
                } else {
                    throw new IllegalArgumentException("File type not identified");
                }
                PluginSupportFactory.getBuildExtractor().extractRelations(links, relMap, null);
            }
            catch (AsynchExitRequestException axex) {
                return new FileLoadResultImpl(false, holdIt);
            }
            catch (IOException ioe) {
                this.displayFileInputError(ioe);
                return new FileLoadResultImpl(false, holdIt);
            }
            catch (OutOfMemoryError oom) {
                ExceptionHandler.getHandler().displayOutOfMemory(oom);
                return new FileLoadResultImpl(false, holdIt);
            }
        }
        this.announceBadLines(sss);
        boolean finished = this.handleDirectionsDupsAndShadows(links, loneNodes, magBins != null, relMap, reducedLinks, holdIt, false, skipShadowQuestion);
        if (finished) {
            this.buildTheNetworkFomLinks(file, idGen, loneNodes, reducedLinks, holdIt);
        }
        return new FileLoadResultImpl(true, holdIt);
    }

    @Override
    public FileLoadFlows.FileLoadResult loadFromASource(File file, List<NetLink> links, Set<NetNode> loneNodes, Integer magBins, UniqueLabeller idGen, boolean loadOnly, FileLoadFlows.FileLoadType type, boolean skipShadowQuestion) {
        boolean finished;
        File holdIt;
        try {
            holdIt = File.createTempFile("BioFabricHold", ".zip");
            holdIt.deleteOnExit();
        }
        catch (IOException ioex) {
            holdIt = null;
        }
        HashSet<NetLink> reducedLinks = new HashSet<NetLink>();
        TreeMap<AugRelation, Boolean> relMap = new TreeMap<AugRelation, Boolean>();
        FabricImportLoader.FileImportStats sss = new FabricImportLoader.FileImportStats();
        BackgroundFileReader br = new BackgroundFileReader();
        if (type == FileLoadFlows.FileLoadType.SIF) {
            finished = br.doBackgroundSIFRead(file, idGen, links, loneNodes, null, sss, magBins, relMap, holdIt);
        } else if (type == FileLoadFlows.FileLoadType.GW) {
            finished = br.doBackgroundGWRead(file, idGen, links, loneNodes, null, sss, false, magBins, relMap, holdIt);
        } else {
            throw new IllegalArgumentException("File type not identified");
        }
        if (!finished) {
            return new FileLoadResultImpl(true, holdIt);
        }
        this.announceBadLines(sss);
        if (loadOnly) {
            return new FileLoadResultImpl(true, holdIt);
        }
        finished = this.handleDirectionsDupsAndShadows(links, loneNodes, magBins != null, relMap, reducedLinks, holdIt, false, skipShadowQuestion);
        if (finished) {
            this.buildTheNetworkFomLinks(file, idGen, loneNodes, reducedLinks, holdIt);
        }
        return new FileLoadResultImpl(true, holdIt);
    }

    private void preprocess(List<NetLink> links, SortedMap<AugRelation, Boolean> relaMap, Set<NetLink> reducedLinks, Set<NetLink> culledLinks, BTProgressMonitor monitor) throws AsynchExitRequestException {
        BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
        bex.assignDirections(links, relaMap, monitor);
        bex.preprocessLinks(links, reducedLinks, culledLinks, monitor);
    }

    public boolean loadXMLFromSource(File file, File holdIt) {
        ArrayList<ParserClient> alist = new ArrayList<ParserClient>();
        FabricFactory ff = new FabricFactory(this.pMan_);
        alist.add(ff);
        SUParser sup = new SUParser(alist);
        if (file.length() > 1000000L) {
            BackgroundFileReader br = new BackgroundFileReader();
            boolean finished = br.doBackgroundRead(ff, sup, file, false, holdIt);
            if (finished) {
                this.setCurrentXMLFile(file);
                this.postXMLLoad(ff, file.getName(), holdIt);
            }
            return true;
        }
        try {
            sup.parse(file);
        }
        catch (IOException ioe) {
            this.displayFileInputError(ioe);
            return false;
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.getHandler().displayOutOfMemory(oom);
            return false;
        }
        this.setCurrentXMLFile(file);
        this.postXMLLoad(ff, file.getName(), holdIt);
        return true;
    }

    private boolean restoreFromBackup(File file) {
        ArrayList<ParserClient> alist = new ArrayList<ParserClient>();
        FabricFactory ff = new FabricFactory(this.pMan_);
        alist.add(ff);
        SUParser sup = new SUParser(alist);
        BackgroundFileReader br = new BackgroundFileReader();
        br.doBackgroundRead(ff, sup, file, true, null);
        file.delete();
        String cfn = this.currentFile_ == null ? null : this.currentFile_.getName();
        this.postXMLLoad(ff, cfn, null);
        return true;
    }

    public boolean postXMLLoad(FabricFactory ff, String fileName, File holdIt) {
        NetworkBuilder nb = new NetworkBuilder(true, holdIt, null);
        nb.setBuildDataForXMLLoad(ff.getFabricNetwork(), BuildDataImpl.BuildMode.BUILD_FROM_XML);
        nb.doNetworkBuild();
        this.manageWindowTitle(fileName);
        return true;
    }

    @Override
    public boolean standardFileChecks(File target, boolean mustExist, boolean canCreate, boolean checkOverwrite, boolean mustBeDirectory, boolean canWrite, boolean canRead) {
        ResourceManager rMan = ResourceManager.getManager();
        boolean doesExist = target.exists();
        if (mustExist && !doesExist) {
            String noFileFormat = rMan.getString("fileChecks.noFileFormat");
            String noFileMsg = MessageFormat.format(noFileFormat, target.getName());
            JOptionPane.showMessageDialog(this.topWindow_, noFileMsg, rMan.getString("fileChecks.noFileTitle"), 0);
            return false;
        }
        if (mustBeDirectory) {
            if (doesExist && !target.isDirectory()) {
                String notADirectoryFormat = rMan.getString("fileChecks.notADirectoryFormat");
                String notADirectoryMsg = MessageFormat.format(notADirectoryFormat, target.getName());
                JOptionPane.showMessageDialog(this.topWindow_, notADirectoryMsg, rMan.getString("fileChecks.notADirectoryTitle"), 0);
                return false;
            }
        } else if (doesExist && !target.isFile()) {
            String notAFileFormat = rMan.getString("fileChecks.notAFileFormat");
            String notAFileMsg = MessageFormat.format(notAFileFormat, target.getName());
            JOptionPane.showMessageDialog(this.topWindow_, notAFileMsg, rMan.getString("fileChecks.notAFileTitle"), 0);
            return false;
        }
        if (!doesExist && canCreate) {
            if (mustBeDirectory) {
                throw new IllegalArgumentException();
            }
            boolean couldNotCreate = false;
            try {
                if (!target.createNewFile()) {
                    couldNotCreate = true;
                }
            }
            catch (IOException ioex) {
                couldNotCreate = true;
            }
            if (couldNotCreate) {
                String noCreateFormat = rMan.getString("fileChecks.noCreateFormat");
                String noCreateMsg = MessageFormat.format(noCreateFormat, target.getName());
                JOptionPane.showMessageDialog(this.topWindow_, noCreateMsg, rMan.getString("fileChecks.noCreateTitle"), 0);
                return false;
            }
        }
        boolean didExist = doesExist;
        doesExist = target.exists();
        if (canWrite && doesExist && !target.canWrite()) {
            String noWriteFormat = rMan.getString("fileChecks.noWriteFormat");
            String noWriteMsg = MessageFormat.format(noWriteFormat, target.getName());
            JOptionPane.showMessageDialog(this.topWindow_, noWriteMsg, rMan.getString("fileChecks.noWriteTitle"), 0);
            return false;
        }
        if (canRead && doesExist && !target.canRead()) {
            String noReadFormat = rMan.getString("fileChecks.noReadFormat");
            String noReadMsg = MessageFormat.format(noReadFormat, target.getName());
            JOptionPane.showMessageDialog(this.topWindow_, noReadMsg, rMan.getString("fileChecks.noReadTitle"), 0);
            return false;
        }
        if (didExist && checkOverwrite) {
            int overwrite;
            String overFormat = rMan.getString("fileChecks.doOverwriteFormat");
            String overMsg = MessageFormat.format(overFormat, target.getName());
            if (this.headlessOracle_ == null && (overwrite = JOptionPane.showConfirmDialog(this.topWindow_, overMsg, rMan.getString("fileChecks.doOverwriteTitle"), 0)) != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public File getTheFile(String ext1, String ext2, String prefTag, String desc, Component useUI) {
        File file = null;
        String filename = FabricCommands.getPreference(prefTag);
        while (file == null) {
            int option;
            File startDir;
            JFileChooser chooser = new JFileChooser();
            FileFilter filter = ext2 == null ? new FileExtensionFilters.SimpleFilter(ext1, desc) : new FileExtensionFilters.DoubleExtensionFilter(ext1, ext2, desc);
            chooser.addChoosableFileFilter(filter);
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.setFileFilter(filter);
            if (filename != null && (startDir = new File(filename)).exists()) {
                chooser.setCurrentDirectory(startDir);
            }
            if ((option = chooser.showOpenDialog(useUI == null ? this.topWindow_ : useUI)) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            if (this.standardFileChecks(file, true, false, false, false, false, true)) continue;
            file = null;
        }
        return file;
    }

    @Override
    public File getTheDirectory(String prefTag) {
        File file = null;
        String filename = FabricCommands.getPreference(prefTag);
        while (file == null) {
            int option;
            File startDir;
            JFileChooser chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.setFileSelectionMode(1);
            if (filename != null && (startDir = new File(filename)).exists()) {
                chooser.setCurrentDirectory(startDir);
            }
            if ((option = chooser.showOpenDialog(this.topWindow_)) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            if (this.standardFileChecks(file, true, false, false, true, false, true)) continue;
            file = null;
        }
        return file;
    }

    public Map<Boolean, AnnotationSet> loadAnnotations(File file, boolean forNodes) {
        AnnotationLoader.ReadStats stats = new AnnotationLoader.ReadStats();
        try {
            AnnotationLoader alod = new AnnotationLoader();
            Map<Boolean, AnnotationSet> aSet = alod.readAnnotations(file, stats, forNodes, this.bfp_.getNetwork(), null);
            FabricCommands.setPreference("AnnotDirectory", file.getAbsoluteFile().getParent());
            return aSet;
        }
        catch (IOException ioe) {
            if (stats.errStr != null) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("attribRead.IOException"), rMan.getString("attribRead.IOExceptionTitle"), 0);
                return null;
            }
            this.displayFileInputError(ioe);
            return null;
        }
        catch (AsynchExitRequestException aerex) {
            UiUtil.fixMePrintout("Do this read on background thread");
            return null;
        }
    }

    @Override
    public Map<AttributeKey, String> loadTheFile(File file, Map<String, Set<NetNode>> nameToIDs, boolean forNodes) {
        HashMap<AttributeKey, String> attributes = new HashMap<AttributeKey, String>();
        try {
            ResourceManager rMan;
            AttributeLoader.ReadStats stats = new AttributeLoader.ReadStats();
            AttributeLoader alod = new AttributeLoader();
            BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
            Map<String, NetNode> nameToID = !forNodes ? bex.reduceNameSetToOne(nameToIDs) : null;
            alod.readAttributes(file, forNodes, attributes, nameToID, stats);
            if (!stats.badLines.isEmpty()) {
                rMan = ResourceManager.getManager();
                String badLineFormat = rMan.getString("attribRead.badLineFormat");
                String badLineMsg = MessageFormat.format(badLineFormat, stats.badLines.size());
                if (this.headlessOracle_ == null) {
                    JOptionPane.showMessageDialog(this.topWindow_, badLineMsg, rMan.getString("attribRead.badLineTitle"), 2);
                } else {
                    this.headlessOracle_.displayErrorMessage(badLineMsg);
                }
            }
            if (!stats.dupLines.isEmpty()) {
                rMan = ResourceManager.getManager();
                String dupLineFormat = rMan.getString("attribRead.dupLineFormat");
                String dupLineMsg = MessageFormat.format(dupLineFormat, stats.dupLines.size());
                if (this.headlessOracle_ == null) {
                    JOptionPane.showMessageDialog(this.topWindow_, dupLineMsg, rMan.getString("attribRead.dupLineTitle"), 2);
                } else {
                    this.headlessOracle_.displayErrorMessage(dupLineMsg);
                }
            }
            if (!forNodes && !stats.shadowsPresent) {
                rMan = ResourceManager.getManager();
                if (this.headlessOracle_ == null) {
                    JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("attribRead.noShadowError"), rMan.getString("attribRead.noShadowTitle"), 0);
                } else {
                    this.headlessOracle_.displayErrorMessage(rMan.getString("attribRead.noShadowError"));
                }
                return null;
            }
        }
        catch (IOException ioe) {
            this.displayFileInputError(ioe);
            return null;
        }
        FabricCommands.setPreference("AttribDirectory", file.getAbsoluteFile().getParent());
        return attributes;
    }

    public boolean saveToCurrentFile() {
        if (this.currentFile_ != null) {
            return this.saveToFile(this.currentFile_.getAbsolutePath());
        }
        return this.saveToFile(null);
    }

    public boolean saveToFile(String fileName) {
        BioFabricNetwork bfn;
        File file = null;
        if (fileName == null) {
            String dirName = FabricCommands.getPreference("LoadDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                FileExtensionFilters.SimpleFilter sf = new FileExtensionFilters.SimpleFilter(".bif", "filterName.bif");
                chooser.addChoosableFileFilter(sf);
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setFileFilter(sf);
                if (dirName != null && (startDir = new File(dirName)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showSaveDialog(this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) continue;
                if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), ".bif")) {
                    file = new File(file.getAbsolutePath() + ".bif");
                }
                if (this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                file = null;
            }
        } else {
            file = new File(fileName);
            if (!this.standardFileChecks(file, false, true, false, false, true, false)) {
                return false;
            }
        }
        if ((bfn = this.bfp_.getNetwork()).getLinkCount(true) > 5000) {
            BackgroundFileWriter bw = new BackgroundFileWriter();
            bw.doBackgroundWrite(file);
            return true;
        }
        try {
            this.saveToOutputStream(new FileOutputStream(file), false, null);
            this.setCurrentXMLFile(file);
            this.manageWindowTitle(file.getName());
            return true;
        }
        catch (AsynchExitRequestException aeex) {
            return false;
        }
        catch (IOException ioe) {
            this.displayFileOutputError();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToOutputStream(OutputStream stream, boolean compress, BTProgressMonitor monitor) throws AsynchExitRequestException, IOException {
        PrintWriter out = null;
        out = compress ? new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(stream, 8192), "UTF-8")) : new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        try {
            Indenter ind = new Indenter(out, 2);
            BioFabricNetwork bfn = this.bfp_.getNetwork();
            if (bfn != null) {
                bfn.writeXML(out, ind, monitor, compress);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void displayFileInputError(IOException ioex) {
        ResourceManager rMan = ResourceManager.getManager();
        if (ioex == null || ioex.getMessage() == null || ioex.getMessage().trim().equals("")) {
            if (this.headlessOracle_ == null) {
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("fileRead.errorMessage"), rMan.getString("fileRead.errorTitle"), 0);
            } else {
                this.headlessOracle_.displayErrorMessage(rMan.getString("fileRead.errorMessage"));
            }
            return;
        }
        String errMsg = ioex.getMessage().trim();
        String format = rMan.getString("fileRead.inputErrorMessageForIOEx");
        String outMsg = MessageFormat.format(format, errMsg);
        if (this.headlessOracle_ == null) {
            JOptionPane.showMessageDialog(this.topWindow_, outMsg, rMan.getString("fileRead.errorTitle"), 0);
        } else {
            this.headlessOracle_.displayErrorMessage(outMsg);
        }
    }

    public void displayFileOutputError() {
        ResourceManager rMan = ResourceManager.getManager();
        JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("fileWrite.errorMessage"), rMan.getString("fileWrite.errorTitle"), 0);
    }

    public void displayInvalidInputError(InvalidInputException iiex) {
        String outMsg;
        boolean haveLine;
        ResourceManager rMan = ResourceManager.getManager();
        String errKey = iiex.getErrorKey();
        boolean haveKey = errKey != null && !errKey.equals("BT_INPUT_ERROR_UNSPECIFIED");
        int lineno = iiex.getErrorLineNumber();
        boolean bl = haveLine = lineno != -1;
        if (haveKey && haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageForLineWithDesc");
            String keyedErr = rMan.getString("invalidInput." + errKey);
            outMsg = MessageFormat.format(format, lineno + 1, keyedErr);
        } else if (haveKey && !haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageWithDesc");
            String keyedErr = rMan.getString("invalidInput." + errKey);
            outMsg = MessageFormat.format(format, keyedErr);
        } else if (!haveKey && haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageForLine");
            outMsg = MessageFormat.format(format, lineno + 1);
        } else {
            outMsg = rMan.getString("fileRead.inputErrorMessage");
        }
        JOptionPane.showMessageDialog(this.topWindow_, outMsg, rMan.getString("fileRead.errorTitle"), 0);
    }

    @Override
    public boolean cancelAndRestore(File restoreFile) {
        if (restoreFile != null && restoreFile.exists() && restoreFile.length() > 20L) {
            ResourceManager rMan = ResourceManager.getManager();
            int restore = JOptionPane.showConfirmDialog(this.topWindow_, rMan.getString("progress.cancelled"), rMan.getString("progress.cancelledTitle"), 0);
            if (restore == 0) {
                this.restoreFromBackup(restoreFile);
                return true;
            }
            restoreFile.delete();
            this.manageWindowTitle(null);
            this.buildEmptyNetwork();
        }
        return false;
    }

    public void buildRestoreCache(File restoreFile, BTProgressMonitor btpm) throws AsynchExitRequestException {
        boolean throwOut = false;
        try {
            this.saveToOutputStream(new FileOutputStream(restoreFile), true, btpm);
        }
        catch (IOException ioex) {
            System.err.println("bad write");
            throwOut = true;
        }
        catch (AsynchExitRequestException aex) {
            throwOut = true;
            throw aex;
        }
        finally {
            if (throwOut) {
                restoreFile.delete();
            }
        }
    }

    public void buildEmptyNetwork() {
        BuildDataImpl obd = new BuildDataImpl(new UniqueLabeller(), new HashSet<NetLink>(), new HashSet<NetNode>(), new HashMap<NetNode, String>(), this.colGen_, BuildDataImpl.BuildMode.BUILD_FROM_SIF);
        try {
            this.newModelOperations(obd, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void preLoadOperations() {
        this.bfp_.reset();
    }

    public BufferedImage expensiveModelOperations(BuildData bfnbd, boolean forMain, BTProgressMonitor monitor) throws IOException, AsynchExitRequestException, LayoutCriterionFailureException {
        Dimension screenSize = forMain && this.headlessOracle_ == null ? Toolkit.getDefaultToolkit().getScreenSize() : new Dimension(600, 800);
        BioFabricNetwork bfn = new BioFabricNetwork(bfnbd, this.pMan_, monitor);
        this.bfp_.installModel(bfn, monitor);
        int[] preZooms = this.bfp_.calcZoomSettings(screenSize);
        BufferedImage topImage = null;
        if (this.headlessOracle_ == null) {
            if (forMain) {
                BufferBuilder bb = new BufferBuilder(null, 100, this.bfp_, this.bfp_.getBucketRend(), this.bfp_.getBufImgStack());
                topImage = bb.buildBufs(preZooms, this.bfp_, 25, monitor);
                this.bfp_.setBufBuilder(bb);
            } else {
                BufferBuilder bb = new BufferBuilder(this.bfp_, this.bfp_.getBucketRend(), this.bfp_.getBufImgStack());
                topImage = bb.buildOneBuf();
                this.bfp_.setBufBuilder(null);
            }
        }
        return topImage;
    }

    public BufferedImage expensiveRecolorOperations(boolean forMain, BTProgressMonitor monitor) throws IOException, AsynchExitRequestException {
        Dimension screenSize = forMain ? Toolkit.getDefaultToolkit().getScreenSize() : new Dimension(800, 400);
        screenSize.setSize((int)(screenSize.getWidth() * 0.8), (int)(screenSize.getHeight() * 0.4));
        this.colGen_.newColorModel();
        this.bfp_.changePaint(monitor);
        int[] zoomLevels = this.bfp_.getZoomController().getZoomLevels();
        BufferedImage topImage = null;
        if (forMain) {
            BufferBuilder bb = new BufferBuilder(null, 100, this.bfp_, this.bfp_.getBucketRend(), this.bfp_.getBufImgStack());
            topImage = bb.buildBufs(zoomLevels, this.bfp_, 24, monitor);
            this.bfp_.setBufBuilder(bb);
        } else {
            BufferBuilder bb = new BufferBuilder(this.bfp_, this.bfp_.getBucketRend(), this.bfp_.getBufImgStack());
            topImage = bb.buildOneBuf();
            this.bfp_.setBufBuilder(null);
        }
        return topImage;
    }

    public void postRecolorOperations(BufferedImage topImage) {
        this.bfw_.getOverview().installImage(topImage, this.bfp_.getWorldScreen());
    }

    public void postLoadOperations(BufferedImage topImage, boolean skipImageLoad) {
        if (!skipImageLoad) {
            this.bfw_.getOverview().installImage(topImage, this.bfp_.getWorldScreen());
        }
        this.bfp_.installModelPost();
        this.bfp_.initZoom();
        this.pMan_.newNetworkInstalled(this.bfp_.getNetwork());
        this.cSet_.checkForChanges();
        this.cSet_.handleZoomButtons();
        this.bfp_.repaint();
    }

    @Override
    public void newModelOperations(BuildData bfnbd, boolean forMain) throws IOException {
        this.preLoadOperations();
        try {
            BufferedImage topImage = this.expensiveModelOperations(bfnbd, forMain, null);
            this.postLoadOperations(topImage, false);
        }
        catch (AsynchExitRequestException asynchExitRequestException) {
        }
        catch (LayoutCriterionFailureException layoutCriterionFailureException) {
            // empty catch block
        }
    }

    @Override
    public void manageWindowTitle(String fileName) {
        String title;
        if (this.headlessOracle_ != null) {
            return;
        }
        ResourceManager rMan = ResourceManager.getManager();
        if (fileName == null) {
            title = rMan.getString("window.title");
        } else {
            String titleFormat = rMan.getString("window.titleWithName");
            title = MessageFormat.format(titleFormat, fileName);
        }
        this.topWindow_.setTitle(title);
    }

    @Override
    public FileLoadFlows.FileLoadType getFileLoadType(File toCheck) {
        return GWImportLoader.isGWFile(toCheck) ? FileLoadFlows.FileLoadType.GW : FileLoadFlows.FileLoadType.SIF;
    }

    public static class FileLoadResultImpl
    implements FileLoadFlows.FileLoadResult {
        private boolean success_;
        private File cacheFile_;

        public FileLoadResultImpl(boolean success, File cacheFile) {
            this.success_ = success;
            this.cacheFile_ = cacheFile;
        }

        public boolean getSuccess() {
            return this.success_;
        }

        public File getCacheFile() {
            return this.cacheFile_;
        }
    }

    public static class PlugInInfo
    implements PlugInNetworkModelAPI {
        private BioFabricNetwork bfn_;
        private FileLoadFlows flf_;
        private BioFabricWindow bfw_;

        PlugInInfo(FileLoadFlowsImpl flf, BioFabricNetwork bfn, BioFabricWindow bfw) {
            this.flf_ = flf;
            this.bfn_ = bfn;
            this.bfw_ = bfw;
        }

        public int getLinkCount(boolean forShadow) {
            return this.bfn_.getLinkCount(forShadow);
        }

        public int getNodeCount() {
            return this.bfn_.getNodeCount();
        }

        public FileLoadFlows getFileUtilities() {
            return this.flf_;
        }

        public JFrame getTopWindow() {
            return this.bfw_.getWindow();
        }

        public BackgroundWorkerControlManager getBWCtrlMgr() {
            return this.bfw_;
        }

        public void stashPluginData(String keyword, BioFabricToolPlugInData data) {
            this.bfn_.stashPluginData(keyword, data);
        }

        public BioFabricToolPlugInData providePluginData(String keyword) {
            return this.bfn_.providePluginData(keyword);
        }

        public boolean getDisplayShadows() {
            FabricDisplayOptionsManager fdom = FabricDisplayOptionsManager.getMgr();
            return fdom.getDisplayOptions().getDisplayShadows();
        }
    }

    private class RecolorNetworkRunner
    implements BackgroundCore {
        private boolean forMain_;
        private File holdIt_;
        private BFWorker bfwk_;

        public RecolorNetworkRunner(boolean forMain, File holdIt, BFWorker bfwk) {
            this.bfwk_ = bfwk;
            this.holdIt_ = holdIt;
            this.forMain_ = forMain;
        }

        public Object getEarlyResult() {
            return new BufferedImage(1, 1, 1);
        }

        public Object runCore() throws AsynchExitRequestException {
            try {
                BTProgressMonitor monitor = this.bfwk_.getMonitor();
                FileLoadFlowsImpl.this.buildRestoreCache(this.holdIt_, monitor);
                BufferedImage bi = FileLoadFlowsImpl.this.expensiveRecolorOperations(this.forMain_, monitor);
                new GarbageRequester().askForGC(monitor);
                return bi;
            }
            catch (IOException ex) {
                this.bfwk_.stashException(ex);
                return null;
            }
        }

        public Object postRunCore() {
            return null;
        }
    }

    public class NetworkRecolor
    implements BackgroundWorkerOwner {
        private File holdIt_;

        public void doNetworkRecolor(boolean isMain, File holdIt) {
            try {
                this.holdIt_ = holdIt;
                FileLoadFlowsImpl.this.bfp_.shutdown();
                BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "netRecolor.waitTitle", "netRecolor.wait", true, null);
                RecolorNetworkRunner runner = new RecolorNetworkRunner(isMain, this.holdIt_, bfw);
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean handleRemoteException(Exception remoteEx) {
            if (remoteEx instanceof IOException) {
                this.finishedRecolor(null, (IOException)remoteEx);
                return true;
            }
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public boolean handleCancellation() {
            return FileLoadFlowsImpl.this.cancelAndRestore(this.holdIt_);
        }

        public void cleanUpPostRepaint(Object result, boolean skipImage) {
            this.finishedRecolor(result, null);
        }

        private void finishedRecolor(Object result, IOException ioEx) {
            FileLoadFlowsImpl.this.postRecolorOperations((BufferedImage)result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NetworkRelayoutRunner
    implements BackgroundCore {
        private BuildDataImpl rbd_;
        private BuildDataImpl.BuildMode mode_;
        private NodeLayout.Params params_;
        private BioFabricNetwork bfn_;
        private Map<AttributeKey, String> nodeAttrib_;
        private File holdIt_;
        private List<String> groupOrder_;
        private Network.LayoutMode layMode_;
        private Boolean pointUp_;
        private SetLayout.LinkMeans linkMeaning_;
        private SortedMap<Integer, NetLink> linkOrder_;
        private ControlTopLayout.CtrlMode cMode_;
        private ControlTopLayout.TargMode tMode_;
        private List<String> fixedList_;
        private boolean showLinkGroupAnnotations_;
        private BFWorker bfwk_;

        NetworkRelayoutRunner(BFWorker bfwk) {
            this.bfwk_ = bfwk;
        }

        @Override
        public Object getEarlyResult() {
            return new BufferedImage(1, 1, 1);
        }

        void setNetworkAndMode(File holdIt, BioFabricNetwork bfn, BuildDataImpl.BuildMode bMode) {
            this.holdIt_ = holdIt;
            this.bfn_ = bfn;
            this.mode_ = bMode;
        }

        void setGroupOrderAndMode(List<String> groupOrder, Network.LayoutMode mode, boolean showGroupLinkAnnotations) {
            this.groupOrder_ = groupOrder;
            this.layMode_ = mode;
            this.showLinkGroupAnnotations_ = showGroupLinkAnnotations;
        }

        void setNodeOrderFromAttrib(Map<AttributeKey, String> nodeAttributes) {
            this.nodeAttrib_ = nodeAttributes;
        }

        void setParams(NodeLayout.Params params) {
            this.params_ = params;
        }

        void setPointUp(boolean pointUp) {
            this.pointUp_ = pointUp;
        }

        void setLinkMeaning(SetLayout.LinkMeans linkMeaning) {
            this.linkMeaning_ = linkMeaning;
        }

        void setControlTopModes(ControlTopLayout.CtrlMode cMode, ControlTopLayout.TargMode tMode, List<String> fixedList) {
            this.cMode_ = cMode;
            this.tMode_ = tMode;
            this.fixedList_ = fixedList;
        }

        void setLinkOrder(SortedMap<Integer, NetLink> linkOrder) {
            this.linkOrder_ = linkOrder;
        }

        @Override
        public Object runCore() throws AsynchExitRequestException {
            BTProgressMonitor monitor = this.bfwk_.getMonitor();
            if (this.holdIt_ != null && this.holdIt_.length() == 0L) {
                FileLoadFlowsImpl.this.buildRestoreCache(this.holdIt_, monitor);
            }
            this.rbd_ = new BuildDataImpl(this.bfn_, this.mode_, monitor);
            if (this.groupOrder_ != null && this.layMode_ != null) {
                this.rbd_.setGroupOrderAndMode(this.groupOrder_, this.layMode_, this.showLinkGroupAnnotations_);
            } else {
                this.rbd_.setGroupOrderAndMode(this.bfn_.getLinkGrouping(), this.bfn_.getLayoutMode(), this.bfn_.getShowLinkGroupAnnotations());
            }
            if (this.nodeAttrib_ != null) {
                this.rbd_.setNodeOrderFromAttrib(this.nodeAttrib_);
            } else if (this.linkOrder_ != null) {
                this.rbd_.setLinkOrder(this.linkOrder_);
            }
            this.rbd_.setCTL(this.cMode_, this.tMode_, this.fixedList_, this.bfn_);
            this.rbd_.setPointUp(this.pointUp_);
            this.rbd_.setLinkMeaning(this.linkMeaning_);
            this.bfn_ = null;
            FileLoadFlowsImpl.this.preLoadOperations();
            try {
                if (this.rbd_.needsLayoutForRelayout()) {
                    NodeLayout nl = this.rbd_.getNodeLayout();
                    boolean nlok = nl.criteriaMet(this.rbd_, monitor);
                    if (!nlok) {
                        throw new IllegalStateException();
                    }
                    nl.doNodeLayout(this.rbd_, this.params_, monitor);
                    EdgeLayout el = this.rbd_.getEdgeLayout();
                    if (el != null) {
                        el.layoutEdges(this.rbd_, monitor);
                    }
                }
                BufferedImage bi = FileLoadFlowsImpl.this.expensiveModelOperations(this.rbd_, true, monitor);
                new GarbageRequester().askForGC(monitor);
                return bi;
            }
            catch (IOException ex) {
                this.bfwk_.stashException(ex);
                return null;
            }
            catch (LayoutCriterionFailureException ex) {
                this.bfwk_.stashException(ex);
                return null;
            }
        }

        @Override
        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NetworkRelayout
    implements BackgroundWorkerOwner {
        private File holdIt_;
        NetworkRelayoutRunner runner_;
        private BFWorker bfwk_;

        public NetworkRelayout() {
            this.bfwk_ = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "netRelayout.waitTitle", "netRelayout.wait", true, null);
            this.runner_ = new NetworkRelayoutRunner(this.bfwk_);
            this.bfwk_.setCore(this.runner_);
        }

        public void setGroupOrderAndMode(List<String> groupOrder, Network.LayoutMode mode, boolean showGroupLinkAnnotations) {
            this.runner_.setGroupOrderAndMode(groupOrder, mode, showGroupLinkAnnotations);
        }

        public void setNodeOrderFromAttrib(Map<AttributeKey, String> nodeAttributes) {
            this.runner_.setNodeOrderFromAttrib(nodeAttributes);
        }

        public void setParams(NodeLayout.Params params) {
            this.runner_.setParams(params);
        }

        public void setPointUp(boolean pointUp) {
            this.runner_.setPointUp(pointUp);
        }

        public void setLinkMeaning(SetLayout.LinkMeans linkMeaning) {
            this.runner_.setLinkMeaning(linkMeaning);
        }

        public void setControlTopModes(ControlTopLayout.CtrlMode cMode, ControlTopLayout.TargMode tMode, List<String> fixedList) {
            this.runner_.setControlTopModes(cMode, tMode, fixedList);
        }

        public void setLinkOrder(SortedMap<Integer, NetLink> linkOrder) {
            this.runner_.setLinkOrder(linkOrder);
        }

        public void doNetworkRelayout(BioFabricNetwork bfn, BuildDataImpl.BuildMode bMode) {
            try {
                this.holdIt_ = File.createTempFile("BioFabricHold", ".zip");
                this.holdIt_.deleteOnExit();
                this.runner_.setNetworkAndMode(this.holdIt_, bfn, bMode);
                if (bMode == BuildDataImpl.BuildMode.REORDER_LAYOUT) {
                    this.bfwk_.makeSuperChart();
                }
                this.bfwk_.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        @Override
        public boolean handleRemoteException(Exception remoteEx) {
            if (remoteEx instanceof IOException) {
                FileLoadFlowsImpl.this.displayFileInputError((IOException)remoteEx);
                return true;
            }
            if (remoteEx instanceof LayoutCriterionFailureException) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(FileLoadFlowsImpl.this.topWindow_, rMan.getString("netLayout.unmetCriteriaMessage"), rMan.getString("netLayout.unmetCriteriaTitle"), 0);
                return true;
            }
            return false;
        }

        @Override
        public void cleanUpPreEnable(Object result) {
        }

        @Override
        public boolean handleCancellation() {
            return FileLoadFlowsImpl.this.cancelAndRestore(this.holdIt_);
        }

        @Override
        public void cleanUpPostRepaint(Object result, boolean skipImage) {
            this.finishedImport(result, null, skipImage);
        }

        private void finishedImport(Object result, IOException ioEx, boolean skipImage) {
            FileLoadFlowsImpl.this.postLoadOperations((BufferedImage)result, skipImage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NewNetworkRunner
    implements BackgroundCore {
        private boolean forMain_;
        private UniqueLabeller idGen_;
        private Set<NetLink> links_;
        private Set<NetNode> loneNodeIDs_;
        private BuildDataImpl.BuildMode bMode_;
        private BioFabricNetwork bfn_;
        private File holdIt_;
        private long linkCount_;
        private BuildDataImpl plugInBuildData_;
        private BFWorker bfwk_;

        public NewNetworkRunner(boolean forMain, File holdIt, BFWorker bfwk) {
            this.forMain_ = forMain;
            this.holdIt_ = holdIt;
            this.bfwk_ = bfwk;
        }

        @Override
        public Object getEarlyResult() {
            return new BufferedImage(1, 1, 1);
        }

        void setBuildDataForSIF(UniqueLabeller idGen, Set<NetLink> links, Set<NetNode> loneNodeIDs, BuildDataImpl.BuildMode bMode) {
            this.idGen_ = idGen;
            this.links_ = links;
            this.loneNodeIDs_ = loneNodeIDs;
            this.bMode_ = bMode;
            this.linkCount_ = links.size();
        }

        void setBuildDataForPlugin(BuildData bd) {
            this.plugInBuildData_ = (BuildDataImpl)bd;
            this.bMode_ = this.plugInBuildData_.getMode();
        }

        void setBuildDataForOptionChange(BioFabricNetwork bfn, BuildDataImpl.BuildMode bMode) {
            this.bfn_ = bfn;
            this.linkCount_ = bfn.getLinkCount(true);
            this.bMode_ = bMode;
        }

        void setBuildDataForXMLLoad(BioFabricNetwork bfn, BuildDataImpl.BuildMode bMode) {
            this.bfn_ = bfn;
            this.linkCount_ = bfn.getLinkCount(true);
            this.bMode_ = bMode;
        }

        private BuildData generateBuildData() {
            switch (this.bMode_) {
                case BUILD_FROM_SIF: {
                    HashMap<NetNode, String> emptyMap = new HashMap<NetNode, String>();
                    return new BuildDataImpl(this.idGen_, this.links_, this.loneNodeIDs_, emptyMap, FileLoadFlowsImpl.this.colGen_, this.bMode_);
                }
                case BUILD_FROM_PLUGIN: {
                    this.plugInBuildData_.setColorGen(FileLoadFlowsImpl.this.colGen_);
                    return this.plugInBuildData_;
                }
                case SHADOW_LINK_CHANGE: 
                case BUILD_FROM_XML: {
                    return new BuildDataImpl(this.bfn_, this.bMode_);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public Object runCore() throws AsynchExitRequestException {
            try {
                BTProgressMonitor monitor = this.bfwk_.getMonitor();
                if (this.holdIt_ != null && this.holdIt_.length() == 0L) {
                    FileLoadFlowsImpl.this.buildRestoreCache(this.holdIt_, monitor);
                }
                BuildData bd = this.generateBuildData();
                FileLoadFlowsImpl.this.preLoadOperations();
                if (FileLoadFlowsImpl.this.headlessOracle_ != null) {
                    monitor = null;
                }
                BufferedImage bi = FileLoadFlowsImpl.this.expensiveModelOperations(bd, this.forMain_, monitor);
                if (this.linkCount_ > 10000L) {
                    new GarbageRequester().askForGC(monitor);
                }
                return bi;
            }
            catch (IOException ex) {
                this.bfwk_.stashException(ex);
                return null;
            }
            catch (LayoutCriterionFailureException ex) {
                this.bfwk_.stashException(ex);
                return null;
            }
        }

        @Override
        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NetworkBuilder
    implements BackgroundWorkerOwner {
        private NewNetworkRunner runner_;
        private boolean finished_;
        private File holdIt_;
        private BFWorker bfwk_;

        NetworkBuilder(boolean isMain, File holdIt, PluginResourceManager rMan) {
            this.bfwk_ = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "netBuild.waitTitle", "netBuild.wait", true, rMan);
            this.runner_ = new NewNetworkRunner(isMain, holdIt, this.bfwk_);
            this.holdIt_ = holdIt;
        }

        void setForSifBuild(UniqueLabeller idGen, Set<NetLink> links, Set<NetNode> loneNodeIDs, BuildDataImpl.BuildMode bMode) {
            if (bMode != BuildDataImpl.BuildMode.BUILD_FROM_SIF) {
                throw new IllegalArgumentException();
            }
            this.runner_.setBuildDataForSIF(idGen, links, loneNodeIDs, bMode);
        }

        void setForPlugInBuild(BuildData bData) {
            this.runner_.setBuildDataForPlugin(bData);
        }

        void setForDisplayOptionChange(BioFabricNetwork bfn, BuildDataImpl.BuildMode bMode) {
            if (bMode != BuildDataImpl.BuildMode.SHADOW_LINK_CHANGE) {
                throw new IllegalArgumentException();
            }
            this.runner_.setBuildDataForOptionChange(bfn, bMode);
        }

        void setBuildDataForXMLLoad(BioFabricNetwork bfn, BuildDataImpl.BuildMode bMode) {
            if (bMode != BuildDataImpl.BuildMode.BUILD_FROM_XML) {
                throw new IllegalArgumentException();
            }
            this.runner_.setBuildDataForXMLLoad(bfn, bMode);
        }

        public void doNetworkBuildForeground() {
            try {
                this.runner_.runCore();
            }
            catch (AsynchExitRequestException asynchExitRequestException) {
                // empty catch block
            }
        }

        public boolean doNetworkBuild() {
            this.finished_ = true;
            try {
                this.bfwk_.setCore(this.runner_);
                this.bfwk_.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        @Override
        public boolean handleRemoteException(Exception remoteEx) {
            this.finished_ = false;
            if (remoteEx instanceof IOException) {
                this.finishedImport(null, (IOException)remoteEx, false);
                return true;
            }
            if (remoteEx instanceof LayoutCriterionFailureException) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(FileLoadFlowsImpl.this.topWindow_, rMan.getString("netLayout.unmetCriteriaMessage"), rMan.getString("netLayout.unmetCriteriaTitle"), 0);
                FileLoadFlowsImpl.this.cancelAndRestore(this.holdIt_);
                return true;
            }
            return false;
        }

        @Override
        public void cleanUpPreEnable(Object result) {
        }

        @Override
        public boolean handleCancellation() {
            this.finished_ = false;
            return FileLoadFlowsImpl.this.cancelAndRestore(this.holdIt_);
        }

        @Override
        public void cleanUpPostRepaint(Object result, boolean skipImage) {
            this.finishedImport(result, null, skipImage);
        }

        private void finishedImport(Object result, IOException ioEx, boolean skipImage) {
            if (ioEx != null) {
                FileLoadFlowsImpl.this.displayFileInputError(ioEx);
                return;
            }
            FileLoadFlowsImpl.this.postLoadOperations((BufferedImage)result, skipImage);
        }
    }

    private class WriterRunner
    implements BackgroundCore {
        private File myFile_;
        private OutputStream myStream_;
        private BFWorker bfwk_;

        public WriterRunner(File file, BFWorker bfwk) {
            this.myFile_ = file;
            this.myStream_ = null;
            this.bfwk_ = bfwk;
        }

        public WriterRunner(OutputStream stream, BFWorker bfwk) {
            this.myStream_ = stream;
            this.myFile_ = null;
            this.bfwk_ = bfwk;
        }

        public Object getEarlyResult() {
            return new Boolean(false);
        }

        public Object runCore() throws AsynchExitRequestException {
            try {
                FileLoadFlowsImpl.this.saveToOutputStream(this.myStream_ == null ? new FileOutputStream(this.myFile_) : this.myStream_, false, this.bfwk_.getMonitor());
                return new Boolean(true);
            }
            catch (IOException ioe) {
                this.bfwk_.stashException(ioe);
                return null;
            }
        }

        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SIFReaderRunner
    implements BackgroundCore {
        private File myFile_;
        private List<NetLink> links_;
        private Set<NetNode> loneNodeIDs_;
        private UniqueLabeller idGen_;
        private Map<String, String> nameMap_;
        private FabricImportLoader.FileImportStats sss_;
        private Integer magBins_;
        private SortedMap<AugRelation, Boolean> relaMap_;
        private File restoreCacheFile_;
        private BFWorker bfwk_;

        public SIFReaderRunner(File file, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, FabricImportLoader.FileImportStats sss, Integer magBins, SortedMap<AugRelation, Boolean> relaMap, File restoreCacheFile, BFWorker bfwk) {
            this.bfwk_ = bfwk;
            this.myFile_ = file;
            this.links_ = links;
            this.loneNodeIDs_ = loneNodeIDs;
            this.idGen_ = idGen;
            this.nameMap_ = nameMap;
            this.sss_ = sss;
            this.magBins_ = magBins;
            this.relaMap_ = relaMap;
            this.restoreCacheFile_ = restoreCacheFile;
        }

        @Override
        public Object getEarlyResult() {
            return new Boolean(false);
        }

        @Override
        public Object runCore() throws AsynchExitRequestException {
            try {
                BTProgressMonitor monitor = this.bfwk_.getMonitor();
                if (this.restoreCacheFile_.length() == 0L) {
                    FileLoadFlowsImpl.this.buildRestoreCache(this.restoreCacheFile_, monitor);
                }
                FileLoadFlowsImpl.this.preLoadOperations();
                FabricImportLoader.FileImportStats sss = new SIFImportLoader().importFabric(this.myFile_, this.idGen_, this.links_, this.loneNodeIDs_, this.nameMap_, this.magBins_, monitor);
                this.sss_.copyInto(sss);
                PluginSupportFactory.getBuildExtractor().extractRelations(this.links_, this.relaMap_, monitor);
                return new Boolean(true);
            }
            catch (IOException ioe) {
                this.bfwk_.stashException(ioe);
                return null;
            }
        }

        @Override
        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GWReaderRunner
    implements BackgroundCore {
        private File myFile_;
        private List<NetLink> links_;
        private Set<NetNode> loneNodeIDs_;
        private UniqueLabeller idGen_;
        private Map<String, String> nameMap_;
        private FabricImportLoader.FileImportStats sss_;
        private Integer magBins_;
        private SortedMap<AugRelation, Boolean> relaMap_;
        private boolean needsGWProcessing_;
        private File restoreCacheFile_;
        private BFWorker bfwk_;

        public GWReaderRunner(File file, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, FabricImportLoader.FileImportStats gws, Integer magBins, SortedMap<AugRelation, Boolean> relaMap, boolean needsGWProcessing, File restoreCacheFile, BFWorker bfwk) {
            this.bfwk_ = bfwk;
            this.myFile_ = file;
            this.links_ = links;
            this.loneNodeIDs_ = loneNodeIDs;
            this.idGen_ = idGen;
            this.nameMap_ = nameMap;
            this.sss_ = gws;
            this.magBins_ = magBins;
            this.relaMap_ = relaMap;
            this.needsGWProcessing_ = needsGWProcessing;
            this.restoreCacheFile_ = restoreCacheFile;
        }

        @Override
        public Object getEarlyResult() {
            return new Boolean(false);
        }

        @Override
        public Object runCore() throws AsynchExitRequestException {
            BTProgressMonitor monitor = this.bfwk_.getMonitor();
            try {
                boolean finshed;
                if (this.restoreCacheFile_.length() == 0L) {
                    FileLoadFlowsImpl.this.buildRestoreCache(this.restoreCacheFile_, monitor);
                }
                FileLoadFlowsImpl.this.preLoadOperations();
                FabricImportLoader.FileImportStats sss = new GWImportLoader().importFabric(this.myFile_, this.idGen_, this.links_, this.loneNodeIDs_, this.nameMap_, this.magBins_, monitor);
                this.sss_.copyInto(sss);
                if (this.needsGWProcessing_ && !(finshed = new GWImportLoader.GWRelationManager().process(this.links_, FileLoadFlowsImpl.this.topWindow_, monitor))) {
                    return null;
                }
                PluginSupportFactory.getBuildExtractor().extractRelations(this.links_, this.relaMap_, monitor);
                return new Boolean(true);
            }
            catch (IOException ioe) {
                this.bfwk_.stashException(ioe);
                return null;
            }
        }

        @Override
        public Object postRunCore() {
            return null;
        }
    }

    public class BackgroundFileWriter
    implements BackgroundWorkerOwner {
        private Exception ex_;
        private File file_;

        public void doBackgroundWrite(File file) {
            this.file_ = file;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "fileWrite.waitTitle", "fileWrite.wait", true, null);
                WriterRunner runner = new WriterRunner(file, bfw);
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void doBackgroundWrite(OutputStream stream) {
            this.file_ = null;
            BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "fileWrite.waitTitle", "fileWrite.wait", true, null);
            WriterRunner runner = new WriterRunner(stream, bfw);
            try {
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean handleRemoteException(Exception remoteEx) {
            if (remoteEx instanceof IOException) {
                this.ex_ = remoteEx;
                return true;
            }
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public boolean handleCancellation() {
            if (this.file_ != null) {
                this.file_.delete();
            }
            return false;
        }

        public void cleanUpPostRepaint(Object result, boolean skipImage) {
            this.finishedOut();
        }

        private void finishedOut() {
            if (this.ex_ != null) {
                FileLoadFlowsImpl.this.displayFileOutputError();
                return;
            }
            FileLoadFlowsImpl.this.setCurrentXMLFile(this.file_);
            FileLoadFlowsImpl.this.manageWindowTitle(this.file_.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreprocessRunner
    implements BackgroundCore {
        private List<NetLink> links_;
        private SortedMap<AugRelation, Boolean> relaMap_;
        private Set<NetLink> reducedLinks_;
        private Set<NetLink> culledLinks_;
        private File holdIt_;
        private BFWorker bfwk_;

        PreprocessRunner(List<NetLink> links, SortedMap<AugRelation, Boolean> relaMap, Set<NetLink> reducedLinks, Set<NetLink> culledLinks, File holdIt, BFWorker bfwk) {
            this.bfwk_ = bfwk;
            this.links_ = links;
            this.relaMap_ = relaMap;
            this.reducedLinks_ = reducedLinks;
            this.culledLinks_ = culledLinks;
            this.holdIt_ = holdIt;
        }

        @Override
        public Object getEarlyResult() {
            return new Boolean(false);
        }

        @Override
        public Object runCore() throws AsynchExitRequestException {
            BTProgressMonitor monitor = this.bfwk_.getMonitor();
            if (this.holdIt_.length() == 0L) {
                FileLoadFlowsImpl.this.buildRestoreCache(this.holdIt_, monitor);
            }
            FileLoadFlowsImpl.this.preprocess(this.links_, this.relaMap_, this.reducedLinks_, this.culledLinks_, monitor);
            return new Boolean(true);
        }

        @Override
        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PreprocessNetwork
    implements BackgroundWorkerOwner {
        private boolean finished_;
        private File holdIt_;

        public boolean doNetworkPreprocess(List<NetLink> links, SortedMap<AugRelation, Boolean> relaMap, Set<NetLink> reducedLinks, Set<NetLink> culledLinks, File holdIt) {
            this.holdIt_ = holdIt;
            this.finished_ = true;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "netPreprocess.waitTitle", "netPreprocess.wait", true, null);
                PreprocessRunner runner = new PreprocessRunner(links, relaMap, reducedLinks, culledLinks, this.holdIt_, bfw);
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        @Override
        public boolean handleRemoteException(Exception remoteEx) {
            this.finished_ = false;
            return false;
        }

        @Override
        public void cleanUpPreEnable(Object result) {
        }

        @Override
        public boolean handleCancellation() {
            this.finished_ = false;
            return FileLoadFlowsImpl.this.cancelAndRestore(this.holdIt_);
        }

        @Override
        public void cleanUpPostRepaint(Object result, boolean skipImage) {
        }
    }

    private class ReaderRunner
    implements BackgroundCore {
        private File myFile_;
        private SUParser myParser_;
        private boolean compressed_;
        private File holdIt_;
        private BFWorker bfwk_;

        public ReaderRunner(SUParser sup, File file, boolean compressed, File holdIt, BFWorker bfwk) {
            this.bfwk_ = bfwk;
            this.myFile_ = file;
            this.myParser_ = sup;
            this.compressed_ = compressed;
            this.holdIt_ = holdIt;
        }

        public Object getEarlyResult() {
            return new Boolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object runCore() throws AsynchExitRequestException {
            BTProgressMonitor monitor = this.bfwk_.getMonitor();
            if (this.holdIt_ != null && this.holdIt_.length() == 0L) {
                FileLoadFlowsImpl.this.buildRestoreCache(this.holdIt_, monitor);
            }
            FilterInputStream pfis = null;
            try {
                long fileLen = this.myFile_.length();
                FileInputStream fis = new FileInputStream(this.myFile_);
                FilterInputStream bis = this.compressed_ ? new GZIPInputStream((InputStream)fis, 8192) : new BufferedInputStream(new FileInputStream(this.myFile_));
                pfis = new ProgressFilterInputStream(bis, fileLen);
                this.myParser_.parse((ProgressFilterInputStream)pfis, monitor, this.compressed_);
                Boolean bl = new Boolean(true);
                return bl;
            }
            catch (IOException ioe) {
                this.bfwk_.stashException(ioe);
                Object var4_10 = null;
                return var4_10;
            }
            finally {
                if (pfis != null) {
                    try {
                        pfis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BackgroundFileReader
    implements BackgroundWorkerOwner {
        private File holdIt_;
        private Exception ex_;
        private boolean finished_;
        private boolean forRecovery_;

        public boolean doBackgroundSIFRead(File file, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, FabricImportLoader.FileImportStats sss, Integer magBins, SortedMap<AugRelation, Boolean> relMap, File holdIt) {
            this.holdIt_ = holdIt;
            this.finished_ = true;
            this.forRecovery_ = false;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "fileLoad.waitTitle", "fileLoad.wait", true, null);
                SIFReaderRunner runner = new SIFReaderRunner(file, idGen, links, loneNodeIDs, nameMap, sss, magBins, relMap, this.holdIt_, bfw);
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        public boolean doBackgroundGWRead(File file, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, FabricImportLoader.FileImportStats gws, boolean needsGWProcess, Integer magBins, SortedMap<AugRelation, Boolean> relMap, File holdIt) {
            this.holdIt_ = holdIt;
            this.finished_ = true;
            this.forRecovery_ = false;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "fileLoad.waitTitle", "fileLoad.wait", true, null);
                GWReaderRunner runner = new GWReaderRunner(file, idGen, links, loneNodeIDs, nameMap, gws, magBins, relMap, needsGWProcess, this.holdIt_, bfw);
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        public boolean doBackgroundRead(FabricFactory ff, SUParser sup, File file, boolean compressed, File holdIt) {
            this.holdIt_ = holdIt;
            this.finished_ = true;
            this.forRecovery_ = holdIt == null;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker(this, FileLoadFlowsImpl.this.topWindow_, FileLoadFlowsImpl.this.bfw_, "fileLoad.waitTitle", "fileLoad.wait", true, null);
                ReaderRunner runner = new ReaderRunner(sup, file, compressed, this.holdIt_, bfw);
                bfw.setCore(runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        @Override
        public boolean handleRemoteException(Exception remoteEx) {
            this.finished_ = false;
            if (remoteEx instanceof IOException) {
                this.ex_ = remoteEx;
                return true;
            }
            return false;
        }

        @Override
        public void cleanUpPreEnable(Object result) {
        }

        @Override
        public boolean handleCancellation() {
            boolean restored = false;
            if (!this.forRecovery_) {
                restored = FileLoadFlowsImpl.this.cancelAndRestore(this.holdIt_);
            }
            this.finished_ = false;
            return restored;
        }

        @Override
        public void cleanUpPostRepaint(Object result, boolean skipImage) {
            this.finishedLoad();
        }

        private void finishedLoad() {
            if (this.ex_ != null) {
                FileLoadFlowsImpl.this.displayFileInputError((IOException)this.ex_);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileLoadType {
        GW,
        SIF;

    }
}

