/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.model.FabricNode;
import org.systemsbiology.biofabric.util.DataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FabricImportLoader {
    protected abstract String[] lineToToks(String var1, FileImportStats var2) throws IOException;

    protected abstract void consumeTokens(String[] var1, UniqueLabeller var2, List<NetLink> var3, Set<NetNode> var4, Map<String, String> var5, Integer var6, Map<String, NetNode> var7, FileImportStats var8) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileImportStats importFabric(File infile, UniqueLabeller idGen, List<NetLink> links, Set<NetNode> loneNodeIDs, Map<String, String> nameMap, Integer magBins, BTProgressMonitor monitor) throws AsynchExitRequestException, IOException {
        FileImportStats retval = new FileImportStats();
        long fileLen = infile.length();
        HashMap<String, NetNode> nameToID = new HashMap<String, NetNode>();
        BufferedReader in = null;
        ArrayList<String[]> tokSets = new ArrayList<String[]>();
        LoopReporter lr = new LoopReporter(fileLen, 20, monitor, 0.0, 1.0, "progress.readingFile");
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] tokens;
                lr.report(line.length() + 1);
                if (line.trim().equals("") || (tokens = this.lineToToks(line, retval)) == null) continue;
                tokSets.add(tokens);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        lr.finish();
        int numLines = tokSets.size();
        lr = new LoopReporter(numLines, 20, monitor, 0.0, 1.0, "progress.buildingEdgesAndNodes");
        for (int i = 0; i < numLines; ++i) {
            String[] tokens = (String[])tokSets.get(i);
            lr.report();
            this.consumeTokens(tokens, idGen, links, loneNodeIDs, nameMap, magBins, nameToID, retval);
        }
        lr.finish();
        return retval;
    }

    protected String stripQuotes(String inString) {
        String procString = inString.trim();
        if (procString.indexOf("\"") == 0 && procString.lastIndexOf("\"") == procString.length() - 1) {
            procString = procString.replaceAll("\"", "");
        }
        return procString;
    }

    protected String stripBrackets(String inString) {
        String procString = inString.trim();
        if (procString.indexOf("|{") == 0 && procString.lastIndexOf("}|") == procString.length() - 2) {
            procString = procString.replaceAll("\\|\\{", "");
            procString = procString.replaceAll("\\}\\|", "");
        }
        return procString;
    }

    protected String mapName(String inString, Map<String, String> nameMap) {
        String retval = inString;
        if (nameMap == null) {
            return retval;
        }
        String mappedString = nameMap.get(inString);
        if (mappedString != null) {
            retval = mappedString;
        }
        return retval;
    }

    protected NetNode nameToNode(String inString, UniqueLabeller idGen, Map<String, NetNode> nameToID) {
        String normName = DataUtil.normKey(inString);
        NetNode nodeID = nameToID.get(normName);
        if (nodeID == null) {
            NID nid = idGen.getNextOID();
            nodeID = new FabricNode(nid, inString);
            nameToID.put(normName, nodeID);
        }
        return nodeID;
    }

    protected void buildLinkAndShadow(NetNode srcID, NetNode trgID, String rel, List<NetLink> links) {
        FabricLink nextLink = new FabricLink(srcID, trgID, rel, false);
        links.add(nextLink);
        if (!srcID.equals(trgID)) {
            FabricLink nextShadowLink = new FabricLink(srcID, trgID, rel, true);
            links.add(nextShadowLink);
        }
    }

    public static class FileImportStats {
        public ArrayList<String> badLines = new ArrayList();

        public void copyInto(FileImportStats other) {
            this.badLines = new ArrayList<String>(other.badLines);
        }
    }
}

