/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.io.PluginWhiteboard;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.parser.ParserClient;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInData;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.NamedColor;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricFactory
implements ParserClient {
    private HashSet<String> allKeys_ = new HashSet();
    private ParserClient currClient_;
    private HashMap<String, ParserClient> clients_;
    private FactoryWhiteboard whiteBoard_ = new FactoryWhiteboard();

    public FabricFactory(PlugInManager pMan) {
        BioFabricNetwork.NetworkDataWorker ndw = new BioFabricNetwork.NetworkDataWorker(this.whiteBoard_, pMan);
        ArrayList<BioFabricNetwork.NetworkDataWorker> alist = new ArrayList<BioFabricNetwork.NetworkDataWorker>();
        alist.add(ndw);
        this.allKeys_.addAll(ndw.keywordsOfInterest());
        Iterator cit = alist.iterator();
        this.clients_ = new HashMap();
        while (cit.hasNext()) {
            ParserClient pc = (ParserClient)cit.next();
            Set<String> keys = pc.keywordsOfInterest();
            for (String key : keys) {
                ParserClient prev = this.clients_.put(key, pc);
                if (prev == null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.currClient_ = null;
    }

    public BioFabricNetwork getFabricNetwork() {
        return this.whiteBoard_.bfn;
    }

    @Override
    public void setContainer(Object container) {
        if (this.currClient_ != null) {
            this.currClient_.setContainer(container);
        }
    }

    @Override
    public boolean finishElement(String elemName) throws IOException {
        if (this.currClient_ == null) {
            return false;
        }
        if (this.currClient_.finishElement(elemName)) {
            this.currClient_ = null;
        }
        return this.allKeys_.contains(elemName);
    }

    @Override
    public void processCharacters(char[] chars, int start, int length) {
        if (this.currClient_ != null) {
            this.currClient_.processCharacters(chars, start, length);
        }
    }

    @Override
    public Set<String> keywordsOfInterest() {
        return this.allKeys_;
    }

    @Override
    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.currClient_ != null) {
            return this.currClient_.processElement(elemName, attrs);
        }
        ParserClient pc = this.clients_.get(elemName);
        if (pc != null) {
            this.currClient_ = pc;
            return this.currClient_.processElement(elemName, attrs);
        }
        return null;
    }

    public static class FactoryWhiteboard
    implements PluginWhiteboard {
        public UniqueLabeller ulb = new UniqueLabeller();
        public BioFabricNetwork bfn;
        public BioFabricNetwork.LinkInfo linkInfo;
        public BioFabricNetwork.NodeInfo nodeInfo;
        public BioFabricNetwork.DrainZone drainZone;
        public FabricColorGenerator fcg;
        public NamedColor currCol;
        public int colTarg = 0;
        public String groupTag;
        public FabricDisplayOptions displayOpts;
        public Map<String, NID.WithName> legacyMap = new HashMap<String, NID.WithName>();
        public Map<NID, NID.WithName> wnMap = new HashMap<NID, NID.WithName>();
        public Annot annot;
        public AnnotationSet currAnnots;
        public BioFabricToolPlugIn currPlugIn_;
        public BioFabricToolPlugInData currPlugInData_;

        public BioFabricToolPlugIn getCurrentPlugIn() {
            return this.currPlugIn_;
        }

        public void setCurrentPlugIn(BioFabricToolPlugIn pi) {
            this.currPlugIn_ = pi;
        }

        public BioFabricToolPlugInData getCurrentPlugInData() {
            return this.currPlugInData_;
        }

        public void setCurrentPlugInData(BioFabricToolPlugInData pid) {
            this.currPlugInData_ = pid;
        }
    }
}

