/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.systemsbiology.biofabric.api.io.BuildExtractor;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.LinkComparator;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildExtractorImpl
implements BuildExtractor {
    @Override
    public Set<NetNode> extractNodes(Collection<NetLink> allLinks, Set<NetNode> loneNodeIDs, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<NetNode> retval = new HashSet<NetNode>(loneNodeIDs);
        LoopReporter lr = new LoopReporter(allLinks.size(), 20, monitor, 0.0, 1.0, "progress.analyzingNodes");
        for (NetLink link : allLinks) {
            retval.add(link.getSrcNode());
            retval.add(link.getTrgNode());
            lr.report();
        }
        return retval;
    }

    @Override
    public void extractRelations(List<NetLink> allLinks, SortedMap<AugRelation, Boolean> relMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashSet<NetLink> flipSet = new HashSet<NetLink>();
        HashSet<AugRelation> flipRels = new HashSet<AugRelation>();
        HashSet<AugRelation> rels = new HashSet<AugRelation>();
        int size = allLinks.size();
        LoopReporter lr = new LoopReporter(size, 20, monitor, 0.0, 1.0, "progress.analyzingRelations");
        for (NetLink nextLink : allLinks) {
            lr.report();
            AugRelation relation = nextLink.getAugRelation();
            if (!nextLink.isFeedback()) {
                NetLink flipLink = nextLink.flipped();
                if (flipSet.contains(flipLink)) {
                    flipRels.add(relation);
                } else {
                    flipSet.add(nextLink);
                }
            }
            rels.add(relation);
        }
        Boolean noDir = new Boolean(false);
        Boolean haveDir = new Boolean(true);
        Iterator rit = rels.iterator();
        while (rit.hasNext()) {
            AugRelation rel;
            relMap.put(rel, flipRels.contains(rel = (AugRelation)rit.next()) ? haveDir : noDir);
        }
    }

    @Override
    public Map<String, NetNode> reduceNameSetToOne(Map<String, Set<NetNode>> mapsToSets) {
        HashMap<String, NetNode> retval = new HashMap<String, NetNode>();
        for (String nextName : mapsToSets.keySet()) {
            Set<NetNode> forName = mapsToSets.get(nextName);
            if (forName.size() != 1) {
                throw new IllegalStateException();
            }
            retval.put(nextName, forName.iterator().next());
        }
        return retval;
    }

    @Override
    public void assignDirections(List<NetLink> allLinks, Map<AugRelation, Boolean> relMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int numLink = allLinks.size();
        LoopReporter lr = new LoopReporter(numLink, 20, monitor, 0.0, 1.0, "progress.installDirections");
        for (NetLink nextLink : allLinks) {
            lr.report();
            AugRelation rel = nextLink.getAugRelation();
            Boolean isDir = relMap.get(rel);
            nextLink.installDirection(isDir);
        }
        lr.finish();
    }

    @Override
    public void preprocessLinks(List<NetLink> allLinks, Set<NetLink> retval, Set<NetLink> culled, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LinkComparator flc = new LinkComparator();
        int numLink = allLinks.size();
        LoopReporter lr = new LoopReporter(numLink, 20, monitor, 0.0, 1.0, "progress.cullingAndFlipping");
        for (NetLink nextLink : allLinks) {
            lr.report();
            if (retval.contains(nextLink)) {
                culled.add(nextLink);
                continue;
            }
            if (!nextLink.isDirected()) {
                if (!nextLink.isFeedback()) {
                    NetLink flipLink = nextLink.flipped();
                    if (retval.contains(flipLink)) {
                        if (flc.compare(nextLink, flipLink) < 0) {
                            retval.remove(flipLink);
                            culled.add(flipLink);
                            retval.add(nextLink);
                            continue;
                        }
                        culled.add(nextLink);
                        continue;
                    }
                    retval.add(nextLink);
                    continue;
                }
                retval.add(nextLink);
                continue;
            }
            retval.add(nextLink);
        }
    }

    @Override
    public void createNeighborLinkMap(Collection<NetLink> allLinks, Set<NetNode> loneNodeIDs, Map<NetNode, Set<NetNode>> nodeToNeighbors, Map<NetNode, Set<NetLink>> nodeToLinks, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(allLinks.size(), 20, monitor, 0.0, 1.0, "progress.generatingStructures");
        for (NetLink link : allLinks) {
            lr.report();
            NetNode src = link.getSrcNode();
            NetNode trg = link.getTrgNode();
            if (nodeToLinks.get(src) == null) {
                nodeToLinks.put(src, new HashSet());
            }
            if (nodeToLinks.get(trg) == null) {
                nodeToLinks.put(trg, new HashSet());
            }
            if (nodeToNeighbors.get(src) == null) {
                nodeToNeighbors.put(src, new HashSet());
            }
            if (nodeToNeighbors.get(trg) == null) {
                nodeToNeighbors.put(trg, new HashSet());
            }
            nodeToLinks.get(src).add(link);
            nodeToLinks.get(trg).add(link);
            nodeToNeighbors.get(src).add(trg);
            nodeToNeighbors.get(trg).add(src);
        }
        for (NetNode node : loneNodeIDs) {
            nodeToLinks.put(node, new HashSet());
            nodeToNeighbors.put(node, new HashSet());
        }
    }
}

