/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.systemsbiology.biofabric.analysis.Link;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.layout.DefaultLayout;
import org.systemsbiology.biofabric.api.layout.EdgeLayout;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.io.AttributeLoader;
import org.systemsbiology.biofabric.layouts.ControlTopLayout;
import org.systemsbiology.biofabric.layouts.HierDAGLayout;
import org.systemsbiology.biofabric.layouts.NodeClusterLayout;
import org.systemsbiology.biofabric.layouts.NodeSimilarityLayout;
import org.systemsbiology.biofabric.layouts.SetLayout;
import org.systemsbiology.biofabric.layouts.WorldBankLayout;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.plugin.PluginBuildData;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDataImpl
implements BuildData {
    private BuildMode mode_;
    public BioFabricNetwork fullNet;
    public List<BioFabricNetwork.NodeInfo> subNodes;
    public List<BioFabricNetwork.LinkInfo> subLinks;
    private BioFabricNetwork bfn_;
    private List<NetNode> existingIDOrder_;
    private Set<NetLink> allLinks_;
    private Set<NetNode> loneNodeIDs_;
    private Set<NetNode> allNodeIDs_;
    private SortedMap<Integer, NetLink> linkOrder_;
    private Map<NetNode, Integer> nodeOrder_;
    private Network.LayoutMode layoutMode_;
    private List<String> linkGroups_;
    private boolean showLinkGroupAnnotations_;
    private AnnotationSet nodeAnnotForLayout_;
    private Map<Boolean, AnnotationSet> linkAnnotsForLayout_;
    private FabricColorGenerator colGen_;
    public Map<NetNode, String> clustAssign;
    public UniqueLabeller idGen;
    public ControlTopLayout.CtrlMode cMode;
    public ControlTopLayout.TargMode tMode;
    public List<String> fixedOrder;
    public Map<String, Set<NetNode>> normNameToIDs;
    public Boolean pointUp;
    public SetLayout.LinkMeans linkMeaning;
    private boolean turnOnShadows_;
    private PluginBuildData plugInData_;

    public BuildDataImpl(BuildMode mode) {
        this.mode_ = mode;
        this.turnOnShadows_ = false;
    }

    public BuildDataImpl(BioFabricNetwork fullNet, List<BioFabricNetwork.NodeInfo> subNodes, List<BioFabricNetwork.LinkInfo> subLinks) {
        this(BuildMode.BUILD_FOR_SUBMODEL);
        this.fullNet = fullNet;
        this.subNodes = subNodes;
        this.subLinks = subLinks;
    }

    public BuildDataImpl(BioFabricNetwork bfn, BuildMode mode) {
        this(mode);
        this.bfn_ = bfn;
    }

    public BuildDataImpl(BioFabricNetwork fullNet, BuildMode mode, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this(mode);
        this.bfn_ = fullNet;
        this.allLinks_ = fullNet.getAllLinks(true);
        this.colGen_ = fullNet.getColorGenerator();
        this.nodeOrder_ = null;
        this.existingIDOrder_ = fullNet.existingIDOrder();
        this.linkOrder_ = null;
        this.linkGroups_ = fullNet.getLinkGrouping();
        this.loneNodeIDs_ = fullNet.getLoneNodes(monitor);
        this.allNodeIDs_ = fullNet.getAllNodeDefinitions().keySet();
        this.clustAssign = fullNet.nodeClustersAssigned() ? fullNet.nodeClusterAssigment() : null;
        this.layoutMode_ = fullNet.getLayoutMode();
        this.idGen = fullNet.getGenerator();
        this.nodeAnnotForLayout_ = null;
        this.linkAnnotsForLayout_ = null;
    }

    public BuildDataImpl(UniqueLabeller idGen, Set<NetLink> allLinks, Set<NetNode> loneNodeIDs, Map<NetNode, String> clustAssign, FabricColorGenerator colGen, BuildMode mode) {
        this(mode);
        this.bfn_ = null;
        this.allLinks_ = allLinks;
        this.colGen_ = colGen;
        this.nodeOrder_ = null;
        this.existingIDOrder_ = null;
        this.linkOrder_ = null;
        this.linkGroups_ = new ArrayList<String>();
        this.clustAssign = clustAssign;
        this.loneNodeIDs_ = loneNodeIDs;
        this.allNodeIDs_ = null;
        this.layoutMode_ = Network.LayoutMode.PER_NODE_MODE;
        this.idGen = idGen;
        this.nodeAnnotForLayout_ = null;
        this.linkAnnotsForLayout_ = null;
    }

    @Override
    public PluginBuildData getPluginBuildData() {
        return this.plugInData_;
    }

    @Override
    public void setPluginBuildData(PluginBuildData plugInData) {
        this.plugInData_ = plugInData;
    }

    @Override
    public Set<NetNode> getSingletonNodes() {
        return this.loneNodeIDs_;
    }

    @Override
    public Set<NetNode> getAllNodes() {
        return this.allNodeIDs_;
    }

    @Override
    public Set<NetLink> getLinks() {
        return this.allLinks_;
    }

    public void initAllNodesBogus(Set<NetNode> startSet) {
        this.allNodeIDs_ = startSet;
    }

    public void addToAllNodesBogus(NetNode node) {
        this.allNodeIDs_.add(node);
    }

    public BuildMode getMode() {
        return this.mode_;
    }

    public boolean canRestore() {
        return true;
    }

    public void setColorGen(FabricColorGenerator colGen) {
        this.colGen_ = colGen;
    }

    public FabricColorGenerator getColorGen() {
        return this.colGen_;
    }

    public Map<String, Set<NetNode>> genNormNameToID() {
        HashMap<String, Set<NetNode>> retval = new HashMap<String, Set<NetNode>>();
        for (NetNode nodeID : this.allNodeIDs_) {
            String name = nodeID.getName();
            String nameNorm = DataUtil.normKey(name);
            Set<NetNode> forName = retval.get(nameNorm);
            if (forName == null) {
                forName = new HashSet<NetNode>();
                retval.put(nameNorm, forName);
            }
            forName.add(nodeID);
        }
        return retval;
    }

    public void setNodeOrderFromAttrib(Map<AttributeKey, String> nodeOrderIn) {
        this.nodeOrder_ = new HashMap<NetNode, Integer>();
        Map<String, Set<NetNode>> nameToID = this.genNormNameToID();
        for (AttributeKey key : nodeOrderIn.keySet()) {
            try {
                Integer newRow = Integer.valueOf(nodeOrderIn.get(key));
                String keyName = ((AttributeLoader.StringKey)key).key;
                String normName = DataUtil.normKey(keyName);
                Set<NetNode> ids = nameToID.get(normName);
                if (ids.size() != 1) {
                    throw new IllegalStateException();
                }
                NetNode id = ids.iterator().next();
                this.nodeOrder_.put(id, newRow);
            }
            catch (NumberFormatException nfex) {
                throw new IllegalStateException();
            }
        }
    }

    public BioFabricNetwork getExistingNetwork() {
        return this.bfn_;
    }

    public NetNode getNodeIDForRowForNetwork(int intval) {
        return this.bfn_.getNodeIDForRow(intval);
    }

    public int getRowCountForNetwork() {
        return this.bfn_.getRowCount();
    }

    public List<NetNode> getExistingIDOrder() {
        return this.existingIDOrder_;
    }

    @Override
    public Map<NetNode, Integer> getNodeOrder() {
        return this.nodeOrder_;
    }

    @Override
    public SortedMap<Integer, NetLink> getLinkOrder() {
        return this.linkOrder_;
    }

    @Override
    public void setNodeOrder(Map<NetNode, Integer> nodeOrder) {
        this.nodeOrder_ = nodeOrder;
    }

    @Override
    public void setLinkOrder(SortedMap<Integer, NetLink> linkOrder) {
        this.linkOrder_ = linkOrder;
    }

    @Override
    public void setNodeAnnotations(AnnotationSet annots) {
        this.nodeAnnotForLayout_ = annots;
    }

    @Override
    public void setLinkAnnotations(Map<Boolean, AnnotationSet> annots) {
        this.linkAnnotsForLayout_ = annots;
    }

    @Override
    public AnnotationSet getNodeAnnotations() {
        return this.nodeAnnotForLayout_;
    }

    @Override
    public Map<Boolean, AnnotationSet> getLinkAnnotations() {
        return this.linkAnnotsForLayout_;
    }

    @Override
    public void setGroupOrderAndMode(List<String> groupOrder, Network.LayoutMode mode, boolean showLinkGroupAnnotations) {
        this.linkGroups_ = groupOrder;
        this.layoutMode_ = mode;
        this.showLinkGroupAnnotations_ = showLinkGroupAnnotations;
    }

    @Override
    public void setLayoutMode(Network.LayoutMode mode) {
        this.layoutMode_ = mode;
    }

    @Override
    public List<String> getGroupOrder() {
        return this.linkGroups_;
    }

    @Override
    public Network.LayoutMode getGroupOrderMode() {
        return this.layoutMode_;
    }

    @Override
    public boolean getShowLinkGroupAnnotations() {
        UiUtil.fixMePrintout("Not propagating into layout operation correctly");
        return this.showLinkGroupAnnotations_;
    }

    public void setCTL(ControlTopLayout.CtrlMode cMode, ControlTopLayout.TargMode tMode, List<String> fixedOrder, BioFabricNetwork bfn) {
        this.normNameToIDs = fixedOrder == null ? null : bfn.getNormNameToIDs();
        this.cMode = cMode;
        this.tMode = tMode;
        this.fixedOrder = fixedOrder;
    }

    public void setPointUp(Boolean pointUp) {
        this.pointUp = pointUp;
    }

    public void setLinkMeaning(SetLayout.LinkMeans linkMeaning) {
        this.linkMeaning = linkMeaning;
    }

    @Override
    public boolean getTurnOnShadows() {
        return this.turnOnShadows_;
    }

    @Override
    public void setTurnOnShadows(boolean turnOn) {
        this.turnOnShadows_ = turnOn;
    }

    @Override
    public boolean needsLayoutForRelayout() {
        switch (this.mode_) {
            case DEFAULT_LAYOUT: 
            case WORLD_BANK_LAYOUT: 
            case CONTROL_TOP_LAYOUT: 
            case HIER_DAG_LAYOUT: 
            case SET_LAYOUT: 
            case REORDER_LAYOUT: 
            case CLUSTERED_LAYOUT: 
            case NODE_CLUSTER_LAYOUT: {
                return true;
            }
            case NODE_ATTRIB_LAYOUT: 
            case LINK_ATTRIB_LAYOUT: 
            case GROUP_PER_NODE_CHANGE: 
            case GROUP_PER_NETWORK_CHANGE: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public NodeLayout getNodeLayout() {
        NodeLayout nlp;
        if (this.plugInData_ != null && (nlp = this.plugInData_.getNodeLayout()) != null) {
            return nlp;
        }
        switch (this.mode_) {
            case DEFAULT_LAYOUT: 
            case BUILD_FROM_SIF: {
                return new DefaultLayout();
            }
            case WORLD_BANK_LAYOUT: {
                return new WorldBankLayout();
            }
            case REORDER_LAYOUT: 
            case CLUSTERED_LAYOUT: {
                return new NodeSimilarityLayout();
            }
            case NODE_CLUSTER_LAYOUT: {
                return new NodeClusterLayout();
            }
            case CONTROL_TOP_LAYOUT: {
                return new ControlTopLayout(this.cMode, this.tMode, this.fixedOrder, this.normNameToIDs);
            }
            case HIER_DAG_LAYOUT: {
                return new HierDAGLayout(this.pointUp);
            }
            case SET_LAYOUT: {
                return new SetLayout(this.linkMeaning);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public EdgeLayout getEdgeLayout() {
        EdgeLayout elp;
        if (this.plugInData_ != null && (elp = this.plugInData_.getEdgeLayout()) != null) {
            return elp;
        }
        switch (this.mode_) {
            case SET_LAYOUT: 
            case REORDER_LAYOUT: 
            case CLUSTERED_LAYOUT: 
            case NODE_CLUSTER_LAYOUT: {
                return null;
            }
            case HIER_DAG_LAYOUT: {
                return new HierDAGLayout.EdgeLayout();
            }
        }
        return new DefaultEdgeLayout();
    }

    static class DoubleRanked {
        double rank;
        String id;
        Link byLink;

        DoubleRanked(double rank, String id, Link byLink) {
            this.rank = rank;
            this.id = id;
            this.byLink = byLink;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuildMode {
        DEFAULT_LAYOUT,
        REORDER_LAYOUT,
        CLUSTERED_LAYOUT,
        SHADOW_LINK_CHANGE,
        GROUP_PER_NODE_CHANGE,
        BUILD_FOR_SUBMODEL,
        BUILD_FROM_XML,
        BUILD_FROM_SIF,
        NODE_ATTRIB_LAYOUT,
        LINK_ATTRIB_LAYOUT,
        NODE_CLUSTER_LAYOUT,
        CONTROL_TOP_LAYOUT,
        HIER_DAG_LAYOUT,
        WORLD_BANK_LAYOUT,
        SET_LAYOUT,
        GROUP_PER_NETWORK_CHANGE,
        BUILD_FROM_PLUGIN;

    }
}

