/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.util.DataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLoader {
    public String readAttributes(File infile, boolean forNodes, Map<AttributeKey, String> results, Map<String, NetNode> nodes, ReadStats stats) throws IOException {
        Pattern nodePat = Pattern.compile("(.*)=(.*)");
        Pattern linkPat = Pattern.compile("(.*\\S) (.*)\\((.*)\\) (\\S.*)=(.*)");
        Matcher mainMatch = forNodes ? nodePat.matcher("") : linkPat.matcher("");
        String retval = null;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));
        String line = null;
        boolean isFirst = true;
        while ((line = in.readLine()) != null) {
            NetNode trgID;
            NetNode srcID;
            FabricLink nextLink;
            if (isFirst) {
                isFirst = false;
                retval = line.trim();
                continue;
            }
            if (line.trim().equals("")) continue;
            mainMatch.reset(line);
            if (!mainMatch.matches()) {
                stats.badLines.add(line);
                continue;
            }
            if (forNodes) {
                String node = mainMatch.group(1).trim().toUpperCase();
                if (node.indexOf("\"") == 0 && node.lastIndexOf("\"") == node.length() - 1) {
                    node = node.replaceAll("\"", "");
                }
                if (results.containsKey(node)) {
                    stats.dupLines.add(line);
                    continue;
                }
                results.put(new StringKey(node), mainMatch.group(2).trim());
                continue;
            }
            String src = mainMatch.group(1).trim();
            String sha = mainMatch.group(2).trim();
            String rel = mainMatch.group(3).trim();
            String trg = mainMatch.group(4).trim();
            boolean isShadow = sha.equals("shdw");
            if (isShadow) {
                stats.shadowsPresent = true;
            }
            if (results.containsKey(nextLink = new FabricLink(srcID = nodes.get(DataUtil.normKey(src)), trgID = nodes.get(DataUtil.normKey(trg)), rel, isShadow))) {
                stats.dupLines.add(line);
                continue;
            }
            results.put(nextLink, mainMatch.group(5).trim());
        }
        in.close();
        return retval;
    }

    public static class ReadStats {
        public ArrayList<String> dupLines;
        public ArrayList<String> badLines = new ArrayList();
        public boolean shadowsPresent;

        public ReadStats() {
            this.dupLines = new ArrayList();
        }
    }

    public static class StringKey
    implements AttributeKey {
        public String key;

        public StringKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public int hashCode() {
            return this.key.toUpperCase().hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof StringKey)) {
                return false;
            }
            StringKey otherT = (StringKey)other;
            return DataUtil.normKey(this.key).equals(DataUtil.normKey(otherT.key));
        }
    }
}

