/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.event;

import java.util.HashSet;
import org.systemsbiology.biofabric.event.LayoutChangeEvent;
import org.systemsbiology.biofabric.event.LayoutChangeListener;
import org.systemsbiology.biofabric.event.SelectionChangeEvent;
import org.systemsbiology.biofabric.event.SelectionChangeListener;

public class EventManager {
    private static EventManager singleton_;
    private HashSet layoutListeners_ = new HashSet();
    private HashSet selectListeners_ = new HashSet();

    public void addLayoutChangeListener(LayoutChangeListener lcl) {
        this.layoutListeners_.add(lcl);
    }

    public void removeLayoutChangeListener(LayoutChangeListener lcl) {
        this.layoutListeners_.remove(lcl);
    }

    public void sendLayoutChangeEvent(LayoutChangeEvent lcev) {
        for (LayoutChangeListener lcl : this.layoutListeners_) {
            lcl.layoutHasChanged(lcev);
        }
    }

    public void addSelectionChangeListener(SelectionChangeListener scl) {
        this.selectListeners_.add(scl);
    }

    public void removeSelectionChangeListener(SelectionChangeListener scl) {
        this.selectListeners_.remove(scl);
    }

    public void sendSelectionChangeEvent(SelectionChangeEvent scev) {
        for (SelectionChangeListener scl : this.selectListeners_) {
            scl.selectionHasChanged(scev);
        }
    }

    public static synchronized EventManager getManager() {
        if (singleton_ == null) {
            singleton_ = new EventManager();
        }
        return singleton_;
    }

    private EventManager() {
    }
}

