/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.cmd;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Point2D;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.cmd.ZoomChangeTracker;
import org.systemsbiology.biofabric.cmd.ZoomTarget;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.util.UiUtil;

public class ZoomCommandSupport {
    private ZoomTarget sup_;
    private JScrollPane jsp_;
    private double[] zoomVals_;
    private int[] zooms_;
    private int currZoomIndex_;
    private double customZoom_;
    private ZoomResult fullModelZoom_;
    private Dimension currViewSize_;
    private double currViewXFrac_;
    private double currViewYFrac_;
    private ZoomChangeTracker tracker_;

    public ZoomCommandSupport(ZoomChangeTracker tracker) {
        this.tracker_ = tracker;
    }

    public void setZoomLevels(int[] zooms) {
        this.zooms_ = zooms;
    }

    public int[] getZoomLevels() {
        return this.zooms_;
    }

    public void setZoomPoints(double[] zoomVals) {
        this.zoomVals_ = zoomVals;
        this.currZoomIndex_ = 0;
        this.customZoom_ = 0.0;
        this.fullModelZoom_ = null;
    }

    public int[] getZoomIndices() {
        int len = this.zoomVals_ == null ? 0 : this.zoomVals_.length;
        int[] retval = new int[len];
        for (int i = 0; i < len; ++i) {
            retval[i] = i;
        }
        return retval;
    }

    public void registerScrollPaneAndZoomTarget(JScrollPane jsp, ZoomTarget sup) {
        this.jsp_ = jsp;
        this.sup_ = sup;
        jsp.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                try {
                    ZoomCommandSupport.this.handlePanelResize();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ChangeListener barChange = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    ZoomCommandSupport.this.trackScrollBars();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        };
        HierarchyListener hChange = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                try {
                    if (e.getID() == 1400 && (e.getChangeFlags() & 4L) != 0L) {
                        ZoomCommandSupport.this.checkBarVisible();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        };
        JScrollBar vsb = jsp.getVerticalScrollBar();
        vsb.getModel().addChangeListener(barChange);
        vsb.addHierarchyListener(hChange);
        JScrollBar hsb = jsp.getHorizontalScrollBar();
        hsb.getModel().addChangeListener(barChange);
        hsb.addHierarchyListener(hChange);
    }

    private ZoomResult calcOptimalZoom(Rectangle chosen, Dimension allDim) {
        int retval;
        Dimension dim = chosen == null ? this.sup_.getBasicSize() : new Dimension(chosen.width, chosen.height);
        int vIndex = -1;
        int hIndex = -1;
        if (this.zoomVals_ != null) {
            double modelWidth;
            double zoom;
            double modelHeight;
            int i;
            for (i = 0; i < this.zoomVals_.length && (modelHeight = (double)dim.height * (zoom = this.zoomVals_[i])) <= (double)allDim.height; ++i) {
                ++vIndex;
            }
            for (i = 0; i < this.zoomVals_.length && (modelWidth = (double)dim.width * (zoom = this.zoomVals_[i])) <= (double)allDim.width; ++i) {
                ++hIndex;
            }
        }
        int n = retval = vIndex < hIndex ? vIndex : hIndex;
        if (retval == -1) {
            double vZoom = (double)allDim.height / (double)dim.height;
            double hZoom = (double)allDim.width / (double)dim.width;
            double useZoom = vZoom > hZoom ? hZoom : vZoom;
            return new ZoomResult(useZoom);
        }
        retval = retval > this.zoomVals_.length - 1 ? this.zoomVals_.length - 1 : retval;
        return new ZoomResult(retval);
    }

    private void doZoom(double newZoomVal) {
        JViewport view = this.jsp_.getViewport();
        Point viewPos = view.getViewPosition();
        Dimension viewDim = view.getExtentSize();
        int vCenter = viewPos.y + viewDim.height / 2;
        int hCenter = viewPos.x + viewDim.width / 2;
        Point2D worldCenter = this.sup_.viewToWorld(new Point(hCenter, vCenter));
        this.sup_.setZoomFactor(newZoomVal, viewDim);
        Point newCenter = this.sup_.pointToViewport(new Point((int)Math.round(worldCenter.getX()), (int)Math.round(worldCenter.getY())));
        this.viewportUpdate(newCenter, viewDim);
    }

    private Point doBounding(int newH, int newV, JViewport view) {
        Dimension allDim = view.getViewSize();
        Dimension viewDim = view.getExtentSize();
        int delH = allDim.width - viewDim.width;
        int delV = allDim.height - viewDim.height;
        if (newH < 0) {
            newH = 0;
        } else if (delH > 0 && newH > delH) {
            newH = delH;
        }
        if (newV < 0) {
            newV = 0;
        } else if (delV > 0 && newV > delV) {
            newV = delV;
        }
        return new Point(newH, newV);
    }

    private void viewportUpdate(Point center, Dimension vDim) {
        JViewport view = this.jsp_.getViewport();
        view.setViewSize(this.sup_.getPreferredSize());
        int newV = center.y - vDim.height / 2;
        int newH = center.x - vDim.width / 2;
        view.setViewPosition(this.doBounding(newH, newV, view));
        view.invalidate();
        this.jsp_.validate();
    }

    private double getCurrentZoom() {
        return this.currZoomIndex_ == -1 ? this.customZoom_ : this.zoomVals_[this.currZoomIndex_];
    }

    public void bumpZoomWrapper(char direction) {
        this.bumpZoom(direction);
        double newZoomVal = this.getCurrentZoom();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
        this.doZoom(newZoomVal);
    }

    public void setZoomIndex(int index) {
        this.setCurrentZoom(new ZoomResult(index));
        double newZoomVal = this.getCurrentZoom();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
        this.doZoom(newZoomVal);
    }

    private void bumpZoom(char direction) {
        if (this.currZoomIndex_ < -1 || this.zoomVals_ == null || this.currZoomIndex_ >= this.zoomVals_.length) {
            return;
        }
        if (direction == '+') {
            if (this.currZoomIndex_ == -1) {
                this.setCurrentZoom(new ZoomResult(0));
            } else {
                if (this.zoomIsMax()) {
                    return;
                }
                this.setCurrentZoom(new ZoomResult(this.currZoomIndex_ + 1));
            }
        } else if (this.currZoomIndex_ == -1) {
            if (this.customZoom_ > this.fullModelZoom_.customZoom) {
                this.setCurrentZoom(this.fullModelZoom_);
            }
        } else if (this.currZoomIndex_ == 0) {
            if (this.fullModelZoom_ == null) {
                UiUtil.fixMePrintout("Seeing this as null after recolor while zoomed!!");
                UiUtil.fixMePrintout("And zoom out ");
                Rectangle bounds = this.sup_.getCurrentBasicBounds();
                Dimension vDim = this.jsp_.getViewport().getExtentSize();
                this.fullModelZoom_ = this.calcOptimalZoom(bounds, vDim);
            }
            this.setCurrentZoom(this.fullModelZoom_);
        } else {
            this.setCurrentZoom(new ZoomResult(this.currZoomIndex_ - 1));
        }
    }

    public boolean zoomIsFirstDefined() {
        return this.currZoomIndex_ == 0;
    }

    public boolean zoomIsMax() {
        return this.currZoomIndex_ == this.zoomVals_.length - 1;
    }

    public boolean canZoomOut() {
        if (this.currZoomIndex_ > 0) {
            return true;
        }
        if (this.currZoomIndex_ == 0 && this.zoomVals_ != null && this.zoomVals_.length > 0 && this.fullModelZoom_.customZoom < this.zoomVals_[0]) {
            return true;
        }
        return this.currZoomIndex_ == -1 && this.fullModelZoom_.customZoom < this.customZoom_;
    }

    private void setCurrentZoom(ZoomResult zres) {
        if (zres.doCustom) {
            this.customZoom_ = zres.customZoom;
            this.currZoomIndex_ = -1;
        } else {
            this.currZoomIndex_ = zres.index;
            this.customZoom_ = 0.0;
        }
    }

    public void zoomToRect(Rectangle bounds) {
        this.zoomToSelectedGutsGuts(bounds, true);
    }

    public void zoomToSelected() {
        Rectangle selected = this.sup_.getSelectedBounds();
        this.zoomToRect(selected);
    }

    public void centerOnRectangle(Rectangle centerRect) {
        this.centerOnSelectedGuts(centerRect);
    }

    public void centerOnSelected() {
        Rectangle selected = this.sup_.getSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    private void zoomToSelectedGutsGuts(Rectangle bounds, boolean doZoom) {
        if (bounds == null) {
            this.zoomToModel(false);
            return;
        }
        Rectangle wsBounds = this.sup_.getWorldRect();
        bounds = wsBounds.intersection(bounds);
        if (bounds.isEmpty()) {
            return;
        }
        Dimension vDim = this.jsp_.getViewport().getExtentSize();
        if (doZoom) {
            ZoomResult zres = this.calcOptimalZoom(bounds, vDim);
            this.setCurrentZoom(zres);
            this.sup_.setZoomFactor(this.getCurrentZoom(), vDim);
        }
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    private void centerOnSelectedGuts(Rectangle selected) {
        this.zoomToSelectedGutsGuts(selected, false);
    }

    public void centerToNextSelected() {
        this.sup_.incrementToNextSelection();
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    public void centerToPreviousSelected() {
        this.sup_.decrementToPreviousSelection();
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    public void zoomToCurrentSelected() {
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.zoomToRect(selected);
    }

    private Rectangle centeredUnion(Rectangle union, Point2D center) {
        int cenX = (int)Math.round(center.getX());
        int cenY = (int)Math.round(center.getY());
        int delmx = cenX - union.x;
        int delmy = cenY - union.y;
        int delpx = union.x + union.width - cenX;
        int delpy = union.y + union.height - cenY;
        int rX = delpx > delmx ? cenX - delpx : cenX - delmx;
        int rW = delpx > delmx ? 2 * delpx : 2 * delmx;
        int rY = delpy > delmy ? cenY - delpy : cenY - delmy;
        int rH = delpy > delmy ? 2 * delpy : 2 * delmy;
        return new Rectangle(rX, rY, rW, rH);
    }

    public void zoomToModel(boolean force) {
        Rectangle bounds = this.sup_.getCurrentBasicBounds();
        Dimension vDim = this.jsp_.getViewport().getExtentSize();
        if (this.fullModelZoom_ == null || force) {
            this.fullModelZoom_ = this.calcOptimalZoom(bounds, vDim);
        }
        this.setCurrentZoom(this.fullModelZoom_);
        this.sup_.setZoomFactor(this.getCurrentZoom(), vDim);
        ((BioFabricPanel)this.sup_).setFullModelViewPos(this.jsp_.getViewport().getViewPosition());
        ((BioFabricPanel)this.sup_).setFullModelExtent(vDim);
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    public void handlePanelResize() {
        JViewport view = this.jsp_.getViewport();
        Dimension viewExtent = view.getExtentSize();
        Dimension viewSize = view.getViewSize();
        Rectangle bounds = this.sup_.getCurrentBasicBounds();
        this.fullModelZoom_ = this.calcOptimalZoom(bounds, viewExtent);
        int currX = (int)Math.round(this.currViewXFrac_ * (double)viewSize.width - (double)viewExtent.width / 2.0);
        int currY = (int)Math.round(this.currViewYFrac_ * (double)viewSize.height - (double)viewExtent.height / 2.0);
        view.setViewPosition(this.doBounding(currX, currY, view));
        this.sup_.adjustWideZoomForSize(viewExtent);
        this.currViewSize_ = viewExtent;
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(true);
        }
    }

    public void trackScrollBars() {
        JViewport view = this.jsp_.getViewport();
        Dimension viewExtent = view.getExtentSize();
        if (this.currViewSize_ == null) {
            this.currViewSize_ = viewExtent;
        }
        if (viewExtent.equals(this.currViewSize_)) {
            Point viewPos = view.getViewPosition();
            int currX = viewPos.x + viewExtent.width / 2;
            int currY = viewPos.y + viewExtent.height / 2;
            Dimension viewSize = view.getViewSize();
            this.currViewXFrac_ = (double)currX / (double)viewSize.width;
            this.currViewYFrac_ = (double)currY / (double)viewSize.height;
        }
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(true);
        }
    }

    public void checkBarVisible() {
        JViewport view = this.jsp_.getViewport();
        this.currViewSize_ = view.getExtentSize();
    }

    private class ZoomResult {
        boolean doCustom;
        int index;
        double customZoom;

        ZoomResult(int index) {
            this.doCustom = false;
            this.index = index;
        }

        ZoomResult(double customZoom) {
            this.doCustom = true;
            this.customZoom = customZoom;
        }

        public String toString() {
            return this.doCustom ? "ZoomResult customZoom = " + this.customZoom : "ZoomResult indexed zoom = " + this.index;
        }
    }
}

