/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.cmd;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.systemsbiology.biofabric.api.io.AttributeKey;
import org.systemsbiology.biofabric.api.io.FileLoadFlows;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.app.BioFabricApplication;
import org.systemsbiology.biofabric.app.BioFabricWindow;
import org.systemsbiology.biofabric.cmd.HeadlessOracle;
import org.systemsbiology.biofabric.cmd.ZoomChangeTracker;
import org.systemsbiology.biofabric.event.EventManager;
import org.systemsbiology.biofabric.event.SelectionChangeEvent;
import org.systemsbiology.biofabric.event.SelectionChangeListener;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.io.FileLoadFlowsImpl;
import org.systemsbiology.biofabric.layouts.ControlTopLayout;
import org.systemsbiology.biofabric.layouts.NodeClusterLayout;
import org.systemsbiology.biofabric.layouts.NodeSimilarityLayout;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInCmd;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.ImageExporter;
import org.systemsbiology.biofabric.ui.dialogs.BreadthFirstLayoutDialog;
import org.systemsbiology.biofabric.ui.dialogs.ClusterLayoutSetupDialog;
import org.systemsbiology.biofabric.ui.dialogs.CompareNodesSetupDialog;
import org.systemsbiology.biofabric.ui.dialogs.ControlTopLayoutSetupDialog;
import org.systemsbiology.biofabric.ui.dialogs.DirectoryChooserDialog;
import org.systemsbiology.biofabric.ui.dialogs.ExportSettingsDialog;
import org.systemsbiology.biofabric.ui.dialogs.ExportSettingsPublishDialog;
import org.systemsbiology.biofabric.ui.dialogs.FabricDisplayOptionsDialog;
import org.systemsbiology.biofabric.ui.dialogs.FabricSearchDialog;
import org.systemsbiology.biofabric.ui.dialogs.LinkGroupingSetupDialog;
import org.systemsbiology.biofabric.ui.dialogs.NodeSimilarityLayoutSetupDialog;
import org.systemsbiology.biofabric.ui.dialogs.PointUpOrDownDialog;
import org.systemsbiology.biofabric.ui.dialogs.ReorderLayoutParamsDialog;
import org.systemsbiology.biofabric.ui.dialogs.SetRelationSemanticsDialog;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.ui.display.FabricMagnifyingTool;
import org.systemsbiology.biofabric.util.FileExtensionFilters;
import org.systemsbiology.biofabric.util.InvalidInputException;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;
import org.systemsbiology.biotapestry.biofabric.FabricCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSet
implements ZoomChangeTracker,
SelectionChangeListener,
FabricDisplayOptionsManager.DisplayOptionTracker {
    public static final int EMPTY_NETWORK = 0;
    public static final int CLOSE = 1;
    public static final int LOAD_FROM_SIF = 2;
    public static final int SEARCH = 3;
    public static final int ZOOM_OUT = 4;
    public static final int ZOOM_IN = 5;
    public static final int CLEAR_SELECTIONS = 6;
    public static final int SAVE_AS = 7;
    public static final int ZOOM_TO_MODEL = 8;
    public static final int ZOOM_TO_SELECTIONS = 9;
    public static final int PROPAGATE_DOWN = 10;
    public static final int ZOOM_TO_RECT = 11;
    public static final int CANCEL = 12;
    public static final int ZOOM_TO_CURRENT_SELECTION = 13;
    public static final int ADD_FIRST_NEIGHBORS = 14;
    public static final int BUILD_SELECT = 15;
    public static final int SET_DISPLAY_OPTIONS = 16;
    public static final int SET_LAYOUT = 17;
    public static final int TOGGLE_SHADOW_LINKS = 18;
    public static final int ABOUT = 25;
    public static final int CENTER_ON_NEXT_SELECTION = 26;
    public static final int CENTER_ON_PREVIOUS_SELECTION = 27;
    public static final int LAYOUT_NODES_VIA_ATTRIBUTES = 28;
    public static final int LAYOUT_LINKS_VIA_ATTRIBUTES = 29;
    public static final int LOAD_WITH_NODE_ATTRIBUTES = 30;
    public static final int LOAD_XML = 31;
    public static final int RELAYOUT_USING_CONNECTIVITY = 32;
    public static final int RELAYOUT_USING_SHAPE_MATCH = 33;
    public static final int SET_LINK_GROUPS = 34;
    public static final int COMPARE_NODES = 35;
    public static final int ZOOM_TO_CURRENT_MOUSE = 36;
    public static final int ZOOM_TO_CURRENT_MAGNIFY = 37;
    public static final int EXPORT_NODE_ORDER = 38;
    public static final int EXPORT_LINK_ORDER = 39;
    public static final int EXPORT_IMAGE = 40;
    public static final int EXPORT_IMAGE_PUBLISH = 41;
    public static final int PRINT = 42;
    public static final int DEFAULT_LAYOUT = 43;
    public static final int EXPORT_SELECTED_NODES = 44;
    public static final int SAVE = 45;
    public static final int LAYOUT_VIA_NODE_CLUSTER_ASSIGN = 46;
    public static final int PRINT_PDF = 47;
    public static final int SHOW_TOUR = 48;
    public static final int SHOW_NAV_PANEL = 49;
    public static final int LAYOUT_TOP_CONTROL = 50;
    public static final int HIER_DAG_LAYOUT = 51;
    public static final int WORLD_BANK_LAYOUT = 52;
    public static final int LOAD_WITH_EDGE_WEIGHTS = 53;
    public static final int LOAD_FROM_GW = 54;
    public static final int ADD_NODE_ANNOTATIONS = 55;
    public static final int ADD_LINK_ANNOTATIONS = 56;
    public static final int SET_PLUGIN_DIR = 57;
    public static final int GENERAL_PUSH = 1;
    public static final int ALLOW_NAV_PUSH = 2;
    private static HashMap<String, CommandSet> perClass_;
    private JFrame topWindow_;
    private BioFabricWindow bfw_;
    private BioFabricApplication bfa_;
    private BioFabricPanel bfp_;
    private PlugInManager pMan_;
    private boolean isAMac_;
    private boolean isForMain_;
    private boolean showNav_;
    private HashMap<Integer, ChecksForEnabled> withIcons_;
    private HashMap<Integer, ChecksForEnabled> noIcons_;
    private HashMap<String, ChecksForEnabled> plugInCmds_;
    private FabricColorGenerator colGen_;
    private FileLoadFlowsImpl flf_;

    public BioFabricWindow getBFW() {
        return this.bfw_;
    }

    public FileLoadFlows getFileLoader() {
        return this.flf_;
    }

    public boolean isAMac() {
        return this.isAMac_;
    }

    @Override
    public void selectionHasChanged(SelectionChangeEvent scev) {
        this.checkForChanges();
    }

    public void checkForChanges() {
        for (ChecksForEnabled cfe : this.withIcons_.values()) {
            cfe.checkIfEnabled();
        }
        for (ChecksForEnabled cfe : this.noIcons_.values()) {
            cfe.checkIfEnabled();
        }
        for (ChecksForEnabled cfe : this.plugInCmds_.values()) {
            cfe.checkIfEnabled();
        }
    }

    public void pushDisabled(int pushCondition) {
        for (ChecksForEnabled cfe : this.withIcons_.values()) {
            cfe.pushDisabled(pushCondition);
        }
        for (ChecksForEnabled cfe : this.noIcons_.values()) {
            cfe.pushDisabled(pushCondition);
        }
        for (ChecksForEnabled cfe : this.plugInCmds_.values()) {
            cfe.pushDisabled(pushCondition);
        }
    }

    public void popDisabled() {
        for (ChecksForEnabled cfe : this.withIcons_.values()) {
            cfe.popDisabled();
        }
        for (ChecksForEnabled cfe : this.noIcons_.values()) {
            cfe.popDisabled();
        }
        for (ChecksForEnabled cfe : this.plugInCmds_.values()) {
            cfe.popDisabled();
        }
    }

    @Override
    public void optionsHaveChanged(boolean needRebuild, boolean needRecolor) {
        if (!needRebuild && !needRecolor) {
            this.bfp_.repaint();
            return;
        }
        if (!this.bfp_.hasAModel()) {
            return;
        }
        if (needRecolor && !needRebuild) {
            this.flf_.doRecolor(this.isForMain_);
        } else if (needRebuild) {
            this.flf_.doDisplayOptionChange();
        }
    }

    public FabricColorGenerator getColorGenerator() {
        return this.colGen_;
    }

    public List<String> getPlugInKeys() {
        return this.pMan_.getOrderedToolPlugInKeys();
    }

    public BioFabricToolPlugIn getPlugIn(String key) {
        return this.pMan_.getToolPlugIn(key);
    }

    public Action getAction(int actionKey, boolean withIcon, Object[] optionArgs) {
        Integer actionKeyObject;
        HashMap<Integer, ChecksForEnabled> useMap = withIcon ? this.withIcons_ : this.noIcons_;
        ChecksForEnabled retval = useMap.get(actionKeyObject = Integer.valueOf(actionKey));
        if (retval != null) {
            return retval;
        }
        switch (actionKey) {
            case 25: {
                retval = new AboutAction(withIcon);
                break;
            }
            case 0: {
                retval = new EmptyNetworkAction(withIcon);
                break;
            }
            case 1: {
                retval = new CloseAction(withIcon);
                break;
            }
            case 31: {
                retval = new LoadXMLAction(withIcon);
                break;
            }
            case 2: {
                retval = new ImportSIFAction(withIcon, false);
                break;
            }
            case 53: {
                throw new IllegalArgumentException();
            }
            case 30: {
                retval = new LoadWithNodeAttributesAction(withIcon);
                break;
            }
            case 54: {
                retval = new ImportGWAction(withIcon);
                break;
            }
            case 7: {
                retval = new SaveAsAction(withIcon);
                break;
            }
            case 45: {
                retval = new SaveAction(withIcon);
                break;
            }
            case 38: {
                retval = new ExportNodeOrderAction(withIcon);
                break;
            }
            case 39: {
                retval = new ExportLinkOrderAction(withIcon);
                break;
            }
            case 44: {
                retval = new ExportSelectedNodesAction(withIcon);
                break;
            }
            case 40: {
                retval = new ExportSimpleAction(withIcon);
                break;
            }
            case 41: {
                retval = new ExportPublishAction(withIcon);
                break;
            }
            case 42: {
                retval = new PrintAction(withIcon);
                break;
            }
            case 47: {
                throw new IllegalArgumentException();
            }
            case 3: {
                retval = new SearchAction(withIcon);
                break;
            }
            case 5: {
                retval = new InOutZoomAction(withIcon, '+');
                break;
            }
            case 4: {
                retval = new InOutZoomAction(withIcon, '-');
                break;
            }
            case 6: {
                retval = new ClearSelectionsAction(withIcon);
                break;
            }
            case 8: {
                retval = new ZoomToModelAction(withIcon);
                break;
            }
            case 9: {
                retval = new ZoomToSelected(withIcon);
                break;
            }
            case 10: {
                retval = new PropagateDownAction(withIcon);
                break;
            }
            case 11: {
                retval = new ZoomToRect(withIcon);
                break;
            }
            case 12: {
                retval = new CancelAction(withIcon);
                break;
            }
            case 26: {
                retval = new CenterOnNextSelected(withIcon);
                break;
            }
            case 27: {
                retval = new CenterOnPreviousSelected(withIcon);
                break;
            }
            case 13: {
                retval = new ZoomToCurrentSelected(withIcon);
                break;
            }
            case 36: {
                retval = new ZoomToCurrentMouse(withIcon);
                break;
            }
            case 37: {
                retval = new ZoomToCurrentMagnify(withIcon);
                break;
            }
            case 14: {
                retval = new AddFirstNeighborsAction(withIcon);
                break;
            }
            case 15: {
                retval = new BuildSelectAction(withIcon);
                break;
            }
            case 16: {
                retval = new SetDisplayOptionsAction(withIcon);
                break;
            }
            case 28: {
                retval = new LayoutNodesViaAttributesAction(withIcon);
                break;
            }
            case 29: {
                retval = new LayoutLinksViaAttributesAction(withIcon);
                break;
            }
            case 32: {
                retval = new LayoutViaConnectivityAction(withIcon);
                break;
            }
            case 43: {
                retval = new DefaultLayoutAction(withIcon);
                break;
            }
            case 51: {
                retval = new HierDAGLayoutAction(withIcon);
                break;
            }
            case 17: {
                retval = new SetLayoutAction(withIcon);
                break;
            }
            case 18: {
                retval = new ToggleShadowLinks(withIcon);
                break;
            }
            case 33: {
                retval = new LayoutViaShapeMatchAction(withIcon);
                break;
            }
            case 34: {
                retval = new SetLinkGroupsAction(withIcon);
                break;
            }
            case 35: {
                retval = new CompareNodesAction(withIcon);
                break;
            }
            case 46: {
                retval = new LayoutViaNodeClusterAction(withIcon);
                break;
            }
            case 50: {
                retval = new LayoutTopControlAction(withIcon);
                break;
            }
            case 48: {
                retval = new ToggleShowTourAction(withIcon);
                break;
            }
            case 49: {
                retval = new ToggleShowNavPanelAction(withIcon);
                break;
            }
            case 52: {
                retval = new WorldBankLayoutAction(withIcon);
                break;
            }
            case 55: {
                retval = new AddNodeAnnotations(withIcon);
                break;
            }
            case 56: {
                retval = new AddLinkAnnotations(withIcon);
                break;
            }
            case 57: {
                retval = new SetPluginDirectory(withIcon);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        useMap.put(actionKeyObject, retval);
        return retval;
    }

    public Action getPluginAction(String plugin, int cmd) {
        String key = plugin + ":::" + cmd;
        ChecksForEnabled retval = this.plugInCmds_.get(key);
        if (retval != null) {
            return retval;
        }
        BioFabricToolPlugIn pi = this.pMan_.getToolPlugIn(plugin);
        BioFabricToolPlugInCmd pic = pi.getCommand(cmd);
        retval = new PlugInAction(pic);
        this.plugInCmds_.put(key, retval);
        return retval;
    }

    public void displayInvalidInputError(InvalidInputException iiex) {
        String outMsg;
        boolean haveLine;
        ResourceManager rMan = ResourceManager.getManager();
        String errKey = iiex.getErrorKey();
        boolean haveKey = errKey != null && !errKey.equals("BT_INPUT_ERROR_UNSPECIFIED");
        int lineno = iiex.getErrorLineNumber();
        boolean bl = haveLine = lineno != -1;
        if (haveKey && haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageForLineWithDesc");
            String keyedErr = rMan.getString("invalidInput." + errKey);
            outMsg = MessageFormat.format(format, lineno + 1, keyedErr);
        } else if (haveKey && !haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageWithDesc");
            String keyedErr = rMan.getString("invalidInput." + errKey);
            outMsg = MessageFormat.format(format, keyedErr);
        } else if (!haveKey && haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageForLine");
            outMsg = MessageFormat.format(format, lineno + 1);
        } else {
            outMsg = rMan.getString("fileRead.inputErrorMessage");
        }
        JOptionPane.showMessageDialog(this.topWindow_, outMsg, rMan.getString("fileRead.errorTitle"), 0);
    }

    public void setFabricPanel(BioFabricPanel bfp) {
        this.bfp_ = bfp;
        this.flf_.setFabricPanel(bfp);
    }

    @Override
    public void zoomStateChanged(boolean scrollOnly) {
        this.handleZoomButtons();
        this.bfw_.getOverview().setViewInWorld(this.bfp_.getViewInWorld());
    }

    public void handleZoomButtons() {
        InOutZoomAction zaOutWI = (InOutZoomAction)this.withIcons_.get(4);
        InOutZoomAction zaOutNI = (InOutZoomAction)this.noIcons_.get(4);
        InOutZoomAction zaInWI = (InOutZoomAction)this.withIcons_.get(5);
        InOutZoomAction zaInNI = (InOutZoomAction)this.noIcons_.get(5);
        if (!this.bfp_.hasAModel()) {
            zaOutWI.setConditionalEnabled(false);
            if (zaOutNI != null) {
                zaOutNI.setConditionalEnabled(false);
            }
            zaInWI.setConditionalEnabled(false);
            if (zaInNI != null) {
                zaInNI.setConditionalEnabled(false);
            }
            return;
        }
        boolean downOn = this.bfp_.getZoomController().canZoomOut();
        zaOutWI.setConditionalEnabled(downOn);
        if (zaOutNI != null) {
            zaOutNI.setConditionalEnabled(downOn);
        }
        boolean upOn = !this.bfp_.getZoomController().zoomIsMax();
        zaInWI.setConditionalEnabled(upOn);
        if (zaInNI != null) {
            zaInNI.setConditionalEnabled(upOn);
        }
    }

    public static synchronized CommandSet getCmds(String className) {
        if (perClass_ == null) {
            throw new IllegalStateException();
        }
        CommandSet fc = perClass_.get(className);
        if (fc == null) {
            throw new IllegalStateException();
        }
        return fc;
    }

    public static synchronized CommandSet initCmds(String className, BioFabricApplication bfa, BioFabricWindow topWindow, boolean isForMain, PlugInManager pMan, HeadlessOracle headlessOracle) {
        CommandSet fc;
        if (perClass_ == null) {
            perClass_ = new HashMap();
        }
        if ((fc = perClass_.get(className)) != null) {
            throw new IllegalStateException();
        }
        fc = new CommandSet(bfa, topWindow, isForMain, pMan, headlessOracle);
        perClass_.put(className, fc);
        return fc;
    }

    private CommandSet(BioFabricApplication bfa, BioFabricWindow bfw, boolean isMain, PlugInManager pMan, HeadlessOracle headlessOracle) {
        this.bfa_ = bfa;
        this.bfw_ = bfw;
        this.topWindow_ = bfw.getWindow();
        this.withIcons_ = new HashMap();
        this.noIcons_ = new HashMap();
        this.plugInCmds_ = new HashMap();
        this.colGen_ = new FabricColorGenerator();
        this.colGen_.newColorModel();
        this.isForMain_ = isMain;
        this.pMan_ = pMan;
        this.flf_ = new FileLoadFlowsImpl(this.bfw_, this.pMan_, this.colGen_, this, headlessOracle, isMain);
        this.isAMac_ = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        FabricDisplayOptionsManager.getMgr().addTracker(this);
        EventManager mgr = EventManager.getManager();
        mgr.addSelectionChangeListener(this);
    }

    public class AboutAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;
        private URL aboutURL_;
        private JEditorPane pane_;
        private JFrame frame_;
        private FixedJButton buttonB_;
        private URL gnuUrl_;
        private URL sunUrl_;

        AboutAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.About"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.About"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/About24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AboutMnem");
                this.putValue("MnemonicKey", mnem);
            }
            this.aboutURL_ = this.getClass().getResource("/org/systemsbiology/biofabric/license/about.html");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.frame_ != null) {
                    this.frame_.setExtendedState(0);
                    this.frame_.toFront();
                    return;
                }
                try {
                    this.pane_ = new JEditorPane(this.aboutURL_);
                }
                catch (IOException ioex) {
                    ExceptionHandler.getHandler().displayException(ioex);
                    return;
                }
                this.gnuUrl_ = this.getClass().getResource("/org/systemsbiology/biofabric/license/LICENSE");
                this.sunUrl_ = this.getClass().getResource("/org/systemsbiology/biofabric/license/LICENSE-SUN");
                ResourceManager rMan = ResourceManager.getManager();
                this.pane_.setEditable(false);
                this.frame_ = new JFrame(rMan.getString("window.aboutTitle"));
                this.pane_.addHyperlinkListener(new HyperlinkListener(){

                    public void hyperlinkUpdate(HyperlinkEvent ev) {
                        try {
                            if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                URL toUse = ev.getDescription().indexOf("-SUN") != -1 ? AboutAction.this.sunUrl_ : AboutAction.this.gnuUrl_;
                                AboutAction.this.pane_.setPage(toUse);
                                AboutAction.this.buttonB_.setEnabled(true);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                this.frame_.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        AboutAction.this.frame_ = null;
                        e.getWindow().dispose();
                    }
                });
                JPanel cp = (JPanel)this.frame_.getContentPane();
                cp.setBackground(Color.white);
                cp.setBorder(new EmptyBorder(20, 20, 20, 20));
                cp.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                JLabel label = new JLabel();
                UiUtil.gbcSet(gbc, 0, 0, 1, 3, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
                cp.add((Component)label, gbc);
                JScrollPane jsp = new JScrollPane(this.pane_);
                UiUtil.gbcSet(gbc, 0, 3, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
                cp.add((Component)jsp, gbc);
                this.buttonB_ = new FixedJButton(rMan.getString("dialogs.back"));
                this.buttonB_.setEnabled(false);
                this.buttonB_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            AboutAction.this.pane_.setPage(AboutAction.this.aboutURL_);
                            AboutAction.this.buttonB_.setEnabled(false);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.close"));
                buttonC.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            AboutAction.this.frame_.setVisible(false);
                            AboutAction.this.frame_.dispose();
                            AboutAction.this.frame_ = null;
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                Box buttonPanel = Box.createHorizontalBox();
                buttonPanel.add(Box.createHorizontalGlue());
                buttonPanel.add(this.buttonB_);
                buttonPanel.add(Box.createHorizontalStrut(10));
                buttonPanel.add(buttonC);
                UiUtil.gbcSet(gbc, 0, 5, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
                cp.add((Component)buttonPanel, gbc);
                this.frame_.setSize(700, 700);
                this.frame_.setLocationRelativeTo(CommandSet.this.topWindow_);
                this.frame_.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class PlugInAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;
        private BioFabricToolPlugInCmd cmd_;

        PlugInAction(BioFabricToolPlugInCmd cmd) {
            this.cmd_ = cmd;
            this.putValue("Name", this.cmd_.getCommandName());
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.cmd_.performOperation(CommandSet.this.topWindow_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return this.cmd_.isEnabled();
        }
    }

    private class SetDisplayOptionsAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        SetDisplayOptionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SetDisplayOpts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SetDisplayOpts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SetDisplayOptsMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FabricDisplayOptionsDialog dod = new FabricDisplayOptionsDialog(CommandSet.this.topWindow_);
                dod.setVisible(true);
                if (dod.haveResult()) {
                    FabricDisplayOptionsManager dopmgr = FabricDisplayOptionsManager.getMgr();
                    dopmgr.setDisplayOptions(dod.getNewOpts(), dod.needsRebuild(), dod.needsRecolor());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class EmptyNetworkAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        EmptyNetworkAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.EmptyNet"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.EmptyNet"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.EmptyNetMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.flf_.manageWindowTitle(null);
                CommandSet.this.flf_.buildEmptyNetwork();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ExportPublishAction
    extends ExportImageAction {
        private static final long serialVersionUID = 1L;

        ExportPublishAction(boolean doIcon) {
            super(doIcon, "command.ExportPublish", "command.ExportPublishMnem");
        }

        protected ExportSettingsDialog.ExportSettings getExportSettings() {
            Rectangle wr = CommandSet.this.bfp_.getRequiredSize();
            ExportSettingsPublishDialog esd = new ExportSettingsPublishDialog(CommandSet.this.topWindow_, wr.width, wr.height);
            esd.setVisible(true);
            ExportSettingsDialog.ExportSettings set = esd.getResults();
            return set;
        }
    }

    private class ExportSimpleAction
    extends ExportImageAction {
        private static final long serialVersionUID = 1L;

        ExportSimpleAction(boolean doIcon) {
            super(doIcon, "command.Export", "command.ExportMnem");
        }

        protected ExportSettingsDialog.ExportSettings getExportSettings() {
            Rectangle wr = CommandSet.this.bfp_.getRequiredSize();
            ExportSettingsDialog esd = new ExportSettingsDialog(CommandSet.this.topWindow_, wr.width, wr.height);
            esd.setVisible(true);
            ExportSettingsDialog.ExportSettings set = esd.getResults();
            return set;
        }
    }

    private abstract class ExportImageAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ExportImageAction(boolean doIcon, String res, String mnemStr) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(res));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(res));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(mnemStr);
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected abstract ExportSettingsDialog.ExportSettings getExportSettings();

        public boolean performOperation(Object[] args) {
            ExportSettingsDialog.ExportSettings set;
            if (args == null) {
                set = this.getExportSettings();
                if (set == null) {
                    return true;
                }
            } else {
                set = (ExportSettingsDialog.ExportSettings)args[0];
            }
            File file = null;
            OutputStream stream = null;
            if (args == null) {
                List<String> supported = ImageExporter.getSupportedFileSuffixes();
                String filename = FabricCommands.getPreference("ExportDirectory");
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.MultiExtensionFilter(supported, "filterName.img"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(CommandSet.this.topWindow_)) != 0) {
                        return true;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!file.exists()) {
                        List<String> suffs = ImageExporter.getFileSuffixesForType(set.formatType);
                        if (!FileExtensionFilters.hasASuffix(file.getName(), ".", suffs)) {
                            file = new File(file.getAbsolutePath() + "." + ImageExporter.getPreferredSuffixForType(set.formatType));
                        }
                    }
                    if (CommandSet.this.flf_.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
            } else if (((Boolean)args[1]).booleanValue()) {
                file = new File((String)args[2]);
                if (!CommandSet.this.flf_.standardFileChecks(file, false, true, true, false, true, false)) {
                    return false;
                }
            } else {
                stream = (OutputStream)args[2];
            }
            try {
                if (file != null) {
                    CommandSet.this.bfp_.exportToFile(file, set.formatType, set.res, set.zoomVal, set.size);
                } else {
                    CommandSet.this.bfp_.exportToStream(stream, set.formatType, set.res, set.zoomVal, set.size);
                }
                if (args == null) {
                    FabricCommands.setPreference("ExportDirectory", file.getAbsoluteFile().getParent());
                }
            }
            catch (IOException ioe) {
                CommandSet.this.flf_.displayFileOutputError();
                return false;
            }
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class PrintAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        PrintAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Print"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Print"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Print24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PrintMnem");
                this.putValue("MnemonicKey", mnem);
            }
            char accel = rMan.getChar("command.PrintAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PrinterJob pj = PrinterJob.getPrinterJob();
                PageFormat pf = pj.defaultPage();
                pf.setOrientation(0);
                pj.setPrintable(CommandSet.this.bfp_, pf);
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pex) {
                        System.err.println(pex);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportSelectedNodesAction
    extends ExportOrderAction {
        private static final long serialVersionUID = 1L;

        ExportSelectedNodesAction(boolean doIcon) {
            super(doIcon, "command.ExportSelectedNodes", "command.ExportSelectedNodesMnem");
        }

        @Override
        protected FileFilter getFilter() {
            return new FileExtensionFilters.SimpleFilter(".txt", "filterName.txt");
        }

        @Override
        protected List<String> getSuffixList() {
            ArrayList<String> cand = new ArrayList<String>();
            cand.add(".txt");
            return cand;
        }

        @Override
        protected String getPrefSuffix() {
            return ".txt";
        }

        @Override
        protected void writeItOut(File file) throws IOException {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            Set<NetNode> sels = CommandSet.this.bfp_.getNodeSelections();
            for (NetNode node : sels) {
                out.println(node.getName());
            }
            out.close();
        }

        @Override
        protected boolean checkGuts() {
            return super.checkGuts() && !CommandSet.this.bfp_.getNodeSelections().isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportLinkOrderAction
    extends ExportOrderAction {
        private static final long serialVersionUID = 1L;

        ExportLinkOrderAction(boolean doIcon) {
            super(doIcon, "command.ExportLinkOrder", "command.ExportLinkOrderMnem");
        }

        @Override
        protected FileFilter getFilter() {
            return new FileExtensionFilters.DoubleExtensionFilter(".eda", ".ea", "filterName.eda");
        }

        @Override
        protected List<String> getSuffixList() {
            ArrayList<String> cand = new ArrayList<String>();
            cand.add(".eda");
            cand.add(".ea");
            return cand;
        }

        @Override
        protected String getPrefSuffix() {
            return ".eda";
        }

        @Override
        protected void writeItOut(File file) throws IOException {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            CommandSet.this.bfp_.getNetwork().writeEDA(out);
            out.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportNodeOrderAction
    extends ExportOrderAction {
        private static final long serialVersionUID = 1L;

        ExportNodeOrderAction(boolean doIcon) {
            super(doIcon, "command.ExportNodeOrder", "command.ExportNodeOrderMnem");
        }

        @Override
        protected FileFilter getFilter() {
            return new FileExtensionFilters.DoubleExtensionFilter(".noa", ".na", "filterName.noa");
        }

        @Override
        protected List<String> getSuffixList() {
            ArrayList<String> cand = new ArrayList<String>();
            cand.add(".noa");
            cand.add(".na");
            return cand;
        }

        @Override
        protected String getPrefSuffix() {
            return ".noa";
        }

        @Override
        protected void writeItOut(File file) throws IOException {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            CommandSet.this.bfp_.getNetwork().writeNOA(out);
            out.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ExportOrderAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ExportOrderAction(boolean doIcon, String name, String mnemStr) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(name));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(name));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(mnemStr);
                this.putValue("MnemonicKey", mnem);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected abstract FileFilter getFilter();

        protected abstract List<String> getSuffixList();

        protected abstract String getPrefSuffix();

        protected abstract void writeItOut(File var1) throws IOException;

        public boolean performOperation(Object[] args) {
            File file = null;
            String dirName = FabricCommands.getPreference("AttribDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                FileFilter sf = this.getFilter();
                chooser.addChoosableFileFilter(sf);
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setFileFilter(sf);
                chooser.addChoosableFileFilter(this.getFilter());
                if (dirName != null && (startDir = new File(dirName)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showSaveDialog(CommandSet.this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) continue;
                if (!file.exists()) {
                    List<String> cand = this.getSuffixList();
                    if (!FileExtensionFilters.hasASuffix(file.getName(), "", cand)) {
                        file = new File(file.getAbsolutePath() + this.getPrefSuffix());
                    }
                }
                if (CommandSet.this.flf_.standardFileChecks(file, false, true, true, false, true, false)) continue;
                file = null;
            }
            try {
                this.writeItOut(file);
            }
            catch (IOException ioe) {
                CommandSet.this.flf_.displayFileOutputError();
                return false;
            }
            FabricCommands.setPreference("AttribDirectory", file.getAbsoluteFile().getParent());
            return true;
        }

        @Override
        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class SaveAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        SaveAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Save"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Save"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Save24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SaveMnem");
                this.putValue("MnemonicKey", mnem);
            }
            char accel = rMan.getChar("command.SaveAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.flf_.saveToCurrentFile();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class SaveAsAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        SaveAsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SaveAs"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SaveAs"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/SaveAs24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SaveAsMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            if (args == null) {
                return CommandSet.this.flf_.saveToFile(null);
            }
            if (((Boolean)args[0]).booleanValue()) {
                String fileName = (String)args[1];
                return CommandSet.this.flf_.saveToFile(fileName);
            }
            OutputStream stream = (OutputStream)args[1];
            BioFabricNetwork bfn = CommandSet.this.bfp_.getNetwork();
            if (bfn.getLinkCount(true) > 5000) {
                CommandSet.this.flf_.doBackgroundWrite(stream);
                return true;
            }
            try {
                CommandSet.this.flf_.saveToOutputStream(stream, false, null);
                return true;
            }
            catch (AsynchExitRequestException aeex) {
                return false;
            }
            catch (IOException ioe) {
                CommandSet.this.flf_.displayFileOutputError();
                return false;
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class LoadWithNodeAttributesAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        LoadWithNodeAttributesAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.LoadSIFWithNodeAttributes"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.LoadSIFWithNodeAttributes"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.LoadSIFWithNodeAttributesMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            File file = null;
            String filename = FabricCommands.getPreference("LoadDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                FileExtensionFilters.SimpleFilter sf = new FileExtensionFilters.SimpleFilter(".sif", "filterName.sif");
                chooser.addChoosableFileFilter(sf);
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setFileFilter(sf);
                if (filename != null && (startDir = new File(filename)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showOpenDialog(CommandSet.this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) {
                    return true;
                }
                if (CommandSet.this.flf_.standardFileChecks(file, true, false, false, false, false, true)) continue;
                file = null;
            }
            File attribFile = CommandSet.this.flf_.getTheFile(".noa", ".na", "AttribDirectory", "filterName.noa", null);
            if (attribFile == null) {
                return true;
            }
            Map<AttributeKey, String> attribs = CommandSet.this.flf_.loadTheFile(attribFile, null, true);
            if (attribs == null) {
                return true;
            }
            FileLoadFlows.FileLoadResult flr = CommandSet.this.flf_.loadFromASource(file, attribs, null, new UniqueLabeller(), FileLoadFlows.FileLoadType.SIF, false);
            return flr.getSuccess();
        }
    }

    private class LoadXMLAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        LoadXMLAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.LoadXML"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.LoadXML"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.LoadXMLMnem");
                this.putValue("MnemonicKey", mnem);
            }
            char accel = rMan.getChar("command.LoadXMLAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            File holdIt;
            File file = null;
            String filename = FabricCommands.getPreference("LoadDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                FileExtensionFilters.SimpleFilter sf = new FileExtensionFilters.SimpleFilter(".bif", "filterName.bif");
                chooser.addChoosableFileFilter(sf);
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setFileFilter(sf);
                if (filename != null && (startDir = new File(filename)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showOpenDialog(CommandSet.this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) {
                    return true;
                }
                if (CommandSet.this.flf_.standardFileChecks(file, true, false, false, false, false, true)) continue;
                file = null;
            }
            try {
                holdIt = File.createTempFile("BioFabricHold", ".zip");
                holdIt.deleteOnExit();
            }
            catch (IOException ioex) {
                holdIt = null;
            }
            return CommandSet.this.flf_.loadXMLFromSource(file, holdIt);
        }
    }

    private class ImportGWAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ImportGWAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.LoadGW"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.LoadGW"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.LoadGWMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            File file = null;
            String filename = FabricCommands.getPreference("LoadDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                FileExtensionFilters.SimpleFilter sf = new FileExtensionFilters.SimpleFilter(".gw", "filterName.gw");
                chooser.addChoosableFileFilter(sf);
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setFileFilter(sf);
                if (filename != null && (startDir = new File(filename)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showOpenDialog(CommandSet.this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) {
                    return true;
                }
                if (CommandSet.this.flf_.standardFileChecks(file, true, false, false, false, false, true)) continue;
                file = null;
            }
            FileLoadFlows.FileLoadResult flr = CommandSet.this.flf_.loadFromASource(file, null, null, new UniqueLabeller(), FileLoadFlows.FileLoadType.GW, false);
            return flr.getSuccess();
        }
    }

    private class ImportSIFAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;
        private boolean doWeights_;

        ImportSIFAction(boolean doIcon, boolean doWeights) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(doWeights ? "command.LoadSIFWithWeights" : "command.LoadSIF"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(doWeights ? "command.LoadSIFWithWeights" : "command.LoadSIF"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(doWeights ? "command.LoadSIFWithWeightsMnem" : "command.LoadSIFMnem");
                this.putValue("MnemonicKey", mnem);
            }
            this.doWeights_ = doWeights;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            File file = null;
            String filename = FabricCommands.getPreference("LoadDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                FileExtensionFilters.SimpleFilter sf = new FileExtensionFilters.SimpleFilter(".sif", "filterName.sif");
                chooser.addChoosableFileFilter(sf);
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.setFileFilter(sf);
                if (filename != null && (startDir = new File(filename)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showOpenDialog(CommandSet.this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) {
                    return true;
                }
                if (CommandSet.this.flf_.standardFileChecks(file, true, false, false, false, false, true)) continue;
                file = null;
            }
            Integer magBins = this.doWeights_ ? Integer.valueOf(4) : null;
            FileLoadFlows.FileLoadResult flr = CommandSet.this.flf_.loadFromASource(file, null, magBins, new UniqueLabeller(), FileLoadFlows.FileLoadType.SIF, false);
            return flr.getSuccess();
        }
    }

    private class SetLinkGroupsAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        SetLinkGroupsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SetLinkGroups"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SetLinkGroups"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SetLinkGroupsMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            BuildDataImpl.BuildMode bmode;
            BioFabricNetwork bfn = CommandSet.this.bfp_.getNetwork();
            List<String> currentTags = bfn.getLinkGroups();
            boolean showGroupAnnot = bfn.getShowLinkGroupAnnotations();
            ArrayList<NetLink> links = new ArrayList<NetLink>(bfn.getAllLinks(true));
            TreeMap<AugRelation, Boolean> relMap = new TreeMap<AugRelation, Boolean>();
            try {
                PluginSupportFactory.getBuildExtractor().extractRelations(links, relMap, null);
            }
            catch (AsynchExitRequestException asynchExitRequestException) {
                // empty catch block
            }
            Set<AugRelation> allRelations = relMap.keySet();
            Network.LayoutMode currMode = bfn.getLayoutMode();
            LinkGroupingSetupDialog lgsd = new LinkGroupingSetupDialog(CommandSet.this.topWindow_, currentTags, showGroupAnnot, currMode, allRelations);
            lgsd.setVisible(true);
            if (!lgsd.haveResult()) {
                return false;
            }
            Network.LayoutMode mode = lgsd.getChosenMode();
            boolean showLinkAnnotations = lgsd.showLinkAnnotations();
            if (mode == Network.LayoutMode.PER_NODE_MODE) {
                bmode = BuildDataImpl.BuildMode.GROUP_PER_NODE_CHANGE;
            } else if (mode == Network.LayoutMode.PER_NETWORK_MODE) {
                bmode = BuildDataImpl.BuildMode.GROUP_PER_NETWORK_CHANGE;
            } else {
                throw new IllegalStateException();
            }
            CommandSet.this.flf_.doLinkGroupRelayout(bfn, lgsd.getGroups(), mode, showLinkAnnotations, bmode);
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class LayoutViaShapeMatchAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        LayoutViaShapeMatchAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.LayoutViaShapeMatch"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.LayoutViaShapeMatch"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.LayoutViaShapeMatchMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            ReorderLayoutParamsDialog clpd = new ReorderLayoutParamsDialog(CommandSet.this.topWindow_, new NodeSimilarityLayout.ResortParams());
            clpd.setVisible(true);
            if (!clpd.haveResult()) {
                return false;
            }
            CommandSet.this.flf_.doShapeMatchRelayout(clpd.getParams());
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class LayoutViaConnectivityAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        LayoutViaConnectivityAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.LayoutViaConnectivity"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.LayoutViaConnectivity"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.LayoutViaConnectivityMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private boolean performOperation(Object[] args) {
            NodeSimilarityLayoutSetupDialog clpd = new NodeSimilarityLayoutSetupDialog(CommandSet.this.topWindow_, new NodeSimilarityLayout.ClusterParams());
            clpd.setVisible(true);
            if (!clpd.haveResult()) {
                return false;
            }
            CommandSet.this.flf_.doConnectivityRelayout(clpd.getParams());
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private abstract class BasicLayoutAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;
        private BuildDataImpl.BuildMode bMode_;

        BasicLayoutAction(boolean doIcon, String nameTag, String mnemTag, BuildDataImpl.BuildMode bMode) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(nameTag));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(nameTag));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(mnemTag);
                this.putValue("MnemonicKey", mnem);
            }
            this.bMode_ = bMode;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.flf_.doBasicRelayout(this.bMode_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class DefaultLayoutAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        DefaultLayoutAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DefaultLayout"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DefaultLayout"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DefaultLayoutMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Set<NetNode> sels = CommandSet.this.bfp_.getNodeSelections();
                NetNode selNode = sels.size() == 1 ? sels.iterator().next() : null;
                BreadthFirstLayoutDialog bfl = new BreadthFirstLayoutDialog(CommandSet.this.topWindow_, selNode, CommandSet.this.bfw_.getFabricPanel().getNetwork());
                bfl.setVisible(true);
                if (bfl.haveResult()) {
                    NodeLayout.Params params = bfl.getParams();
                    CommandSet.this.flf_.doDefaultRelayout(params);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class WorldBankLayoutAction
    extends BasicLayoutAction {
        private static final long serialVersionUID = 1L;

        WorldBankLayoutAction(boolean doIcon) {
            super(doIcon, "command.WorldBankLayout", "command.WorldBankLayoutMnem", BuildDataImpl.BuildMode.WORLD_BANK_LAYOUT);
        }
    }

    private class ToggleShadowLinks
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ToggleShadowLinks(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ToggleShadowLinks"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ToggleShadowLinks"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/S24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ToggleShadowLinksMnem");
                this.putValue("MnemonicKey", mnem);
            }
            CommandSet.this.showNav_ = true;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (CommandSet.this.bfp_.getNetwork().getLinkCount(false) > 100000) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int keepGoing = JOptionPane.showConfirmDialog(CommandSet.this.topWindow_, rMan.getString("toggleShadow.bigFileLongTime"), rMan.getString("toggleShadow.bigFileLongTimeTitle"), 0);
                    if (keepGoing != 0) {
                        return;
                    }
                }
                FabricDisplayOptionsManager dopmgr = FabricDisplayOptionsManager.getMgr();
                FabricDisplayOptions dop = dopmgr.getDisplayOptions();
                FabricDisplayOptions newDop = dop.clone();
                newDop.setDisplayShadows(!dop.getDisplayShadows());
                dopmgr.setDisplayOptions(newDop, true, false);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class SetLayoutAction
    extends BasicLayoutAction {
        private static final long serialVersionUID = 1L;

        SetLayoutAction(boolean doIcon) {
            super(doIcon, "command.SetLayout", "command.SetLayoutMnem", BuildDataImpl.BuildMode.SET_LAYOUT);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                HashSet<String> rels = new HashSet<String>();
                Set<NetLink> links = CommandSet.this.bfp_.getNetwork().getAllLinks(false);
                for (NetLink link : links) {
                    rels.add(link.getRelation());
                }
                if (rels.size() != 1) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(CommandSet.this.topWindow_, rMan.getString("setLayout.oneRelationAllowed"), rMan.getString("setLayout.oneRelationAllowedTitle"), 2);
                    return;
                }
                SetRelationSemanticsDialog puodd = new SetRelationSemanticsDialog(CommandSet.this.topWindow_, (String)rels.iterator().next());
                puodd.setVisible(true);
                if (puodd.haveResult()) {
                    CommandSet.this.flf_.doSetRelayout(puodd.getLinkMeaning());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class HierDAGLayoutAction
    extends BasicLayoutAction {
        private static final long serialVersionUID = 1L;

        HierDAGLayoutAction(boolean doIcon) {
            super(doIcon, "command.HierDAGLayout", "command.HierDAGLayoutMnem", BuildDataImpl.BuildMode.HIER_DAG_LAYOUT);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PointUpOrDownDialog puodd = new PointUpOrDownDialog(CommandSet.this.topWindow_);
                puodd.setVisible(true);
                boolean pointUp = false;
                if (puodd.haveResult()) {
                    pointUp = puodd.getPointUp();
                    CommandSet.this.flf_.doHierDagRelayout(pointUp);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class LayoutTopControlAction
    extends BasicLayoutAction {
        private static final long serialVersionUID = 1L;

        LayoutTopControlAction(boolean doIcon) {
            super(doIcon, "command.TopControlLayout", "command.TopControlLayoutMnem", BuildDataImpl.BuildMode.CONTROL_TOP_LAYOUT);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ControlTopLayoutSetupDialog ctlsud = new ControlTopLayoutSetupDialog(CommandSet.this.topWindow_);
                ctlsud.setVisible(true);
                if (ctlsud.haveResult()) {
                    List<String> fixedList = null;
                    ControlTopLayout.CtrlMode cMode = ctlsud.getCMode();
                    ControlTopLayout.TargMode tMode = ctlsud.getTMode();
                    if (cMode == ControlTopLayout.CtrlMode.FIXED_LIST) {
                        File fileEda = CommandSet.this.flf_.getTheFile(".txt", null, "AttribDirectory", "filterName.txt", null);
                        if (fileEda == null) {
                            return;
                        }
                        fixedList = UiUtil.simpleFileRead(fileEda);
                        if (fixedList == null) {
                            return;
                        }
                    }
                    CommandSet.this.flf_.doControlTopRelayout(cMode, tMode, fixedList);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class LayoutViaNodeClusterAction
    extends LayoutViaAttributesAction {
        private static final long serialVersionUID = 1L;

        LayoutViaNodeClusterAction(boolean doIcon) {
            super(doIcon, "command.LayoutViaNodeClusterAction", "command.LayoutViaNodeClusterAction");
        }

        protected boolean performOperation() {
            Set<NetNode> sels = CommandSet.this.bfp_.getNodeSelections();
            NetNode selNode = sels.size() == 1 ? sels.iterator().next() : null;
            ClusterLayoutSetupDialog clsd = new ClusterLayoutSetupDialog(CommandSet.this.topWindow_, CommandSet.this.bfp_.getNetwork(), selNode);
            clsd.setVisible(true);
            if (clsd.haveResult()) {
                NodeClusterLayout.ClusterParams params = clsd.getParams();
                if (params.needsFile() && !ClusterLayoutSetupDialog.askForFileInfo(params, CommandSet.this, CommandSet.this.flf_, CommandSet.this.bfp_.getNetwork())) {
                    return true;
                }
                CommandSet.this.flf_.doNetworkClusterRelayout(params);
            }
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class ToggleShowNavPanelAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ToggleShowNavPanelAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ShowNavPanel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ShowNavPanel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ShowNavPanelMnem");
                this.putValue("MnemonicKey", mnem);
            }
            CommandSet.this.showNav_ = true;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                CommandSet.this.showNav_ = !CommandSet.this.showNav_;
                CommandSet.this.bfw_.showNavAndControl(CommandSet.this.showNav_);
                CommandSet.this.checkForChanges();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ToggleShowTourAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;
        private boolean showTour_;

        ToggleShowTourAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ShowTourAction"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ShowTourAction"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ShowTourActionMnem");
                this.putValue("MnemonicKey", mnem);
            }
            this.showTour_ = true;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                this.showTour_ = !this.showTour_;
                CommandSet.this.bfw_.showTour(this.showTour_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.showNav_;
        }
    }

    private class LayoutLinksViaAttributesAction
    extends LayoutViaAttributesAction {
        private static final long serialVersionUID = 1L;

        LayoutLinksViaAttributesAction(boolean doIcon) {
            super(doIcon, "command.LayoutLinksViaAttributes", "command.LayoutLinksViaAttributesMnem");
        }

        protected boolean performOperation() {
            File file = CommandSet.this.flf_.getTheFile(".eda", ".ed", "AttribDirectory", "filterName.eda", null);
            if (file == null) {
                return true;
            }
            Map<String, Set<NetNode>> nameToIDs = CommandSet.this.bfp_.getNetwork().getNormNameToIDs();
            Map<AttributeKey, String> edgeAttributes = CommandSet.this.flf_.loadTheFile(file, nameToIDs, false);
            if (edgeAttributes == null) {
                return true;
            }
            SortedMap<Integer, NetLink> modifiedAndChecked = CommandSet.this.bfp_.getNetwork().checkNewLinkOrder(edgeAttributes);
            if (modifiedAndChecked == null) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(CommandSet.this.topWindow_, rMan.getString("attribRead.badColMessage"), rMan.getString("attribRead.badColSemanticsTitle"), 2);
                return true;
            }
            CommandSet.this.flf_.doNetworkLinkRelayout(modifiedAndChecked);
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class SetPluginDirectory
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        SetPluginDirectory(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SetPluginDirectory"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SetPluginDirectory"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SetPluginDirectoryMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean performOperation() {
            String currentChoice = CommandSet.this.pMan_.getDirectory();
            DirectoryChooserDialog dcd = new DirectoryChooserDialog(CommandSet.this.topWindow_, CommandSet.this.flf_, currentChoice);
            dcd.setVisible(true);
            if (dcd.haveResult()) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(CommandSet.this.topWindow_, rMan.getString("setPlugin.RestartMessage"), rMan.getString("setPlugin.RestartMessageTitle"), 1);
                File directory = dcd.getDirectory();
                CommandSet.this.pMan_.setDirectory(directory);
            }
            return true;
        }
    }

    private class AddLinkAnnotations
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        AddLinkAnnotations(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddLinkAnnotations"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddLinkAnnotations"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddLinkAnnotationsMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean performOperation() {
            File file = CommandSet.this.flf_.getTheFile(".tsv", null, "AnnotDirectory", "filterName.tsv", null);
            if (file == null) {
                return true;
            }
            Map<Boolean, AnnotationSet> aSet = CommandSet.this.flf_.loadAnnotations(file, false);
            if (aSet == null) {
                return true;
            }
            CommandSet.this.bfp_.getNetwork().setLinkAnnotations(aSet.get(Boolean.TRUE), true);
            CommandSet.this.bfp_.getNetwork().setLinkAnnotations(aSet.get(Boolean.FALSE), false);
            CommandSet.this.flf_.doRecolor(CommandSet.this.isForMain_);
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class AddNodeAnnotations
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        AddNodeAnnotations(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddNodeAnnotations"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddNodeAnnotations"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddNodeAnnotationsMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean performOperation() {
            File file = CommandSet.this.flf_.getTheFile(".tsv", null, "AnnotDirectory", "filterName.tsv", null);
            if (file == null) {
                return true;
            }
            Map<Boolean, AnnotationSet> aSet = CommandSet.this.flf_.loadAnnotations(file, true);
            if (aSet == null) {
                return true;
            }
            CommandSet.this.bfp_.getNetwork().setNodeAnnotations(aSet.get(Boolean.TRUE));
            CommandSet.this.flf_.doRecolor(CommandSet.this.isForMain_);
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private class LayoutNodesViaAttributesAction
    extends LayoutViaAttributesAction {
        private static final long serialVersionUID = 1L;

        LayoutNodesViaAttributesAction(boolean doIcon) {
            super(doIcon, "command.LayoutNodesViaAttributes", "command.LayoutNodesViaAttributesMnem");
        }

        protected boolean performOperation() {
            File file = CommandSet.this.flf_.getTheFile(".noa", ".na", "AttribDirectory", "filterName.noa", null);
            if (file == null) {
                return true;
            }
            Map<AttributeKey, String> nodeAttributes = CommandSet.this.flf_.loadTheFile(file, null, true);
            if (nodeAttributes == null) {
                return true;
            }
            if (!CommandSet.this.bfp_.getNetwork().checkNewNodeOrder(nodeAttributes)) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(CommandSet.this.topWindow_, rMan.getString("attribRead.badRowMessage"), rMan.getString("attribRead.badRowSemanticsTitle"), 2);
                return true;
            }
            CommandSet.this.flf_.doNetworkRelayout(nodeAttributes);
            return true;
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel() && CommandSet.this.bfp_.getNetwork().getLinkCount(true) != 0;
        }
    }

    private abstract class LayoutViaAttributesAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        LayoutViaAttributesAction(boolean doIcon, String name, String mnemStr) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(name));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(name));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(mnemStr);
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected abstract boolean performOperation();

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class CloseAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        CloseAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Close"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Close"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Stop24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CloseMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfa_.shutdownFabric();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class CompareNodesAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        CompareNodesAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CompareNodes"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CompareNodes"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CompareNodesMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Set<NetNode> allNodeIDs = CommandSet.this.bfp_.getNetwork().getNodeSetIDs();
                Map<String, Set<NetNode>> normNameToIDs = CommandSet.this.bfp_.getNetwork().getNormNameToIDs();
                CompareNodesSetupDialog fsd = new CompareNodesSetupDialog(CommandSet.this.topWindow_, allNodeIDs, normNameToIDs);
                fsd.setVisible(true);
                if (fsd.haveResult()) {
                    Set<NetNode> result = fsd.getResults();
                    CommandSet.this.bfp_.installSearchResult(result, true);
                    CommandSet.this.bfp_.addFirstNeighbors();
                    CommandSet.this.bfp_.selectionsToSubmodel();
                }
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class SearchAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        SearchAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Search"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Search"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Find24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SearchMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                boolean haveSelection = CommandSet.this.bfp_.haveASelection();
                boolean buildingSels = CommandSet.this.bfp_.amBuildingSelections();
                FabricSearchDialog fsd = new FabricSearchDialog(CommandSet.this.topWindow_, CommandSet.this.bfw_.getFabricPanel().getNetwork(), haveSelection, buildingSels);
                fsd.setVisible(true);
                if (fsd.itemWasFound()) {
                    Set<NetNode> matches = fsd.getMatches();
                    boolean doDiscard = fsd.discardSelections();
                    CommandSet.this.bfw_.getFabricPanel().installSearchResult(matches, doDiscard);
                }
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class CancelAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        CancelAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CancelAddMode"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CancelAddMode"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Stop24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CancelAddModeMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.cancelModals();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return false;
        }

        protected boolean reversePush(int pushCondition) {
            return (pushCondition & 2) != 0;
        }
    }

    private class ZoomToRect
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ZoomToRect(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToRect"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToRect"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/ZoomToFabricRect24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToRectMnem");
                this.putValue("MnemonicKey", mnem);
                char accel = rMan.getChar("command.ZoomToRectAccel");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.setToCollectZoomRect();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class ClearSelectionsAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ClearSelectionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ClearSel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ClearSel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/ClearFabricSelected24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ClearSelMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.clearSelections();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    private class InOutZoomAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;
        private char sign_;

        InOutZoomAction(boolean doIcon, char sign) {
            String accelName;
            String mnemName;
            String stringName;
            String iconName;
            this.sign_ = sign;
            ResourceManager rMan = ResourceManager.getManager();
            if (sign == '+') {
                iconName = "ZoomIn24.gif";
                stringName = "command.ZoomIn";
                mnemName = "command.ZoomInMnem";
                accelName = "command.ZoomInAccel";
            } else {
                iconName = "ZoomOut24.gif";
                stringName = "command.ZoomOut";
                mnemName = "command.ZoomOutMnem";
                accelName = "command.ZoomOutAccel";
            }
            this.putValue("Name", rMan.getString(stringName));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(stringName));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/" + iconName);
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(mnemName);
                this.putValue("MnemonicKey", mnem);
            }
            char accel = rMan.getChar(accelName);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.getZoomController().bumpZoomWrapper(this.sign_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void setConditionalEnabled(boolean enabled) {
            this.setEnabled(enabled);
        }

        public void checkIfEnabled() {
        }

        protected boolean canPush(int pushCondition) {
            return (pushCondition & 2) == 0;
        }
    }

    private class BuildSelectAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        BuildSelectAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.BuildSelect"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.BuildSelect"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.BuildSelectMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.toggleBuildSelect();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class AddFirstNeighborsAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        AddFirstNeighborsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddFirstNeighbors"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddFirstNeighbors"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/PlusOneDeg24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddFirstNeighborsMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.addFirstNeighbors();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    private class CenterOnPreviousSelected
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        CenterOnPreviousSelected(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CenterOnPreviousSelected"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CenterOnPreviousSelected"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Back24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CenterOnPreviousSelectedMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.getZoomController().centerToPreviousSelected();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    private class CenterOnNextSelected
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        CenterOnNextSelected(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CenterOnNextSelected"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CenterOnNextSelected"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/Forward24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CenterOnNextSelectedMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.getZoomController().centerToNextSelected();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    private class ZoomToCurrentMagnify
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ZoomToCurrentMagnify(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToCurrentMagnify"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToCurrentMagnify"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/ZoomToFabricSelected24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToCurrentMagnifyMnem");
                this.putValue("MnemonicKey", mnem);
                char accel = rMan.getChar("command.ZoomToCurrentMagnifyAccel");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FabricMagnifyingTool fmt = CommandSet.this.bfp_.getMagnifier();
                Rectangle rect = fmt.getClipRect();
                CommandSet.this.bfp_.getZoomController().zoomToRect(rect);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class ZoomToCurrentMouse
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ZoomToCurrentMouse(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToCurrentMouse"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToCurrentMouse"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToCurrentMouseMnem");
                this.putValue("MnemonicKey", mnem);
                char accel = rMan.getChar("command.ZoomToCurrentMouseAccel");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FabricMagnifyingTool fmt = CommandSet.this.bfp_.getMagnifier();
                Point2D pt = fmt.getMouseLoc();
                Point rcPoint = CommandSet.this.bfp_.worldToRowCol(pt);
                Rectangle rect = CommandSet.this.bfp_.buildFocusBox(rcPoint);
                CommandSet.this.bfp_.getZoomController().zoomToRect(rect);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class ZoomToCurrentSelected
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ZoomToCurrentSelected(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToCurrentSelected"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToCurrentSelected"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/ZoomToFabricSelected24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToCurrentSelectedMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.getZoomController().zoomToCurrentSelected();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    private class ZoomToModelAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ZoomToModelAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToModel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToModel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/ZoomToAllFabric24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToModelMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.getZoomController().zoomToModel(false);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.hasAModel();
        }
    }

    private class ZoomToSelected
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        ZoomToSelected(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToSelected"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToSelected"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/ZoomToAllFabricSelected24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToSelectedMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.getZoomController().zoomToSelected();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    private class PropagateDownAction
    extends ChecksForEnabled {
        private static final long serialVersionUID = 1L;

        PropagateDownAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.PropagateDown"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.PropagateDown"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/PropagateSelected24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PropagateDownMnem");
                this.putValue("MnemonicKey", mnem);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CommandSet.this.bfp_.selectionsToSubmodel();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts() {
            return CommandSet.this.bfp_.haveASelection();
        }
    }

    public abstract class ChecksForEnabled
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected static final int IGNORE = -1;
        protected static final int DISABLED = 0;
        protected static final int ENABLED = 1;
        protected boolean enabled_ = true;
        protected boolean pushed_ = false;

        public void checkIfEnabled() {
            this.enabled_ = this.checkGuts();
            if (!this.pushed_) {
                this.setEnabled(this.enabled_);
            }
        }

        public void pushDisabled(int pushCondition) {
            this.pushed_ = this.canPush(pushCondition);
            boolean reversed = this.reversePush(pushCondition);
            if (this.pushed_) {
                this.setEnabled(reversed);
            }
        }

        public void setConditionalEnabled(boolean enabled) {
            this.enabled_ = enabled;
            if (!this.pushed_) {
                this.setEnabled(this.enabled_);
            }
        }

        public boolean isPushed() {
            return this.pushed_;
        }

        public void popDisabled() {
            if (this.pushed_) {
                this.setEnabled(this.enabled_);
                this.pushed_ = false;
            }
        }

        protected boolean checkGuts() {
            return true;
        }

        protected boolean canPush(int pushCondition) {
            return true;
        }

        protected boolean reversePush(int pushCondition) {
            return false;
        }
    }

    public class HeadlessExportAction
    extends ExportImageAction {
        private static final long serialVersionUID = 1L;

        public HeadlessExportAction() {
            super(false, "command.HeadlessExport", "command.HeadlessExportMnem");
        }

        protected ExportSettingsDialog.ExportSettings getExportSettings() {
            return null;
        }
    }

    public class HeadlessImportSIFAction {
        private File inputFile_;

        public HeadlessImportSIFAction(File inputFile) {
            this.inputFile_ = inputFile;
        }

        public boolean performOperation(Object[] args) {
            FileLoadFlows.FileLoadResult flr = CommandSet.this.flf_.loadFromASource(this.inputFile_, null, null, new UniqueLabeller(), FileLoadFlows.FileLoadType.SIF, false);
            return flr.getSuccess();
        }
    }
}

