/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.app;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.app.ArgParser;
import org.systemsbiology.biofabric.app.BioFabricWindow;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.cmd.HeadlessOracle;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.ui.ImageExporter;
import org.systemsbiology.biofabric.ui.dialogs.ExportSettingsDialog;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageGeneratorApplication {
    public static final int SIF_INPUT = 0;
    public static final int PNG_OUTPUT = 0;
    private Map<String, Object> args_;

    public static void main(String[] argv) {
        ResourceManager.initManager("org.systemsbiology.biofabric.props.BioFabric");
        ArgParser ap = new ArgParser();
        Map<String, Object> argMap = ap.parse(ArgParser.AppType.PIPELINE, argv);
        if (argMap == null || argMap.size() != 3) {
            System.err.print(ap.getUsage(ArgParser.AppType.PIPELINE));
            System.exit(1);
        }
        ImageGeneratorApplication iga = new ImageGeneratorApplication(argMap);
        try {
            String errMsg = iga.generate();
            if (errMsg != null) {
                System.err.println(errMsg);
                System.exit(1);
            }
        }
        catch (GeneratorException gex) {
            System.err.println(gex.getMessage());
        }
        catch (MissingArgException maex) {
            System.err.print(ap.getUsage(ArgParser.AppType.PIPELINE));
            System.exit(1);
        }
    }

    private ImageGeneratorApplication(Map<String, Object> args) {
        this.args_ = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generate() throws GeneratorException, MissingArgException {
        Class<CommandSet> clazz = CommandSet.class;
        synchronized (CommandSet.class) {
            Object[] osArgs;
            ResourceManager rMan = ResourceManager.getManager();
            System.setProperty("java.awt.headless", "true");
            BioFabricWindow bfw = new BioFabricWindow(this.args_, null, true, true);
            ExceptionHandler.getHandler().initializeForHeadless(false);
            PlugInManager plum = new PlugInManager();
            boolean ok = plum.loadPlugIns(this.args_);
            if (!ok) {
                System.err.println("Problems loading plugins");
            }
            CommandSet.initCmds("mainWindow", null, bfw, true, plum, new HeadlessOracle());
            bfw.initWindow(null);
            CommandSet cmd = CommandSet.getCmds("mainWindow");
            int inputType = 0;
            int outputType = 0;
            boolean haveInput = false;
            switch (inputType) {
                case 0: {
                    String sifFileName = (String)this.args_.get("sifImport");
                    if (sifFileName == null) {
                        throw new MissingArgException();
                    }
                    File sifFile = new File(sifFileName);
                    CommandSet commandSet = cmd;
                    commandSet.getClass();
                    CommandSet.HeadlessImportSIFAction sifLoader = new CommandSet.HeadlessImportSIFAction(commandSet, sifFile);
                    osArgs = null;
                    boolean okl = sifLoader.performOperation(osArgs);
                    if (!okl) {
                        throw new GeneratorException(rMan.getString("headless.csvInputFailure"));
                    }
                    haveInput = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!haveInput) {
                throw new GeneratorException(rMan.getString("headless.noInputFailure"));
            }
            boolean aSuccess = false;
            switch (outputType) {
                case 0: {
                    String imageFileName = (String)this.args_.get("pngExport");
                    if (imageFileName == null) {
                        throw new MissingArgException();
                    }
                    CommandSet.HeadlessExportAction hexa = new CommandSet.HeadlessExportAction(cmd);
                    osArgs = this.imageExportPrepForFile(this.args_, imageFileName, cmd);
                    if (osArgs != null) {
                        boolean hok = hexa.performOperation(osArgs);
                        if (!hok) {
                            System.err.println(rMan.getString("headless.imageExportFailure"));
                            break;
                        }
                        aSuccess = true;
                        break;
                    }
                    System.err.println(rMan.getString("headless.imageExportFailure"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!aSuccess) {
                System.err.println(rMan.getString("headless.totalExportFailure"));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return rMan.getString("headless.earlyExit");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    private Object[] imageExportPrepForFile(Map args, String imageFileName, CommandSet cmd) throws MissingArgException {
        Object[] osArgs = new Object[3];
        osArgs[1] = new Boolean(true);
        osArgs[2] = imageFileName;
        ExportSettingsDialog.ExportSettings settings = this.imageExportPrepGuts(args, cmd);
        osArgs[0] = settings;
        return osArgs;
    }

    private ExportSettingsDialog.ExportSettings imageExportPrepGuts(Map<String, Object> args, CommandSet cmd) throws MissingArgException {
        ResourceManager rMan = ResourceManager.getManager();
        String outputWidthStr = (String)this.args_.get("pngWidth");
        if (outputWidthStr == null) {
            throw new MissingArgException();
        }
        int outputWidth = 0;
        try {
            outputWidth = Integer.parseInt(outputWidthStr);
        }
        catch (NumberFormatException nfex) {
            System.err.println(rMan.getString("headless.imageExportBadWidth"));
            return null;
        }
        List suppRes = ImageExporter.getSupportedResolutions(false);
        List<String> suppForms = ImageExporter.getSupportedExports();
        ExportSettingsDialog.ExportSettings settings = new ExportSettingsDialog.ExportSettings();
        if (!suppForms.contains("PNG")) {
            System.err.println(rMan.getString("headless.imageExportPrepFailure"));
            return null;
        }
        settings.formatType = "PNG";
        if (ImageExporter.formatRequiresResolution(settings.formatType)) {
            List resList = ImageExporter.getSupportedResolutions(false);
            if (resList.size() == 0) {
                throw new IllegalStateException();
            }
            Object[] resVal = (Object[])resList.get(0);
            ImageExporter.RationalNumber ratNum = (ImageExporter.RationalNumber)resVal[1];
            settings.res = new ImageExporter.ResolutionSettings();
            settings.res.dotsPerUnit = ratNum;
            settings.res.units = 1;
        } else {
            settings.res = null;
        }
        BioFabricPanel bfp = cmd.getBFW().getFabricPanel();
        Rectangle wr = bfp.getRequiredSize();
        settings.zoomVal = (double)outputWidth / (double)wr.width;
        double currentZoomHeight = Math.round((double)wr.height * settings.zoomVal);
        double currentZoomWidth = Math.round((double)wr.width * settings.zoomVal);
        settings.size = new Dimension((int)currentZoomWidth, (int)currentZoomHeight);
        return settings;
    }

    public static class MissingArgException
    extends Exception {
    }

    public static class GeneratorException
    extends Exception {
        private Exception wrapped_;

        GeneratorException(String message, Exception wrapped) {
            super(message);
            this.wrapped_ = wrapped;
        }

        GeneratorException(String message) {
            super(message);
            this.wrapped_ = null;
        }

        public Exception getWrappedException() {
            return this.wrapped_;
        }
    }
}

