/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.app;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerControlManager;
import org.systemsbiology.biofabric.app.BioFabricApplication;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.ui.display.BioFabricNavAndControl;
import org.systemsbiology.biofabric.ui.display.BioFabricOverview;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.ui.display.FabricMagnifyingTool;
import org.systemsbiology.biofabric.ui.render.BucketRenderer;
import org.systemsbiology.biofabric.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioFabricWindow
implements BackgroundWorkerControlManager {
    private MyTopWindow myWindow_;
    private BioFabricPanel cp_;
    private BioFabricApplication bfa_;
    private FabricMagnifyingTool fmt_;
    private HashMap<Integer, Action> actionMap_;
    private BioFabricNavAndControl nac_;
    private boolean isMain_;
    private JPanel hidingPanel_;
    private CardLayout myCard_;
    private JSplitPane sp_;
    private double savedSplitFrac_;
    private boolean isHeadless_;

    public BioFabricWindow(Map<String, Object> args, BioFabricApplication bfa, boolean isMain, boolean isHeadless) {
        this.isHeadless_ = isHeadless;
        if (!isHeadless) {
            this.myWindow_ = new MyTopWindow(isMain);
        }
        this.bfa_ = bfa;
        this.isMain_ = isMain;
        this.actionMap_ = new HashMap();
    }

    public JFrame getWindow() {
        return this.myWindow_;
    }

    @Override
    public void disableControls() {
        this.disableControls(1, true);
    }

    public void disableControls(int pushFlags, boolean displayToo) {
        CommandSet fc = CommandSet.getCmds(this.isMain_ ? "mainWindow" : "selectionWindow");
        if (displayToo) {
            this.myCard_.show(this.hidingPanel_, "Hiding");
            this.fmt_.enableControls(false);
            this.nac_.getOverview().showView(false);
        }
        this.nac_.getNavTool().enableControls(false);
        this.myWindow_.getContentPane().validate();
        fc.pushDisabled(pushFlags);
    }

    @Override
    public void reenableControls() {
        CommandSet fc = CommandSet.getCmds(this.isMain_ ? "mainWindow" : "selectionWindow");
        fc.popDisabled();
        this.myCard_.show(this.hidingPanel_, "SUPanel");
        this.fmt_.enableControls(true);
        this.nac_.getOverview().showView(true);
        this.nac_.getNavTool().enableControls(true);
        this.myWindow_.getContentPane().validate();
    }

    @Override
    public void redraw() {
        this.cp_.repaint();
    }

    public void initWindow(Dimension dim) {
        CommandSet fc = CommandSet.getCmds(this.isMain_ ? "mainWindow" : "selectionWindow");
        JPanel cpane = null;
        JToolBar toolBar = null;
        if (!this.isHeadless_) {
            cpane = (JPanel)this.myWindow_.getContentPane();
            cpane.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "BioTapCancel");
            cpane.getActionMap().put("BioTapCancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent e) {
                    try {
                        AbstractAction aa = (AbstractAction)BioFabricWindow.this.actionMap_.get(12);
                        aa.actionPerformed(null);
                        return;
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                        return;
                    }
                }
            });
            this.menuInstall(fc, this.isMain_);
            toolBar = new JToolBar();
            this.stockActionMap(fc, this.isMain_);
            this.stockToolBar(toolBar, this.isMain_, fc);
        }
        this.nac_ = new BioFabricNavAndControl(this.isMain_, this.myWindow_, this.isHeadless_);
        this.fmt_ = this.nac_.getFMT();
        BucketRenderer bucketRend = new BucketRenderer(fc.getColorGenerator());
        this.cp_ = new BioFabricPanel(fc.getColorGenerator(), this.bfa_, this.fmt_, this.nac_.getOverview(), this.nac_.getNavTool(), this.isMain_, this, bucketRend, this.isHeadless_);
        fc.setFabricPanel(this.cp_);
        this.nac_.setFabricPanel(this.cp_);
        this.cp_.setFabricLocation(this.nac_.getFabricLocation(), this.nac_.getMouseOverView());
        if (this.isHeadless_) {
            return;
        }
        this.cp_.getPanel().setBackground(Color.white);
        JScrollPane jsp = new JScrollPane(this.cp_.getPanel());
        jsp.setHorizontalScrollBarPolicy(32);
        jsp.setVerticalScrollBarPolicy(22);
        this.cp_.setScroll(jsp);
        this.cp_.getZoomController().registerScrollPaneAndZoomTarget(jsp, this.cp_);
        cpane.setLayout(new BorderLayout());
        if (toolBar != null) {
            cpane.add((Component)toolBar, "North");
        }
        this.hidingPanel_ = new JPanel();
        this.myCard_ = new CardLayout();
        this.hidingPanel_.setLayout(this.myCard_);
        this.hidingPanel_.add((Component)jsp, "SUPanel");
        JPanel blankPanel = new JPanel();
        blankPanel.setBackground(Color.white);
        this.hidingPanel_.add((Component)blankPanel, "Hiding");
        this.sp_ = new JSplitPane(0, this.hidingPanel_, this.nac_.getPanel());
        this.sp_.setDividerLocation((int)((double)dim.height * 0.5));
        this.sp_.setResizeWeight(1.0);
        cpane.add((Component)this.sp_, "Center");
        URL ugif = this.getClass().getResource("/org/systemsbiology/biofabric/images/BioFab16White.gif");
        this.myWindow_.setIconImage(new ImageIcon(ugif).getImage());
        this.myWindow_.setResizable(true);
        fc.checkForChanges();
        fc.handleZoomButtons();
    }

    public void stopBufferBuilding() {
        this.cp_.shutdown();
    }

    public BioFabricPanel getFabricPanel() {
        return this.cp_;
    }

    public BioFabricOverview getOverview() {
        return this.nac_.getOverview();
    }

    public void showNavAndControl(boolean show) {
        if (this.isHeadless_) {
            return;
        }
        if (show) {
            this.sp_.setEnabled(true);
            this.nac_.setToBlank(!show);
            this.sp_.setDividerLocation(this.savedSplitFrac_);
        } else {
            this.nac_.setToBlank(!show);
            int lastLoc = this.sp_.getDividerLocation();
            this.savedSplitFrac_ = (double)lastLoc / (double)this.sp_.getHeight();
            this.sp_.setDividerLocation(1.0);
            this.sp_.setEnabled(false);
        }
    }

    public void showTour(boolean show) {
        if (this.isHeadless_) {
            return;
        }
        if (this.nac_.showTour(show)) {
            this.sp_.resetToPreferredSizes();
        }
    }

    private void menuInstall(CommandSet fc, boolean isMain) {
        JMenu fMenu;
        ResourceManager rMan = ResourceManager.getManager();
        JMenuBar menuBar = new JMenuBar();
        if (isMain) {
            fMenu = new JMenu(rMan.getString("command.File"));
            fMenu.setMnemonic(rMan.getChar("command.FileMnem"));
            menuBar.add(fMenu);
            fMenu.add(fc.getAction(31, false, null));
            fMenu.add(fc.getAction(45, false, null));
            fMenu.add(fc.getAction(7, false, null));
            fMenu.add(new JSeparator());
            JMenu importMenu = new JMenu(rMan.getString("command.importMenu"));
            importMenu.setMnemonic(rMan.getChar("command.importMenuMnem"));
            fMenu.add(importMenu);
            importMenu.add(fc.getAction(2, false, null));
            importMenu.add(fc.getAction(30, false, null));
            importMenu.add(fc.getAction(54, false, null));
            JMenu exportMenu = new JMenu(rMan.getString("command.exportMenu"));
            exportMenu.setMnemonic(rMan.getChar("command.exportMenuMnem"));
            fMenu.add(exportMenu);
            exportMenu.add(fc.getAction(40, false, null));
            exportMenu.add(fc.getAction(41, false, null));
            exportMenu.add(new JSeparator());
            exportMenu.add(fc.getAction(38, false, null));
            exportMenu.add(fc.getAction(39, false, null));
            exportMenu.add(new JSeparator());
            exportMenu.add(fc.getAction(44, false, null));
            fMenu.add(new JSeparator());
            fMenu.add(fc.getAction(0, false, null));
            fMenu.add(new JSeparator());
            fMenu.add(fc.getAction(42, false, null));
            fMenu.add(new JSeparator());
            fMenu.add(fc.getAction(57, false, null));
            fMenu.add(new JSeparator());
            fMenu.add(fc.getAction(1, false, null));
        } else {
            fMenu = new JMenu(rMan.getString("command.File"));
            fMenu.setMnemonic(rMan.getChar("command.FileMnem"));
            menuBar.add(fMenu);
            JMenu exportMenu = new JMenu(rMan.getString("command.exportMenu"));
            exportMenu.setMnemonic(rMan.getChar("command.exportMenuMnem"));
            fMenu.add(exportMenu);
            exportMenu.add(fc.getAction(40, false, null));
            exportMenu.add(fc.getAction(41, false, null));
            exportMenu.add(new JSeparator());
            exportMenu.add(fc.getAction(44, false, null));
        }
        JMenu eMenu = new JMenu(rMan.getString("command.Edit"));
        eMenu.setMnemonic(rMan.getChar("command.EditMnem"));
        menuBar.add(eMenu);
        eMenu.add(fc.getAction(6, false, null));
        eMenu.add(fc.getAction(14, false, null));
        if (isMain) {
            eMenu.add(fc.getAction(10, false, null));
        }
        Action bsa = fc.getAction(15, false, null);
        JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(bsa);
        jcb.setSelected(true);
        eMenu.add(jcb);
        eMenu.add(new JSeparator());
        eMenu.add(fc.getAction(16, false, null));
        JMenu vMenu = new JMenu(rMan.getString("command.View"));
        vMenu.setMnemonic(rMan.getChar("command.ViewMnem"));
        menuBar.add(vMenu);
        vMenu.add(fc.getAction(4, false, null));
        vMenu.add(fc.getAction(5, false, null));
        vMenu.add(fc.getAction(8, false, null));
        vMenu.add(fc.getAction(11, false, null));
        vMenu.add(fc.getAction(36, false, null));
        vMenu.add(fc.getAction(37, false, null));
        vMenu.add(fc.getAction(9, false, null));
        vMenu.add(new JSeparator());
        vMenu.add(fc.getAction(27, false, null));
        vMenu.add(fc.getAction(13, false, null));
        vMenu.add(fc.getAction(26, false, null));
        JMenu sMenu = new JMenu(rMan.getString("command.Tools"));
        sMenu.setMnemonic(rMan.getChar("command.ToolsMnem"));
        menuBar.add(sMenu);
        sMenu.add(fc.getAction(3, false, null));
        sMenu.add(fc.getAction(35, false, null));
        List<String> piks = fc.getPlugInKeys();
        for (String pik : piks) {
            BioFabricToolPlugIn tpi = fc.getPlugIn(pik);
            JMenu plugMenu = new JMenu(tpi.getToolMenu());
            sMenu.add(plugMenu);
            int numAction = tpi.getCommandCount();
            for (int i = 0; i < numAction; ++i) {
                plugMenu.add(fc.getPluginAction(pik, i));
            }
        }
        JMenu lMenu = new JMenu(rMan.getString("command.Layout"));
        lMenu.setMnemonic(rMan.getChar("command.LayoutMnem"));
        menuBar.add(lMenu);
        lMenu.add(fc.getAction(43, false, null));
        lMenu.add(new JSeparator());
        lMenu.add(fc.getAction(50, false, null));
        lMenu.add(fc.getAction(51, false, null));
        lMenu.add(fc.getAction(46, false, null));
        lMenu.add(fc.getAction(17, false, null));
        lMenu.add(fc.getAction(52, false, null));
        lMenu.add(new JSeparator());
        lMenu.add(fc.getAction(32, false, null));
        lMenu.add(fc.getAction(33, false, null));
        lMenu.add(new JSeparator());
        lMenu.add(fc.getAction(28, false, null));
        lMenu.add(fc.getAction(29, false, null));
        lMenu.add(new JSeparator());
        lMenu.add(fc.getAction(34, false, null));
        lMenu.add(new JSeparator());
        lMenu.add(fc.getAction(55, false, null));
        lMenu.add(fc.getAction(56, false, null));
        JMenu wMenu = new JMenu(rMan.getString("command.Windows"));
        wMenu.setMnemonic(rMan.getChar("command.ToolsMnem"));
        menuBar.add(wMenu);
        JCheckBoxMenuItem jcbS = new JCheckBoxMenuItem(fc.getAction(49, false, null));
        jcbS.setSelected(true);
        wMenu.add(jcbS);
        JCheckBoxMenuItem jcbT = new JCheckBoxMenuItem(fc.getAction(48, false, null));
        jcbT.setSelected(true);
        wMenu.add(jcbT);
        JMenu hMenu = new JMenu(rMan.getString("command.Help"));
        hMenu.setMnemonic(rMan.getChar("command.HelpMnem"));
        menuBar.add(hMenu);
        hMenu.add(fc.getAction(25, false, null));
        this.myWindow_.setJMenuBar(menuBar);
    }

    private void stockActionMap(CommandSet fc, boolean isMain) {
        this.actionMap_.put(3, fc.getAction(3, true, null));
        this.actionMap_.put(4, fc.getAction(4, true, null));
        this.actionMap_.put(5, fc.getAction(5, true, null));
        this.actionMap_.put(14, fc.getAction(14, true, null));
        this.actionMap_.put(6, fc.getAction(6, true, null));
        this.actionMap_.put(8, fc.getAction(8, true, null));
        this.actionMap_.put(11, fc.getAction(11, true, null));
        this.actionMap_.put(18, fc.getAction(18, true, null));
        this.actionMap_.put(12, fc.getAction(12, true, null));
        this.actionMap_.put(13, fc.getAction(13, true, null));
        this.actionMap_.put(26, fc.getAction(26, true, null));
        this.actionMap_.put(27, fc.getAction(27, true, null));
        if (isMain) {
            this.actionMap_.put(10, fc.getAction(10, true, null));
        }
    }

    private void stockToolBar(JToolBar toolBar, boolean isMain, CommandSet fc) {
        toolBar.removeAll();
        toolBar.add(this.actionMap_.get(4));
        toolBar.add(this.actionMap_.get(5));
        toolBar.add(this.actionMap_.get(8));
        toolBar.add(this.actionMap_.get(11));
        toolBar.addSeparator();
        toolBar.add(this.actionMap_.get(27));
        toolBar.add(this.actionMap_.get(13));
        toolBar.add(this.actionMap_.get(26));
        toolBar.addSeparator();
        toolBar.add(this.actionMap_.get(14));
        toolBar.add(this.actionMap_.get(6));
        toolBar.addSeparator();
        toolBar.add(this.actionMap_.get(12));
        toolBar.addSeparator();
        toolBar.add(this.actionMap_.get(3));
        toolBar.addSeparator();
        toolBar.add(this.actionMap_.get(18));
        if (isMain) {
            toolBar.addSeparator();
            toolBar.add(this.actionMap_.get(10));
        }
    }

    public class MyTopWindow
    extends JFrame {
        private static final long serialVersionUID = 1L;

        public MyTopWindow(boolean isMain) {
            super(isMain ? "BioFabric" : "BioFabric: Selected Submodel View");
        }
    }
}

