/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.app;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.app.ArgParser;
import org.systemsbiology.biofabric.app.BioFabricWindow;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.ui.dialogs.UpdateJavaDialog;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioFabricApplication {
    private boolean forCyto_;
    private BioFabricWindow bfw_;
    private BioFabricWindow selectionWindow_;
    private PlugInManager plum_;

    public BioFabricApplication(boolean forCyto, Map<String, Object> args) {
        this.forCyto_ = forCyto;
        ResourceManager.initManager("org.systemsbiology.biofabric.props.BioFabric");
        this.plum_ = new PlugInManager();
        boolean ok = this.plum_.loadPlugIns(args);
        if (!ok) {
            System.err.println("Problems loading plugins");
        }
    }

    public void shutdownFabric() {
        this.bfw_.stopBufferBuilding();
        this.bfw_.getWindow().dispose();
        if (this.selectionWindow_ != null) {
            this.selectionWindow_.getWindow().dispose();
        }
        if (!this.forCyto_) {
            System.exit(0);
        }
    }

    public void closeSelection() {
        this.bfw_.getFabricPanel().setSelectionPanel(null);
        this.selectionWindow_.getWindow().setVisible(false);
    }

    public BioFabricWindow launchSelection() {
        this.bfw_.getFabricPanel().setSelectionPanel(this.selectionWindow_.getFabricPanel());
        this.selectionWindow_.getWindow().setSize((int)((double)this.bfw_.getWindow().getWidth() * 0.8), (int)((double)this.bfw_.getWindow().getHeight() * 0.8));
        this.selectionWindow_.getWindow().setVisible(true);
        this.raiseSelection();
        return this.selectionWindow_;
    }

    public void raiseSelection() {
        this.selectionWindow_.getWindow().setExtendedState(0);
        this.selectionWindow_.getWindow().toFront();
    }

    public BioFabricWindow launch(Map<String, Object> args) {
        String verNum;
        boolean isAMac = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (isAMac && ((verNum = System.getProperty("java.version").toLowerCase()).indexOf("1.4") == 0 || verNum.indexOf("1.5") == 0)) {
            UpdateJavaDialog ujw = new UpdateJavaDialog();
            ujw.setVisible(true);
            if (!ujw.keepGoingAnyway()) {
                return null;
            }
        }
        this.bfw_ = new BioFabricWindow(args, this, true, false);
        ExceptionHandler.getHandler().initialize(this.bfw_.getWindow());
        Dimension cbf = UiUtil.centerBigFrame(this.bfw_.getWindow(), 1600, 1200, 1.0, 0);
        this.bfw_.getWindow().setDefaultCloseOperation(0);
        this.bfw_.getWindow().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BioFabricApplication.this.shutdownFabric();
            }
        });
        CommandSet.initCmds("mainWindow", this, this.bfw_, true, this.plum_, null);
        this.bfw_.initWindow(cbf);
        this.bfw_.getWindow().setVisible(true);
        this.initSelection();
        return this.bfw_;
    }

    public static void main(String[] argv) {
        ArgParser ap = new ArgParser();
        final Map<String, Object> argMap = ap.parse(ArgParser.AppType.VIEWER, argv);
        if (argMap == null) {
            System.err.print(ap.getUsage(ArgParser.AppType.VIEWER));
            System.exit(0);
        }
        final BioFabricApplication su = new BioFabricApplication(false, argMap);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                su.launch(argMap);
            }
        });
    }

    private void initSelection() {
        this.selectionWindow_ = new BioFabricWindow(new HashMap<String, Object>(), this, false, false);
        Dimension swDim = new Dimension((int)((double)this.bfw_.getWindow().getWidth() * 0.8), (int)((double)this.bfw_.getWindow().getHeight() * 0.8));
        this.selectionWindow_.getWindow().setSize(swDim.width, swDim.height);
        this.selectionWindow_.getWindow().setLocationRelativeTo(this.bfw_.getWindow());
        this.selectionWindow_.getWindow().setDefaultCloseOperation(0);
        this.selectionWindow_.getWindow().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BioFabricApplication.this.closeSelection();
            }
        });
        CommandSet.initCmds("selectionWindow", this, this.selectionWindow_, false, this.plum_, null);
        this.selectionWindow_.initWindow(swDim);
    }
}

