/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biofabric.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgParser {
    public static final String FILE = "file";
    public static final String PLUG_IN_DIR = "plugInDir";
    public static final String SIF_BATCH_INPUT = "sifImport";
    public static final String IMAGE_BATCH_OUTPUT = "pngExport";
    public static final String IMAGE_OUTPUT_WIDTH = "pngWidth";

    public Map<String, Object> parse(AppType type, String[] argv) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            list.add(arg.startsWith("-") ? arg.toLowerCase() : arg);
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String finalArg = list.size() > 0 ? (String)list.get(list.size() - 1) : null;
        List<ArgInfo> targs = this.loadForType(type);
        int tNum = targs.size();
        for (int i = 0; i < tNum; ++i) {
            Object argVal;
            ArgInfo ai = targs.get(i);
            int index = list.indexOf("-" + ai.key.toLowerCase());
            if (!ai.followOn) {
                if (index != -1) {
                    argVal = true;
                    list.remove(index);
                } else {
                    argVal = false;
                }
                argMap.put(ai.key, argVal);
                continue;
            }
            if (index != -1) {
                if (index == list.size() - 1) {
                    return null;
                }
                argVal = (String)list.get(index + 1);
                if (((String)argVal).startsWith("-")) {
                    return null;
                }
                list.remove(index + 1);
                list.remove(index);
            } else {
                argVal = null;
            }
            argMap.put(ai.key, argVal);
        }
        if (list.size() == 0) {
            return argMap;
        }
        if (list.size() > 1) {
            return null;
        }
        String remains = (String)list.get(0);
        if (remains.equals(finalArg)) {
            argMap.put(FILE, remains);
        }
        return argMap;
    }

    public String getUsage(AppType type) {
        List<ArgInfo> targs = this.loadForType(type);
        return this.generateUsage(targs);
    }

    private List<ArgInfo> loadForType(AppType type) {
        ArrayList<ArgInfo> retval = new ArrayList<ArgInfo>();
        if (type == AppType.VIEWER) {
            retval.add(new ArgInfo(PLUG_IN_DIR, true, true));
            retval.add(new ArgInfo(FILE, true, true));
        } else if (type == AppType.PIPELINE) {
            retval.add(new ArgInfo(SIF_BATCH_INPUT, true, false));
            retval.add(new ArgInfo(IMAGE_BATCH_OUTPUT, true, false));
            retval.add(new ArgInfo(IMAGE_OUTPUT_WIDTH, true, false));
        } else {
            throw new IllegalArgumentException();
        }
        return retval;
    }

    private String generateUsage(List<ArgInfo> targs) {
        StringBuffer buf = new StringBuffer();
        ResourceManager rMan = ResourceManager.getManager();
        buf.append(rMan.getString("argParser.arguments"));
        buf.append("\n");
        int tNum = targs.size();
        for (int i = 0; i < tNum; ++i) {
            ArgInfo ai = targs.get(i);
            buf.append(ai.opKey ? " [ -" : " -");
            buf.append(ai.key);
            buf.append(ai.opKey ? " ] " : " ");
            if (ai.followOn) {
                buf.append(" argument");
                buf.append(ai.opKey ? " ] " : "");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private class ArgInfo {
        String key;
        boolean followOn;
        boolean opKey;

        ArgInfo(String key, boolean followOn, boolean opKey) {
            this.key = key;
            this.followOn = followOn;
            this.opKey = opKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AppType {
        VIEWER,
        PIPELINE;

    }
}

