/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.worker;

import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;

public final class LoopReporter {
    private long max_;
    private long skipLines_;
    private BTProgressMonitor monitor_;
    private double startFrac_;
    private double endFrac_;
    private String message_;
    private long count_;
    private long skipProg_;
    private boolean indeterminate_;

    public LoopReporter(long max, int bins, BTProgressMonitor monitor, double startFrac, double endFrac, String message) {
        this.indeterminate_ = false;
        this.max_ = max == 0L ? 1L : max;
        this.monitor_ = monitor;
        this.startFrac_ = startFrac;
        this.endFrac_ = endFrac;
        this.message_ = message;
        this.skipLines_ = bins == 0 ? 0L : this.max_ / (long)bins;
        this.count_ = 0L;
        this.skipProg_ = this.skipLines_;
    }

    public LoopReporter(long max, int bins, BTProgressMonitor monitor) {
        this.indeterminate_ = true;
        this.monitor_ = monitor;
        this.count_ = 0L;
        this.max_ = max == 0L ? 1L : max;
        this.skipLines_ = bins == 0 ? 0L : this.max_ / (long)bins;
        this.count_ = 0L;
        this.skipProg_ = this.skipLines_;
    }

    public void report(long progress) throws AsynchExitRequestException {
        this.skipProg_ -= progress;
        this.count_ += progress;
        if (this.skipProg_ <= 0L) {
            if (this.indeterminate_) {
                if (this.monitor_ != null && !this.monitor_.updateUnknownProgress()) {
                    throw new AsynchExitRequestException();
                }
            } else {
                double currFrac = this.startFrac_ + (this.endFrac_ - this.startFrac_) * ((double)this.count_ / (double)this.max_);
                if (this.monitor_ != null && !this.monitor_.updateProgressAndPhase((int)(currFrac * 100.0), this.message_)) {
                    throw new AsynchExitRequestException();
                }
            }
            this.skipProg_ = this.skipLines_;
        }
    }

    public void finish() throws AsynchExitRequestException {
        if (this.monitor_ != null && (this.indeterminate_ ? !this.monitor_.updateUnknownProgress() : !this.monitor_.updateProgressAndPhase(100, this.message_))) {
            throw new AsynchExitRequestException();
        }
    }

    public void report() throws AsynchExitRequestException {
        this.report(1L);
    }
}

