/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NID
implements Cloneable,
Comparable<NID> {
    private final String id_;

    public NID(String id) {
        this.id_ = id;
    }

    public NID(NID other) {
        this.id_ = other.id_;
    }

    public String getInternal() {
        return this.id_;
    }

    public NID clone() {
        try {
            NID newVal = (NID)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public int hashCode() {
        return this.id_.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof NID)) {
            return false;
        }
        NID otherMM = (NID)other;
        return this.id_.equals(otherMM.id_);
    }

    public String toString() {
        return "OID: " + this.id_;
    }

    @Override
    public int compareTo(NID other) {
        return this.id_.compareTo(other.id_);
    }

    public static Collection<WithName> addNames(Collection<NID> nids, Map<NID, String> idToName, Collection<WithName> target) {
        for (NID nid : nids) {
            target.add(new WithName(nid, idToName.get(nid)));
        }
        return target;
    }

    public static Set<String> justNames(Collection<WithName> nids) {
        HashSet<String> retval = new HashSet<String>();
        for (WithName nid : nids) {
            String name = nid.getName();
            if (retval.contains(name)) {
                throw new IllegalStateException();
            }
            retval.add(name);
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WithName
    implements Cloneable,
    Comparable<WithName> {
        private final NID nid_;
        private final String name_;

        public WithName(NID id, String name) {
            this.name_ = name;
            this.nid_ = id;
        }

        public WithName(WithName other) {
            this.nid_ = other.nid_;
            this.name_ = other.name_;
        }

        public WithName clone() {
            try {
                WithName newVal = (WithName)super.clone();
                return newVal;
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }

        public int hashCode() {
            return this.nid_.hashCode();
        }

        public NID getNID() {
            return this.nid_;
        }

        public String getName() {
            return this.name_;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof WithName)) {
                return false;
            }
            WithName otherMM = (WithName)other;
            boolean eq = this.nid_.equals(otherMM.nid_);
            boolean neq = this.name_.equals(otherMM.name_);
            if (eq && !neq) {
                throw new IllegalStateException();
            }
            return eq;
        }

        public String toString() {
            return "WithName: " + this.nid_ + " " + this.name_;
        }

        @Override
        public int compareTo(WithName other) {
            boolean eq = this.nid_.equals(other.nid_);
            boolean neq = this.name_.equals(other.name_);
            if (eq && !neq) {
                throw new IllegalStateException();
            }
            int nDiff = this.name_.compareTo(other.name_);
            if (nDiff != 0) {
                return nDiff;
            }
            return this.nid_.compareTo(other.nid_);
        }
    }
}

