/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.util;

import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMax
implements Cloneable,
Comparable<MinMax> {
    public static final int EQUALS = 0;
    public static final int IS_PROPER_SUPERSET = 1;
    public static final int IS_PROPER_SUBSET = 2;
    public static final int IS_DISJOINT = 3;
    public static final int INTERSECTS = 4;
    public int min;
    public int max;

    public MinMax() {
    }

    public MinMax(int val) {
        this.min = val;
        this.max = val;
    }

    public MinMax(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public MinMax(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public MinMax(SortedSet<Integer> ofIntegers) {
        if (ofIntegers.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.min = ofIntegers.first();
        this.max = ofIntegers.last();
    }

    public MinMax(MinMax other) {
        this.min = other.min;
        this.max = other.max;
    }

    public MinMax clone() {
        try {
            MinMax newVal = (MinMax)super.clone();
            return newVal;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException();
        }
    }

    public MinMax reset(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public int hashCode() {
        return this.min + this.max;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MinMax)) {
            return false;
        }
        MinMax otherMM = (MinMax)other;
        return this.min == otherMM.min && this.max == otherMM.max;
    }

    public SortedSet<Integer> getAsSortedSet() {
        TreeSet<Integer> retval = new TreeSet<Integer>();
        for (int i = this.min; i <= this.max; ++i) {
            retval.add(new Integer(i));
        }
        return retval;
    }

    public MinMax union(MinMax other) {
        MinMax retval = new MinMax();
        retval.min = this.min < other.min ? this.min : other.min;
        retval.max = this.max > other.max ? this.max : other.max;
        return retval;
    }

    public MinMax intersect(MinMax other) {
        MinMax retval = new MinMax();
        retval.min = this.min < other.min ? other.min : this.min;
        int n = retval.max = this.max > other.max ? other.max : this.max;
        if (retval.min > retval.max) {
            return null;
        }
        return retval;
    }

    public boolean contained(int val) {
        return val >= this.min && val <= this.max;
    }

    public boolean outsideOrOnBoundary(int val) {
        return val <= this.min || val >= this.max;
    }

    public MinMax init() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        return this;
    }

    public MinMax update(int newVal) {
        if (newVal < this.min) {
            this.min = newVal;
        }
        if (newVal > this.max) {
            this.max = newVal;
        }
        return this;
    }

    public int evaluate(MinMax other) {
        if (this.min == other.min && this.max == other.max) {
            return 0;
        }
        if (this.min >= other.min && this.max <= other.max) {
            return 1;
        }
        if (this.min <= other.min && this.max >= other.max) {
            return 2;
        }
        if (this.max < other.min || this.min > other.max) {
            return 3;
        }
        return 4;
    }

    public String toString() {
        return "min: " + this.min + " max: " + this.max;
    }

    @Override
    public int compareTo(MinMax other) {
        if (this.min != other.min) {
            return this.min - other.min;
        }
        return this.max - other.max;
    }
}

