/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.api.parser.ParserClient;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFactoryClient
implements ParserClient {
    protected Object container_;
    protected HashMap<String, AbstractFactoryClient> workerMap_;
    protected HashMap<String, GlueStick> glueStickMap_;
    protected AbstractFactoryClient currWorker_;
    protected String currElem_;
    protected Object sharedWhiteboard_;
    protected HashSet<String> myKeys_ = new HashSet();

    public AbstractFactoryClient(Object sharedWhiteboard) {
        this.workerMap_ = new HashMap();
        this.glueStickMap_ = new HashMap();
        this.sharedWhiteboard_ = sharedWhiteboard;
    }

    @Override
    public void setContainer(Object container) {
        this.container_ = container;
    }

    @Override
    public boolean finishElement(String elemName) throws IOException {
        if (this.currWorker_ != null) {
            boolean dropWorker = this.currWorker_.finishElement(elemName);
            if (dropWorker) {
                if (!elemName.equals(this.currElem_)) {
                    throw new IllegalStateException();
                }
                this.currWorker_ = null;
                this.currElem_ = null;
            }
            return this.myKeys_.contains(elemName);
        }
        this.localFinishElement(elemName);
        return this.myKeys_.contains(elemName);
    }

    @Override
    public void processCharacters(char[] chars, int start, int length) {
        if (this.currWorker_ != null) {
            this.currWorker_.processCharacters(chars, start, length);
            return;
        }
        this.localProcessCharacters(chars, start, length);
    }

    @Override
    public Set<String> keywordsOfInterest() {
        return this.myKeys_;
    }

    @Override
    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.currWorker_ != null) {
            return this.currWorker_.processElement(elemName, attrs);
        }
        AbstractFactoryClient assignedWorker = this.workerMap_.get(elemName);
        if (assignedWorker != null) {
            GlueStick glue;
            this.currElem_ = elemName;
            this.currWorker_ = assignedWorker;
            Object createdElement = this.currWorker_.processElement(elemName, attrs);
            if (createdElement != null && (glue = this.glueStickMap_.get(elemName)) != null) {
                glue.glueKidToParent(createdElement, this, this.sharedWhiteboard_);
            }
            return createdElement;
        }
        return this.localProcessElement(elemName, attrs);
    }

    protected void installWorker(AbstractFactoryClient worker, GlueStick glue) {
        Set<String> uniqueKeys = worker.keywordsOfInterest();
        for (String key : uniqueKeys) {
            this.workerMap_.put(key, worker);
            if (glue == null) continue;
            this.glueStickMap_.put(key, glue);
        }
    }

    protected abstract Object localProcessElement(String var1, Attributes var2) throws IOException;

    protected void localFinishElement(String elemName) throws IOException {
    }

    protected void localProcessCharacters(char[] chars, int start, int length) {
    }
}

