/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.model;

import java.util.Comparator;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.util.DataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkComparator
implements Comparator<NetLink> {
    @Override
    public int compare(NetLink one, NetLink otherLink) {
        if (one.equals(otherLink)) {
            return 0;
        }
        String srcOne = DataUtil.normKey(one.getSrcNode().getName());
        String trgOne = DataUtil.normKey(one.getTrgNode().getName());
        String srcTwo = DataUtil.normKey(otherLink.getSrcNode().getName());
        String trgTwo = DataUtil.normKey(otherLink.getTrgNode().getName());
        if (!srcOne.equals(srcTwo)) {
            return srcOne.compareTo(srcTwo);
        }
        if (!trgOne.equals(trgTwo)) {
            return trgOne.compareTo(trgTwo);
        }
        if (one.isShadow() != otherLink.isShadow()) {
            return one.isShadow() ? -1 : 1;
        }
        if (!DataUtil.normKey(one.getRelation()).equals(DataUtil.normKey(otherLink.getRelation()))) {
            return one.getRelation().compareToIgnoreCase(otherLink.getRelation());
        }
        if (!one.getSrcNode().equals(otherLink.getSrcNode())) {
            return one.getSrcNode().compareTo(otherLink.getSrcNode());
        }
        if (!one.getTrgNode().equals(otherLink.getTrgNode())) {
            return one.getTrgNode().compareTo(otherLink.getTrgNode());
        }
        throw new IllegalStateException();
    }
}

