/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.io.BuildDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeLayout {
    public boolean criteriaMet(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        return true;
    }

    public abstract List<NetNode> doNodeLayout(BuildData var1, Params var2, BTProgressMonitor var3) throws AsynchExitRequestException;

    public void installNodeOrder(List<NetNode> targetIDs, BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        int currRow = 0;
        LoopReporter lr = new LoopReporter(targetIDs.size(), 20, monitor, 0.0, 1.0, "progress.installOrdering");
        HashMap<NetNode, Integer> nodeOrder = new HashMap<NetNode, Integer>();
        for (NetNode target : targetIDs) {
            lr.report();
            Integer rowTag = currRow++;
            nodeOrder.put(target, rowTag);
        }
        rbd.setNodeOrder(nodeOrder);
        lr.finish();
    }

    protected List<NetNode> convertOrderToMap(BuildData rbd, List<Integer> orderedStringRows) {
        HashMap<NetNode, Integer> nOrd = new HashMap<NetNode, Integer>();
        TreeMap<Integer, NetNode> rev = new TreeMap<Integer, NetNode>();
        int numOsr = orderedStringRows.size();
        for (int i = 0; i < numOsr; ++i) {
            Integer intval = orderedStringRows.get(i);
            NetNode nid = ((BuildDataImpl)rbd).getNodeIDForRowForNetwork(intval);
            nOrd.put(nid, i);
            rev.put(i, nid);
        }
        rbd.setNodeOrder(nOrd);
        return new ArrayList<NetNode>(rev.values());
    }

    public static interface Params {
    }
}

