/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLayout
extends NodeLayout {
    @Override
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<NetNode> startNodeIDs = params == null ? null : ((DefaultParams)params).startNodes;
        List<NetNode> targetIDs = this.defaultNodeOrder(rbd.getLinks(), rbd.getSingletonNodes(), startNodeIDs, monitor);
        this.installNodeOrder(targetIDs, rbd, monitor);
        return targetIDs;
    }

    public List<NetNode> defaultNodeOrder(Set<NetLink> allLinks, Set<NetNode> loneNodes, List<NetNode> startNodes, BTProgressMonitor monitor) throws AsynchExitRequestException {
        SortedSet perCount;
        HashMap<NetNode, Integer> linkCounts = new HashMap<NetNode, Integer>();
        HashMap<NetNode, Set<NetNode>> targsPerSource = new HashMap<NetNode, Set<NetNode>>();
        ArrayList<NetNode> targets = new ArrayList<NetNode>();
        HashSet<NetNode> targsToGo = new HashSet<NetNode>();
        int numLink = allLinks.size();
        LoopReporter lr = new LoopReporter(numLink, 20, monitor, 0.0, 0.25, "progress.calculateNodeDegree");
        for (NetLink nextLink : allLinks) {
            lr.report();
            NetNode sidwn = nextLink.getSrcNode();
            NetNode tidwn = nextLink.getTrgNode();
            Set<NetNode> targs = (HashSet<NetNode>)targsPerSource.get(sidwn);
            if (targs == null) {
                targs = new HashSet<NetNode>();
                targsPerSource.put(sidwn, targs);
            }
            targs.add(tidwn);
            targs = (Set)targsPerSource.get(tidwn);
            if (targs == null) {
                targs = new HashSet();
                targsPerSource.put(tidwn, targs);
            }
            targs.add(sidwn);
            targsToGo.add(sidwn);
            targsToGo.add(tidwn);
            Integer srcCount = (Integer)linkCounts.get(sidwn);
            linkCounts.put(sidwn, srcCount == null ? Integer.valueOf(1) : Integer.valueOf(srcCount + 1));
            Integer trgCount = (Integer)linkCounts.get(tidwn);
            linkCounts.put(tidwn, trgCount == null ? Integer.valueOf(1) : Integer.valueOf(trgCount + 1));
        }
        lr.finish();
        lr = new LoopReporter(linkCounts.size(), 20, monitor, 0.25, 0.5, "progress.rankByDegree");
        TreeMap countRank = new TreeMap(Collections.reverseOrder());
        for (NetNode src : linkCounts.keySet()) {
            lr.report();
            Integer count = (Integer)linkCounts.get(src);
            perCount = (TreeSet<NetNode>)countRank.get(count);
            if (perCount == null) {
                perCount = new TreeSet<NetNode>();
                countRank.put(count, perCount);
            }
            perCount.add(src);
        }
        lr.finish();
        if (startNodes != null && !startNodes.isEmpty()) {
            ArrayList<NetNode> queue = new ArrayList<NetNode>();
            targsToGo.removeAll(startNodes);
            targets.addAll(startNodes);
            queue.addAll(startNodes);
            this.flushQueue(targets, targsPerSource, linkCounts, targsToGo, queue, monitor, 0.5, 0.75);
        }
        while (!targsToGo.isEmpty()) {
            for (Integer key : countRank.keySet()) {
                perCount = (SortedSet)countRank.get(key);
                for (NetNode node : perCount) {
                    if (!targsToGo.contains(node)) continue;
                    ArrayList<NetNode> queue = new ArrayList<NetNode>();
                    targsToGo.remove(node);
                    targets.add(node);
                    this.addMyKidsNR(targets, targsPerSource, linkCounts, targsToGo, node, queue, monitor, 0.75, 1.0);
                }
            }
        }
        LoopReporter lr2 = new LoopReporter(loneNodes.size(), 20, monitor, 0.0, 0.25, "progress.addSingletonsToTargets");
        HashSet targSet = new HashSet(targets);
        TreeSet<NetNode> remains = new TreeSet<NetNode>();
        for (NetNode lnod : loneNodes) {
            if (targSet.contains(lnod)) continue;
            lr2.report();
            remains.add(lnod);
        }
        lr2.finish();
        targets.addAll(remains);
        return targets;
    }

    private List<NetNode> orderMyKids(Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, NetNode node) {
        Set<NetNode> targs = targsPerSource.get(node);
        if (targs == null) {
            return new ArrayList<NetNode>();
        }
        TreeMap kidMap = new TreeMap(Collections.reverseOrder());
        for (NetNode nextTarg : targs) {
            Integer count = linkCounts.get(nextTarg);
            TreeSet<NetNode> perCount = (TreeSet<NetNode>)kidMap.get(count);
            if (perCount == null) {
                perCount = new TreeSet<NetNode>();
                kidMap.put(count, perCount);
            }
            perCount.add(nextTarg);
        }
        ArrayList<NetNode> myKidsToProc = new ArrayList<NetNode>();
        for (TreeSet<NetNode> perCount : kidMap.values()) {
            for (NetNode kid : perCount) {
                if (!targsToGo.contains(kid)) continue;
                myKidsToProc.add(kid);
            }
        }
        return myKidsToProc;
    }

    private void addMyKidsNR(List<NetNode> targets, Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, NetNode node, List<NetNode> queue, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        queue.add(node);
        this.flushQueue(targets, targsPerSource, linkCounts, targsToGo, queue, monitor, startFrac, endFrac);
    }

    private void flushQueue(List<NetNode> targets, Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, List<NetNode> queue, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(targsToGo.size(), 20, monitor, startFrac, endFrac, "progress.nodeOrdering");
        int lastSize = targsToGo.size();
        while (!queue.isEmpty()) {
            NetNode node = queue.remove(0);
            int ttgSize = targsToGo.size();
            lr.report(lastSize - ttgSize);
            lastSize = ttgSize;
            List<NetNode> myKids = this.orderMyKids(targsPerSource, linkCounts, targsToGo, node);
            for (NetNode kid : myKids) {
                if (!targsToGo.contains(kid)) continue;
                targsToGo.remove(kid);
                targets.add(kid);
                queue.add(kid);
            }
        }
        lr.finish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultParams
    implements NodeLayout.Params {
        public List<NetNode> startNodes;

        public DefaultParams(List<NetNode> startNodes) {
            this.startNodes = startNodes;
        }
    }
}

