/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.layout;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.AnnotColorSource;
import org.systemsbiology.biofabric.api.layout.EdgeLayout;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEdgeLayout
implements EdgeLayout {
    @Override
    public void preProcessEdges(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
    }

    public SortedMap<Integer, NetLink> layoutEdges(Map<NetNode, Integer> nodeOrder, Set<NetLink> allLinks, List<String> linkGroups, Network.LayoutMode layoutMode, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NetNode, Integer> targToRow = new HashMap<NetNode, Integer>();
        for (NetNode target : nodeOrder.keySet()) {
            Integer rowObj = nodeOrder.get(target);
            targToRow.put(target, rowObj);
        }
        HashMap<String, String> augToRel = new HashMap<String, String>();
        for (NetLink link : allLinks) {
            AugRelation augRel = link.getAugRelation();
            String match = (String)augToRel.get(augRel.relation);
            if (match != null) continue;
            for (String rel : linkGroups) {
                if (!this.bestSuffixMatch(augRel.relation, rel, linkGroups)) continue;
                augToRel.put(augRel.relation, rel);
            }
        }
        DefaultFabricLinkLocater dfll = new DefaultFabricLinkLocater(targToRow, linkGroups, augToRel, layoutMode);
        TreeSet<NetLink> order = new TreeSet<NetLink>(dfll);
        LoopReporter lr = new LoopReporter(allLinks.size(), 20, monitor, 0.0, 1.0, "progress.linkLayout");
        for (NetLink link : allLinks) {
            lr.report();
            order.add(link);
        }
        TreeMap<Integer, NetLink> retval = new TreeMap<Integer, NetLink>();
        int count = 0;
        for (NetLink link : order) {
            retval.put(count++, link);
            lr.report();
        }
        lr.finish();
        return retval;
    }

    @Override
    public void layoutEdges(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        SortedMap<Integer, NetLink> retval = this.layoutEdges(rbd.getNodeOrder(), rbd.getLinks(), rbd.getGroupOrder(), rbd.getGroupOrderMode(), monitor);
        rbd.setLinkOrder(retval);
        if (rbd.getShowLinkGroupAnnotations()) {
            this.installLinkAnnotations(rbd, monitor);
        } else {
            rbd.setLinkAnnotations(null);
        }
    }

    public SortedMap<Integer, NetLink> layoutAllEdges(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        SortedMap<Integer, NetLink> retval = this.layoutEdges(rbd.getNodeOrder(), rbd.getLinks(), rbd.getGroupOrder(), rbd.getGroupOrderMode(), monitor);
        rbd.setLinkOrder(retval);
        if (rbd.getShowLinkGroupAnnotations()) {
            this.installLinkAnnotations(rbd, monitor);
        } else {
            rbd.setLinkAnnotations(null);
        }
        return retval;
    }

    protected void installLinkAnnotations(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter(rbd.getLinkOrder().size(), 20, monitor, 0.0, 1.0, "progress.linkAnnotationPrep");
        ArrayList<NetLink> linkList = new ArrayList<NetLink>();
        for (NetLink link : rbd.getLinkOrder().values()) {
            linkList.add(link);
            lr.report();
        }
        lr.finish();
        AnnotationSet nonShdwAnnots = this.calcGroupLinkAnnots(rbd, linkList, monitor, false, rbd.getGroupOrder());
        AnnotationSet withShdwAnnots = this.calcGroupLinkAnnots(rbd, linkList, monitor, true, rbd.getGroupOrder());
        HashMap<Boolean, AnnotationSet> linkAnnots = new HashMap<Boolean, AnnotationSet>();
        linkAnnots.put(true, withShdwAnnots);
        linkAnnots.put(false, nonShdwAnnots);
        rbd.setLinkAnnotations(linkAnnots);
    }

    protected AnnotationSet calcGroupLinkAnnots(BuildData rbd, List<NetLink> links, BTProgressMonitor monitor, boolean shadow, List<String> linkGroups) throws AsynchExitRequestException {
        String which = shadow ? "progress.linkAnnotationShad" : "progress.linkAnnotationNoShad";
        LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, which);
        Map<String, String> colorMap = AnnotColorSource.getColorMap(linkGroups);
        AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
        String lastType = null;
        int startPos = 0;
        int endPos = 0;
        int numLink = links.size();
        int count = 0;
        for (int i = 0; i < numLink; ++i) {
            NetLink link = links.get(i);
            lr.report();
            if (link.isShadow() && !shadow) continue;
            String thisType = link.getRelation();
            if (lastType == null) {
                lastType = thisType;
                startPos = count;
            } else if (!lastType.equals(thisType)) {
                retval.addAnnot(PluginSupportFactory.buildAnnotation(lastType, startPos, endPos, 0, this.getColor(lastType, colorMap)));
                lastType = thisType;
                startPos = count;
            }
            endPos = count++;
        }
        if (lastType != null) {
            retval.addAnnot(PluginSupportFactory.buildAnnotation(lastType, startPos, endPos, 0, this.getColor(lastType, colorMap)));
        }
        lr.finish();
        return retval;
    }

    private boolean bestSuffixMatch(String augR, String relToMatch, List<String> allRels) {
        if (relToMatch == null) {
            return true;
        }
        int topLen = 0;
        String topRel = null;
        for (String aRel : allRels) {
            int ioaRel;
            int matchLen = aRel.length();
            if (matchLen < topLen || (ioaRel = augR.indexOf(aRel)) < 0 || ioaRel != augR.length() - matchLen) continue;
            if (topLen == matchLen) {
                throw new IllegalStateException();
            }
            if (topLen >= matchLen) continue;
            topLen = matchLen;
            topRel = aRel;
        }
        if (topRel == null) {
            throw new IllegalStateException();
        }
        return topRel.equals(relToMatch);
    }

    protected String getColor(String type, Map<String, String> colorMap) {
        return colorMap.get(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultFabricLinkLocater
    implements Comparator<NetLink> {
        private Map<NetNode, Integer> nodeToRow_;
        private List<String> relOrder_;
        private Map<String, String> augToRel_;
        Network.LayoutMode layMode_;

        public DefaultFabricLinkLocater(Map<NetNode, Integer> nodeToRow, List<String> relOrder, Map<String, String> augToRel, Network.LayoutMode layMode) {
            this.nodeToRow_ = nodeToRow;
            this.augToRel_ = augToRel;
            this.relOrder_ = relOrder;
            this.layMode_ = layMode;
        }

        @Override
        public int compare(NetLink link1, NetLink link2) {
            Integer perGroup;
            boolean link2Reg;
            if (link1.equals(link2)) {
                return 0;
            }
            NetNode l1s = link1.getSrcNode();
            NetNode l1t = link1.getTrgNode();
            NetNode l2s = link2.getSrcNode();
            NetNode l2t = link2.getTrgNode();
            Integer l1sR = this.nodeToRow_.get(l1s);
            Integer l1tR = this.nodeToRow_.get(l1t);
            Integer l2sR = this.nodeToRow_.get(l2s);
            Integer l2tR = this.nodeToRow_.get(l2t);
            int link1Top = Math.min(l1sR, l1tR);
            int link1Bot = Math.max(l1sR, l1tR);
            int link2Top = Math.min(l2sR, l2tR);
            int link2Bot = Math.max(l2sR, l2tR);
            boolean link1Reg = !link1.isShadow();
            boolean bl = link2Reg = !link2.isShadow();
            if (this.layMode_ == Network.LayoutMode.PER_NETWORK_MODE) {
                int ord2;
                AugRelation link1Rel = link1.getAugRelation();
                AugRelation link2Rel = link2.getAugRelation();
                int ord1 = this.relOrder_.indexOf(this.augToRel_.get(link1Rel.relation));
                int ordDiff = ord1 - (ord2 = this.relOrder_.indexOf(this.augToRel_.get(link2Rel.relation)));
                if (ordDiff != 0) {
                    return ordDiff;
                }
            }
            if (link1Reg && link2Reg) {
                int topDiff = link1Top - link2Top;
                if (topDiff != 0) {
                    return topDiff;
                }
                perGroup = this.orderUsingGroups(link1, link2);
                if (perGroup != null) {
                    return perGroup;
                }
                int botDiff = link1Bot - link2Bot;
                if (botDiff != 0) {
                    return botDiff;
                }
                return this.orderForNode(link1, link2, l1sR, l1tR, l2sR, l2tR);
            }
            if (!link1Reg && !link2Reg) {
                int botDiff = link1Bot - link2Bot;
                if (botDiff != 0) {
                    return botDiff;
                }
                perGroup = this.orderUsingGroups(link1, link2);
                if (perGroup != null) {
                    return perGroup;
                }
                int topDiff = link1Top - link2Top;
                if (topDiff != 0) {
                    return topDiff;
                }
                return this.orderForNode(link1, link2, l1sR, l1tR, l2sR, l2tR);
            }
            if (link1Reg && !link2Reg) {
                int rsDiff = link1Top - link2Bot;
                if (rsDiff != 0) {
                    return rsDiff;
                }
                perGroup = this.orderUsingGroups(link1, link2);
                if (perGroup != null) {
                    return perGroup;
                }
                return 1;
            }
            if (!link1Reg && link2Reg) {
                int rsDiff = link1Bot - link2Top;
                if (rsDiff != 0) {
                    return rsDiff;
                }
                perGroup = this.orderUsingGroups(link1, link2);
                if (perGroup != null) {
                    return perGroup;
                }
                return -1;
            }
            throw new IllegalArgumentException();
        }

        public Integer orderUsingGroups(NetLink link1, NetLink link2) {
            int ord2;
            int ord1;
            int ordDiff;
            AugRelation link1Rel = link1.getAugRelation();
            AugRelation link2Rel = link2.getAugRelation();
            if (this.layMode_ == Network.LayoutMode.PER_NODE_MODE && (ordDiff = (ord1 = this.relOrder_.indexOf(this.augToRel_.get(link1Rel.relation))) - (ord2 = this.relOrder_.indexOf(this.augToRel_.get(link2Rel.relation)))) != 0) {
                return ordDiff;
            }
            return null;
        }

        public int orderForNode(NetLink link1, NetLink link2, Integer l1sR, Integer l1tR, Integer l2sR, Integer l2tR) {
            boolean dirFeed2;
            Boolean link2PointsUp;
            Boolean link1PointsUp;
            AugRelation link1Rel = link1.getAugRelation();
            AugRelation link2Rel = link2.getAugRelation();
            boolean link1IsDir = link1.isDirected();
            Boolean bl = link1IsDir ? Boolean.valueOf(l1sR > l1tR) : (link1PointsUp = null);
            Boolean link1PointsDown = link1IsDir ? Boolean.valueOf(l1sR < l1tR) : null;
            boolean link2IsDir = link2.isDirected();
            Boolean bl2 = link2IsDir ? Boolean.valueOf(l2sR > l2tR) : (link2PointsUp = null);
            Boolean link2PointsDown = link2IsDir ? Boolean.valueOf(l2sR < l2tR) : null;
            boolean undirFeed1 = !link1IsDir && l1sR.intValue() == l1tR.intValue();
            boolean undirFeed2 = !link2IsDir && l2sR.intValue() == l2tR.intValue();
            boolean dirFeed1 = link1IsDir && link1PointsUp == false && link1PointsDown == false;
            boolean bl3 = dirFeed2 = link2IsDir && link2PointsUp == false && link2PointsDown == false;
            if (undirFeed1 && dirFeed2) {
                return -1;
            }
            if (dirFeed1 && undirFeed2) {
                return 1;
            }
            if (link1IsDir && !link2IsDir) {
                return 1;
            }
            if (!link1IsDir && link2IsDir) {
                return -1;
            }
            if (link1IsDir && link2IsDir) {
                if (link1PointsDown.booleanValue() && link2PointsUp.booleanValue()) {
                    return -1;
                }
                if (link1PointsUp.booleanValue() && link2PointsDown.booleanValue()) {
                    return 1;
                }
            }
            int relComp = link1Rel.compareTo(link2Rel);
            return relComp;
        }
    }
}

