/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.layout;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotColorSource {
    public static AnnotColor[] getColorCycle() {
        AnnotColor[] ancs = AnnotColor.values();
        AnnotColor[] annotColors = new AnnotColor[ancs.length];
        AnnotColor[] annotColorArray = ancs;
        int n = annotColorArray.length;
        for (int i = 0; i < n; ++i) {
            AnnotColor ac;
            annotColors[ac.getCycle()] = ac = annotColorArray[i];
        }
        return ancs;
    }

    public static Color[] getGrayCycle() {
        Color[] annotGrays = new Color[]{new Color(220, 220, 220, 127), new Color(245, 245, 245, 127)};
        return annotGrays;
    }

    public static Map<String, String> getColorMap(List<String> linkGroups) {
        HashMap<String, String> colorMap = new HashMap<String, String>();
        int numLg = linkGroups.size();
        int numColor = AnnotColor.values().length;
        AnnotColor[] myCycle = AnnotColorSource.getColorCycle();
        for (int i = 0; i < numLg; ++i) {
            String linkGroup = linkGroups.get(i);
            AnnotColor ac = myCycle[i % numColor];
            colorMap.put(linkGroup, ac.getName());
        }
        return colorMap;
    }

    public int getAnnotColorCount() {
        return AnnotColor.values().length;
    }

    public int getLinkAnnotGrayCount() {
        return 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnnotColor {
        GRAY_BLUE("GrayBlue", 0, new Color(228, 236, 248, 255)),
        ORANGE("Orange", 1, new Color(253, 222, 195, 255)),
        YELLOW("Yellow", 2, new Color(255, 252, 203, 255)),
        GREEN("Green", 3, new Color(227, 253, 230, 255)),
        PURPLE("Purple", 4, new Color(227, 224, 253, 255)),
        PINK("Pink", 5, new Color(253, 224, 235, 255)),
        POWDER_BLUE("PowderBlue", 6, new Color(224, 243, 253, 255)),
        PEACH("Peach", 7, new Color(254, 246, 225, 255)),
        DARK_GRAY_BLUE("DarkGrayBlue", 8, new Color(205, 212, 223, 255)),
        DARK_ORANGE("DarkOrange", 9, new Color(228, 200, 176, 255)),
        DARK_YELLOW("DarkYellow", 10, new Color(230, 227, 183, 255)),
        DARK_GREEN("DarkGreen", 11, new Color(205, 228, 207, 255)),
        DARK_PURPLE("DarkPurple", 12, new Color(205, 202, 228, 255)),
        DARK_PINK("DarkPink", 13, new Color(228, 202, 212, 255)),
        DARK_POWDER_BLUE("DarkPowderBlue", 14, new Color(202, 219, 228, 255)),
        DARK_PEACH("DarkPeach", 15, new Color(229, 221, 203, 255));

        private final String name_;
        private final int cycle_;
        private final Color col_;

        private AnnotColor(String name, int cycle, Color col) {
            this.name_ = name;
            this.cycle_ = cycle;
            this.col_ = col;
        }

        public Color getColor() {
            return this.col_;
        }

        public String getName() {
            return this.name_;
        }

        public int getCycle() {
            return this.cycle_;
        }

        public static AnnotColor getColor(String name) {
            String collapseName = name.replaceAll(" ", "");
            for (AnnotColor ac : AnnotColor.values()) {
                if (!ac.name_.equalsIgnoreCase(collapseName)) continue;
                return ac;
            }
            throw new IllegalArgumentException();
        }
    }
}

