/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.api.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CharacterEntityMapper {
    public static String mapEntities(String input, boolean doSpaces) {
        String retval = input;
        if (input.indexOf(34) != -1) {
            retval = retval.replaceAll("\"", "&quot;");
        }
        if (input.indexOf(60) != -1) {
            retval = retval.replaceAll("<", "&lt;");
        }
        if (input.indexOf(62) != -1) {
            retval = retval.replaceAll(">", "&gt;");
        }
        if (input.indexOf(38) != -1) {
            retval = retval.replaceAll("&", "&amp;");
        }
        if (doSpaces && input.indexOf(32) != -1) {
            retval = retval.replaceAll(" ", "&nbsp;");
        }
        StringBuffer buf = new StringBuffer();
        int len = retval.length();
        for (int i = 0; i < len; ++i) {
            char ch;
            char intval = ch = retval.charAt(i);
            if (ch > '\u007f') {
                buf.append("&#x");
                if (ch < '\u1000') {
                    buf.append('0');
                }
                buf.append(Integer.toString(ch, 16));
                buf.append(";");
                continue;
            }
            buf.append(ch);
        }
        retval = buf.toString();
        return retval;
    }

    public static String unmapEntities(String input, boolean doSpaces) {
        if (input == null) {
            return input;
        }
        String retval = input;
        if (input.indexOf("&quot;") != -1) {
            retval = retval.replaceAll("&quot;", "\"");
        }
        if (input.indexOf("&lt;") != -1) {
            retval = retval.replaceAll("&lt;", "<");
        }
        if (input.indexOf("&gt;") != -1) {
            retval = retval.replaceAll("&gt;", ">");
        }
        if (input.indexOf("&amp;") != -1) {
            retval = retval.replaceAll("&amp;", "&");
        }
        if (doSpaces && input.indexOf("&nbsp;") != -1) {
            retval = retval.replaceAll("&nbsp;", " ");
        }
        StringBuffer buf = new StringBuffer();
        int len = retval.length();
        int i = 0;
        while (i < len) {
            String chopped = retval.substring(i);
            if (chopped.indexOf("&#x") == 0) {
                int semiIndex = chopped.indexOf(59);
                if (semiIndex > 7) {
                    buf.append(chopped.charAt(0));
                    ++i;
                    continue;
                }
                String numStr = chopped.substring(3, semiIndex);
                try {
                    int numVal = Integer.parseInt(numStr, 16);
                    buf.append((char)numVal);
                    i += 8;
                }
                catch (NumberFormatException nfe) {
                    buf.append(chopped.charAt(0));
                    ++i;
                }
                continue;
            }
            buf.append(chopped.charAt(0));
            ++i;
        }
        retval = buf.toString();
        return retval;
    }

    public static String mapEntitiesNotTags(String input, boolean doSpaces) {
        String retval = CharacterEntityMapper.mapEntities(input, doSpaces);
        Pattern iopen = Pattern.compile("&lt;i&gt;");
        Pattern iclose = Pattern.compile("&lt;/i&gt;");
        Pattern supOpen = Pattern.compile("&lt;sup&gt;");
        Pattern supClose = Pattern.compile("&lt;/sup&gt;");
        Pattern subOpen = Pattern.compile("&lt;sub&gt;");
        Pattern subClose = Pattern.compile("&lt;/sub&gt;");
        Matcher m = iopen.matcher(retval);
        retval = m.replaceAll("<i>");
        m = iclose.matcher(retval);
        retval = m.replaceAll("</i>");
        m = supOpen.matcher(retval);
        retval = m.replaceAll("<sup>");
        m = supClose.matcher(retval);
        retval = m.replaceAll("</sup>");
        m = subOpen.matcher(retval);
        retval = m.replaceAll("<sub>");
        m = subClose.matcher(retval);
        retval = m.replaceAll("</sub>");
        return retval;
    }
}

