/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.analysis;

import java.util.Comparator;
import java.util.Map;
import org.systemsbiology.biofabric.api.util.NID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIDLink
implements Cloneable,
Comparable<NIDLink> {
    protected NID.WithName src_;
    protected NID.WithName trg_;

    public NIDLink(NID.WithName src, NID.WithName trg) {
        if (src == null || trg == null) {
            throw new IllegalArgumentException();
        }
        this.src_ = src;
        this.trg_ = trg;
    }

    public NIDLink(NIDLink other) {
        this.src_ = other.src_;
        this.trg_ = other.trg_;
    }

    public NIDLink clone() {
        try {
            return (NIDLink)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public NID.WithName getTrg() {
        return this.trg_;
    }

    public NID.WithName getSrc() {
        return this.src_;
    }

    public int hashCode() {
        return this.src_.hashCode() + this.trg_.hashCode();
    }

    public String toString() {
        return "src = " + this.src_ + " trg = " + this.trg_;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof NIDLink)) {
            return false;
        }
        NIDLink otherLink = (NIDLink)other;
        return this.src_.equals(otherLink.src_) && this.trg_.equals(otherLink.trg_);
    }

    @Override
    public int compareTo(NIDLink otherLink) {
        if (this == otherLink) {
            return 0;
        }
        if (!this.src_.equals(otherLink.src_)) {
            return this.src_.compareTo(otherLink.src_);
        }
        return this.trg_.compareTo(otherLink.trg_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NIDLinkLocationOrder
    implements Comparator<NIDLink> {
        private Map<NID.WithName, Integer> nodeToRow_;

        public NIDLinkLocationOrder(Map<NID.WithName, Integer> nodeToRow) {
            this.nodeToRow_ = nodeToRow;
        }

        @Override
        public int compare(NIDLink link1, NIDLink link2) {
            NID.WithName l1s = link1.getSrc();
            NID.WithName l1t = link1.getTrg();
            NID.WithName l2s = link2.getSrc();
            NID.WithName l2t = link2.getTrg();
            Integer l1sR = this.nodeToRow_.get(l1s);
            Integer l1tR = this.nodeToRow_.get(l1t);
            Integer l2sR = this.nodeToRow_.get(l2s);
            Integer l2tR = this.nodeToRow_.get(l2t);
            if (l1sR.equals(l2sR)) {
                return l1tR - l2tR;
            }
            if (l1sR.equals(l2tR)) {
                return l1tR - l2sR;
            }
            if (l1tR.equals(l2sR)) {
                return l1sR - l2tR;
            }
            if (l1tR.equals(l2tR)) {
                return l1sR - l2sR;
            }
            throw new IllegalArgumentException();
        }
    }
}

