/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.analysis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSearcher {
    private HashSet<NetNode> allNodes_;
    private HashSet<NetLink> allEdges_;
    private ArrayList<NetNode> nodeOrder_;
    private ArrayList<NetLink> edgeOrder_;

    public GraphSearcher(Set<NetNode> nodes, Set<NetLink> links) {
        this.allNodes_ = new HashSet<NetNode>(nodes);
        this.allEdges_ = new HashSet<NetLink>(links);
        this.edgeOrder_ = null;
        this.nodeOrder_ = null;
    }

    public GraphSearcher(List<NetNode> nodes, List<NetLink> links) {
        this.allNodes_ = new HashSet<NetNode>(nodes);
        this.allEdges_ = new HashSet();
        this.edgeOrder_ = new ArrayList();
        this.nodeOrder_ = new ArrayList<NetNode>(nodes);
        for (NetLink link : links) {
            if (!this.allEdges_.contains(link)) {
                this.edgeOrder_.add(link);
            }
            this.allEdges_.add(link);
        }
    }

    public Map<NetNode, Integer> nodeDegree(boolean inOnly, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return relCollapse ? GraphSearcher.nodeNeighborCount(inOnly, this.allEdges_, monitor) : GraphSearcher.nodeDegree(inOnly, this.allEdges_, monitor);
    }

    public static Map<NetNode, Integer> nodeDegree(boolean inOnly, Set<NetLink> edges, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NodeAndRel, Integer> retval0 = new HashMap<NodeAndRel, Integer>();
        for (NetLink link : edges) {
            NetNode src = link.getSrcNode();
            NetNode trg = link.getTrgNode();
            String relation = link.getRelation();
            NodeAndRel sar = new NodeAndRel(src, relation);
            if (!inOnly) {
                Integer deg = (Integer)retval0.get(sar);
                if (deg == null) {
                    retval0.put(sar, 1);
                } else {
                    retval0.put(sar, deg + 1);
                }
            }
            NodeAndRel tar = new NodeAndRel(trg, relation);
            Integer deg = (Integer)retval0.get(trg);
            if (deg == null) {
                retval0.put(tar, 1);
                continue;
            }
            retval0.put(tar, deg + 1);
        }
        HashMap<NetNode, Integer> retval = new HashMap<NetNode, Integer>();
        for (NodeAndRel nar : retval0.keySet()) {
            Integer count = (Integer)retval0.get(nar);
            Integer nco = retval.get(nar.getNode());
            nco = nco == null ? Integer.valueOf(count) : Integer.valueOf(count + nco);
            retval.put(nar.getNode(), nco);
        }
        return retval;
    }

    public static Map<NetNode, Integer> nodeNeighborCount(boolean inOnly, Set<NetLink> edges, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NetNode, Integer> retval = new HashMap<NetNode, Integer>();
        for (NetLink link : edges) {
            Integer deg;
            NetNode src = link.getSrcNode();
            NetNode trg = link.getTrgNode();
            if (!inOnly) {
                deg = retval.get(src);
                if (deg == null) {
                    retval.put(src, 1);
                } else {
                    retval.put(src, deg + 1);
                }
            }
            if ((deg = retval.get(trg)) == null) {
                retval.put(trg, 1);
                continue;
            }
            retval.put(trg, deg + 1);
        }
        return retval;
    }

    private SortedSet<NodeDegree> nodeDegreeSet(boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        return GraphSearcher.nodeDegreeSet(this.allEdges_, relCollapse, monitor);
    }

    private static SortedSet<NodeDegree> nodeDegreeSet(Set<NetLink> edges, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        TreeSet<NodeDegree> retval = new TreeSet<NodeDegree>();
        Map<NetNode, Integer> nds = relCollapse ? GraphSearcher.nodeNeighborCount(false, edges, monitor) : GraphSearcher.nodeDegree(false, edges, monitor);
        for (NetNode nar : nds.keySet()) {
            NodeDegree ndeg = new NodeDegree(nar, nds.get(nar));
            retval.add(ndeg);
        }
        return retval;
    }

    public static List<NetNode> nodesByDegree(Set<NetNode> nodes, SortedSet<NodeDegree> nds) {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        for (NodeDegree nd : nds) {
            NetNode node = nd.getNodeID();
            if (!nodes.contains(node)) continue;
            retval.add(node);
        }
        return retval;
    }

    public SortedSet<SourcedNodeDegree> nodeDegreeSetWithSource(List<NetNode> sourceOrder) {
        HashSet<NetNode> trgSources;
        HashMap<NetNode, HashSet<NetNode>> allSrcs = new HashMap<NetNode, HashSet<NetNode>>();
        for (NetLink nextLink : this.allEdges_) {
            NetNode trg = nextLink.getTrgNode();
            trgSources = (HashSet<NetNode>)allSrcs.get(trg);
            if (trgSources == null) {
                trgSources = new HashSet<NetNode>();
                allSrcs.put(trg, trgSources);
            }
            trgSources.add(nextLink.getSrcNode());
        }
        TreeSet<SourcedNodeDegree> retval = new TreeSet<SourcedNodeDegree>();
        for (NetNode node : allSrcs.keySet()) {
            trgSources = (Set)allSrcs.get(node);
            SourcedNodeDegree ndeg = new SourcedNodeDegree(node, sourceOrder, trgSources);
            retval.add(ndeg);
        }
        return retval;
    }

    public SortedSet<SourcedNodeAndRelDegree> nodeDegreeSetWithSourceMultigraph(List<NetNode> sourceOrder) {
        HashMap<NetNode, HashSet<NodeAndRel>> allSrcs = new HashMap<NetNode, HashSet<NodeAndRel>>();
        for (NetLink nextLink : this.allEdges_) {
            NetNode trg = nextLink.getTrgNode();
            String rel = nextLink.getAugRelation().relation;
            HashSet<NodeAndRel> trgSrcAndRels = (HashSet<NodeAndRel>)allSrcs.get(trg);
            if (trgSrcAndRels == null) {
                trgSrcAndRels = new HashSet<NodeAndRel>();
                allSrcs.put(trg, trgSrcAndRels);
            }
            trgSrcAndRels.add(new NodeAndRel(nextLink.getSrcNode(), rel));
        }
        TreeSet<SourcedNodeAndRelDegree> retval = new TreeSet<SourcedNodeAndRelDegree>();
        for (NetNode node : allSrcs.keySet()) {
            Set trgSources = (Set)allSrcs.get(node);
            SourcedNodeAndRelDegree ndeg = new SourcedNodeAndRelDegree(node, sourceOrder, trgSources);
            retval.add(ndeg);
        }
        return retval;
    }

    public SortedSet<SourcedNodeGray> nodeGraySetWithSource(List<NetNode> sourceOrder) {
        HashSet<NetNode> trgSources;
        HashMap<NetNode, HashSet<NetNode>> allSrcs = new HashMap<NetNode, HashSet<NetNode>>();
        for (NetLink nextLink : this.allEdges_) {
            NetNode trg = nextLink.getTrgNode();
            trgSources = (HashSet<NetNode>)allSrcs.get(trg);
            if (trgSources == null) {
                trgSources = new HashSet<NetNode>();
                allSrcs.put(trg, trgSources);
            }
            trgSources.add(nextLink.getSrcNode());
        }
        TreeSet<SourcedNodeGray> retval = new TreeSet<SourcedNodeGray>();
        for (NetNode node : allSrcs.keySet()) {
            trgSources = (Set)allSrcs.get(node);
            SourcedNodeGray ndeg = new SourcedNodeGray(node, sourceOrder, trgSources);
            retval.add(ndeg);
        }
        return retval;
    }

    public static SortedSet<SourcedNodeGray> nodeGraySetWithSourceFromMap(List<NetNode> sourceOrder, Map<NetNode, Set<NetNode>> srcsPerTarg) {
        TreeSet<SourcedNodeGray> retval = new TreeSet<SourcedNodeGray>();
        for (NetNode node : srcsPerTarg.keySet()) {
            SourcedNodeGray ndeg = new SourcedNodeGray(node, sourceOrder, srcsPerTarg.get(node));
            retval.add(ndeg);
        }
        return retval;
    }

    public List<NetNode> nodeDegreeOrder(boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        SortedSet<NodeDegree> nds = this.nodeDegreeSet(relCollapse, monitor);
        for (NodeDegree ndeg : nds) {
            retval.add(ndeg.getNodeID());
        }
        return retval;
    }

    public Map<NetNode, Integer> topoSort(boolean compress) {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        HashMap<NetNode, Integer> retval = new HashMap<NetNode, Integer>();
        HashSet<NetNode> currentNodes = new HashSet<NetNode>(this.allNodes_);
        Set<NetLink> currentEdges = new HashSet<NetLink>();
        for (NetLink link : this.allEdges_) {
            currentEdges.add(((FabricLink)link).clone());
        }
        Map<NetNode, Set<NetLink>> outEdges = this.calcOutboundEdges(currentEdges);
        Set<NetNode> rootNodes = this.buildRootList(currentNodes, currentEdges);
        int level = 0;
        while (!rootNodes.isEmpty()) {
            Integer ilevel = new Integer(level++);
            for (NetNode nodeID : rootNodes) {
                retval.put(nodeID, ilevel);
                outEdges.remove(nodeID);
                currentNodes.remove(nodeID);
            }
            currentEdges = this.invertOutboundEdges(outEdges);
            rootNodes = this.buildRootList(currentNodes, currentEdges);
        }
        if (compress) {
            this.contractTopoSort(retval);
        }
        return retval;
    }

    public List<QueueEntry> depthSearch() {
        HashSet<NetNode> visited = new HashSet<NetNode>();
        Set<NetNode> rootNodes = this.buildRootList(this.allNodes_, this.allEdges_);
        Map<NetNode, Set<NetLink>> outEdges = this.calcOutboundEdges(this.allEdges_);
        ArrayList<QueueEntry> retval = new ArrayList<QueueEntry>();
        if (this.edgeOrder_ != null) {
            HashSet<NetNode> seenRoots = new HashSet<NetNode>();
            for (NetNode currNode : this.nodeOrder_) {
                if (!rootNodes.contains(currNode)) continue;
                boolean gottaLink = false;
                for (NetLink link : this.edgeOrder_) {
                    NetNode src = link.getSrcNode();
                    if (!currNode.equals(src) || seenRoots.contains(src)) continue;
                    seenRoots.add(src);
                    gottaLink = true;
                    this.searchGutsDepth(src, visited, outEdges, 0, this.edgeOrder_, retval);
                }
                if (gottaLink) continue;
                visited.add(currNode);
                retval.add(new QueueEntry(0, currNode));
            }
        } else {
            for (NetNode currNode : rootNodes) {
                this.searchGutsDepth(currNode, visited, outEdges, 0, null, retval);
            }
        }
        return retval;
    }

    public List<QueueEntry> breadthSearch(List<NetNode> startNodes, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        List<NetNode> byDeg = this.nodeDegreeOrder(relCollapse, monitor);
        Collections.reverse(byDeg);
        ArrayList<NetNode> toProcess = new ArrayList<NetNode>(byDeg);
        if (startNodes != null && !startNodes.isEmpty()) {
            toProcess.removeAll(startNodes);
            ArrayList<NetNode> useDeg = new ArrayList<NetNode>(startNodes);
            useDeg.addAll(toProcess);
            toProcess = useDeg;
        }
        HashSet<NetNode> visited = new HashSet<NetNode>();
        ArrayList<QueueEntry> queue = new ArrayList<QueueEntry>();
        ArrayList<QueueEntry> retval = new ArrayList<QueueEntry>();
        Map<NetNode, Set<NetLink>> outEdges = this.calcOutboundEdges(this.allEdges_);
        while (!toProcess.isEmpty()) {
            queue.add(new QueueEntry(0, toProcess.get(0)));
            this.searchGutsBreadth(visited, queue, outEdges, retval, null, byDeg);
            toProcess.removeAll(visited);
        }
        return retval;
    }

    public List<QueueEntry> breadthSearch(boolean byDegree, boolean relCollapse, List<NetNode> useRoots, BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        List<NetNode> byDeg = null;
        if (byDegree) {
            byDeg = this.nodeDegreeOrder(relCollapse, monitor);
            Collections.reverse(byDeg);
        }
        HashSet<NetNode> visited = new HashSet<NetNode>();
        ArrayList<QueueEntry> queue = new ArrayList<QueueEntry>();
        ArrayList<QueueEntry> retval = new ArrayList<QueueEntry>();
        Map<NetNode, Set<NetLink>> outEdges = this.calcOutboundEdges(this.allEdges_);
        List<NetNode> rootNodes = useRoots == null ? new ArrayList<NetNode>(this.buildRootList(this.allNodes_, this.allEdges_)) : useRoots;
        Iterator<NetNode> rit = rootNodes.iterator();
        while (rit.hasNext()) {
            queue.add(new QueueEntry(0, rit.next()));
        }
        this.searchGutsBreadth(visited, queue, outEdges, retval, null, byDeg);
        return retval;
    }

    public List<QueueEntry> breadthSearchUntilStopped(Set<NetNode> startNodes, CriteriaJudge judge) {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        HashSet<NetNode> visited = new HashSet<NetNode>();
        ArrayList<QueueEntry> queue = new ArrayList<QueueEntry>();
        ArrayList<QueueEntry> retval = new ArrayList<QueueEntry>();
        Map<NetNode, Set<NetLink>> outEdges = this.calcOutboundEdges(this.allEdges_);
        Iterator<NetNode> rit = startNodes.iterator();
        while (rit.hasNext()) {
            queue.add(new QueueEntry(0, rit.next()));
        }
        this.searchGutsBreadth(visited, queue, outEdges, retval, judge, null);
        return retval;
    }

    public int invertTopoSort(Map<NetNode, Integer> topoSort, Map<Integer, List<NetNode>> invert) {
        Iterator<NetNode> kit = topoSort.keySet().iterator();
        int maxLevel = -1;
        while (kit.hasNext()) {
            List<NetNode> nodeList;
            NetNode key = kit.next();
            Integer level = topoSort.get(key);
            int currLev = level;
            if (currLev > maxLevel) {
                maxLevel = currLev;
            }
            if ((nodeList = invert.get(level)) == null) {
                nodeList = new ArrayList<NetNode>();
                invert.put(level, nodeList);
            }
            nodeList.add(key);
        }
        return maxLevel;
    }

    public List<NetNode> topoSortToPartialOrdering(Map<NetNode, Integer> topoSort) {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        TreeMap<Integer, List<NetNode>> invert = new TreeMap<Integer, List<NetNode>>();
        this.invertTopoSort(topoSort, invert);
        for (List<NetNode> listForLevel : invert.values()) {
            Collections.sort(listForLevel);
            retval.addAll(listForLevel);
        }
        return retval;
    }

    public List<NetNode> topoSortToPartialOrdering(Map<NetNode, Integer> topoSort, Set<NetLink> allLinks, boolean relCollapse, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        TreeMap<Integer, List<NetNode>> invert = new TreeMap<Integer, List<NetNode>>();
        SortedSet<NodeDegree> nds = GraphSearcher.nodeDegreeSet(allLinks, relCollapse, monitor);
        this.invertTopoSort(topoSort, invert);
        for (List<NetNode> listForLevel : invert.values()) {
            List<NetNode> l4lbyDeg = GraphSearcher.nodesByDegree(new HashSet<NetNode>(listForLevel), nds);
            Collections.reverse(l4lbyDeg);
            retval.addAll(l4lbyDeg);
        }
        return retval;
    }

    public List<NetLink> onlyLinksFromSources(List<NetLink> linkList, Set<NetNode> nodes) {
        ArrayList<NetLink> retval = new ArrayList<NetLink>();
        int numLinks = linkList.size();
        for (int j = 0; j < numLinks; ++j) {
            NetLink link = linkList.get(j);
            if (!nodes.contains(link.getSrcNode())) continue;
            retval.add(link);
        }
        return retval;
    }

    public static Map<NetNode, Integer> topoSortReposition(Map<NetNode, Integer> origSort, NetNode moveID, boolean moveMin) {
        int inc;
        int maxMove;
        int minMove;
        int moveCol;
        Integer origCol = origSort.get(moveID);
        if (origCol == null) {
            return new HashMap<NetNode, Integer>(origSort);
        }
        int colVal = origCol;
        boolean colDup = false;
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        for (NetNode key : origSort.keySet()) {
            if (key.equals(moveID)) continue;
            Integer checkCol = origSort.get(key);
            int chekVal = checkCol;
            if (chekVal < minVal) {
                minVal = chekVal;
            }
            if (chekVal > maxVal) {
                maxVal = chekVal;
            }
            if (chekVal != colVal) continue;
            colDup = true;
        }
        if (moveMin) {
            if (colDup) {
                moveCol = minVal;
                minMove = minVal;
                maxMove = maxVal;
                inc = 1;
            } else {
                moveCol = colVal < minVal ? colVal : minVal;
                minMove = minVal;
                maxMove = colVal - 1;
                inc = 1;
            }
        } else if (colDup) {
            moveCol = maxVal + 1;
            minMove = minVal - 1;
            maxMove = minVal - 1;
            inc = 0;
        } else {
            moveCol = colVal > maxVal ? colVal : maxVal;
            minMove = minVal - 1;
            maxMove = minVal - 1;
            inc = 0;
        }
        HashMap<NetNode, Integer> retval = new HashMap<NetNode, Integer>();
        for (NetNode key : origSort.keySet()) {
            if (key.equals(moveID)) {
                retval.put(moveID, moveCol);
                continue;
            }
            Integer checkCol = origSort.get(key);
            int chekVal = checkCol;
            if (chekVal >= minMove && chekVal <= maxMove) {
                retval.put(key, chekVal + inc);
                continue;
            }
            retval.put(key, checkCol);
        }
        return retval;
    }

    public List<NetNode> topoSortToPartialOrderingByDegree(Map<NetNode, Integer> topoSort, Map<NetNode, Integer> degree) {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        TreeMap<Integer, List<NetNode>> invert = new TreeMap<Integer, List<NetNode>>();
        this.invertTopoSort(topoSort, invert);
        boolean first = true;
        for (List<NetNode> listForLevel : invert.values()) {
            if (first) {
                first = false;
                TreeSet ssnd = new TreeSet(Collections.reverseOrder());
                for (int i = 0; i < listForLevel.size(); ++i) {
                    NetNode node = listForLevel.get(i);
                    ssnd.add(new NodeDegree(node, degree.get(node)));
                }
                for (NodeDegree nd : ssnd) {
                    retval.add(nd.getNodeID());
                }
                continue;
            }
            HashSet<NetNode> snSortSet = new HashSet<NetNode>(retval);
            List<NetLink> justFromSrc = this.onlyLinksFromSources(new ArrayList<NetLink>(this.allEdges_), new HashSet<NetNode>(retval));
            ArrayList<NetNode> working = new ArrayList<NetNode>(retval);
            working.addAll(listForLevel);
            GraphSearcher gs = new GraphSearcher(working, justFromSrc);
            SortedSet<SourcedNodeDegree> snds = gs.nodeDegreeSetWithSource(retval);
            for (SourcedNodeDegree node : snds) {
                if (snSortSet.contains(node.getNode())) continue;
                retval.add(node.getNode());
            }
        }
        return retval;
    }

    public List<NetNode> topoSortToPartialOrderingByGray(Map<NetNode, Integer> topoSort, Map<NetNode, Integer> degree) {
        ArrayList<NetNode> retval = new ArrayList<NetNode>();
        TreeMap<Integer, List<NetNode>> invert = new TreeMap<Integer, List<NetNode>>();
        this.invertTopoSort(topoSort, invert);
        boolean first = true;
        for (List<NetNode> listForLevel : invert.values()) {
            if (first) {
                first = false;
                TreeSet ssnd = new TreeSet(Collections.reverseOrder());
                for (int i = 0; i < listForLevel.size(); ++i) {
                    NetNode node = listForLevel.get(i);
                    ssnd.add(new NodeDegree(node, degree.get(node)));
                }
                for (NodeDegree nd : ssnd) {
                    retval.add(nd.getNodeID());
                }
                continue;
            }
            HashSet<NetNode> snSortSet = new HashSet<NetNode>(retval);
            List<NetLink> justFromSrc = this.onlyLinksFromSources(new ArrayList<NetLink>(this.allEdges_), new HashSet<NetNode>(retval));
            ArrayList<NetNode> working = new ArrayList<NetNode>(retval);
            working.addAll(listForLevel);
            GraphSearcher gs = new GraphSearcher(working, justFromSrc);
            SortedSet<SourcedNodeGray> snds = gs.nodeGraySetWithSource(retval);
            for (SourcedNodeGray node : snds) {
                if (snSortSet.contains(node.getNodeID())) continue;
                retval.add(node.getNodeID());
            }
        }
        return retval;
    }

    private Map<NetNode, Set<NetLink>> calcOutboundEdges(Set<NetLink> edges) {
        HashMap<NetNode, Set<NetLink>> retval = new HashMap<NetNode, Set<NetLink>>();
        for (NetLink link : edges) {
            this.addaLink(link, link.getSrcNode(), retval);
            if (link.isDirected()) continue;
            this.addaLink(link, link.getTrgNode(), retval);
        }
        return retval;
    }

    private void addaLink(NetLink link, NetNode bin, Map<NetNode, Set<NetLink>> collect) {
        Set<NetLink> forBin = collect.get(bin);
        if (forBin == null) {
            forBin = new HashSet<NetLink>();
            collect.put(bin, forBin);
        }
        forBin.add(link);
    }

    private Set<NetNode> buildRootList(Set<NetNode> nodes, Set<NetLink> edges) {
        HashSet<NetNode> retval = new HashSet<NetNode>();
        retval.addAll(nodes);
        for (NetLink link : edges) {
            NetNode trg = link.getTrgNode();
            retval.remove(trg);
        }
        return retval;
    }

    private Set<NetLink> invertOutboundEdges(Map<NetNode, Set<NetLink>> outEdges) {
        HashSet<NetLink> retval = new HashSet<NetLink>();
        for (NetNode src : outEdges.keySet()) {
            Set<NetLink> links = outEdges.get(src);
            for (NetLink lnk : links) {
                if (lnk.isFeedback()) {
                    retval.add(((FabricLink)lnk).clone());
                    continue;
                }
                retval.add(lnk.flipped());
            }
        }
        return retval;
    }

    private void searchGutsDepth(NetNode vertexID, HashSet<NetNode> visited, Map<NetNode, Set<NetLink>> edgesFromSrc, int depth, List<NetLink> edgeOrder, List<QueueEntry> results) {
        if (visited.contains(vertexID)) {
            return;
        }
        visited.add(vertexID);
        results.add(new QueueEntry(depth, vertexID));
        Set<NetLink> outEdges = edgesFromSrc.get(vertexID);
        if (outEdges == null) {
            return;
        }
        if (edgeOrder != null) {
            for (NetLink link : edgeOrder) {
                NetNode targ;
                if (!vertexID.equals(link.getSrcNode()) || visited.contains(targ = link.getTrgNode())) continue;
                this.searchGutsDepth(targ, visited, edgesFromSrc, depth + 1, edgeOrder, results);
            }
        } else {
            for (NetLink link : outEdges) {
                NetNode targ = link.getTrgNode();
                if (visited.contains(targ)) continue;
                this.searchGutsDepth(targ, visited, edgesFromSrc, depth + 1, edgeOrder, results);
            }
        }
    }

    private void searchGutsBreadth(HashSet<NetNode> visited, ArrayList<QueueEntry> queue, Map<NetNode, Set<NetLink>> edgesFromSrc, List<QueueEntry> results, CriteriaJudge judge, List<NetNode> byDegree) {
        while (queue.size() > 0) {
            Set<NetLink> outEdges;
            QueueEntry curr = queue.remove(0);
            if (visited.contains(curr.name)) continue;
            visited.add(curr.name);
            results.add(curr);
            if (judge != null && judge.stopHere(curr.name) || (outEdges = edgesFromSrc.get(curr.name)) == null) continue;
            if (byDegree != null) {
                HashSet<NetNode> fltrg = new HashSet<NetNode>();
                for (NetLink fl : outEdges) {
                    if (fl.isDirected()) {
                        fltrg.add(fl.getTrgNode());
                        continue;
                    }
                    NetNode flSrc = fl.getSrcNode();
                    fltrg.add(curr.name.equals(flSrc) ? fl.getTrgNode() : flSrc);
                }
                for (NetNode trg : byDegree) {
                    if (!fltrg.contains(trg)) continue;
                    queue.add(new QueueEntry(curr.depth + 1, trg));
                }
                continue;
            }
            for (NetLink flink : outEdges) {
                UiUtil.fixMePrintout("What should we be doing here???");
            }
        }
    }

    private void contractTopoSort(Map<NetNode, Integer> topoSort) {
        boolean changed;
        HashMap<Integer, List<NetNode>> nodesAtLevel = new HashMap<Integer, List<NetNode>>();
        int maxLevel = this.invertTopoSort(topoSort, nodesAtLevel);
        if (maxLevel == -1) {
            return;
        }
        Map<NetNode, Set<NetLink>> outEdges = this.calcOutboundEdges(this.allEdges_);
        do {
            changed = false;
            for (int i = maxLevel; i >= 0; --i) {
                List<NetNode> nodeList = nodesAtLevel.get(i);
                ArrayList<NetNode> listCopy = new ArrayList<NetNode>(nodeList);
                int numNodes = nodeList.size();
                for (int j = 0; j < numNodes; ++j) {
                    NetNode currNode = (NetNode)listCopy.get(j);
                    Set<NetLink> linksForNode = outEdges.get(currNode);
                    HashSet<NetNode> targsForNode = new HashSet<NetNode>();
                    for (NetLink link : linksForNode) {
                        NetNode targ = link.getTrgNode();
                        targsForNode.add(targ);
                    }
                    int min = this.getMinLevel(targsForNode, topoSort, i, maxLevel);
                    if (min <= i + 1) continue;
                    List<NetNode> higherNodeList = nodesAtLevel.get(min - 1);
                    higherNodeList.add(currNode);
                    nodeList.remove(currNode);
                    topoSort.put(currNode, min - 1);
                    changed = true;
                }
            }
        } while (changed);
    }

    private int getMinLevel(Set<NetNode> targs, Map<NetNode, Integer> topoSort, int currLevel, int maxLevel) {
        if (targs == null) {
            return currLevel;
        }
        int min = maxLevel;
        for (NetNode trg : targs) {
            Integer level = topoSort.get(trg);
            int currLev = level;
            if (min <= currLev) continue;
            min = currLev;
        }
        return min;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeAndRel
    implements Comparable<NodeAndRel> {
        private NetNode node_;
        private String relation_;

        public NodeAndRel(NetNode node, String relation) {
            this.node_ = node;
            this.relation_ = relation;
        }

        public NetNode getNode() {
            return this.node_;
        }

        public String getRelation() {
            return this.relation_;
        }

        public int hashCode() {
            return this.node_.hashCode() + this.relation_.hashCode();
        }

        public String toString() {
            return " node = " + this.node_ + " relation = " + this.relation_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof NodeAndRel)) {
                return false;
            }
            NodeAndRel otherSR = (NodeAndRel)other;
            if (!this.node_.equals(otherSR.node_)) {
                return false;
            }
            return this.relation_.equals(otherSR.relation_);
        }

        @Override
        public int compareTo(NodeAndRel otherSR) {
            int cn = this.node_.compareTo(otherSR.node_);
            if (cn != 0) {
                return cn;
            }
            return this.relation_.compareTo(otherSR.relation_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MMDSourcedNode
    implements Comparable<MMDSourcedNode> {
        private NetNode node_;
        private int myIn_;
        private ArrayList<Integer> mySourceOrderList_;

        public MMDSourcedNode(NetNode node, Map<NetNode, Integer> inDegs, List<NetNode> placeList, Map<NetNode, Set<NetNode>> l2s) {
            this.node_ = node;
            Set<NetNode> mySet = l2s.get(this.node_);
            TreeSet<Integer> mySourceOrder = new TreeSet<Integer>();
            int numNode = placeList.size();
            for (int i = 0; i < numNode; ++i) {
                NetNode nodex = placeList.get(i);
                if (!mySet.contains(nodex)) continue;
                mySourceOrder.add(i);
            }
            this.mySourceOrderList_ = new ArrayList();
            this.myIn_ = inDegs.get(this.node_);
        }

        public NetNode getNode() {
            return this.node_;
        }

        public int hashCode() {
            return this.node_.hashCode();
        }

        public String toString() {
            return " node = " + this.node_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MMDSourcedNode)) {
                return false;
            }
            MMDSourcedNode otherDeg = (MMDSourcedNode)other;
            return this.node_ == null ? otherDeg.node_ == null : this.node_.equals(otherDeg.node_);
        }

        @Override
        public int compareTo(MMDSourcedNode otherDeg) {
            if (this.node_.equals(otherDeg.node_)) {
                return 0;
            }
            int mySize = this.mySourceOrderList_.size();
            int hisSize = otherDeg.mySourceOrderList_.size();
            int min = Math.min(mySize, hisSize);
            for (int i = 0; i < min; ++i) {
                int myVal = this.mySourceOrderList_.get(i);
                int hisVal = otherDeg.mySourceOrderList_.get(i);
                int diff = hisVal - myVal;
                if (diff == 0) continue;
                return diff;
            }
            int diffSize = hisSize - mySize;
            if (diffSize != 0) {
                return diffSize;
            }
            int myIn = this.myIn_;
            int hisIn = otherDeg.myIn_;
            int diffIn = myIn - hisIn;
            if (diffIn != 0) {
                return diffIn;
            }
            if (this.node_ == null) {
                return otherDeg.node_ == null ? 0 : -1;
            }
            return this.node_.compareTo(otherDeg.node_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SourcedNode
    implements Comparable<SourcedNode> {
        private NetNode node_;
        private int myIn_;
        private ArrayList<Integer> mySourceOrderList_;

        public SourcedNode(NetNode node, Map<NetNode, Integer> inDegs, Map<NetNode, Integer> nameToRow, Map<NetNode, Set<NetNode>> l2s) {
            this.node_ = node;
            TreeSet<Integer> myOrder = new TreeSet<Integer>();
            Set<NetNode> mySet = l2s.get(this.node_);
            for (NetNode nextNode : mySet) {
                Integer nextSourceRow = nameToRow.get(nextNode);
                myOrder.add(nextSourceRow);
            }
            this.mySourceOrderList_ = new ArrayList(myOrder);
            this.myIn_ = inDegs.get(this.node_);
        }

        public NetNode getNode() {
            return this.node_;
        }

        public int hashCode() {
            return this.node_.hashCode();
        }

        public String toString() {
            return " node = " + this.node_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SourcedNode)) {
                return false;
            }
            SourcedNode otherDeg = (SourcedNode)other;
            return this.node_ == null ? otherDeg.node_ == null : this.node_.equals(otherDeg.node_);
        }

        @Override
        public int compareTo(SourcedNode otherDeg) {
            if (this.node_.equals(otherDeg.node_)) {
                return 0;
            }
            int mySize = this.mySourceOrderList_.size();
            int hisSize = otherDeg.mySourceOrderList_.size();
            int min = Math.min(mySize, hisSize);
            for (int i = 0; i < min; ++i) {
                int myVal = this.mySourceOrderList_.get(i);
                int hisVal = otherDeg.mySourceOrderList_.get(i);
                int diff = hisVal - myVal;
                if (diff == 0) continue;
                return diff;
            }
            int diffSize = hisSize - mySize;
            if (diffSize != 0) {
                return diffSize;
            }
            int diffIn = this.myIn_ - otherDeg.myIn_;
            if (diffIn != 0) {
                return diffIn;
            }
            if (this.node_ == null) {
                return otherDeg.node_ == null ? 0 : -1;
            }
            return this.node_.compareTo(otherDeg.node_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SourcedNodeGray
    implements Comparable<SourcedNodeGray> {
        private NetNode node_;
        private int degree_;
        private char[] srcs_;
        private String binNum_;
        private BigInteger bi_;
        private BigInteger gray_;
        private List<NetNode> srcOrder_;
        private Set<NetNode> mySrcs_;

        public SourcedNodeGray(NetNode node, List<NetNode> srcOrder, Set<NetNode> mySrcs) {
            this.node_ = node;
            this.degree_ = mySrcs.size();
            this.mySrcs_ = mySrcs;
            int numSrc = srcOrder.size();
            this.srcOrder_ = new ArrayList<NetNode>(srcOrder);
            this.srcs_ = new char[numSrc];
            for (int i = 0; i < numSrc; ++i) {
                this.srcs_[i] = mySrcs.contains(srcOrder.get(i)) ? 49 : 48;
            }
            this.binNum_ = String.copyValueOf(this.srcs_);
            this.bi_ = this.gray_ = new BigInteger(this.binNum_, 2);
            BigInteger working = this.gray_;
            while (!(working = working.shiftRight(1)).equals(BigInteger.ZERO)) {
                this.bi_ = this.bi_.xor(working);
            }
        }

        public Set<NetNode> getSrcs() {
            return this.mySrcs_;
        }

        public NetNode getNodeID() {
            return this.node_;
        }

        public String getBinNum() {
            return this.binNum_;
        }

        public int hashCode() {
            return this.node_.hashCode() + this.degree_;
        }

        public String toString() {
            return " node = " + this.node_ + " degree = " + this.degree_ + " gray_ = " + this.gray_.toString(2) + " bi = " + this.bi_.toString(2);
        }

        public String toStringAsSets() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.node_.getName());
            ret.append(": ");
            boolean first = true;
            for (int i = 0; i < this.srcs_.length; ++i) {
                if (this.srcs_[i] != '1') continue;
                if (!first) {
                    ret.append(" + ");
                } else {
                    first = false;
                }
                ret.append(this.srcOrder_.get(i));
            }
            return ret.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof SourcedNodeGray)) {
                return false;
            }
            SourcedNodeGray otherDeg = (SourcedNodeGray)other;
            if (this.degree_ != otherDeg.degree_) {
                return false;
            }
            return this.node_ == null ? otherDeg.node_ == null : this.node_.equals(otherDeg.node_);
        }

        @Override
        public int compareTo(SourcedNodeGray otherDeg) {
            int nameDiff = this.node_.compareTo(otherDeg.node_);
            if (nameDiff == 0) {
                return 0;
            }
            int grayComp = -this.bi_.compareTo(otherDeg.bi_);
            if (grayComp != 0) {
                return grayComp;
            }
            return nameDiff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SourcedNodeAndRelDegree
    implements Comparable<SourcedNodeAndRelDegree> {
        private NetNode node_;
        private int degree_;
        private boolean[] srcs_;

        public SourcedNodeAndRelDegree(NetNode node, List<NetNode> srcOrder, Set<NodeAndRel> mySARs) {
            this.node_ = node;
            this.degree_ = mySARs.size();
            int numSrc = srcOrder.size();
            this.srcs_ = new boolean[numSrc];
            HashSet<NetNode> snSet = new HashSet<NetNode>();
            for (NodeAndRel sar : mySARs) {
                snSet.add(sar.getNode());
            }
            for (int i = 0; i < numSrc; ++i) {
                if (!snSet.contains(srcOrder.get(i))) continue;
                this.srcs_[i] = true;
            }
        }

        public NetNode getNode() {
            return this.node_;
        }

        public int hashCode() {
            return this.node_.hashCode() + this.degree_;
        }

        public String toString() {
            return " node = " + this.node_ + " degree = " + this.degree_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SourcedNodeAndRelDegree)) {
                return false;
            }
            SourcedNodeAndRelDegree otherDeg = (SourcedNodeAndRelDegree)other;
            if (this.degree_ != otherDeg.degree_) {
                return false;
            }
            return this.node_ == null ? otherDeg.node_ == null : this.node_.equals(otherDeg.node_);
        }

        @Override
        public int compareTo(SourcedNodeAndRelDegree otherDeg) {
            if (this.node_.equals(otherDeg.node_)) {
                return 0;
            }
            if (this.degree_ != otherDeg.degree_) {
                return otherDeg.degree_ - this.degree_;
            }
            boolean iAmBigger = false;
            boolean heIsBigger = false;
            for (int i = 0; i < this.srcs_.length; ++i) {
                if (this.srcs_[i] && !otherDeg.srcs_[i]) {
                    iAmBigger = true;
                    heIsBigger = false;
                    break;
                }
                if (!otherDeg.srcs_[i] || this.srcs_[i]) continue;
                iAmBigger = false;
                heIsBigger = true;
                break;
            }
            if (iAmBigger) {
                return -1;
            }
            if (heIsBigger) {
                return 1;
            }
            if (this.node_ == null) {
                return otherDeg.node_ == null ? 0 : -1;
            }
            return this.node_.compareTo(otherDeg.node_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SourcedNodeDegree
    implements Comparable<SourcedNodeDegree> {
        private NetNode node_;
        private int degree_;
        private boolean[] srcs_;

        public SourcedNodeDegree(NetNode node, List<NetNode> srcOrder, Set<NetNode> mySrcs) {
            this.node_ = node;
            this.degree_ = mySrcs.size();
            int numSrc = srcOrder.size();
            this.srcs_ = new boolean[numSrc];
            for (int i = 0; i < numSrc; ++i) {
                if (!mySrcs.contains(srcOrder.get(i))) continue;
                this.srcs_[i] = true;
            }
        }

        public NetNode getNode() {
            return this.node_;
        }

        public int hashCode() {
            return this.node_.hashCode() + this.degree_;
        }

        public String toString() {
            return " node = " + this.node_ + " degree = " + this.degree_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SourcedNodeDegree)) {
                return false;
            }
            SourcedNodeDegree otherDeg = (SourcedNodeDegree)other;
            if (this.degree_ != otherDeg.degree_) {
                return false;
            }
            return this.node_ == null ? otherDeg.node_ == null : this.node_.equals(otherDeg.node_);
        }

        @Override
        public int compareTo(SourcedNodeDegree otherDeg) {
            if (this.node_.equals(otherDeg.node_)) {
                return 0;
            }
            if (this.degree_ != otherDeg.degree_) {
                return otherDeg.degree_ - this.degree_;
            }
            boolean iAmBigger = false;
            boolean heIsBigger = false;
            for (int i = 0; i < this.srcs_.length; ++i) {
                if (this.srcs_[i] && !otherDeg.srcs_[i]) {
                    iAmBigger = true;
                    heIsBigger = false;
                    break;
                }
                if (!otherDeg.srcs_[i] || this.srcs_[i]) continue;
                iAmBigger = false;
                heIsBigger = true;
                break;
            }
            if (iAmBigger) {
                return -1;
            }
            if (heIsBigger) {
                return 1;
            }
            if (this.node_ == null) {
                return otherDeg.node_ == null ? 0 : -1;
            }
            return this.node_.compareTo(otherDeg.node_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeDegree
    implements Comparable<NodeDegree> {
        private NetNode node_;
        private int degree_;

        public NodeDegree(NetNode node, int degree) {
            this.node_ = node;
            this.degree_ = degree;
        }

        public NetNode getNodeID() {
            return this.node_;
        }

        public int hashCode() {
            return this.node_.hashCode() + this.degree_;
        }

        public String toString() {
            return " node = " + this.node_ + " degree = " + this.degree_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof NodeDegree)) {
                return false;
            }
            NodeDegree otherDeg = (NodeDegree)other;
            if (this.degree_ != otherDeg.degree_) {
                return false;
            }
            return this.node_ == null ? otherDeg.node_ == null : this.node_.equals(otherDeg.node_);
        }

        @Override
        public int compareTo(NodeDegree otherDeg) {
            if (this.degree_ != otherDeg.degree_) {
                return this.degree_ - otherDeg.degree_;
            }
            if (this.node_ == null) {
                return otherDeg.node_ == null ? 0 : -1;
            }
            return this.node_.compareTo(otherDeg.node_);
        }
    }

    public static interface CriteriaJudge {
        public boolean stopHere(NetNode var1);
    }

    public class QueueEntry {
        public int depth;
        public NetNode name;

        QueueEntry(int depth, NetNode name) {
            this.depth = depth;
            this.name = name;
        }

        public String toString() {
            return this.name + " depth = " + this.depth;
        }
    }
}

