/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleFinder {
    private Set<NetNode> nodes_;
    private Set<NetLink> links_;
    private HashMap<NetNode, Set<NetLink>> linksForNode_;
    private Integer white_;
    private Integer grey_;
    private Integer black_;

    public CycleFinder(Set<NetNode> nodes, Set<NetLink> links, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.nodes_ = nodes;
        this.links_ = links;
        this.linksForNode_ = new HashMap();
        LoopReporter lr = new LoopReporter(links.size(), 20, monitor, 0.0, 1.0, "progress.cycleFinderSetup");
        for (NetLink link : this.links_) {
            lr.report();
            Set<NetLink> linksForSrc = this.linksForNode_.get(link.getSrcNode());
            if (linksForSrc == null) {
                linksForSrc = new HashSet<NetLink>();
                this.linksForNode_.put(link.getSrcNode(), linksForSrc);
            }
            linksForSrc.add(link);
        }
        this.white_ = 0;
        this.grey_ = 1;
        this.black_ = 2;
        lr.finish();
    }

    public boolean hasACycle(BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr0 = new LoopReporter(this.nodes_.size(), 20, monitor, 0.0, 1.0, "progress.cycleFinderVisitPass1");
        HashMap<NetNode, Integer> colors = new HashMap<NetNode, Integer>();
        for (NetNode node : this.nodes_) {
            lr0.report();
            colors.put(node, this.white_);
        }
        lr0.finish();
        LoopReporter lr = new LoopReporter(this.nodes_.size(), 20, monitor, 0.0, 1.0, "progress.cycleFinderVisitPass2");
        for (NetNode node : this.nodes_) {
            Integer color = (Integer)colors.get(node);
            if (!color.equals(this.white_) || !this.visit(node, colors, lr)) continue;
            lr.finish();
            return true;
        }
        lr.finish();
        return false;
    }

    private boolean visit(NetNode vertex, Map<NetNode, Integer> colors, LoopReporter lr) throws AsynchExitRequestException {
        colors.put(vertex, this.grey_);
        lr.report();
        Set<NetLink> linksForVertex = this.linksForNode_.get(vertex);
        if (linksForVertex != null) {
            for (NetLink link : linksForVertex) {
                Integer targColor = colors.get(link.getTrgNode());
                if (targColor.equals(this.grey_)) {
                    return true;
                }
                if (!targColor.equals(this.white_) || !this.visit(link.getTrgNode(), colors, lr)) continue;
                return true;
            }
        }
        colors.put(vertex, this.black_);
        return false;
    }
}

